/*
 * Decompiled with CFR 0.152.
 */
package utils.stampe;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.print.PageFormat;
import java.util.StringTokenizer;
import java.util.Vector;
import utils.Funzioni;
import utils.MyTrace;
import utils.stampe.OggettoToPrint;
import utils.stampe.Page;
import utils.stampe.Segnalibro;
import utils.stampe.Stringa;

public class TabellaSenzaBordi
extends OggettoToPrint {
    public int[] columnWidth;
    public boolean[] rightAlligned;
    public String[] header;
    public Vector data;
    public int columnNr;
    public Font font;
    FontMetrics fm;
    PageFormat pf;
    final int LARGHEZZA = 567;
    int x = 0;
    int y = 0;
    int passo = 2;

    public TabellaSenzaBordi(Font font, String[] header, Vector data, int[] columnWidth, boolean[] rightAlligned, int x, int y, int passo) {
        this.header = header;
        this.data = data;
        this.columnWidth = columnWidth;
        this.columnNr = header.length;
        this.font = font;
        this.x = x;
        this.y = y;
        this.passo = passo;
        if (columnWidth == null) {
            this.setDefaultColumnWidth();
        } else {
            int i;
            int totalWidth = 0;
            for (i = 0; i < this.columnNr; ++i) {
                totalWidth += this.columnWidth[i];
            }
            for (i = 0; i < this.columnNr; ++i) {
            }
        }
        if (rightAlligned == null) {
            this.setDefaultRightAlligned();
        } else {
            this.rightAlligned = rightAlligned;
        }
    }

    private void setDefaultColumnWidth() {
        int cw = 1000 / this.columnNr;
        this.columnWidth = new int[this.columnNr];
        for (int i = 0; i < this.columnNr; ++i) {
            this.columnWidth[i] = cw;
        }
    }

    private void setDefaultRightAlligned() {
        this.rightAlligned = new boolean[this.columnNr];
        for (int i = 0; i < this.columnNr; ++i) {
            this.rightAlligned[i] = false;
        }
    }

    @Override
    int print(Segnalibro contesto) {
        int i;
        int i2;
        Font boldFont = new Font("Calibri", 1, 9);
        contesto.graphics.setFont(boldFont);
        this.fm = contesto.graphics.getFontMetrics();
        int rowHeight = this.fm.getHeight();
        if (this.y == 0) {
            this.y = rowHeight;
        }
        int[] columnWidth = this.columnWidth;
        int[] columnPos = new int[this.columnNr];
        for (i2 = 0; i2 < this.columnNr; ++i2) {
            columnPos[i2] = 1;
            for (int j = 0; j < i2; ++j) {
                int n = i2;
                columnPos[n] = columnPos[n] + columnWidth[j];
            }
        }
        i2 = 0;
        while (i2 < this.columnNr) {
            int n = i2++;
            columnWidth[n] = columnWidth[n] - 2;
        }
        Vector[] cell = new Vector[this.columnNr];
        int maxCellHeight = 0;
        for (i = 0; i < this.columnNr; ++i) {
            cell[i] = this.splitString(this.header[i], this.columnWidth[i]);
            maxCellHeight = maxCellHeight > cell[i].size() ? maxCellHeight : cell[i].size();
        }
        for (i = 0; i < maxCellHeight; ++i) {
            for (int j = 0; j < this.columnNr; ++j) {
                if (cell[j].size() <= i) continue;
                contesto.currentPage.add(new Stringa((String)cell[j].elementAt(i), boldFont, this.x + columnPos[j], (int)contesto.pf.getImageableY() + this.y));
            }
            this.y += this.passo * rowHeight;
            if (this.y < contesto.yLimit) continue;
            contesto.getMy_pj_corrente().getDummyBook().append(new Page((Vector)contesto.currentPage.clone(), contesto.gestore), this.pf);
            contesto.currentPage.removeAllElements();
            this.y = this.passo * rowHeight;
        }
        contesto.graphics.setFont(this.font);
        this.fm = contesto.graphics.getFontMetrics();
        rowHeight = this.fm.getHeight();
        for (i = 0; i < this.data.size(); ++i) {
            int j;
            cell = new Vector[this.columnNr];
            maxCellHeight = 0;
            String[] row = (String[])this.data.elementAt(i);
            MyTrace.log.fine("vettore riga attuale =" + row[0] + ":" + row[1] + "+ ecc..");
            for (j = 0; j < this.columnNr; ++j) {
                cell[j] = this.splitString(row[j], columnWidth[j]);
                maxCellHeight = maxCellHeight > cell[j].size() ? maxCellHeight : cell[j].size();
            }
            for (j = 0; j < maxCellHeight; ++j) {
                for (int k = 0; k < this.columnNr; ++k) {
                    if (cell[k].size() <= j) continue;
                    if (this.rightAlligned[k]) {
                        contesto.currentPage.add(new Stringa((String)cell[k].elementAt(j), this.font, this.x + columnPos[k] + columnWidth[k] - this.fm.stringWidth((String)cell[k].elementAt(j)), (int)contesto.pf.getImageableY() + this.y));
                        continue;
                    }
                    contesto.currentPage.add(new Stringa((String)cell[k].elementAt(j), this.font, this.x + columnPos[k], (int)contesto.pf.getImageableY() + this.y));
                }
                this.y += this.passo * rowHeight;
                if (this.y < 750) continue;
                contesto.getMy_pj_corrente().getDummyBook().append(new Page((Vector)contesto.currentPage.clone(), contesto.gestore), contesto.pf);
                contesto.currentPage.removeAllElements();
                this.y = this.passo * rowHeight;
            }
        }
        return contesto.currY;
    }

    private Vector splitString(String stringToSplit, int maxWidth) {
        try {
            Vector<String> result = new Vector<String>();
            if (maxWidth >= this.fm.stringWidth(stringToSplit)) {
                result.add(stringToSplit);
                return result;
            }
            StringTokenizer st = new StringTokenizer(stringToSplit, " ");
            String row = "";
            while (st.hasMoreTokens()) {
                String word = st.nextToken();
                if (maxWidth > this.fm.stringWidth(row + word)) {
                    row = row + word + " ";
                } else if (!row.equals("")) {
                    result.add(row);
                    row = word;
                }
                if (maxWidth >= this.fm.stringWidth(word)) continue;
                char[] chars = word.toCharArray();
                row = "";
                for (int i = 0; i < chars.length; ++i) {
                    if (maxWidth > this.fm.stringWidth(row + chars[i])) {
                        row = row + chars[i];
                        continue;
                    }
                    result.add(row);
                    row = "" + chars[i];
                }
            }
            if (!row.equals("")) {
                result.add(row);
            }
            return result;
        }
        catch (Exception e) {
            MyTrace.log.severe("ECCEZIONE su TabellaSenzaBordi.splitString() ECCEZIONE:[" + e + "]");
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            e.printStackTrace();
            return new Vector();
        }
    }
}

