/*
 * Decompiled with CFR 0.152.
 */
package utils.stampe;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.print.PageFormat;
import java.util.StringTokenizer;
import java.util.Vector;
import utils.MyTrace;
import utils.stampe.Linea;
import utils.stampe.OggettoToPrint;
import utils.stampe.Page;
import utils.stampe.Segnalibro;
import utils.stampe.Stringa;

public class Tabella
extends OggettoToPrint {
    public int[] columnWidth;
    public boolean[] rightAlligned;
    public String[] header;
    public Vector data;
    public int columnNr;
    public Font font;
    FontMetrics fm;
    PageFormat pf;
    final int LARGHEZZA = 567;
    int x = 0;
    int y = 0;

    public Tabella(Font font, String[] header, Vector data, int[] columnWidth, boolean[] rightAlligned, int x, int y) {
        this.header = header;
        this.data = data;
        this.columnWidth = columnWidth;
        this.columnNr = header.length;
        this.font = font;
        this.x = x;
        this.y = y;
        if (columnWidth == null) {
            this.setDefaultColumnWidth();
        } else {
            int i;
            int totalWidth = 0;
            for (i = 0; i < this.columnNr; ++i) {
                totalWidth += this.columnWidth[i];
            }
            for (i = 0; i < this.columnNr; ++i) {
                this.columnWidth[i] = this.columnWidth[i] * this.LARGHEZZA / totalWidth;
            }
        }
        if (rightAlligned == null) {
            this.setDefaultRightAlligned();
        } else {
            this.rightAlligned = rightAlligned;
        }
    }

    private void setDefaultColumnWidth() {
        int cw = 1000 / this.columnNr;
        this.columnWidth = new int[this.columnNr];
        for (int i = 0; i < this.columnNr; ++i) {
            this.columnWidth[i] = cw;
        }
    }

    private void setDefaultRightAlligned() {
        this.rightAlligned = new boolean[this.columnNr];
        for (int i = 0; i < this.columnNr; ++i) {
            this.rightAlligned[i] = false;
        }
    }

    @Override
    int print(Segnalibro seg) {
        int i;
        int i2;
        Font boldFont = new Font("serif", 1, 12);
        seg.graphics.setFont(boldFont);
        this.fm = seg.graphics.getFontMetrics();
        int rowHeight = this.fm.getHeight();
        if (this.y == 0) {
            this.y = rowHeight;
        }
        int[] columnWidth = this.columnWidth;
        int[] columnPos = new int[this.columnNr];
        for (i2 = 0; i2 < this.columnNr; ++i2) {
            columnPos[i2] = 1;
            for (int j = 0; j < i2; ++j) {
                int n = i2;
                columnPos[n] = columnPos[n] + columnWidth[j];
            }
        }
        i2 = 0;
        while (i2 < this.columnNr) {
            int n = i2++;
            columnWidth[n] = columnWidth[n] - 2;
        }
        Vector[] cell = new Vector[this.columnNr];
        int maxCellHeight = 0;
        for (i = 0; i < this.columnNr; ++i) {
            MyTrace.log.info("this.header[i] =" + this.header[i]);
            cell[i] = this.splitString(this.header[i], this.columnWidth[i]);
            maxCellHeight = maxCellHeight > cell[i].size() ? maxCellHeight : cell[i].size();
        }
        seg.currentPage.add(new Linea((int)seg.pf.getImageableX(), (int)seg.pf.getImageableY() + this.y - rowHeight + 3, (int)seg.pf.getImageableX() + seg.xLimit, (int)seg.pf.getImageableY() + this.y - rowHeight + 3));
        for (i = 0; i < maxCellHeight; ++i) {
            for (int j = 0; j < this.columnNr; ++j) {
                if (cell[j].size() > i) {
                    seg.currentPage.add(new Stringa((String)cell[j].elementAt(i), boldFont, (int)seg.pf.getImageableX() + columnPos[j], (int)seg.pf.getImageableY() + this.y));
                }
                seg.currentPage.add(new Linea((int)seg.pf.getImageableX() + columnPos[j] - 1, (int)seg.pf.getImageableY() + this.y - rowHeight + 3, (int)seg.pf.getImageableX() + columnPos[j] - 1, (int)seg.pf.getImageableY() + this.y + 3));
            }
            seg.currentPage.add(new Linea((int)seg.pf.getImageableX() + seg.xLimit, (int)seg.pf.getImageableY() + this.y - rowHeight + 3, (int)seg.pf.getImageableX() + seg.xLimit, (int)seg.pf.getImageableY() + this.y + 3));
            this.y += rowHeight;
            if (this.y < seg.yLimit) continue;
            seg.getMy_pj_corrente().getDummyBook().append(new Page((Vector)seg.currentPage.clone(), seg.gestore), this.pf);
            seg.currentPage.removeAllElements();
            this.y = rowHeight;
        }
        seg.graphics.setFont(this.font);
        this.fm = seg.graphics.getFontMetrics();
        rowHeight = this.fm.getHeight();
        for (i = 0; i < this.data.size(); ++i) {
            int j;
            seg.currentPage.add(new Linea((int)seg.pf.getImageableX(), (int)seg.pf.getImageableY() + this.y - rowHeight + 3, (int)seg.pf.getImageableX() + seg.xLimit, (int)seg.pf.getImageableY() + this.y - rowHeight + 3));
            cell = new Vector[this.columnNr];
            maxCellHeight = 0;
            String[] row = (String[])this.data.elementAt(i);
            for (j = 0; j < this.columnNr; ++j) {
                cell[j] = this.splitString(row[j], columnWidth[j]);
                maxCellHeight = maxCellHeight > cell[j].size() ? maxCellHeight : cell[j].size();
            }
            for (j = 0; j < maxCellHeight; ++j) {
                for (int k = 0; k < this.columnNr; ++k) {
                    if (cell[k].size() > j) {
                        if (this.rightAlligned[k]) {
                            seg.currentPage.add(new Stringa((String)cell[k].elementAt(j), this.font, (int)seg.pf.getImageableX() + columnPos[k] + columnWidth[k] - this.fm.stringWidth((String)cell[k].elementAt(j)), (int)seg.pf.getImageableY() + this.y));
                        } else {
                            seg.currentPage.add(new Stringa((String)cell[k].elementAt(j), this.font, (int)seg.pf.getImageableX() + columnPos[k], (int)seg.pf.getImageableY() + this.y));
                        }
                    }
                    seg.currentPage.add(new Linea((int)seg.pf.getImageableX() + columnPos[k] - 1, (int)seg.pf.getImageableY() + this.y - rowHeight + 3, (int)seg.pf.getImageableX() + columnPos[k] - 1, (int)seg.pf.getImageableY() + this.y + 3));
                }
                seg.currentPage.add(new Linea((int)seg.pf.getImageableX() + seg.xLimit, (int)seg.pf.getImageableY() + this.y - rowHeight + 3, (int)seg.pf.getImageableX() + seg.xLimit, (int)seg.pf.getImageableY() + this.y + 3));
                this.y += rowHeight;
                if (this.y < seg.yLimit) continue;
                seg.getMy_pj_corrente().getDummyBook().append(new Page((Vector)seg.currentPage.clone(), seg.gestore), seg.pf);
                seg.currentPage.removeAllElements();
                this.y = rowHeight;
            }
        }
        seg.currentPage.add(new Linea((int)seg.pf.getImageableX(), (int)seg.pf.getImageableY() + this.y - rowHeight + 3, (int)seg.pf.getImageableX() + seg.xLimit, (int)seg.pf.getImageableY() + this.y - rowHeight + 3));
        return seg.currY;
    }

    private Vector splitString(String stringToSplit, int maxWidth) {
        Vector<String> result = new Vector<String>();
        MyTrace.log.info("stringToSplit=" + stringToSplit);
        if (maxWidth >= this.fm.stringWidth(stringToSplit)) {
            result.add(stringToSplit);
            return result;
        }
        StringTokenizer st = new StringTokenizer(stringToSplit, " ");
        String row = "";
        while (st.hasMoreTokens()) {
            String word = st.nextToken();
            if (maxWidth > this.fm.stringWidth(row + word)) {
                row = row + word + " ";
            } else if (!row.equals("")) {
                result.add(row);
                row = word;
            }
            if (maxWidth >= this.fm.stringWidth(word)) continue;
            char[] chars = word.toCharArray();
            row = "";
            for (int i = 0; i < chars.length; ++i) {
                if (maxWidth > this.fm.stringWidth(row + chars[i])) {
                    row = row + chars[i];
                    continue;
                }
                result.add(row);
                row = "" + chars[i];
            }
        }
        if (!row.equals("")) {
            result.add(row);
        }
        return result;
    }
}

