/*
 * Decompiled with CFR 0.152.
 */
package utils.stampe;

import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.JInternalFrame;
import utils.Funzioni;
import utils.MyTrace;
import utils.stampe.OggettoToPrint;
import utils.stampe.Page;
import utils.stampe.Segnalibro;

public class ImmagineEsterna
extends OggettoToPrint {
    int x;
    int y;
    int width;
    int height;
    String path;
    URL imageURL_i = null;
    FontMetrics fm;
    PageFormat pf;
    private Image image_i;
    Funzioni f;
    JInternalFrame framechiamante;

    public ImmagineEsterna(String path, int x, int y, int width, int height) {
        this.x = x;
        this.path = path;
        this.height = height;
        this.width = width;
        this.y = y;
        this.f = new Funzioni();
        try {
            this.imageURL_i = new URL("file:" + path);
            if (Funzioni.FileExist(path)) {
                MyTrace.log.info("URL= " + this.imageURL_i.toString());
                BufferedImage image = ImageIO.read(this.imageURL_i);
                this.image_i = image;
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
        }
        catch (IOException e) {
            e.printStackTrace();
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
        }
    }

    @Override
    int print(Segnalibro contesto) {
        this.fm = contesto.graphics.getFontMetrics();
        int rowHeight = this.fm.getHeight();
        if (contesto.currY == 0) {
            contesto.currY = rowHeight;
        }
        contesto.currentPage.add(new ImmagineEsterna(this.path, this.x, this.y, this.width, this.height));
        contesto.currY += rowHeight;
        if (contesto.currY >= contesto.yLimit) {
            contesto.getMy_pj_corrente().getDummyBook().append(new Page((Vector)contesto.currentPage.clone(), contesto.gestore), contesto.pf);
            contesto.currentPage.removeAllElements();
            contesto.currY = rowHeight;
        }
        return contesto.currY;
    }

    @Override
    public void print(Graphics g, PageFormat pf, int pageIndex) {
        g.drawImage(this.image_i, this.x, this.y, this.width, this.height, this.framechiamante);
        MyTrace.log.finest("Immagine: " + this.image_i + ", Posizione X=" + this.x + ", Posizione Y=" + this.y + ", Larghezza=" + this.width + ", Altezza=" + this.height + ", FrameChiamante= " + this.framechiamante);
    }
}

