/*
 * Decompiled with CFR 0.152.
 */
package utils.stampe;

import com.itextpdf.text.Document;
import com.itextpdf.text.pdf.DefaultFontMapper;
import com.itextpdf.text.pdf.FontMapper;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfTemplate;
import com.itextpdf.text.pdf.PdfWriter;
import gestionale.andamento_e_bilancio.Punto;
import java.awt.Desktop;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.xy.XYSeries;
import utils.Funzioni;
import utils.MyTrace;
import utils.stampe.OggettoToPrint;

class GraficoOvunque_PDF_AndamentoTemporale
extends OggettoToPrint {
    int x;
    int y;
    int width;
    int height;
    int dimensione_ascissa;
    Vector a;
    Vector p;
    Vector u;
    Graphics g;
    String titolo;
    String intestazioneX;
    String intestazioneY;

    public GraficoOvunque_PDF_AndamentoTemporale(Vector a, Vector p, Vector u, int dimensione_ascissa, int x, int y, int width, int height, String titolo, String intestazioneX, String intestazioneY, String nome_path) {
        MyTrace.log.info("Costruttore Grafico Ovunque");
        this.height = height;
        this.width = width;
        this.x = x;
        this.y = y;
        this.a = a;
        this.p = p;
        this.u = u;
        this.intestazioneX = intestazioneX;
        this.intestazioneY = intestazioneY;
        this.titolo = titolo;
        this.dimensione_ascissa = dimensione_ascissa;
        XYSeries series = new XYSeries((Comparable)((Object)"Average Size"));
        boolean limite = false;
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        for (Punto punto : a) {
            dataset.addValue(punto.getImporto(), (Comparable)((Object)"attivo"), (Comparable)((Object)("" + punto.getIndice())));
        }
        for (Punto punto : p) {
            dataset.addValue(punto.getImporto(), (Comparable)((Object)"passivo"), (Comparable)((Object)("" + punto.getIndice())));
        }
        for (Punto punto : u) {
            dataset.addValue(punto.getImporto(), (Comparable)((Object)"utile"), (Comparable)((Object)("" + punto.getIndice())));
        }
        JFreeChart chart = ChartFactory.createBarChart3D((String)("" + this.titolo), (String)("" + this.intestazioneX), (String)("" + this.intestazioneY), (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)true);
        Graphics2D g2 = (Graphics2D)this.g;
        PdfWriter writer = null;
        Document document = new Document();
        try {
            writer = PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(nome_path));
            document.open();
            PdfContentByte contentByte = writer.getDirectContent();
            PdfTemplate template = contentByte.createTemplate(1000.0f, 1000.0f);
            Graphics2D graphics2d = template.createGraphics(590.0f, 835.0f, (FontMapper)new DefaultFontMapper());
            MyTrace.log.info("1) graphics2d.getTrasform()  =" + graphics2d.getTransform().toString());
            MyTrace.log.info("2) graphics2d.getClipBounds()=" + graphics2d.getClipBounds().toString());
            Rectangle2D.Double rectangle2d = new Rectangle2D.Double(this.x, this.y, this.width, 500.0);
            chart.draw(graphics2d, (Rectangle2D)rectangle2d);
            graphics2d.dispose();
            contentByte.addTemplate(template, 0.0f, 0.0f);
        }
        catch (Exception e) {
            MyTrace.log.severe("ERRORE:  eccezione NELLA STAMPA SUL FILE");
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            e.printStackTrace();
        }
        document.close();
        File file = new File(nome_path);
        try {
            Desktop.getDesktop().open(file);
        }
        catch (IOException ex) {
            MyTrace.log.severe("ERRORE:  eccezione NELLA CREAZIONE DEL FILE");
            Funzioni.inviaBugPerEmail(ex);
            Funzioni.LogStackTrace(ex);
        }
    }
}

