/*
 * Decompiled with CFR 0.152.
 */
package utils;

import gestionale.configurazioni.Configurazioni;
import gestionale.r_analitica.MyReportAnalitica;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.tree.DefaultMutableTreeNode;
import utils.Funzioni;
import utils.Link;
import utils.MyTrace;

public class MenuDinamico {
    String cartella_report = "";
    String[] listaFiles;

    public void MenuDinamico() {
        MyTrace.log.info("ISTANZIATO: MenuDinamico");
    }

    public DefaultMutableTreeNode creaMenuReport() {
        MyTrace.log.info("START: creaMenuReport");
        this.CaricaFiles();
        DefaultMutableTreeNode nodoCartella = new DefaultMutableTreeNode("Report Analisi Dinamiche");
        DefaultMutableTreeNode nodo = null;
        if (this.listaFiles == null) {
            return nodoCartella;
        }
        try {
            ArrayList<String> lista = new ArrayList<String>(Arrays.asList(this.listaFiles));
            MyTrace.log.info("VOCI CARICATE: " + lista.toString());
            for (String menu : lista) {
                final String nomeFileReport = menu.replace(".jasper", "");
                String nomeMenu = nomeFileReport.replace('_', ' ');
                nodo = new DefaultMutableTreeNode(new Link(nomeMenu, "gestionale.r_analitica.MyReportAnalitica", ""){

                    @Override
                    public boolean azionePredefinita() {
                        MyReportAnalitica oggetto = new MyReportAnalitica(nomeFileReport);
                        Configurazioni.getIstanza().desktopwindow.myDesktopPane.add(oggetto);
                        oggetto.setVisible(true);
                        oggetto.moveToFront();
                        return true;
                    }
                });
                nodoCartella.add(nodo);
            }
        }
        catch (Exception ex) {
            MyTrace.log.severe("ECCEZIONE: errore e/o problemi nella CARTELLA REPORT: forse manca proprio la cartella report");
            ex.printStackTrace();
            Funzioni.inviaBugPerEmail(ex);
            Funzioni.LogStackTrace(ex);
        }
        catch (Error err) {
            MyTrace.log.severe("ERRORE: errore di avvio o di linkaggio cartella report");
            err.printStackTrace();
        }
        return nodoCartella;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] CaricaFiles() {
        File objFile = null;
        boolean blnRet = false;
        this.cartella_report = System.getProperty("user.dir") + System.getProperty("file.separator") + "report" + System.getProperty("file.separator");
        MyTrace.log.info("CARTELLA REPORT:" + this.cartella_report);
        FilenameFilter filtro = new FilenameFilter(){
            boolean file_ok = false;

            @Override
            public boolean accept(File dir, String name) {
                this.file_ok = name.contains(".jasper");
                return this.file_ok;
            }
        };
        try {
            objFile = new File(this.cartella_report);
            boolean bl = blnRet = objFile.exists() && objFile.isDirectory();
            if (blnRet) {
                MyTrace.log.info("MenuDinamico:a) Trovato CARTELLA REPORT per i men\u00f9 dinamici");
                MyTrace.log.info("MenuDinamico:b) carico la lista dei report nella cartella predefinita!");
                this.listaFiles = objFile.list(filtro);
                MyTrace.log.info("MenuDinamico:c) trovata correttamente lista dei report nella cartella predefinita!");
            } else {
                MyTrace.log.info("MenuDinamico: NON Trovato CARTELLA REPORT per i men\u00f9 dinamici");
            }
        }
        catch (Exception e) {
            blnRet = false;
            MyTrace.log.severe("ECCEZIONE: errore e/o problemi nella lettura della CARTELLA REPORT");
        }
        finally {
            if (objFile != null) {
                objFile = null;
            }
        }
        return this.listaFiles;
    }
}

