/*
 * Decompiled with CFR 0.152.
 */
package utils;

import gestionale.MyDesktopWindow;
import gestionale.configurazioni.Configurazioni;
import javax.swing.JInternalFrame;
import utils.Funzioni;
import utils.MyTrace;

public class Link {
    public String title = "";
    public String formName;
    public String permesso;
    private Object oggetto;
    private Class classe;

    public Link(String title, String formName, String permesso) {
        this.title = title;
        this.formName = formName;
        this.permesso = permesso;
    }

    public String toString() {
        return this.title;
    }

    public String getFrame() {
        return this.formName;
    }

    public String getPermesso() {
        return this.permesso;
    }

    public boolean getPermessoConcesso() {
        boolean ritorno = true;
        if (!this.permesso.equals("")) {
            ritorno = MyDesktopWindow.profilo.controllaPermesso(this.permesso);
        } else {
            MyTrace.log.info("ANOMALIA:  permesso non richiesto in :" + this.title + ":  con nome del form=" + this.formName);
        }
        return ritorno;
    }

    public void inizializza() {
    }

    public boolean azionePredefinita() {
        try {
            MyTrace.log.config("PERMESSO: " + this.permesso + " = " + this.getPermessoConcesso());
            if (!this.getPermessoConcesso()) {
                return false;
            }
            this.classe = Class.forName(this.formName);
            JInternalFrame oggetto = (JInternalFrame)this.classe.newInstance();
            Configurazioni.getIstanza().desktopwindow.myDesktopPane.add(oggetto);
            oggetto.setVisible(true);
            oggetto.moveToFront();
        }
        catch (Exception ex) {
            MyTrace.log.severe("ERRORE:  eccezione azionePredefinita errore di istanziazione ");
            ex.printStackTrace();
            Funzioni.inviaBugPerEmail(ex);
            Funzioni.LogStackTrace(ex);
        }
        catch (Error err) {
            MyTrace.log.severe("ERRORE: azionePredefinita errore di avvio o di linkaggio dello specifico modulo");
            err.printStackTrace();
        }
        return true;
    }
}

