/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import utils.Funzioni;
import utils.IBANField;
import utils.IBANFormatter;
import utils.MyTrace;

public class IBANCellRenderer
extends DefaultTableCellRenderer {
    IBANField ibanField;

    private void tfFocusLost(FocusEvent evt) {
        this.ibanField.setText(this.getText());
        this.ibanField.setForeground(new Color(0, 0, 0));
        this.ibanField.setBackground(new Color(150, 100, 200));
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        System.out.println("row=" + row + " col=" + column + " value=" + value.toString());
        String testo = "";
        try {
            testo = value.toString();
        }
        catch (Exception err) {
            MyTrace.log.severe("ECCEZIONE in getTableCellRendererComponent() valore non presente");
            err.printStackTrace();
            Funzioni.inviaBugPerEmail(err);
            Funzioni.LogStackTrace(err);
        }
        IBANFormatter mf = new IBANFormatter();
        this.ibanField = new IBANField(mf);
        this.ibanField.setOpaque(true);
        this.ibanField.setPreferredSize(new Dimension(100, 25));
        this.ibanField.setForeground(new Color(100, 100, 100));
        this.ibanField.setText(testo);
        this.ibanField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                IBANCellRenderer.this.tfFocusLost(evt);
            }
        });
        return this.ibanField;
    }
}

