/*
 * Decompiled with CFR 0.152.
 */
package utils;

import gestionale.configurazioni.Configurazioni;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Calendar;
import utils.Connessione;
import utils.Funzioni;
import utils.MyTrace;

public class GestioneLicenze {
    Calendar dataonline = Calendar.getInstance();
    Calendar datascadenza = Calendar.getInstance();
    Calendar dataattuale = Calendar.getInstance();
    boolean modalit\u00e0ConsultazioneAttiva = false;
    String ragioneSociale = "";
    int id_azienda = 0;
    Funzioni funz = new Funzioni();

    public boolean verifica_validita_licenza(int id_azienda) {
        MyTrace.log.info("GESTIONE LICENZE SOFTWARE OLIMPO");
        this.id_azienda = id_azienda;
        try {
            this.recupera_data_limite_dal_database_online();
        }
        catch (Exception err) {
            MyTrace.log.severe("ECCEZIONE: NEL RECUPERO LICENZE ONLINE");
            err.printStackTrace();
            Funzioni.inviaBugPerEmail(err);
            Funzioni.LogStackTrace(err);
        }
        catch (Error err) {
            MyTrace.log.severe("ERRORE: NEL RECUPERO LICENZE ONLINE");
            err.printStackTrace();
        }
        try {
            this.datascadenza.set(2200, 12, 31);
            this.estrai_data_limite_dal_database_master();
            Configurazioni.datascadenza = this.datascadenza;
            if (this.datascadenza.before(this.dataattuale)) {
                this.modalit\u00e0ConsultazioneAttiva = true;
            }
        }
        catch (Exception err) {
            MyTrace.log.severe("ECCEZIONE: NELLA VERIFICA LICENZE");
            err.printStackTrace();
            Funzioni.inviaBugPerEmail(err);
            Funzioni.LogStackTrace(err);
        }
        catch (Error err) {
            MyTrace.log.severe("ERRORE:  NELLA  VERIFICA LICENZE");
            err.printStackTrace();
        }
        MyTrace.log.info("GESTIONE LICENZA SOFTWARE OLIMPO    modalit\u00e0 consultazione = " + this.modalit\u00e0ConsultazioneAttiva);
        MyTrace.log.info("GESTIONE LICENZA SOFTWARE OLIMPO            licenza valida = " + !this.modalit\u00e0ConsultazioneAttiva);
        return this.modalit\u00e0ConsultazioneAttiva;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Calendar estrai_data_limite_dal_database_master() {
        MyTrace.log.info("LICENZA Estraggo Scadenza dall'azienda avente  id=_" + this.id_azienda + "_");
        String query_seleziona = "SELECT * FROM anag_azienda WHERE idAnag_azienda=" + this.id_azienda;
        ResultSet res = Configurazioni.getIstanza().connessione_master.eseguiQuery(query_seleziona);
        try {
            while (res.next()) {
                this.ragioneSociale = res.getString("ragione_sociale");
                this.datascadenza.setTime(res.getDate("data_scadenza_licenza"));
                MyTrace.log.info("ESTRATTA CORRETTAMENTE DATA '" + this.funz.formatta_Calendar_in_data_SQL(this.datascadenza) + "'");
            }
        }
        catch (SQLException ex) {
            MyTrace.log.severe("ECCEZIONE:  SQL estrai_data_limite_dal_database_master anomalia nel retrive dati azienda id=" + this.id_azienda);
            MyTrace.log.severe("ECCEZIONE:  SQL probabile che non esiste la colonna `data_scadenza_licenza` ");
            ex.printStackTrace();
            Funzioni.inviaBugPerEmail(ex);
            Funzioni.LogStackTrace(ex);
            this.crea_la_colonna_scadenza_nel_db_master();
        }
        catch (Error err) {
            MyTrace.log.severe("ERRORE: estrai_data_limite_dal_database_master  anomalia nel retrive dati azienda id=" + this.id_azienda);
            err.printStackTrace();
        }
        finally {
            Configurazioni.getIstanza().connessione_master.ChiudiResultSet(res);
        }
        return this.datascadenza;
    }

    private void crea_la_colonna_scadenza_nel_db_master() {
        MyTrace.log.info("TENTO la creazione della colonna `gestionale_olimpo`.`anag_azienda`.`data_scadenza_licenza` ");
        String query_creazione = "ALTER TABLE `anag_azienda` ADD COLUMN `data_scadenza_licenza` DATE NULL DEFAULT '2200-12-31'  AFTER `nome_database` ;";
        boolean risultato = Configurazioni.getIstanza().connessione_master.eseguiAggiornamento(query_creazione);
        if (risultato) {
            MyTrace.log.info("CREAZIONE OK");
        } else {
            MyTrace.log.info("CREAZIONE KO");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Calendar recupera_data_limite_dal_database_online() {
        MyTrace.log.info("TENTO la connessione al DB online delle scadenze");
        Connessione connessione_db_licenze_online = new Connessione("www.kronositalia.com", "admin_licenze_olimpo", "olimpoadmin", "gest$$licenze", "3306");
        try {
            if (connessione_db_licenze_online.connetti()) {
                MyTrace.log.info("Sono connesso al db ONLINE delle  licenze");
                MyTrace.log.info("LICENZA Recupero Scadenza Online dall'azienda avente  id=_" + this.id_azienda + "_");
                String query_seleziona = "SELECT * FROM anag_azienda WHERE idAnag_azienda=" + this.id_azienda;
                ResultSet res = connessione_db_licenze_online.eseguiQuery(query_seleziona);
                while (res.next()) {
                    this.ragioneSociale = res.getString("ragione_sociale");
                    this.dataonline.setTime(res.getDate("data_scadenza_licenza"));
                    MyTrace.log.info("ESTRATTA CORRETTAMENTE NUOVA DATA '" + this.funz.formatta_Calendar_in_data_SQL(this.dataonline) + "'");
                }
                Configurazioni.getIstanza().connessione_master.ChiudiResultSet(res);
                this.aggiorna_data_licenza_su_db_master(this.dataonline);
            } else {
                MyTrace.log.severe("DB online non raggiungibile");
            }
        }
        catch (SQLException ex) {
            MyTrace.log.severe("ECCEZIONE:  SQL estrai_data_limite_dal_database_master anomalia nel retrive dati azienda id=" + this.id_azienda);
            ex.printStackTrace();
            Funzioni.inviaBugPerEmail(ex);
            Funzioni.LogStackTrace(ex);
        }
        catch (Error err) {
            MyTrace.log.severe("ERRORE: estrai_data_limite_dal_database_master  anomalia nel retrive dati azienda id=" + this.id_azienda);
            err.printStackTrace();
        }
        finally {
            connessione_db_licenze_online.disconnetti();
        }
        return this.dataonline;
    }

    private void aggiorna_data_licenza_su_db_master(Calendar nuova_scadenza) {
        MyTrace.log.info("AGGIORNA NUOVA SCADENZA " + this.funz.formatta_Calendar_in_data_SQL(nuova_scadenza));
        String sql = "UPDATE `anag_azienda` SET `data_scadenza_licenza`='" + this.funz.formatta_Calendar_in_data_SQL(nuova_scadenza) + "' WHERE `idAnag_azienda`='" + this.id_azienda + "'; ";
        int numero = 0;
        boolean risultato = false;
        try {
            Statement stmt = Configurazioni.getIstanza().connessione_master.connssl.createStatement();
            numero = stmt.executeUpdate(sql);
            risultato = true;
            stmt.close();
            MyTrace.log.info("AGGIORNAMENTO AVVENUTO CORRETTAMENTE");
        }
        catch (Exception e) {
            MyTrace.log.severe("DB: EXQ3=" + e.toString());
            Funzioni.LogStackTrace(e);
            risultato = false;
        }
    }

    public static long verifica_giorni_rimanenti() {
        Calendar dataattuale = Calendar.getInstance();
        Funzioni funz = new Funzioni();
        long giorniRimanenti = 0L;
        giorniRimanenti = Funzioni.giorniTraDueDateCalendar2(Configurazioni.datascadenza, dataattuale);
        MyTrace.log.info("GIORNI LICENZA RIMANENTI = " + giorniRimanenti);
        return giorniRimanenti;
    }
}

