/*
 * Decompiled with CFR 0.152.
 */
package utils;

import gestionale.auth.Diritto;
import gestionale.auth.Gruppo;
import gestionale.auth.InsiemeGruppi;
import gestionale.auth.Permesso;
import gestionale.configurazioni.Configurazioni;
import gestionale.configurazioni.ProfiloUtente;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import javax.swing.JOptionPane;
import utils.BannerWorking;
import utils.Funzioni;
import utils.MyTrace;
import utils.Performance;

public class FunzioniDiritti
extends Thread {
    Funzioni funzioni;
    int id_guppo;
    private Vector elenco_permessi_dalle_classi;
    private Vector elenco_permessi_dal_database;
    boolean permessi_estratti_dal_database_ok = false;
    static boolean estrazione_completata = false;
    private static boolean classe_istanziata = false;
    public HashMap<Integer, String> gruppi_operatore;

    public FunzioniDiritti() {
        if (!classe_istanziata) {
            this.gruppi_operatore = new HashMap();
            this.funzioni = new Funzioni();
            this.start();
            classe_istanziata = true;
        } else {
            MyTrace.log.severe("ERRORE DI PROGRAMMAZIONE (CLASSE FunzioniDiritti istanziata pi\u00f9 volte)");
        }
    }

    private void displayResource(URL url) {
        try {
            InputStream is = url.openStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            String nextLine = null;
            while ((nextLine = br.readLine()) != null) {
            }
        }
        catch (IOException ioe) {
            Funzioni.LogStackTrace(ioe);
            ioe.printStackTrace();
        }
    }

    private Class[] getClasseNamesInPackage(String jarName, String packageName) {
        MyTrace.log.fine("GET Class Name START");
        Performance performance = new Performance("KRONOS SUB: getClasseNamesInPackage per il package <" + packageName + ">");
        ArrayList classes = new ArrayList();
        packageName = packageName.replaceAll("\\.", "/");
        MyTrace.log.fine("JAR = " + jarName + "    looking for package = " + packageName);
        String nome_file = "";
        try {
            JarEntry jarEntry;
            FileInputStream fis = new FileInputStream(jarName);
            JarInputStream jarFile = new JarInputStream(new BufferedInputStream(fis));
            while ((jarEntry = jarFile.getNextJarEntry()) != null) {
                String jarname = jarEntry.getName();
                if (!jarname.startsWith(packageName) || !jarname.endsWith(".class") || jarname.contains("$")) continue;
                nome_file = jarEntry.getName().replaceAll("/", "\\.");
                MyTrace.log.finest("Found class = " + nome_file);
                classes.add(Class.forName(nome_file.substring(0, nome_file.length() - 6)));
            }
        }
        catch (Exception e) {
            MyTrace.log.severe("ECCEZIONE: NON E'' RIUSCITA l''ENUMERAZIONE DELLE CLASSI NEL JAR relativamente al nomefile = " + nome_file);
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            e.printStackTrace();
        }
        catch (Error e) {
            MyTrace.log.severe("ERRORE LINK: NON E'' RIUSCITO IL LINK DELLE CLASSI NEL JAR: nomefile=" + nome_file + " .. probabile mancanaza di una libreria");
            Funzioni.LogStackTraceError(e);
            e.printStackTrace();
        }
        MyTrace.log.fine("GET Class Name STOP");
        performance.fine();
        return classes.toArray(new Class[classes.size()]);
    }

    public void CopiaPermessiDalDatabase(ProfiloUtente profilo) {
        MyTrace.log.info("1) STO PER COPIARE I PERMESSI ESTRATTI DAL DB AZIENDA NELL'ISTANZA DI  FUNZIONE DIRITTI");
        this.permessi_estratti_dal_database_ok = true;
        if (profilo == null) {
            return;
        }
        this.elenco_permessi_dal_database = new Vector();
        for (String permesso : profilo.map_diritti.keySet()) {
            this.elenco_permessi_dal_database.add(permesso);
        }
        MyTrace.log.info("2) COPIATI in FUNZIONE DIRITTI NUMERO :" + this.elenco_permessi_dal_database.size() + ": PERMESSI");
        MyTrace.log.info("3) I PERMESSI DAL DATABASE SONO :" + this.elenco_permessi_dal_database.toString());
    }

    public int NumeroPermessiDelleClassi() {
        if (this.elenco_permessi_dalle_classi.isEmpty()) {
            return 0;
        }
        return this.elenco_permessi_dalle_classi.size();
    }

    public int NumeroPermessiDalDatabase() {
        if (this.elenco_permessi_dal_database.isEmpty()) {
            return 0;
        }
        return this.elenco_permessi_dal_database.size();
    }

    private Vector NewEstraiPermessiDalleClassi() {
        MyTrace.log.info("########################################################################");
        MyTrace.log.info("########   ESTRAZIONE PERMESSI DALLE CLASSI NEL JAR        #############");
        MyTrace.log.info("########   by SANDRO 11/12/2012                            #############");
        Vector<String> permessi_sw = new Vector<String>();
        String current_dir = Configurazioni.cartella_di_lavoro;
        String fullname_package_jar = current_dir + "GESTIONALE.jar";
        MyTrace.log.info("1) JAR=" + fullname_package_jar);
        File test = new File(fullname_package_jar);
        if (!test.exists()) {
            fullname_package_jar = current_dir + "dist" + System.getProperty("file.separator") + "GESTIONALE.jar";
            MyTrace.log.info("2) JAR=" + fullname_package_jar);
            test = new File(fullname_package_jar);
            if (!test.exists()) {
                MyTrace.log.severe(" ERRORE GRAVE: non trovato il GESTIONALE.jar in   " + current_dir);
                System.exit(1);
            }
        }
        MyTrace.log.info("3) JAR=" + fullname_package_jar);
        ArrayList classes = new ArrayList();
        String nome_file = "";
        try {
            JarEntry oggetto_nel_jar;
            FileInputStream fis = new FileInputStream(fullname_package_jar);
            JarInputStream jarFile = new JarInputStream(new BufferedInputStream(fis));
            while ((oggetto_nel_jar = jarFile.getNextJarEntry()) != null) {
                String nome_oggetto = oggetto_nel_jar.getName();
                if (!nome_oggetto.endsWith(".class") || nome_oggetto.contains("$")) continue;
                nome_file = oggetto_nel_jar.getName().replaceAll("/", "\\.");
                MyTrace.log.finest("Trovata classe = " + nome_file);
                classes.add(Class.forName(nome_file.substring(0, nome_file.length() - 6)));
            }
        }
        catch (Exception e) {
            MyTrace.log.severe("ECCEZIONE: NON E'' RIUSCITA l''ENUMERAZIONE DELLE CLASSI NEL JAR relativamente al nomefile = " + nome_file);
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            e.printStackTrace();
        }
        catch (Error e) {
            MyTrace.log.severe("ERRORE LINK: NON E'' RIUSCITO IL LINK DELLE CLASSI NEL JAR: nomefile=" + nome_file + " .. probabile mancanaza di una libreria");
            Funzioni.LogStackTraceError(e);
            e.printStackTrace();
        }
        MyTrace.log.info("FINE estrazione classi sul JAR");
        Class[] classi_utili_nel_jar = classes.toArray(new Class[classes.size()]);
        MyTrace.log.info("#########################################################################################");
        MyTrace.log.info("#######  Numero di classi nel jar =" + classi_utili_nel_jar.length);
        for (int i = 0; i < classi_utili_nel_jar.length; ++i) {
            Field f = null;
            Class classe = classi_utili_nel_jar[i];
            String nomeClasse = classe.getName();
            try {
                f = classe.getDeclaredField("civetta_permessi");
                if (f.equals(null)) continue;
                MyTrace.log.fine("TROVATA CIVETTA IN " + nomeClasse);
                String[] diritti_temp2 = null;
                int size_diritti = 0;
                try {
                    size_diritti = classe.getDeclaredField("size_diritti").getInt(null);
                    Field ff = classe.getDeclaredField("array_diritti");
                    diritti_temp2 = (String[])ff.get(null);
                    for (int ii = 0; ii < size_diritti; ++ii) {
                        if (!permessi_sw.contains(diritti_temp2[ii])) {
                            permessi_sw.add(diritti_temp2[ii]);
                            continue;
                        }
                        MyTrace.log.severe("ERRORE: Permesso :" + diritti_temp2[ii] + ": DUPLICATO SULLE CIVETTE DELLE CLASSI " + classe.getName());
                    }
                    continue;
                }
                catch (IllegalArgumentException ex) {
                    MyTrace.log.severe("ECCEZIONE  nell'argomento");
                    Funzioni.inviaBugPerEmail(ex);
                    Funzioni.LogStackTrace(ex);
                    continue;
                }
                catch (IllegalAccessException ex) {
                    MyTrace.log.severe("ECCEZIONE  nell'accesso");
                    Funzioni.inviaBugPerEmail(ex);
                    Funzioni.LogStackTrace(ex);
                    continue;
                }
            }
            catch (NoSuchFieldException e) {
                MyTrace.log.finest("ESCLUSA CLASSE: =" + classe.getName());
                continue;
            }
            catch (Exception e) {
                MyTrace.log.severe("ERRORE:  eccezione FunzioneDiritti() B");
                e.printStackTrace();
                Funzioni.inviaBugPerEmail(e);
                Funzioni.LogStackTrace(e);
            }
        }
        MyTrace.log.info("#########################################################################################");
        MyTrace.log.info("########   PERMESSI ESTRATTI DAL JAR (PERMESSI CIVETTA) SONO in NUMERO: =" + permessi_sw.size() + "   #############");
        MyTrace.log.info("########   PERMESSI CIVETTA CARICATI:" + permessi_sw.toString() + "             #############");
        return permessi_sw;
    }

    private Vector EstraiPermessiDalleClassi() {
        int ii;
        Field ff;
        int size_diritti;
        String[] diritti_temp2;
        boolean tipofunzionale;
        String nomeClasse;
        Class classe;
        Field f;
        int i;
        MyTrace.log.info("########################################################################");
        MyTrace.log.info("########   ESTRAZIONE PERMESSI DALLE CLASSI NEL PACKAGER   #############");
        MyTrace.log.info("########   (PERMESSI CIVETTA)                              #############");
        Class[] array_classi = null;
        Vector<String> permessi_sw = new Vector<String>();
        MyTrace.log.fine("**** Find diritti sw");
        String current_dir = Configurazioni.cartella_di_lavoro;
        String file_gestionale = current_dir + "GESTIONALE.jar";
        MyTrace.log.info("1) JAR=" + file_gestionale);
        File test = new File(file_gestionale);
        if (!test.exists()) {
            file_gestionale = current_dir + "dist" + System.getProperty("file.separator") + "GESTIONALE.jar";
            MyTrace.log.info("2) JAR=" + file_gestionale);
            test = new File(file_gestionale);
            if (!test.exists()) {
                MyTrace.log.severe(" ERRORE GRAVE: non trovato il GESTIONALE.jar in   " + current_dir);
                System.exit(1);
            }
        }
        MyTrace.log.info("3) JAR=" + file_gestionale);
        array_classi = this.getClasseNamesInPackage(file_gestionale, "gestionale");
        MyTrace.log.info("****Numero di classi GESTIONALE=" + array_classi.length);
        for (i = 0; i < array_classi.length; ++i) {
            f = null;
            classe = array_classi[i];
            nomeClasse = classe.getName();
            tipofunzionale = nomeClasse.contains("$");
            if (!tipofunzionale) {
                try {
                    f = classe.getDeclaredField("civetta_permessi");
                    if (f.equals(null)) continue;
                    MyTrace.log.fine("****TROVATA CIVETTA IN " + nomeClasse);
                    diritti_temp2 = null;
                    size_diritti = 0;
                    try {
                        size_diritti = classe.getDeclaredField("size_diritti").getInt(null);
                        ff = classe.getDeclaredField("array_diritti");
                        diritti_temp2 = (String[])ff.get(null);
                        for (ii = 0; ii < size_diritti; ++ii) {
                            if (!permessi_sw.contains(diritti_temp2[ii])) {
                                permessi_sw.add(diritti_temp2[ii]);
                                continue;
                            }
                            MyTrace.log.severe("ERRORE: Permesso :" + diritti_temp2[ii] + ": DUPLICATO SULLE CIVETTE DELLE CLASSI " + classe.getName());
                        }
                    }
                    catch (IllegalArgumentException ex) {
                        MyTrace.log.severe("ECCEZIONE  nell'argomento");
                        Funzioni.inviaBugPerEmail(ex);
                        Funzioni.LogStackTrace(ex);
                    }
                    catch (IllegalAccessException ex) {
                        MyTrace.log.severe("ECCEZIONE  nell'accesso");
                        Funzioni.inviaBugPerEmail(ex);
                        Funzioni.LogStackTrace(ex);
                    }
                }
                catch (NoSuchFieldException e) {
                    MyTrace.log.finest("ESCLUSA CLASSE: =" + classe.getName());
                }
                catch (Exception e) {
                    MyTrace.log.severe("ERRORE:  eccezione FunzioneDiritti() B");
                    e.printStackTrace();
                    Funzioni.inviaBugPerEmail(e);
                    Funzioni.LogStackTrace(e);
                }
                continue;
            }
            MyTrace.log.finest("ESCLUSA CLASSE FUNZIONALE: =" + nomeClasse);
        }
        array_classi = this.getClasseNamesInPackage(file_gestionale, "magazzino");
        MyTrace.log.info("**** Numero di classi MAGAZZINO=" + array_classi.length);
        for (i = 0; i < array_classi.length; ++i) {
            f = null;
            classe = array_classi[i];
            nomeClasse = classe.getName();
            tipofunzionale = nomeClasse.contains("$");
            if (!tipofunzionale) {
                try {
                    f = classe.getDeclaredField("civetta_permessi");
                    if (f.equals(null)) continue;
                    MyTrace.log.fine("****TROVATA CIVETTA IN " + nomeClasse);
                    diritti_temp2 = null;
                    size_diritti = 0;
                    try {
                        size_diritti = classe.getDeclaredField("size_diritti").getInt(null);
                        ff = classe.getDeclaredField("array_diritti");
                        diritti_temp2 = (String[])ff.get(null);
                        for (ii = 0; ii < size_diritti; ++ii) {
                            if (!permessi_sw.contains(diritti_temp2[ii])) {
                                permessi_sw.add(diritti_temp2[ii]);
                                continue;
                            }
                            MyTrace.log.severe("ERRORE: Permesso :" + diritti_temp2[ii] + ": DUPLICATO SULLE CIVETTE DELLE CLASSI " + classe.getName());
                        }
                    }
                    catch (IllegalArgumentException ex) {
                        Funzioni.inviaBugPerEmail(ex);
                        Funzioni.LogStackTrace(ex);
                    }
                    catch (IllegalAccessException ex) {
                        Funzioni.inviaBugPerEmail(ex);
                        Funzioni.LogStackTrace(ex);
                    }
                }
                catch (NoSuchFieldException e) {
                    MyTrace.log.finest("ESCLUSA CLASSE: =" + classe.getName());
                }
                catch (Exception e) {
                    MyTrace.log.severe("ERRORE:  eccezione FunzioneDiritti() D");
                    e.printStackTrace();
                    Funzioni.inviaBugPerEmail(e);
                    Funzioni.LogStackTrace(e);
                }
                continue;
            }
            MyTrace.log.finest("ESCLUSA CLASSE FUNZIONALE: =" + nomeClasse);
        }
        array_classi = this.getClasseNamesInPackage(file_gestionale, "trasporti");
        MyTrace.log.info("****Numero di classi TRASPORTI=" + array_classi.length);
        for (i = 0; i < array_classi.length; ++i) {
            f = null;
            classe = array_classi[i];
            nomeClasse = classe.getName();
            tipofunzionale = nomeClasse.contains("$");
            if (!tipofunzionale) {
                try {
                    f = classe.getDeclaredField("civetta_permessi");
                    if (f.equals(null)) continue;
                    MyTrace.log.fine("****TROVATA CIVETTA IN " + nomeClasse);
                    diritti_temp2 = null;
                    size_diritti = 0;
                    try {
                        size_diritti = classe.getDeclaredField("size_diritti").getInt(null);
                        ff = classe.getDeclaredField("array_diritti");
                        diritti_temp2 = (String[])ff.get(null);
                        for (ii = 0; ii < size_diritti; ++ii) {
                            if (!permessi_sw.contains(diritti_temp2[ii])) {
                                permessi_sw.add(diritti_temp2[ii]);
                                continue;
                            }
                            MyTrace.log.severe("ERRORE: Permesso :" + diritti_temp2[ii] + ": DUPLICATO SULLE CIVETTE DELLE CLASSI " + classe.getName());
                        }
                    }
                    catch (IllegalArgumentException ex) {
                        Funzioni.inviaBugPerEmail(ex);
                        Funzioni.LogStackTrace(ex);
                    }
                    catch (IllegalAccessException ex) {
                        Funzioni.inviaBugPerEmail(ex);
                        Funzioni.LogStackTrace(ex);
                    }
                }
                catch (NoSuchFieldException e) {
                    MyTrace.log.finest("ESCLUSA CLASSE: =" + classe.getName());
                }
                catch (Exception e) {
                    MyTrace.log.severe("ERRORE:  eccezione FunzioneDiritti() F");
                    e.printStackTrace();
                    Funzioni.inviaBugPerEmail(e);
                    Funzioni.LogStackTrace(e);
                }
                continue;
            }
            MyTrace.log.finest("ESCLUSA CLASSE FUNZIONALE: =" + nomeClasse);
        }
        array_classi = this.getClasseNamesInPackage(file_gestionale, "controlling");
        MyTrace.log.info("****Numero di classi CONTROLLING=" + array_classi.length);
        for (i = 0; i < array_classi.length; ++i) {
            f = null;
            classe = array_classi[i];
            nomeClasse = classe.getName();
            tipofunzionale = nomeClasse.contains("$");
            if (!tipofunzionale) {
                try {
                    f = classe.getDeclaredField("civetta_permessi");
                    if (f.equals(null)) continue;
                    MyTrace.log.fine("****TROVATA CIVETTA IN " + nomeClasse);
                    diritti_temp2 = null;
                    size_diritti = 0;
                    try {
                        size_diritti = classe.getDeclaredField("size_diritti").getInt(null);
                        ff = classe.getDeclaredField("array_diritti");
                        diritti_temp2 = (String[])ff.get(null);
                        for (ii = 0; ii < size_diritti; ++ii) {
                            if (!permessi_sw.contains(diritti_temp2[ii])) {
                                permessi_sw.add(diritti_temp2[ii]);
                                continue;
                            }
                            MyTrace.log.severe("ERRORE: Permesso :" + diritti_temp2[ii] + ": DUPLICATO SULLE CIVETTE DELLE CLASSI " + classe.getName());
                        }
                    }
                    catch (IllegalArgumentException ex) {
                        Funzioni.inviaBugPerEmail(ex);
                        Funzioni.LogStackTrace(ex);
                    }
                    catch (IllegalAccessException ex) {
                        Funzioni.inviaBugPerEmail(ex);
                        Funzioni.LogStackTrace(ex);
                    }
                }
                catch (NoSuchFieldException e) {
                    MyTrace.log.finest("ESCLUSA CLASSE: =" + classe.getName());
                }
                catch (Exception e) {
                    MyTrace.log.severe("ERRORE:  eccezione FunzioneDiritti() F");
                    e.printStackTrace();
                    Funzioni.inviaBugPerEmail(e);
                    Funzioni.LogStackTrace(e);
                }
                continue;
            }
            MyTrace.log.finest("ESCLUSA CLASSE FUNZIONALE: =" + nomeClasse);
        }
        MyTrace.log.info("#############################################################################");
        MyTrace.log.info("########   PERMESSI ESTARTTI DAL JAR (PERMESSI CIVETTA) SONO in NUMERO: =" + permessi_sw.size() + "   #############");
        MyTrace.log.info("########   PERMESSI CIVETTA CARICATI:" + permessi_sw.toString());
        return permessi_sw;
    }

    public void controlla_coerenza_del_numero_di_permessi() {
        try {
            MyTrace.log.info("#########    CONTROLLO COERENZA PERMESSI    ###########");
            int res = this.sistema_coerenza_del_numero_di_permessi();
            if (res == 0) {
                MyTrace.log.info("PERMESSI COERENTI e TUTTO OK");
            } else {
                if (res == 2) {
                    MyTrace.log.severe("PROBLEMA DI COERENZA CON IL DATABASE!");
                    JOptionPane.showMessageDialog(null, "PROBLEMA DI COERENZA PERMESSI DEL DATABASE!!!\n    provare a riavviare OLIMPO!!!");
                }
                if (res == 1 || res == 3) {
                    MyTrace.log.severe("ESISTONO DELLE NUOVE INTERFACCE E SONO STATI ASSEGNATI I RELATIVI DIRITTI!!! ");
                    JOptionPane.showMessageDialog(null, "ESISTONO DELLE NUOVE INTERFACCE A CUI \n SONO STATI ASSEGNATI I DIRITTI!!! \n \u00e8 preferibile riavviare OLIMPO!!!");
                }
            }
        }
        catch (Exception ex) {
            MyTrace.log.severe("ERRORE: CATTURATA ECCEZIONE NEL CHECK PERMESSI =" + ex.toString());
            Funzioni.inviaBugPerEmail(ex);
            Funzioni.LogStackTrace(ex);
        }
    }

    private boolean cancello_i_permessi_di_troppo_dal_db() {
        BannerWorking bw = new BannerWorking("CANCELLO EVENTUALI PERMESSI IN ECCESSO SUL DB");
        boolean status = false;
        bw.start();
        Vector elenco_permessi_dalle_classi_temp = (Vector)this.elenco_permessi_dalle_classi.clone();
        Vector elenco_permessi_dal_database_temp = (Vector)this.elenco_permessi_dal_database.clone();
        Iterator i = elenco_permessi_dal_database_temp.iterator();
        int ii = 1;
        MyTrace.log.fine("NUMERO PERMESSI DAL DB       = " + elenco_permessi_dal_database_temp.size());
        MyTrace.log.fine("NUMERO PERMESSI DALLE CLASSI = " + elenco_permessi_dalle_classi_temp.size());
        try {
            while (i.hasNext()) {
                boolean trovato = false;
                String permesso = (String)i.next();
                MyTrace.log.fine("RISCONTRO PERMESSO '" + permesso + "'  numero=" + ii++);
                Iterator i2 = elenco_permessi_dalle_classi_temp.iterator();
                if (permesso != null) {
                    while (i2.hasNext()) {
                        if (!permesso.equals((String)i2.next())) continue;
                        trovato = true;
                    }
                }
                if (trovato) continue;
                MyTrace.log.info("ATTENZIONE PERMESSO DEL DATABASE <<" + permesso + ">>  NON TROVATO NELLE CLASSI");
                this.cancello_il_permesso_sul_db(permesso);
                status = true;
            }
        }
        catch (Exception ex) {
            MyTrace.log.severe("ERRORE:  eccezione cancello_i_permessi_di_troppo_dal_db()");
            ex.printStackTrace();
            Funzioni.inviaBugPerEmail(ex);
            Funzioni.LogStackTrace(ex);
        }
        catch (Error err) {
            MyTrace.log.severe("ERRORE: cancello_i_permessi_di_troppo_dal_db() errore di avvio o di linkaggio dello specifico modulo");
            err.printStackTrace();
        }
        if (!status) {
            MyTrace.log.info("NON CI SONO PERMESSI IN ECCESSO NEL DB (TUTTO OK)");
        }
        bw.stop();
        return status;
    }

    private boolean cancello_il_permesso_sul_db(String permesso) {
        MyTrace.log.info("Cancello PERMESSO <<" + permesso + ">> ORA LO elimino dal Database Azienda=" + Configurazioni.getIstanza().connessione.nomeDB);
        if (permesso == "null" || permesso == null) {
            MyTrace.log.info("TROVATO PERMESSO NULLO LO elimino dal Database");
            String query_pulizia = "delete auth_diritti, auth_permessi from auth_diritti left join  auth_permessi ON auth_diritti.id_permesso=auth_permessi.id WHERE   auth_permessi.id is null";
            boolean r_query_pulizia = Configurazioni.getIstanza().connessione.eseguiAggiornamento(query_pulizia);
            if (r_query_pulizia) {
                MyTrace.log.info("END CANCELLAZIONE PERMESSO '" + permesso + "' TUTTO OK");
            } else {
                MyTrace.log.severe("Cancellazione Diritto non riuscito '" + permesso + "'  KO");
            }
            MyTrace.log.info("Cancellazione eseguita con esito = " + r_query_pulizia);
        } else {
            InsiemeGruppi insieme_g = new InsiemeGruppi();
            insieme_g.caricamento("", "");
            boolean r_start = Configurazioni.getIstanza().connessione.start_transaction();
            Permesso p = new Permesso();
            p.setNome_permesso(permesso);
            p.getId();
            boolean r_i = p.cancella();
            Iterator i3 = insieme_g.vettoreGruppi.iterator();
            boolean res2 = false;
            while (i3.hasNext()) {
                Gruppo g = (Gruppo)i3.next();
                Diritto d = new Diritto();
                d.setId_gruppo(g.getId());
                d.setId_permesso(p.getId());
                d.setOk(1);
                res2 = d.cancella(false);
            }
            if (!(r_start && r_i && res2)) {
                MyTrace.log.severe("Cancellazione Diritto non riuscita");
                Configurazioni.eccezione.gestisci("3.2", null);
            } else {
                Configurazioni.getIstanza().connessione.commit();
                MyTrace.log.info("END CANCELLAZIONE PERMESSO '" + permesso + "' TUTTO OK");
            }
        }
        return true;
    }

    private boolean inserisco_i_permessi_mancanti_sul_db() {
        BannerWorking bw = new BannerWorking("INSERISCO GLI EVENTUALI PERMESSI MANCANTI SUL DB");
        boolean status = false;
        bw.start();
        Vector elenco_permessi_dalle_classi_temp = (Vector)this.elenco_permessi_dalle_classi.clone();
        Vector elenco_permessi_dal_database_temp = (Vector)this.elenco_permessi_dal_database.clone();
        Iterator i = elenco_permessi_dalle_classi_temp.iterator();
        int ii = 1;
        Configurazioni.getIstanza().connessione.start_transaction();
        boolean res = true;
        while (i.hasNext()) {
            boolean trovato = false;
            String permesso = (String)i.next();
            MyTrace.log.fine("VERIFICA PERMESSO '" + permesso + "'  numero=" + ii++);
            Iterator i2 = elenco_permessi_dal_database_temp.iterator();
            while (i2.hasNext()) {
                if (!permesso.equals((String)i2.next())) continue;
                trovato = true;
            }
            if (trovato) continue;
            res = this.inserisco_il_permesso_sul_db(permesso);
            status = true;
        }
        if (!res) {
            MyTrace.log.severe("ERRORE: INSERISCO GLI EVENTUALI PERMESSI MANCANTI SUL DB non riuscita");
            Configurazioni.eccezione.gestisci("3.2", null);
            Configurazioni.getIstanza().connessione.rollback();
            status = false;
        } else {
            Configurazioni.getIstanza().connessione.commit();
        }
        if (!status) {
            MyTrace.log.info("NON CI SONO PERMESSI MANCANTI NEL DB (TUTTO OK)");
        }
        bw.stop();
        return status;
    }

    private boolean inserisco_il_permesso_sul_db(String permesso) {
        MyTrace.log.info("Manca PERMESSO '" + permesso + "' ORA LO INSERISCO CON I DIRITTI DEL GRUPPO");
        InsiemeGruppi insieme_g = new InsiemeGruppi();
        insieme_g.caricamento("", "");
        Permesso p = new Permesso();
        p.setNome_permesso(permesso);
        boolean r_i = p.inserisci();
        Iterator i3 = insieme_g.vettoreGruppi.iterator();
        boolean res2 = false;
        while (i3.hasNext()) {
            Gruppo g = (Gruppo)i3.next();
            Diritto d = new Diritto();
            d.setId_gruppo(g.getId());
            d.setId_permesso(p.getId());
            d.setOk(1);
            res2 = d.iinserisci(false);
        }
        if (!r_i || !res2) {
            MyTrace.log.severe("inserimento permesso non riuscita");
            Configurazioni.eccezione.gestisci("3.2", null);
            Configurazioni.getIstanza().connessione.rollback();
            return false;
        }
        return true;
    }

    private int sistema_coerenza_del_numero_di_permessi() throws URISyntaxException {
        Performance start = new Performance("CONTROLLO COERENZA PERMESSI");
        MyTrace.log.info("permessi nelle liste reali SW=" + this.elenco_permessi_dalle_classi.size() + "       permessi DB=" + this.elenco_permessi_dal_database.size());
        Vector elenco_permessi_dalle_classi_temp = (Vector)this.elenco_permessi_dalle_classi.clone();
        Vector elenco_permessi_dal_database_temp = (Vector)this.elenco_permessi_dal_database.clone();
        MyTrace.log.info("permessi nelle liste CLONE  SW=" + elenco_permessi_dalle_classi_temp.size() + "       permessi DB=" + elenco_permessi_dal_database_temp.size());
        boolean permessi_aggiunti = this.inserisco_i_permessi_mancanti_sul_db();
        boolean permessi_di_troppo = this.cancello_i_permessi_di_troppo_dal_db();
        int status = (permessi_aggiunti ? 1 : 0) + (permessi_di_troppo ? 2 : 0);
        return status;
    }

    @Override
    public void run() {
        Thread.currentThread().setName("<<THREAD::ESTRAZIONE_DIRITTI_CLASSI:>>");
        if (!estrazione_completata) {
            Performance performance = new Performance("!!!!!!!!!!ESTRAZIONE DIRITTI SU THREAD!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
            this.elenco_permessi_dalle_classi = this.NewEstraiPermessiDalleClassi();
            performance.fine();
            estrazione_completata = true;
            MyTrace.log.info("!!!!!!!!!! ATTENDO IL TERMINE DELL'ESTRAZIONE PERMESSI GRUPPO DAL DATABASE");
            while (!this.permessi_estratti_dal_database_ok) {
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException e) {
                    MyTrace.log.severe("!!!!!!!!!!ECCEZIONE ANOMALA durante l'attesa dell'estrazione diritti");
                    e.printStackTrace();
                    Funzioni.inviaBugPerEmail(e);
                    Funzioni.LogStackTrace(e);
                }
            }
            MyTrace.log.info("!!!!!!!!!! ATTESA ESTRAZIONE PERMESSI GRUPPO DAL DATABASE TERMINATA");
            this.controlla_coerenza_del_numero_di_permessi();
        } else {
            MyTrace.log.severe("!!!!!!!!!! ESTRAZIONE DIRITTI: chiamata su thread doppia ");
            StackTraceElement[] ste = new Throwable().getStackTrace();
            System.out.println(ste[0].getClassName() + ":" + ste[0].getMethodName());
            System.out.println(ste[1].getClassName() + ":" + ste[1].getMethodName());
        }
    }
}

