/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.Vector;
import javax.swing.JOptionPane;
import utils.Funzioni;
import utils.MyTrace;

public class FunzioniDate {
    public String dataCorrente() {
        GregorianCalendar cal = new GregorianCalendar();
        String DATE_FORMAT = "yyyy-MM-dd";
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
        String dataNew = sdf.format(cal.getTime());
        return dataNew;
    }

    public String OraCorrente() {
        GregorianCalendar cal = new GregorianCalendar();
        String ORA_FORMAT = "HH:mm";
        SimpleDateFormat sdf = new SimpleDateFormat(ORA_FORMAT);
        String oraNew = sdf.format(cal.getTime());
        return oraNew;
    }

    public String dataCorrenteIt() {
        GregorianCalendar cal = new GregorianCalendar();
        String DATE_FORMAT = "yyyy-MM-dd";
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
        String dataNew = sdf.format(cal.getTime());
        return this.gira_data(dataNew);
    }

    public int annoCorrente() {
        GregorianCalendar cal = new GregorianCalendar();
        int giorno = cal.get(5);
        int mese = cal.get(2);
        int anno = cal.get(1);
        return anno;
    }

    public Vector ultimi_anni(int numero) {
        Vector<Object> vettore = new Vector<Object>();
        int anno_corrente = this.annoCorrente();
        vettore.addElement("");
        for (int j = 0; j < numero; ++j) {
            vettore.addElement(anno_corrente - j);
        }
        return vettore;
    }

    public String costruisciDataEng(int giorno, int mese, int anno) {
        return Integer.toString(anno) + "-" + Integer.toString(mese) + "-" + Integer.toString(giorno);
    }

    public String costruisciDataEng(String giorno, String mese, String anno) {
        return anno + "-" + mese + "-" + giorno;
    }

    public String gira_data(String data) {
        try {
            String[] temp = null;
            if (data != null) {
                if (!data.equals("") && data != null) {
                    temp = data.split("-");
                    if (temp.length == 2) {
                        return "" + temp[1] + "-" + temp[0];
                    }
                    if (temp.length == 1) {
                        return "" + temp[0];
                    }
                    return "" + temp[2] + "-" + temp[1] + "-" + temp[0];
                }
                return "";
            }
            return "";
        }
        catch (Exception err) {
            MyTrace.log.severe("Funzioni GIRA DATA con data=" + data);
            err.printStackTrace();
            Funzioni.inviaBugPerEmail(err);
            Funzioni.LogStackTrace(err);
            return "";
        }
    }

    public String gira_data_filtro(String data) {
        block15: {
            try {
                int contatore = 0;
                for (int i = 0; i < data.length(); ++i) {
                    if (!data.substring(i, i + 1).equals("-")) continue;
                    ++contatore;
                }
                String[] temp = null;
                if (data != null) {
                    if (!data.equals("") && data != null) {
                        temp = data.split("-");
                        if (contatore == 0) {
                            if (temp[0] != null && temp[0].length() == 1) {
                                temp[0] = "0" + temp[0];
                            }
                            return temp[0];
                        }
                        if (contatore == 1) {
                            if (temp[0] != null && temp[0].length() == 1) {
                                temp[0] = "0" + temp[0];
                            }
                            if (temp.length == 2 && temp[1] != null && temp[1].length() == 1) {
                                temp[1] = "0" + temp[1];
                            }
                            if (temp.length == 2) {
                                return temp[1] + "-" + temp[0];
                            }
                            return temp[0];
                        }
                        if (contatore == 2) {
                            if (temp[0] != null && temp[0].length() == 1) {
                                temp[0] = "0" + temp[0];
                            }
                            if (temp[1] != null && temp[1].length() == 1) {
                                temp[1] = "0" + temp[1];
                            }
                            if (temp.length == 3) {
                                return "" + temp[2] + "-" + temp[1] + "-" + temp[0];
                            }
                            return temp[1] + "-" + temp[0];
                        }
                        break block15;
                    }
                    return null;
                }
                return "";
            }
            catch (Exception err) {
                MyTrace.log.severe("Funzioni GIRA DATA FILTRO con data=" + data);
                err.printStackTrace();
                Funzioni.inviaBugPerEmail(err);
                Funzioni.LogStackTrace(err);
                return null;
            }
        }
        return "";
    }

    public String giorno(String data) {
        try {
            String[] temp = null;
            if (!data.equals("")) {
                temp = data.split("-");
                return "" + temp[2];
            }
            return "";
        }
        catch (Exception err) {
            MyTrace.log.severe("Funzioni GIORNO");
            err.printStackTrace();
            Funzioni.inviaBugPerEmail(err);
            Funzioni.LogStackTrace(err);
            return "";
        }
    }

    public String mese(String data) {
        try {
            String[] temp = null;
            if (!data.equals("")) {
                temp = data.split("-");
                return "" + temp[1];
            }
            return "";
        }
        catch (Exception err) {
            MyTrace.log.severe("Funzioni MESE");
            err.printStackTrace();
            Funzioni.inviaBugPerEmail(err);
            Funzioni.LogStackTrace(err);
            return "";
        }
    }

    public String anno(String data) {
        try {
            String[] temp = null;
            if (!data.equals("")) {
                temp = data.split("-");
                return "" + temp[0];
            }
            return "";
        }
        catch (Exception err) {
            MyTrace.log.severe("Funzioni ANNO");
            err.printStackTrace();
            Funzioni.inviaBugPerEmail(err);
            Funzioni.LogStackTrace(err);
            return "";
        }
    }

    public int annopiuuno(String data) {
        try {
            String[] temp = null;
            String a = "";
            if (!data.equals("")) {
                temp = data.split("-");
                a = "" + temp[0];
            } else {
                a = "1000";
            }
            return Integer.parseInt(a) + 1;
        }
        catch (Exception err) {
            MyTrace.log.severe("Funzioni ANNO +1");
            err.printStackTrace();
            Funzioni.inviaBugPerEmail(err);
            Funzioni.LogStackTrace(err);
            return 1002;
        }
    }

    public String riconverti_mese(String mese) {
        String retVal = "";
        String[] n_mounth = new String[]{"01", "02", "03", "04", "05", "06", "07", "08", "09", "10", "11", "12"};
        String[] mounth = new String[]{"Gennaio", "Febbraio", "Marzo", "Aprile", "Maggio", "Giugno", "Luglio", "Agosto", "Settembre", "Ottobre", "Novembre", "Dicembre"};
        for (int i = 0; i < 12; ++i) {
            if (!mounth[i].equals(mese)) continue;
            retVal = n_mounth[i];
        }
        return retVal;
    }

    public String converti_mese(String numero) {
        String retVal = "";
        if (numero.length() == 1) {
            numero = "0" + numero;
        }
        String[] n_mounth = new String[]{"01", "02", "03", "04", "05", "06", "07", "08", "09", "10", "11", "12"};
        String[] mounth = new String[]{"Gennaio", "Febbraio", "Marzo", "Aprile", "Maggio", "Giugno", "Luglio", "Agosto", "Settembre", "Ottobre", "Novembre", "Dicembre"};
        for (int i = 0; i < 12; ++i) {
            if (!n_mounth[i].equals(numero)) continue;
            retVal = mounth[i];
        }
        return retVal;
    }

    public String rollDay(int mounthToAdd) {
        String dataNew = "";
        String DATE_FORMAT = "yyyy-MM-dd";
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
        try {
            GregorianCalendar c1 = new GregorianCalendar();
            c1.add(2, mounthToAdd);
            dataNew = sdf.format(c1.getTime());
        }
        catch (Exception e) {
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            e.printStackTrace();
        }
        return dataNew;
    }

    public String addMounth(String date, int mounthToAdd) {
        String dataNew = "";
        String DATE_FORMAT = "yyyy-MM-dd";
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
        try {
            int anno = Integer.parseInt(this.anno(date));
            int mese = Integer.parseInt(this.mese(date));
            int giorno = Integer.parseInt(this.giorno(date));
            GregorianCalendar c1 = new GregorianCalendar(anno, mese - 1, giorno);
            MyTrace.log.severe("mesi da aggiungere=" + mounthToAdd);
            c1.add(2, mounthToAdd);
            dataNew = sdf.format(c1.getTime());
            MyTrace.log.info("nuova data=" + dataNew);
        }
        catch (Exception e) {
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            e.printStackTrace();
        }
        return dataNew;
    }

    public String addDay(String date, int dayToAdd) {
        String dataNew = "";
        String DATE_FORMAT = "yyyy-MM-dd";
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
        try {
            int anno = Integer.parseInt(this.anno(date));
            int mese = Integer.parseInt(this.mese(date));
            int giorno = Integer.parseInt(this.giorno(date));
            GregorianCalendar c1 = new GregorianCalendar(anno, mese - 1, giorno);
            c1.add(6, dayToAdd);
            dataNew = sdf.format(c1.getTime());
            MyTrace.log.info("nuova data=" + dataNew);
        }
        catch (Exception e) {
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            e.printStackTrace();
        }
        return dataNew;
    }

    public String giornoDellaSettimana(String date) {
        int dayOfWeek = 0;
        String retVal = "";
        String DATE_FORMAT = "yyyy-MM-dd";
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
        try {
            int anno = Integer.parseInt(this.anno(date));
            int mese = Integer.parseInt(this.mese(date));
            int giorno = Integer.parseInt(this.giorno(date));
            GregorianCalendar c1 = new GregorianCalendar(anno, mese - 1, giorno);
            dayOfWeek = c1.get(7);
        }
        catch (Exception e) {
            e.printStackTrace();
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
        }
        switch (dayOfWeek) {
            case 1: {
                retVal = "Domenica";
                break;
            }
            case 2: {
                retVal = "Luned\u00ec";
                break;
            }
            case 3: {
                retVal = "Marted\u00ec";
                break;
            }
            case 4: {
                retVal = "Mercoled\u00ec";
                break;
            }
            case 5: {
                retVal = "Gioved\u00ec";
                break;
            }
            case 6: {
                retVal = "Venerd\u00ec";
                break;
            }
            case 7: {
                retVal = "Sabato";
                break;
            }
            default: {
                retVal = "";
            }
        }
        return retVal;
    }

    public int giorniDifferenza(Date date1, Date date2, TimeZone tz) {
        Calendar cal1 = null;
        Calendar cal2 = null;
        if (tz == null) {
            cal1 = Calendar.getInstance();
            cal2 = Calendar.getInstance();
        } else {
            cal1 = Calendar.getInstance(tz);
            cal2 = Calendar.getInstance(tz);
        }
        cal1.setTime(date1);
        long ldate1 = date1.getTime() + (long)cal1.get(15) + (long)cal1.get(16);
        cal2.setTime(date2);
        long ldate2 = date2.getTime() + (long)cal2.get(15) + (long)cal2.get(16);
        int hr1 = (int)(ldate1 / 3600000L);
        int hr2 = (int)(ldate2 / 3600000L);
        int days1 = hr1 / 24;
        int days2 = hr2 / 24;
        int dateDiff = days2 - days1;
        int weekOffset = cal2.get(7) - cal1.get(7) < 0 ? 1 : 0;
        int weekDiff = dateDiff / 7 + weekOffset;
        int yearDiff = cal2.get(1) - cal1.get(1);
        int monthDiff = yearDiff * 12 + cal2.get(2) - cal1.get(2);
        return dateDiff;
    }

    public int MesiDifferenza(Date date1, Date date2, TimeZone tz) {
        Calendar cal1 = null;
        Calendar cal2 = null;
        if (tz == null) {
            cal1 = Calendar.getInstance();
            cal2 = Calendar.getInstance();
        } else {
            cal1 = Calendar.getInstance(tz);
            cal2 = Calendar.getInstance(tz);
        }
        cal1.setTime(date1);
        long ldate1 = date1.getTime() + (long)cal1.get(15) + (long)cal1.get(16);
        cal2.setTime(date2);
        long ldate2 = date2.getTime() + (long)cal2.get(15) + (long)cal2.get(16);
        int hr1 = (int)(ldate1 / 3600000L);
        int hr2 = (int)(ldate2 / 3600000L);
        int days1 = hr1 / 24;
        int days2 = hr2 / 24;
        int dateDiff = days2 - days1;
        int weekOffset = cal2.get(7) - cal1.get(7) < 0 ? 1 : 0;
        int weekDiff = dateDiff / 7 + weekOffset;
        int yearDiff = cal2.get(1) - cal1.get(1);
        int monthDiff = yearDiff * 12 + cal2.get(2) - cal1.get(2);
        return monthDiff;
    }

    public int AnniDifferenza(Date date1, Date date2, TimeZone tz) {
        Calendar cal1 = null;
        Calendar cal2 = null;
        if (tz == null) {
            cal1 = Calendar.getInstance();
            cal2 = Calendar.getInstance();
        } else {
            cal1 = Calendar.getInstance(tz);
            cal2 = Calendar.getInstance(tz);
        }
        cal1.setTime(date1);
        long ldate1 = date1.getTime() + (long)cal1.get(15) + (long)cal1.get(16);
        cal2.setTime(date2);
        long ldate2 = date2.getTime() + (long)cal2.get(15) + (long)cal2.get(16);
        int hr1 = (int)(ldate1 / 3600000L);
        int hr2 = (int)(ldate2 / 3600000L);
        int days1 = hr1 / 24;
        int days2 = hr2 / 24;
        int dateDiff = days2 - days1;
        int weekOffset = cal2.get(7) - cal1.get(7) < 0 ? 1 : 0;
        int weekDiff = dateDiff / 7 + weekOffset;
        int yearDiff = cal2.get(1) - cal1.get(1);
        int monthDiff = yearDiff * 12 + cal2.get(2) - cal1.get(2);
        return yearDiff;
    }

    public int data1maggiore(String data1, String data2) {
        int in_sc = 0;
        String DATE_FORMAT = "yyyy-MM-dd";
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
        try {
            int anno = Integer.parseInt(this.anno(data1));
            int mese = Integer.parseInt(this.mese(data1));
            int giorno = Integer.parseInt(this.giorno(data1));
            GregorianCalendar c1 = new GregorianCalendar(anno, mese - 1, giorno);
            int anno2 = Integer.parseInt(this.anno(data2));
            int mese2 = Integer.parseInt(this.mese(data2));
            int giorno2 = Integer.parseInt(this.giorno(data2));
            GregorianCalendar c2 = new GregorianCalendar(anno2, mese2 - 1, giorno2);
            in_sc = c1.after(c2) ? 1 : 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
        }
        return in_sc;
    }

    public String date_to_string(Date d) {
        String DATE_FORMAT = "yyyy-MM-dd";
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
        if (d != null) {
            StringBuilder temp = new StringBuilder(sdf.format(d));
            return temp.toString();
        }
        return "0000-00-00";
    }

    public Date string_to_date(String s) {
        Date date = null;
        if (s == null) {
            return null;
        }
        if (s.equals("0000-00-00")) {
            return null;
        }
        if (s != null) {
            try {
                SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
                date = formatter.parse(s);
            }
            catch (ParseException ex) {
                Funzioni.inviaBugPerEmail(ex);
                Funzioni.LogStackTrace(ex);
                MyTrace.log.severe(ex.toString());
                date = new Date();
                return null;
            }
        }
        return date;
    }

    public String ottieniUltimoGiornoDelMese(String date) {
        String dataNew = "";
        String DATE_FORMAT = "yyyy-MM-dd";
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
        try {
            int anno = Integer.parseInt(this.anno(date));
            int mese = Integer.parseInt(this.mese(date));
            int giorno = Integer.parseInt(this.giorno(date));
            GregorianCalendar c1 = new GregorianCalendar(anno, mese - 1, giorno);
            c1.set(5, c1.getActualMaximum(5));
            c1.set(10, 23);
            c1.set(12, 59);
            c1.set(13, 59);
            dataNew = sdf.format(c1.getTime());
            MyTrace.log.info("nuova data=" + dataNew);
        }
        catch (Exception e) {
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            e.printStackTrace();
        }
        return dataNew;
    }

    public String calcola_scadenza(String data_partenza, int giorni_da_agg, boolean fine_mese) {
        String date_finale = data_partenza;
        while (giorni_da_agg >= 30) {
            if (giorni_da_agg < 30) continue;
            date_finale = this.addMounth(date_finale, 1);
            giorni_da_agg -= 30;
        }
        if (fine_mese) {
            date_finale = this.ottieniUltimoGiornoDelMese(date_finale);
        }
        date_finale = this.addDay(date_finale, giorni_da_agg);
        return date_finale;
    }

    public String null_to_zero(String data) {
        if (data == null || data.equals("null") || data.equals("    -  -  ")) {
            return "0000-00-00";
        }
        return data;
    }

    public String null_to_zero_ora(String ora) {
        if (ora == null || ora.equals("null") || ora.equals("  :  ")) {
            return "00:00";
        }
        return ora;
    }

    public boolean check_data(String data_en) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        format.setLenient(false);
        try {
            format.parse(data_en);
        }
        catch (ParseException e) {
            System.out.println("Date " + data_en + " is not valid according to " + format.toPattern() + " pattern.");
            JOptionPane.showMessageDialog(null, "Attenzione, Data non corretta");
            return false;
        }
        return true;
    }

    public String last_day_of_mounth(String mese) {
        if (mese.equals("11") || mese.equals("04") || mese.equals("06") || mese.equals("09")) {
            return "30";
        }
        if (mese.equals("02")) {
            return "28";
        }
        return "31";
    }
}

