/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.text.AttributeSet;
import javax.swing.text.Element;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.StyledEditorKit;

public class FontAndSizeAction
extends StyledEditorKit.StyledTextAction {
    private static final long serialVersionUID = 584531387732416339L;
    private String family;
    private float fontSize;
    JDialog formatText;
    private boolean accept = false;
    JComboBox fontFamilyChooser;
    JComboBox fontSizeChooser;

    public FontAndSizeAction() {
        super("Font and Size");
    }

    public String toString() {
        return "Font and Size";
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JEditorPane editor = this.getEditor(e);
        int p0 = editor.getSelectionStart();
        StyledDocument doc = this.getStyledDocument(editor);
        Element paragraph = doc.getCharacterElement(p0);
        AttributeSet as = paragraph.getAttributes();
        this.family = StyleConstants.getFontFamily(as);
        this.fontSize = StyleConstants.getFontSize(as);
        this.formatText = new JDialog(new JFrame(), "Font and Size", true);
        this.formatText.getContentPane().setLayout(new BorderLayout());
        JPanel choosers = new JPanel();
        choosers.setLayout(new GridLayout(2, 1));
        JPanel fontFamilyPanel = new JPanel();
        fontFamilyPanel.add(new JLabel("Font"));
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] fontNames = ge.getAvailableFontFamilyNames();
        this.fontFamilyChooser = new JComboBox();
        for (int i = 0; i < fontNames.length; ++i) {
            this.fontFamilyChooser.addItem(fontNames[i]);
        }
        this.fontFamilyChooser.setSelectedItem(this.family);
        fontFamilyPanel.add(this.fontFamilyChooser);
        choosers.add(fontFamilyPanel);
        JPanel fontSizePanel = new JPanel();
        fontSizePanel.add(new JLabel("Size"));
        this.fontSizeChooser = new JComboBox();
        this.fontSizeChooser.setEditable(true);
        this.fontSizeChooser.addItem(new Float(4.0f));
        this.fontSizeChooser.addItem(new Float(8.0f));
        this.fontSizeChooser.addItem(new Float(12.0f));
        this.fontSizeChooser.addItem(new Float(16.0f));
        this.fontSizeChooser.addItem(new Float(20.0f));
        this.fontSizeChooser.addItem(new Float(24.0f));
        this.fontSizeChooser.setSelectedItem(new Float(this.fontSize));
        fontSizePanel.add(this.fontSizeChooser);
        choosers.add(fontSizePanel);
        JButton ok = new JButton("OK");
        ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                FontAndSizeAction.this.accept = true;
                FontAndSizeAction.this.formatText.dispose();
                FontAndSizeAction.this.family = (String)FontAndSizeAction.this.fontFamilyChooser.getSelectedItem();
                FontAndSizeAction.this.fontSize = Float.parseFloat(FontAndSizeAction.this.fontSizeChooser.getSelectedItem().toString());
            }
        });
        JButton cancel = new JButton("Cancel");
        cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                FontAndSizeAction.this.formatText.dispose();
            }
        });
        JPanel buttons = new JPanel();
        buttons.add(ok);
        buttons.add(cancel);
        this.formatText.getContentPane().add((Component)choosers, "Center");
        this.formatText.getContentPane().add((Component)buttons, "South");
        this.formatText.pack();
        this.formatText.setVisible(true);
        SimpleAttributeSet attr = null;
        if (editor != null && this.accept) {
            attr = new SimpleAttributeSet();
            StyleConstants.setFontFamily(attr, this.family);
            StyleConstants.setFontSize(attr, (int)this.fontSize);
            this.setCharacterAttributes(editor, attr, false);
        }
    }
}

