/*
 * Decompiled with CFR 0.152.
 */
package utils;

import gestionale.configurazioni.Configurazioni;
import java.awt.Desktop;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import utils.Funzioni;
import utils.MyTrace;

public class FileCopy {
    public String carica_file(File file_da_copiare) {
        try {
            int len;
            FileInputStream in = new FileInputStream(file_da_copiare);
            File outputFile = new File(Configurazioni.hm.get("path_bolle") + "\\" + file_da_copiare.getName());
            FileOutputStream out = new FileOutputStream(outputFile);
            byte[] buf = new byte[1024];
            while ((len = ((InputStream)in).read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            ((InputStream)in).close();
            ((OutputStream)out).close();
            return outputFile.getName();
        }
        catch (FileNotFoundException ex) {
            MyTrace.log.info("File da copiare non trovato");
            Funzioni.inviaBugPerEmail(ex);
            Funzioni.LogStackTrace(ex);
            return "";
        }
        catch (IOException ex) {
            MyTrace.log.info("File Writer non creato");
            Funzioni.inviaBugPerEmail(ex);
            Funzioni.LogStackTrace(ex);
            return "";
        }
    }

    public boolean delete_file(File file_da_cancellare) {
        if (file_da_cancellare.exists()) {
            if (file_da_cancellare.canWrite()) {
                boolean success = file_da_cancellare.delete();
                if (success) {
                    return true;
                }
                IllegalArgumentException ex = new IllegalArgumentException("Delete: filed: " + file_da_cancellare.getName());
                MyTrace.log.severe("Delete: filed: " + file_da_cancellare.getName());
                Funzioni.inviaBugPerEmail(ex);
                Funzioni.LogStackTrace(ex);
                return false;
            }
            IllegalArgumentException ex = new IllegalArgumentException("Delete: no such file or directory: " + file_da_cancellare.getName());
            MyTrace.log.severe("Delete: no such file or directory: " + file_da_cancellare.getName());
            Funzioni.inviaBugPerEmail(ex);
            Funzioni.LogStackTrace(ex);
            return false;
        }
        IllegalArgumentException ex = new IllegalArgumentException("Delete: write protected: " + file_da_cancellare.getName());
        MyTrace.log.severe("Delete: write protected: " + file_da_cancellare.getName());
        Funzioni.inviaBugPerEmail(ex);
        Funzioni.LogStackTrace(ex);
        return false;
    }

    public void vedi_file(String name) {
        File temp = new File(Configurazioni.hm.get("path_bolle") + "\\" + name);
        try {
            Desktop desktop = null;
            if (Desktop.isDesktopSupported()) {
                desktop = Desktop.getDesktop();
            }
            desktop.open(temp);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public File creaFile(String name) {
        File temp = new File(Configurazioni.hm.get("path_bolle") + "\\" + name);
        return temp;
    }
}

