/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.awt.Dimension;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.JFormattedTextField;
import utils.Funzioni;
import utils.FunzioniDate;
import utils.JCalendarPopup;
import utils.MyTrace;

public class DateField
extends JFormattedTextField
implements PropertyChangeListener,
KeyListener,
FocusListener {
    FunzioniDate fd = new FunzioniDate();
    Date targetDate = null;
    String dateParam = "date";
    String languageString = null;
    public static final String LANGUAGE_PARAM = "language";

    public DateField() {
    }

    public DateField(JFormattedTextField.AbstractFormatter formatter) {
        super(formatter);
        this.setPreferredSize(new Dimension(100, 27));
        this.addKeyListener(this);
        this.addFocusListener(this);
    }

    public Date getTargetDate() {
        return this.targetDate;
    }

    public void setTargetDate(Date dateTarget) {
        this.targetDate = dateTarget;
    }

    public String getDateParam() {
        return this.dateParam;
    }

    public void setDateParam(String newParam) {
        this.dateParam = newParam;
    }

    public void cambia(PropertyChangeEvent evt) {
        if (evt.getNewValue() instanceof Date) {
            Date d = (Date)evt.getNewValue();
            GregorianCalendar cal = new GregorianCalendar();
            String DATE_FORMAT = "yyyy-MM-dd";
            SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
            String dataNew = sdf.format(d);
            this.setText(this.fd.gira_data(dataNew));
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
        if (this.dateParam.equalsIgnoreCase(evt.getPropertyName()) && evt.getNewValue() instanceof Date) {
            this.targetDate = (Date)evt.getNewValue();
        }
        if (LANGUAGE_PARAM.equalsIgnoreCase(evt.getPropertyName()) && evt.getNewValue() instanceof String) {
            this.languageString = (String)evt.getNewValue();
        }
        this.cambia(evt);
    }

    @Override
    public void keyTyped(KeyEvent e) {
        int keyCode = e.getKeyCode();
        if (keyCode == 115) {
            Date dateTarget = this.getTargetDate();
            JCalendarPopup popup = JCalendarPopup.createCalendarPopup(this.getDateParam(), dateTarget, this, this.languageString);
            popup.addPropertyChangeListener(this);
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        int keyCode = e.getKeyCode();
        if (keyCode == 115) {
            Date dateTarget = this.getTargetDate();
            JCalendarPopup popup = JCalendarPopup.createCalendarPopup(this.getDateParam(), dateTarget, this, this.languageString);
            popup.addPropertyChangeListener(this);
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        try {
            this.setText(this.getText().replaceAll(" ", ""));
        }
        catch (Exception ex) {
            MyTrace.log.severe("ECCEZIONE focusLost() del DateField");
            ex.printStackTrace();
            Funzioni.inviaBugPerEmail(ex);
            Funzioni.LogStackTrace(ex);
        }
    }
}

