/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.Timer;
import utils.Funzioni;
import utils.MyTrace;
import utils.Risorse;

public class BannerAttesa {
    public static long tempo_franchigia = 500L;
    private final int timeout = 5000;
    private final int tempo_show = 800;
    private final int tempo_hide = 400;
    private final int passi_per_show = 10;
    private final int passi_per_hide = 8;
    JDialog banner = new JDialog();
    private Timer show = null;
    private Timer hide = null;
    private float grado_trasparenza = 0.0f;
    private int passo = 0;
    boolean trasparenza_possibile;
    private long tempo_di_visualizzazione;
    private int modalita = 0;
    private boolean start = false;
    public static long attivazioni = 0L;
    public static long disattivazioni = 0L;

    public BannerAttesa(int modalita) {
        this.modalita = modalita;
        this.inizializza();
    }

    public BannerAttesa() {
        this.modalita = 0;
        this.inizializza();
    }

    private void inizializza() {
        int hSize;
        int wSize;
        MyTrace.log.config("BannerAttesa inizializza() START");
        JLabel imageLabel = new JLabel();
        Risorse risorse = Risorse.puntatore;
        this.banner.setUndecorated(true);
        RoundRectangle2D.Double forma = null;
        double hh = Toolkit.getDefaultToolkit().getScreenSize().getHeight();
        double ww = Toolkit.getDefaultToolkit().getScreenSize().getWidth();
        if (this.modalita == 0) {
            wSize = 250;
            hSize = 40;
            this.banner.setLocation((int)ww / 2 - wSize / 2, (int)hh / 2 - hSize / 2 + 150);
            this.banner.setSize(wSize, hSize);
            forma = new RoundRectangle2D.Double(0.0, 0.0, wSize, hSize, 30.0, 30.0);
        }
        if (this.modalita == 1) {
            wSize = 32;
            hSize = 32;
            this.banner.setLocation((int)ww - 100, (int)hh - 100);
            this.banner.setSize(wSize, hSize);
        }
        try {
            this.banner.setShape(forma);
        }
        catch (Exception ex) {
            MyTrace.log.severe("ERRORE:  eccezione di istanziazione della configurazione (PROBABILE PROBLEMA CON LA VERSIONE DI JAVA)");
            ex.printStackTrace();
            Funzioni.inviaBugPerEmail(ex);
            Funzioni.LogStackTrace(ex);
        }
        catch (Error err) {
            MyTrace.log.severe("ERRORE: errore di avvio o di linkaggio(PROBABILE PROBLEMA CON LA VERSIONE DI JAVA)");
            err.printStackTrace();
        }
        try {
            if (this.modalita == 0) {
                imageLabel.setIcon(risorse.icona_attesa);
            }
            if (this.modalita == 1) {
                imageLabel.setIcon(risorse.icona_elabora);
            }
            imageLabel.setName("Attesa");
            this.banner.add(imageLabel);
            this.banner.getRootPane().setOpaque(false);
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice gs = ge.getDefaultScreenDevice();
            this.trasparenza_possibile = gs.isWindowTranslucencySupported(GraphicsDevice.WindowTranslucency.TRANSLUCENT);
            if (this.trasparenza_possibile) {
                this.impostaTrasparenza(0.0f);
                MyTrace.log.config("modalit\u00e0 translucida attiva");
            }
        }
        catch (Exception ex) {
            MyTrace.log.severe("ERRORE:  eccezione di istanziazione della grafica del Banner (Le Configurazioni sono istanziate?)");
            ex.printStackTrace();
            Funzioni.inviaBugPerEmail(ex);
            Funzioni.LogStackTrace(ex);
        }
        this.passo = 0;
        this.show = new Timer(80, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MyTrace.log.finer("show passo=" + BannerAttesa.this.passo + " V=" + BannerAttesa.this.grado_trasparenza);
                if (BannerAttesa.this.passo > 0) {
                    BannerAttesa.this.passo++;
                    if (BannerAttesa.this.passo <= 10) {
                        BannerAttesa.this.grado_trasparenza += 0.1f;
                        BannerAttesa.this.grado_trasparenza = (double)BannerAttesa.this.grado_trasparenza > 0.85 ? 1.0f : BannerAttesa.this.grado_trasparenza;
                        BannerAttesa.this.impostaTrasparenza(BannerAttesa.this.grado_trasparenza);
                    } else if ((double)BannerAttesa.this.grado_trasparenza >= 1.0) {
                        BannerAttesa.this.grado_trasparenza = 1.0f;
                        BannerAttesa.this.show.stop();
                    }
                } else {
                    BannerAttesa.this.passo++;
                    BannerAttesa.this.grado_trasparenza = 0.0f;
                    BannerAttesa.this.impostaTrasparenza(BannerAttesa.this.grado_trasparenza);
                }
            }
        });
        this.hide = new Timer(50, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MyTrace.log.finer("hide passo=" + BannerAttesa.this.passo + " V=" + BannerAttesa.this.grado_trasparenza);
                BannerAttesa.this.passo++;
                if (BannerAttesa.this.passo <= 8) {
                    BannerAttesa.this.grado_trasparenza -= 0.125f;
                    BannerAttesa.this.grado_trasparenza = (double)BannerAttesa.this.grado_trasparenza < 0.15 ? 0.0f : BannerAttesa.this.grado_trasparenza;
                    BannerAttesa.this.impostaTrasparenza(BannerAttesa.this.grado_trasparenza);
                } else {
                    if (BannerAttesa.this.grado_trasparenza <= 0.0f) {
                        BannerAttesa.this.grado_trasparenza = 0.0f;
                        BannerAttesa.this.impostaTrasparenza(BannerAttesa.this.grado_trasparenza);
                        BannerAttesa.this.hide.stop();
                    }
                    if (BannerAttesa.this.start) {
                        BannerAttesa.this.hide.stop();
                        BannerAttesa.this.start = false;
                        BannerAttesa.this.passo = 0;
                        BannerAttesa.this.show.start();
                    }
                }
            }
        });
        this.show.setRepeats(true);
        this.hide.setRepeats(true);
        MyTrace.log.config("BannerAttesa inizializza() STOP");
    }

    private synchronized void visualizza() {
        MyTrace.log.finer("BannerAttesa => Visualizza()    (ATTIVO)");
        this.impostaTrasparenza(0.0f);
        this.banner.setVisible(true);
        this.banner.setAlwaysOnTop(true);
    }

    private void impostaTrasparenza(float grado_trasparenza_da_assegnare) {
        MyTrace.log.finer("BannerAttesa => Trasparenza =" + grado_trasparenza_da_assegnare);
        if (this.trasparenza_possibile) {
            this.banner.setOpacity(0.0f);
        } else {
            if (grado_trasparenza_da_assegnare <= 0.0f) {
                this.banner.setVisible(false);
            }
            if (grado_trasparenza_da_assegnare >= 1.0f) {
                this.banner.setVisible(true);
                this.banner.setAlwaysOnTop(true);
            }
        }
    }

    private synchronized void fermaTutto() {
        MyTrace.log.finest("BannerAttesa => FermaTutto  (DISATTIVO)");
        this.banner.setVisible(false);
        this.show.stop();
        this.hide.stop();
        this.passo = 0;
        this.grado_trasparenza = 0.0f;
    }

    public synchronized void start() {
        MyTrace.log.fine("BannerAttesa => START g=" + this.grado_trasparenza + " hide.isRunning()=" + this.hide.isRunning());
        ++attivazioni;
        if (this.hide.isRunning()) {
            this.start = true;
        } else if (!this.show.isRunning()) {
            MyTrace.log.fine("BannerAttesa => VISUALIZZO   START");
            this.tempo_di_visualizzazione = System.currentTimeMillis();
            this.visualizza();
            this.passo = 0;
            this.show.start();
        }
    }

    public synchronized void stop() {
        MyTrace.log.finer("BannerAttesa => STOP g=" + this.grado_trasparenza + " show.isRunning()=" + this.show.isRunning());
        this.start = false;
        ++disattivazioni;
        if (this.show.isRunning() || (double)this.grado_trasparenza >= 1.0) {
            MyTrace.log.fine("PERFORMANCE: BannerAttesa => NASCONDO START  durata=" + (System.currentTimeMillis() - this.tempo_di_visualizzazione) + " millisecondi");
            this.show.stop();
            if (!this.hide.isRunning()) {
                this.passo = 0;
                this.hide.start();
            }
        }
    }
}

