/*
 * Decompiled with CFR 0.152.
 */
package trasporti.viaggi;

import anagrafiche.clienti_fornitori.Anagrafica;
import anagrafiche.mezzi.Mezzo;
import com.mysql.jdbc.ResultSetMetaData;
import controlling.analitica_operativa.AnaliticaOperativaVDA;
import gestionale.MyDesktopWindow;
import gestionale.configurazioni.Configurazioni;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.Iterator;
import javax.swing.JOptionPane;
import trasporti.autista.Autista;
import trasporti.bolle.Bolla;
import trasporti.bolle.InsiemeBolle;
import trasporti.listini.TraListino;
import trasporti.ordini.InsiemeOrdini;
import trasporti.ordini.InsiemeRigheOrdineViaggio;
import trasporti.ordini.Ordine;
import trasporti.ordini.RigaOrdineViaggio;
import trasporti.pedane.InsiemePedane;
import trasporti.pedane.Pedana;
import trasporti.prese_consegne.InsiemePC;
import trasporti.prese_consegne.PresaConsegna;
import trasporti.scheda_di_trasporto.InsiemeSchedeTrasporto;
import trasporti.tratte.Tratta;
import utils.Funzioni;
import utils.FunzioniDate;
import utils.FunzioniTrasporti;
import utils.Money;
import utils.MyTrace;

public class Viaggio {
    private String descrizione;
    private String data_partenza = "0000-00-00";
    private String data_arrivo = "0000-00-00";
    private String ora_partenza = "00:00";
    private String ora_arrivo = "00:00";
    private String desc_breve;
    private String ar;
    private String pv;
    private String rag_soc_vettore;
    private String cognome_autista;
    private String nome_autista;
    private String codice_vettore;
    private String ordini_in_viaggio;
    private String targa_trattore;
    private String targa_rimorchio;
    private String clienti_in_viaggio;
    private String n_ordini_clienti_in_viaggio;
    private String descrizione_trattore;
    private int id;
    private int id_autista;
    private int id_trattore;
    private int id_rimorchio;
    private int id_avettore;
    private int id_cdr_trattore;
    private int numero_viaggio;
    private int anno;
    private int confermato;
    private double km_percorsi;
    private double km_a_vuoto;
    private double km_partenza;
    private double km_arrivo;
    private double km_tot;
    private double tot_km_ordine;
    private InsiemePC insieme_pc;
    private InsiemeOrdini insieme_o;
    private InsiemeRigheOrdineViaggio insieme_r_fp;
    private InsiemeRigheOrdineViaggio insieme_righe_ordini;
    private Autista autista;
    private Mezzo trattore;
    private Mezzo rimorchio;
    private Anagrafica vettore;
    private InsiemePedane insieme_pedane;
    private InsiemeSchedeTrasporto insieme_schede_trasporto;
    private Tratta tratta;
    private TraListino listino;
    private Money prezzo = new Money(BigDecimal.ZERO);
    private Money fatturato = new Money(BigDecimal.ZERO);
    private Money tot_ordine_fattura = new Money(BigDecimal.ZERO);
    private Funzioni f = new Funzioni();
    private FunzioniDate fda = new FunzioniDate();
    private FunzioniTrasporti ft = new FunzioniTrasporti();
    private Tratta[] array_tratte;
    public AnaliticaOperativaVDA analitica_viaggio;
    private InsiemeBolle insieme_bolle;

    public Viaggio() {
        this.insieme_r_fp = new InsiemeRigheOrdineViaggio();
    }

    public String toString() {
        return "V. N\u00b0 " + this.getNumero_viaggio() + " [" + this.getDesc_breve() + "] del " + this.getData_partenza_it();
    }

    public Tratta[] getArray_tratte() {
        return this.array_tratte;
    }

    public void setArray_tratte(Tratta[] array_tratte) {
        this.array_tratte = array_tratte;
    }

    public String getCodice_vettore() {
        return this.codice_vettore;
    }

    public void setCodice_vettore(String codice_vettore) {
        this.codice_vettore = codice_vettore;
    }

    public String getTratta_complessiva() {
        return this.desc_breve;
    }

    public void setTratta_complessiva(String tratta_complessiva) {
        this.desc_breve = tratta_complessiva;
    }

    public String getData_arrivo() {
        return this.data_arrivo;
    }

    public void setData_arrivo(String data_arrivo) {
        this.data_arrivo = data_arrivo;
    }

    public String getData_partenza() {
        return this.data_partenza;
    }

    public void setData_partenza(String data_partenza) {
        this.data_partenza = data_partenza;
    }

    public String getDescrizione() {
        return this.descrizione;
    }

    public void setDescrizione(String descrizione) {
        this.descrizione = descrizione;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getId_autista() {
        return this.id_autista;
    }

    public void setId_autista(int id_autista) {
        this.id_autista = id_autista;
    }

    public int getId_rimorchio() {
        return this.id_rimorchio;
    }

    public void setId_rimorchio(int id_rimorchio) {
        this.id_rimorchio = id_rimorchio;
    }

    public int getId_trattore() {
        return this.id_trattore;
    }

    public void setId_trattore(int id_trattore) {
        this.id_trattore = id_trattore;
    }

    public String getTarga_rimorchio() {
        return this.targa_rimorchio;
    }

    public void setTarga_rimorchio(String targa_rimorchio) {
        this.targa_rimorchio = targa_rimorchio;
    }

    public InsiemePC getInsieme_pc() {
        return this.insieme_pc;
    }

    public void setInsieme_pc(InsiemePC insieme_pc) {
        this.insieme_pc = insieme_pc;
    }

    public String getOra_arrivo() {
        return this.ora_arrivo;
    }

    public void setOra_arrivo(String ora_arrivo) {
        this.ora_arrivo = ora_arrivo;
    }

    public String getOra_partenza() {
        return this.ora_partenza;
    }

    public void setOra_partenza(String ora_partenza) {
        this.ora_partenza = ora_partenza;
    }

    public Autista getAutista() {
        return this.autista;
    }

    public void setAutista(Autista autista) {
        this.autista = autista;
    }

    public Mezzo getRimorchio() {
        return this.rimorchio;
    }

    public void setRimorchio(Mezzo rimorchio) {
        this.rimorchio = rimorchio;
    }

    public Mezzo getTrattore() {
        return this.trattore;
    }

    public void setTrattore(Mezzo trattore) {
        this.trattore = trattore;
    }

    public String getDesc_breve() {
        return this.desc_breve;
    }

    public void setDesc_breve(String desc_breve) {
        this.desc_breve = desc_breve;
    }

    public int getId_cdr_trattore() {
        return this.id_cdr_trattore;
    }

    public void setId_cdr_trattore(int id_cdr_trattore) {
        this.id_cdr_trattore = id_cdr_trattore;
    }

    public Anagrafica getVettore() {
        return this.vettore;
    }

    public void setVettore(Anagrafica vettore) {
        this.vettore = vettore;
    }

    public int getId_avettore() {
        return this.id_avettore;
    }

    public void setId_avettore(int id_vettore) {
        this.id_avettore = id_vettore;
    }

    public String getAr() {
        return this.ar;
    }

    public void setAr(String ar) {
        this.ar = ar;
    }

    public String getData_arrivo_it() {
        return this.fda.gira_data(this.getData_arrivo());
    }

    public String getData_partenza_it() {
        return this.fda.gira_data(this.getData_partenza());
    }

    public String getPv() {
        return this.pv;
    }

    public void setPv(String pv) {
        this.pv = pv;
    }

    public String getRag_soc_vettore() {
        return this.rag_soc_vettore;
    }

    public void setRag_soc_vettore(String rag_soc_vettore) {
        this.rag_soc_vettore = rag_soc_vettore;
    }

    public String getCognome_autista() {
        return this.cognome_autista;
    }

    public void setCognome_autista(String cognome_autista) {
        this.cognome_autista = cognome_autista;
    }

    public String getNome_autista() {
        return this.nome_autista;
    }

    public void setNome_autista(String nome_autista) {
        this.nome_autista = nome_autista;
    }

    public int getAnno() {
        return this.anno;
    }

    public void setAnno(int anno) {
        this.anno = anno;
    }

    public int getNumero_viaggio() {
        return this.numero_viaggio;
    }

    public void setNumero_viaggio(int numero_viaggio) {
        this.numero_viaggio = numero_viaggio;
    }

    public int getConfermato() {
        return this.confermato;
    }

    public void setConfermato(int confermato) {
        this.confermato = confermato;
    }

    public InsiemeRigheOrdineViaggio getInsieme_r_fp() {
        return this.insieme_r_fp;
    }

    public void setInsieme_r_fp(InsiemeRigheOrdineViaggio insieme_r_fp) {
        this.insieme_r_fp = insieme_r_fp;
    }

    public Tratta getTratta() {
        return this.tratta;
    }

    public void setTratta(Tratta tratta) {
        this.tratta = tratta;
    }

    public TraListino getListino() {
        return this.listino;
    }

    public void setListino(TraListino listino) {
        this.listino = listino;
    }

    public Money getPrezzo() {
        return this.prezzo;
    }

    public void setPrezzo(Money prezzo) {
        this.prezzo = prezzo;
    }

    public InsiemeOrdini getInsieme_o() {
        return this.insieme_o;
    }

    public void setInsieme_o(InsiemeOrdini insieme_o) {
        this.insieme_o = insieme_o;
    }

    public double getKm_a_vuoto() {
        return this.km_a_vuoto;
    }

    public void setKm_a_vuoto(double km_a_vuoto) {
        this.km_a_vuoto = km_a_vuoto;
    }

    public double getKm_arrivo() {
        return this.km_arrivo;
    }

    public void setKm_arrivo(double km_arrivo) {
        this.km_arrivo = km_arrivo;
    }

    public double getKm_partenza() {
        return this.km_partenza;
    }

    public void setKm_partenza(double km_partenza) {
        this.km_partenza = km_partenza;
    }

    public double getKm_percorsi() {
        return this.km_percorsi;
    }

    public void setKm_percorsi(double km_percorsi) {
        this.km_percorsi = km_percorsi;
    }

    public double getKm_tot() {
        return this.km_tot;
    }

    public void setKm_tot(double km_tot) {
        this.km_tot = km_tot;
    }

    public InsiemePedane getInsieme_pedane() {
        return this.insieme_pedane;
    }

    public void setInsieme_pedane(InsiemePedane insieme_pedane) {
        this.insieme_pedane = insieme_pedane;
    }

    public InsiemeSchedeTrasporto getInsieme_schede_trasporto() {
        return this.insieme_schede_trasporto;
    }

    public void setInsieme_schede_trasporto(InsiemeSchedeTrasporto insieme_schede_trasporto) {
        this.insieme_schede_trasporto = insieme_schede_trasporto;
    }

    public AnaliticaOperativaVDA getAnalitica_viaggio() {
        return this.analitica_viaggio;
    }

    public void setAnalitica_viaggio(AnaliticaOperativaVDA analitica_viaggio) {
        this.analitica_viaggio = analitica_viaggio;
    }

    public String getOrdini_in_viaggio() {
        return this.ordini_in_viaggio;
    }

    public void setOrdini_in_viaggio(String ordini_in_viaggio) {
        this.ordini_in_viaggio = ordini_in_viaggio;
    }

    public InsiemeBolle getInsieme_bolle() {
        return this.insieme_bolle;
    }

    public void setInsieme_bolle(InsiemeBolle insieme_bolle) {
        this.insieme_bolle = insieme_bolle;
    }

    public InsiemeRigheOrdineViaggio getInsieme_righe_ordini() {
        return this.insieme_righe_ordini;
    }

    public void setInsieme_righe_ordini(InsiemeRigheOrdineViaggio insieme_righe_ordini) {
        this.insieme_righe_ordini = insieme_righe_ordini;
    }

    public String getTarga_trattore() {
        return this.targa_trattore;
    }

    public void setTarga_trattore(String targa_trattore) {
        this.targa_trattore = targa_trattore;
    }

    public String getClienti_in_viaggio() {
        return this.clienti_in_viaggio;
    }

    public void setClienti_in_viaggio(String clienti_in_viaggio) {
        this.clienti_in_viaggio = clienti_in_viaggio;
    }

    public String getN_ordini_clienti_in_viaggio() {
        return this.n_ordini_clienti_in_viaggio;
    }

    public void setN_ordini_clienti_in_viaggio(String n_ordini_clienti_in_viaggio) {
        this.n_ordini_clienti_in_viaggio = n_ordini_clienti_in_viaggio;
    }

    public String getDescrizione_trattore() {
        return this.descrizione_trattore;
    }

    public void setDescrizione_trattore(String descrizione_trattore) {
        this.descrizione_trattore = descrizione_trattore;
    }

    public Money getFatturato() {
        return this.fatturato;
    }

    public void setFatturato(Money fatturato) {
        this.fatturato = fatturato;
    }

    public Money getTot_ordine_fattura() {
        return this.tot_ordine_fattura;
    }

    public void setTot_ordine_fattura(Money tot_ordine_fattura) {
        this.tot_ordine_fattura = tot_ordine_fattura;
    }

    public double getTot_km_ordine() {
        return this.tot_km_ordine;
    }

    public void setTot_km_ordine(double tot_km_ordine) {
        this.tot_km_ordine = tot_km_ordine;
    }

    public boolean inserisciViaggio(boolean da_solo) {
        MyTrace.log.info("START Inserimento viaggio");
        try {
            String query_ins;
            boolean r_ins;
            if (da_solo) {
                Configurazioni.getIstanza().connessione.start_transaction();
            }
            if (!(r_ins = Configurazioni.getIstanza().connessione.eseguiAggiornamento(query_ins = "INSERT INTO mtra_viaggi(descrizione,desc_breve,id_autista,id_mezzo,id_rimorchio,data_partenza,ora_partenza,id_anagrafica,andata_ritorno,km_percorsi,km_a_vuoto,km_tot,km_partenza,km_arrivo) VALUES ('" + this.getDescrizione().replaceAll("'", "''") + "'," + "'" + this.getDesc_breve().replaceAll("'", "''") + "'," + "" + this.f.zero_to_null(this.getId_autista()) + "," + this.f.zero_to_null(this.getId_trattore()) + "," + "" + this.f.zero_to_null(this.getId_rimorchio()) + "," + "'" + this.getData_partenza() + "'," + "'" + this.getOra_partenza() + "'," + "" + this.f.zero_to_null(this.getId_avettore()) + "," + "'" + this.getAr() + "'," + "" + this.getKm_percorsi() + "," + "" + this.getKm_a_vuoto() + "," + "" + this.getKm_tot() + "," + "" + this.getKm_partenza() + "," + "" + this.getKm_arrivo() + ")"))) {
                MyTrace.log.severe("Inserimento viaggio non riuscito");
                Configurazioni.getIstanza().connessione.rollback();
                Configurazioni.eccezione.gestisci("2.2", null);
                return false;
            }
            String strSQL = "SELECT @@identity FROM mtra_viaggi";
            ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(strSQL);
            int id_inserito = 0;
            try {
                while (res.next()) {
                    id_inserito = res.getInt("@@identity");
                }
            }
            catch (Exception e) {
                Funzioni.inviaBugPerEmail(e);
                Funzioni.LogStackTrace(e);
                e.printStackTrace();
            }
            Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
            this.setId(id_inserito);
            boolean res_c = true;
            if (this.getConfermato() == 1) {
                res_c = this.conferma_viaggio();
            }
            if (!res_c) {
                MyTrace.log.severe("Inserimento viaggio non riuscito per conferma");
                Configurazioni.getIstanza().connessione.rollback();
                Configurazioni.eccezione.gestisci("2.2", null);
                return false;
            }
            boolean res1 = true;
            boolean res_pc = true;
            Iterator i = this.getInsieme_pc().vettorePC.iterator();
            int count = 0;
            while (i.hasNext()) {
                PresaConsegna pc = (PresaConsegna)i.next();
                if (pc.getId_pc() == 0) {
                    res_pc = pc.inserisciPC(false);
                }
                if (!res_pc) {
                    MyTrace.log.severe("Inserimento viaggio non riuscito per pc transito");
                    Configurazioni.getIstanza().connessione.rollback();
                    Configurazioni.eccezione.gestisci("2.2", null);
                    return false;
                }
                if (pc.getId_viaggio() != this.getId() && pc.getId_viaggio() != 0) continue;
                pc.setOrdine(count);
                pc.setId_viaggio(this.getId());
                boolean res_p = pc.assegnaAViaggio(false);
                if (!res_p) {
                    Configurazioni.getIstanza().connessione.rollback();
                    MyTrace.log.severe("Inserimento viaggio non riuscito per ASSEGNAZIONE PRESA/CONSEGNA");
                    Configurazioni.eccezione.gestisci("2.3", null);
                    return false;
                }
                boolean trovato = false;
                if (this.getInsieme_o() != null) {
                    Iterator i_o = this.getInsieme_o().vettoreO.iterator();
                    while (i_o.hasNext() && !trovato) {
                        Ordine o = (Ordine)i_o.next();
                        if (o.getId() != pc.getId_ordine()) continue;
                        trovato = true;
                    }
                } else {
                    this.setInsieme_o(new InsiemeOrdini());
                }
                if (trovato) continue;
                Ordine o = new Ordine();
                o.seleziona("where id_ordine=" + pc.getId_ordine());
                this.getInsieme_o().vettoreO.add(o);
            }
            boolean res3 = true;
            if (this.getTratta().getId() == 0) {
                res3 = this.getTratta().inserisciTratta(false);
            }
            if (this.getArray_tratte() != null) {
                for (int j = 0; j < this.getArray_tratte().length; ++j) {
                    if (this.getArray_tratte()[j].getId() != 0) continue;
                    res3 = this.getArray_tratte()[j].inserisciTratta(false);
                }
            }
            if (!res3) {
                MyTrace.log.severe("Inserimento viaggio non riuscito per tratta");
                Configurazioni.getIstanza().connessione.rollback();
                Configurazioni.eccezione.gestisci("2.2", null);
                return false;
            }
            boolean res5 = true;
            for (RigaOrdineViaggio ro : this.getInsieme_r_fp().vettoreR) {
                ro.setId_viaggio(this.getId());
                if (ro.getT_o().equals("T") && ro.getId_tratta() == 0) {
                    ro.setId_tratta(this.getTratta().getId());
                }
                res5 = ro.iinserisci(false);
            }
            if (!res5) {
                MyTrace.log.severe("Inserimento viaggio non riuscito per rov");
                Configurazioni.getIstanza().connessione.rollback();
                Configurazioni.eccezione.gestisci("2.2", null);
                return false;
            }
            String q = "INSERT INTO mtra_ordini_viaggi_rif(id_ordine,id_viaggio) VALUES ";
            Iterator i_o = this.getInsieme_o().vettoreO.iterator();
            int primo_gruppo = 0;
            while (i_o.hasNext()) {
                Ordine o = (Ordine)i_o.next();
                if (primo_gruppo != 0) {
                    q = q + " ,\n";
                }
                q = q + " (" + o.getId() + "," + "" + this.getId() + ")";
                ++primo_gruppo;
            }
            q = q + " ";
            MyTrace.log.info("QUERY vari id ordini/viaggi =" + q);
            boolean r_ins_rel = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q);
            if (!r_ins_rel) {
                MyTrace.log.severe("Inserimento INSIEME id/ordine/id viaggio non riuscito");
                Configurazioni.getIstanza().connessione.rollback();
                Configurazioni.eccezione.gestisci("2.2", null);
                return false;
            }
            String q_trace = "INSERT INTO sys_trace(id_operatore,nome_tabella,id_soggetto,data,azione,query) VALUES('" + MyDesktopWindow.profilo.id + "','mtra_viaggi','" + this.getId() + "',NOW(),'INS','" + query_ins.replaceAll("'", "''") + "')";
            boolean r_trace = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_trace);
            if (!r_trace) {
                MyTrace.log.severe("Inserimento Viaggio non riuscito per trace");
                Configurazioni.getIstanza().connessione.rollback();
                Configurazioni.eccezione.gestisci("2.3", null);
                return false;
            }
            if (da_solo) {
                Configurazioni.getIstanza().connessione.commit();
            }
            return true;
        }
        catch (Exception ex) {
            MyTrace.log.severe("ERRORE:  eccezione inserisci() Viaggio");
            ex.printStackTrace();
            Funzioni.inviaBugPerEmail(ex);
            Funzioni.LogStackTrace(ex);
            return false;
        }
        catch (Error err) {
            MyTrace.log.severe("ERRORE: Main() inserisci di avvio o di linkaggio");
            err.printStackTrace();
            return false;
        }
    }

    public boolean modificaViaggio(boolean da_solo) {
        MyTrace.log.info("START Modifica viaggio");
        try {
            String q_trace;
            boolean r_trace;
            String query_mod;
            boolean r_mod;
            if (da_solo) {
                Configurazioni.getIstanza().connessione.start_transaction();
            }
            if (!(r_mod = Configurazioni.getIstanza().connessione.eseguiAggiornamento(query_mod = "UPDATE mtra_viaggi SET id_autista=" + this.f.zero_to_null(this.getId_autista()) + "," + " id_mezzo=" + this.f.zero_to_null(this.getId_trattore()) + "," + " id_rimorchio=" + this.f.zero_to_null(this.getId_rimorchio()) + "," + " descrizione='" + this.getDescrizione().replaceAll("'", "''") + "', " + " desc_breve='" + this.getDesc_breve().replaceAll("'", "''") + "', " + " data_partenza='" + this.getData_partenza() + "', " + " data_arrivo='" + this.fda.null_to_zero(this.getData_arrivo()) + "', " + " ora_partenza='" + this.fda.null_to_zero_ora(this.getOra_partenza()) + "', " + " id_anagrafica=" + this.f.zero_to_null(this.getId_avettore()) + ", " + " ora_arrivo='" + this.fda.null_to_zero_ora(this.getOra_arrivo()) + "', " + " km_percorsi=" + this.getKm_percorsi() + ", " + " km_a_vuoto=" + this.getKm_a_vuoto() + ", " + " km_partenza=" + this.getKm_partenza() + ", " + " km_arrivo=" + this.getKm_arrivo() + ", " + " km_tot=" + this.getKm_tot() + ", " + " andata_ritorno='" + this.getAr() + "' " + " WHERE id_viaggio=" + this.getId() + " "))) {
                MyTrace.log.severe("Modifica viaggio non riuscita");
                Configurazioni.getIstanza().connessione.rollback();
                Configurazioni.eccezione.gestisci("3.2", null);
                return false;
            }
            for (PresaConsegna rv : this.getInsieme_pc().vettorePC) {
                Ordine o;
                PresaConsegna pc;
                boolean res_p = true;
                if (rv.getId_viaggio() == this.getId() || rv.getId_viaggio() == 0) {
                    if (rv.getId_pc() == 0) {
                        rv.setId_viaggio(this.getId());
                        pc = rv;
                        pc.setId_viaggio(this.getId());
                        res_p = pc.assegnaAViaggio(false);
                    } else {
                        pc = rv;
                        pc.setId_viaggio(this.getId());
                        res_p = pc.assegnaAViaggio(false);
                    }
                } else {
                    pc = rv;
                    pc.setId_viaggio(0);
                    res_p = pc.assegnaAViaggio(false);
                }
                if (!res_p) {
                    MyTrace.log.severe("Modifica viaggio non riuscita per pc");
                    Configurazioni.getIstanza().connessione.rollback();
                    Configurazioni.eccezione.gestisci("3.2", null);
                    return false;
                }
                boolean trovato = false;
                Iterator i_o = this.getInsieme_o().vettoreO.iterator();
                while (i_o.hasNext() && !trovato) {
                    o = (Ordine)i_o.next();
                    if (o.getId() != rv.getId_ordine()) continue;
                    trovato = true;
                }
                if (trovato) continue;
                o = new Ordine();
                o.seleziona("where id_ordine=" + rv.getId_ordine());
                this.getInsieme_o().vettoreO.add(o);
            }
            boolean res3 = true;
            if (this.getTratta().getId() == 0) {
                res3 = this.getTratta().inserisciTratta(false);
            }
            if (this.getArray_tratte() != null) {
                for (int j = 0; j < this.getArray_tratte().length; ++j) {
                    if (this.getArray_tratte()[j].getId() != 0) continue;
                    res3 = this.getArray_tratte()[j].inserisciTratta(false);
                }
            }
            if (!res3) {
                MyTrace.log.severe("Modifica viaggio non riuscita per pc");
                Configurazioni.getIstanza().connessione.rollback();
                Configurazioni.eccezione.gestisci("3.2", null);
                return false;
            }
            boolean res1 = true;
            String w = " where id_viaggio=" + this.getId();
            res1 = this.getInsieme_r_fp().eliminaRighe(w);
            if (!res1) {
                MyTrace.log.severe("Modifica viaggio non riuscita per eliminazione righe");
                Configurazioni.getIstanza().connessione.rollback();
                Configurazioni.eccezione.gestisci("3.2", null);
                return false;
            }
            boolean res5 = true;
            for (RigaOrdineViaggio ro : this.getInsieme_r_fp().vettoreR) {
                ro.setId_viaggio(this.getId());
                if (ro.getT_o().equals("T") && ro.getId_tratta() == 0) {
                    ro.setId_tratta(this.getTratta().getId());
                }
                res5 = ro.iinserisci(false);
            }
            if (!res5) {
                MyTrace.log.severe("Modifica viaggio non riuscita per inserimento righe");
                Configurazioni.getIstanza().connessione.rollback();
                Configurazioni.eccezione.gestisci("3.2", null);
                return false;
            }
            boolean res_c = true;
            if (this.getConfermato() == 1) {
                res_c = this.conferma_viaggio();
            }
            if (!res_c) {
                MyTrace.log.severe("Modifica viaggio non riuscita per conferma viaggio");
                Configurazioni.getIstanza().connessione.rollback();
                Configurazioni.eccezione.gestisci("3.2", null);
                return false;
            }
            int primo_gruppo = 0;
            String q3 = "INSERT INTO mtra_ordini_viaggi_rif(id_ordine,id_viaggio) VALUES ";
            boolean res8 = true;
            for (Ordine o : this.getInsieme_o().vettoreO) {
                w = " where id_ordine=" + o.getId();
                res8 = this.getInsieme_righe_ordini().eliminaRighe(w);
                if (primo_gruppo != 0) {
                    q3 = q3 + " ,\n";
                }
                q3 = q3 + " (" + o.getId() + "," + "" + this.getId() + ")";
                ++primo_gruppo;
            }
            q3 = q3 + " ";
            if (!res8) {
                MyTrace.log.severe("Modifica viaggio non riuscita per eliminazione ro");
                Configurazioni.getIstanza().connessione.rollback();
                Configurazioni.eccezione.gestisci("3.2", null);
                return false;
            }
            for (RigaOrdineViaggio ro : this.getInsieme_righe_ordini().vettoreR) {
                res5 = ro.iinserisci(false);
                Ordine o = new Ordine();
                o.setId(ro.getId_ordine());
                o.seleziona_righe();
                o.aggiornaPrezzoTotale(false);
            }
            String q2 = "DELETE FROM mtra_ordini_viaggi_rif where id_viaggio=" + this.getId();
            boolean r_del = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q2);
            MyTrace.log.info("QUERY vari id ordini/viaggi =" + q3);
            boolean r_ins_rel = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q3);
            if (!r_ins_rel) {
                MyTrace.log.severe("Inserimento INSIEME id/ordine/id viaggio non riuscito");
                Configurazioni.getIstanza().connessione.rollback();
                Configurazioni.eccezione.gestisci("2.2", null);
                return false;
            }
            boolean res_bolla = true;
            for (Bolla b : this.getInsieme_bolle().vettoreV) {
                if (b == null) continue;
                if (b.getId_ordine() != 0) {
                    if (b.getId() == 0) {
                        res_bolla = b.inserisci(true);
                        continue;
                    }
                    res_bolla = b.modifica(true);
                    continue;
                }
                res_bolla = b.elimina(false);
            }
            if (!res_bolla) {
                MyTrace.log.severe("Viaggi_Modificao non riuscita per bolla");
                Configurazioni.eccezione.gestisci("3.3", null);
                return false;
            }
            if (this.getInsieme_pedane() != null) {
                for (Pedana p : this.getInsieme_pedane().vettorePedane) {
                    if (p.getId() == 0) {
                        if (p.getN_p_caricate() == 0 && p.getN_p_rotte() == 0) continue;
                        p.inserisci(true);
                        continue;
                    }
                    p.modifica(true);
                }
            }
            if (!(r_trace = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_trace = "INSERT INTO sys_trace(id_operatore,nome_tabella,id_soggetto,data,azione,query) VALUES('" + MyDesktopWindow.profilo.id + "','mtra_viaggi','" + this.getId() + "',NOW(),'MOD','" + query_mod.replaceAll("'", "''") + "')"))) {
                MyTrace.log.severe("Viaggi_Modificao non riuscita per trace");
                Configurazioni.eccezione.gestisci("3.3", null);
                return false;
            }
            if (da_solo) {
                Configurazioni.getIstanza().connessione.commit();
            }
            return true;
        }
        catch (Exception ex) {
            MyTrace.log.severe("ERRORE:  eccezione modifica viaggio()");
            ex.printStackTrace();
            Funzioni.inviaBugPerEmail(ex);
            Funzioni.LogStackTrace(ex);
            return false;
        }
        catch (Error err) {
            MyTrace.log.severe("ERRORE: modifica viaggio() inserisci di avvio o di linkaggio");
            err.printStackTrace();
            return false;
        }
    }

    public boolean conferma_viaggio() {
        String query_mod = "UPDATE mtra_viaggi SET numero_viaggio=" + this.f.zero_to_null(this.getNumero_viaggio()) + "," + " anno='" + this.getAnno() + "', " + " confermato=" + this.getConfermato() + " " + " WHERE id_viaggio='" + this.getId() + "'";
        boolean r_mod = Configurazioni.getIstanza().connessione.eseguiAggiornamento(query_mod);
        if (!r_mod) {
            String q_rollback = "rollback";
            boolean r = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_rollback);
            MyTrace.log.severe("Conferma viaggio non riuscita");
            Configurazioni.eccezione.gestisci("3.2", null);
            return false;
        }
        return true;
    }

    public void seleziona_dettagli() {
        this.setAutista(new Autista());
        this.getAutista().seleziona(this.getId_autista());
        this.setTrattore(new Mezzo());
        String w2 = " WHERE mtra_mezzi.id_macchina= " + this.getId_trattore() + " ";
        this.getTrattore().seleziona(w2);
        this.setRimorchio(new Mezzo());
        w2 = " WHERE mtra_mezzi.id_macchina= " + this.getId_rimorchio() + " ";
        this.getRimorchio().seleziona(w2);
        this.setInsieme_pc(new InsiemePC());
        String w = " WHERE mtra_prese_consegne.id_viaggio= " + this.getId() + "";
        String order_by = "   ORDER BY ordine_viaggio";
        this.getInsieme_pc().caricamento(w, order_by);
        w2 = " WHERE mtra_ordini_viaggi_righe.id_viaggio='" + this.getId() + "'";
        InsiemeRigheOrdineViaggio i_r = new InsiemeRigheOrdineViaggio();
        i_r.caricamento(w2, "");
        this.setInsieme_r_fp(i_r);
        String where = " WHERE mtra_ordini_viaggi_rif.id_viaggio=" + this.getId();
        this.setInsieme_o(new InsiemeOrdini());
        this.getInsieme_o().caricamento(where, "", false);
        String w1 = " WHERE 1 AND (  ";
        String w3 = " WHERE 1 AND (  ";
        for (Ordine o : this.getInsieme_o().vettoreO) {
            o.seleziona_anagrafica();
            w1 = w1 + "  mtra_ordini.id_ordine= " + o.getId() + " OR ";
            w3 = w3 + "  mtra_bolle.id_ordine= " + o.getId() + " OR ";
        }
        w1 = w1 + "0) ";
        w3 = w3 + "0) ";
        this.setInsieme_righe_ordini(new InsiemeRigheOrdineViaggio());
        this.getInsieme_righe_ordini().caricamento(w1, "");
        this.setInsieme_bolle(new InsiemeBolle());
        this.getInsieme_bolle().caricamento(w3, "");
        this.setInsieme_pedane(new InsiemePedane());
        for (PresaConsegna presa : this.getInsieme_pc().vettorePC) {
            String where2 = " WHERE id_presa= " + presa.getId_pc() + "";
            this.getInsieme_pedane().caricamento2(where2, "");
        }
        InsiemeSchedeTrasporto insieme_schede = new InsiemeSchedeTrasporto();
        this.setInsieme_schede_trasporto(insieme_schede);
        String query_seleziona_schede = "SELECT * FROM mtra_schede_trasporto WHERE id_viaggio= " + this.getId();
        this.getInsieme_schede_trasporto().caricamento(query_seleziona_schede);
    }

    public boolean elimina_insieme_pedane() {
        Iterator i = this.getInsieme_pedane().vettorePedane.iterator();
        boolean res = true;
        while (i.hasNext()) {
            Pedana p = (Pedana)i.next();
            res = p.elimina(true);
        }
        return res;
    }

    public boolean elimina_bolle() {
        Iterator i = this.getInsieme_bolle().vettoreV.iterator();
        boolean res = true;
        while (i.hasNext()) {
            Bolla b = (Bolla)i.next();
            res = b.elimina(false);
        }
        return res;
    }

    public boolean eliminaViaggio(boolean da_solo) {
        if (da_solo) {
            Configurazioni.getIstanza().connessione.start_transaction();
        }
        boolean res1 = true;
        boolean res2 = true;
        boolean res3 = true;
        boolean res4 = true;
        boolean res5 = true;
        for (PresaConsegna p : this.getInsieme_pc().vettorePC) {
            p.setId_viaggio(0);
            res1 = p.assegnaAViaggio(false);
        }
        if (!res1) {
            Configurazioni.getIstanza().connessione.rollback();
            MyTrace.log.severe("Elimina viaggio non riuscita per prese consegne");
            Configurazioni.eccezione.gestisci("3.2", null);
            return false;
        }
        for (RigaOrdineViaggio rov : this.getInsieme_r_fp().vettoreR) {
            if (rov.getId_fp() == 0) {
                res2 = rov.elimina();
                continue;
            }
            Configurazioni.getIstanza().connessione.rollback();
            MyTrace.log.severe("Non posso eliminare il viaggio perche una riga viaggio \u00e8 presentre in una fattura passiva vettore");
            JOptionPane.showMessageDialog(null, "Non posso eliminare il viaggio perche una riga viaggio \u00e8 presentre in una fattura passiva vettore");
            Configurazioni.eccezione.gestisci("2.2", null);
            return false;
        }
        if (!res2) {
            Configurazioni.getIstanza().connessione.rollback();
            MyTrace.log.severe("Elimina viaggio non riuscita per righe ov");
            Configurazioni.eccezione.gestisci("3.2", null);
            return false;
        }
        res3 = this.elimina_insieme_pedane();
        if (!res3) {
            Configurazioni.getIstanza().connessione.rollback();
            MyTrace.log.severe("Elimina viaggio non riuscita per pedane");
            Configurazioni.eccezione.gestisci("3.2", null);
            return false;
        }
        String q = "DELETE FROM mtra_ordini_viaggi_rif where id_viaggio=" + this.getId();
        res4 = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q);
        if (!res4) {
            Configurazioni.getIstanza().connessione.rollback();
            MyTrace.log.severe("Elimina viaggio non riuscita per mtra_ordini_viaggi_rife");
            Configurazioni.eccezione.gestisci("3.2", null);
            return false;
        }
        res5 = this.elimina_bolle();
        if (!res5) {
            Configurazioni.getIstanza().connessione.rollback();
            MyTrace.log.severe("Elimina viaggio non riuscita per bolle");
            Configurazioni.eccezione.gestisci("3.2", null);
            return false;
        }
        String query_del = "DELETE FROM mtra_viaggi WHERE id_viaggio=" + this.getId();
        boolean r_del = Configurazioni.getIstanza().connessione.eseguiAggiornamento(query_del);
        if (!r_del) {
            Configurazioni.getIstanza().connessione.rollback();
            MyTrace.log.severe("Delete viaggio non riuscito");
            Configurazioni.eccezione.gestisci("2.2", null);
            return false;
        }
        String q_trace = "INSERT INTO sys_trace(id_operatore,nome_tabella,id_soggetto,data,azione,query) VALUES('" + MyDesktopWindow.profilo.id + "','mtra_viaggi','" + this.getId() + "',NOW(),'DEL','" + query_del.replaceAll("'", "''") + "')";
        boolean r_trace = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_trace);
        if (!r_trace) {
            Configurazioni.getIstanza().connessione.rollback();
            MyTrace.log.severe("Del viaggio non riuscito per trace");
            Configurazioni.eccezione.gestisci("2.3", null);
            return false;
        }
        if (da_solo) {
            Configurazioni.getIstanza().connessione.commit();
        }
        return true;
    }

    public boolean salva_prezzi() {
        Configurazioni.getIstanza().connessione.start_transaction();
        boolean res4 = true;
        res4 = this.getListino().getId() == 0 ? this.getListino().inserisci(true) : this.getListino().modifica(true);
        if (!res4) {
            Configurazioni.getIstanza().connessione.rollback();
            MyTrace.log.severe("Inserimento Prezzo non riuscito per trace");
            Configurazioni.eccezione.gestisci("2.3", null);
            return false;
        }
        Configurazioni.getIstanza().connessione.commit();
        return true;
    }

    public Money importo_viaggio() {
        Money importo = new Money(BigDecimal.ZERO);
        String query = "SELECT * FROM mtra_ordini_viaggi_righe where id_viaggio=" + this.getId();
        ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query);
        try {
            ResultSetMetaData meta = (ResultSetMetaData)res.getMetaData();
            while (res.next()) {
                double prezzo_for = res.getDouble("prezzo_for");
                double prezzo_um = res.getDouble("prezzo_um");
                double quantita = res.getDouble("quantita");
                if (prezzo_for != 0.0) {
                    importo = importo.plus(new Money(prezzo_for));
                    continue;
                }
                importo = importo.plus(new Money(prezzo_um * quantita));
            }
        }
        catch (Exception e) {
            MyTrace.log.severe("Seleziona prezzo non riuscito ");
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            Configurazioni.eccezione.gestisci("4.1", null);
        }
        Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        return importo;
    }

    Object getColValue(int col) {
        String retVal = "";
        switch (col) {
            case 0: {
                retVal = "" + this.getNumero_viaggio() + "/" + this.getAnno();
                break;
            }
            case 1: {
                retVal = "" + this.getData_partenza_it();
                break;
            }
            case 2: {
                retVal = "" + this.getDesc_breve();
                break;
            }
            case 3: {
                retVal = this.getPv();
                break;
            }
            case 4: {
                if (this.getCognome_autista() == null) {
                    return "";
                }
                retVal = this.getCognome_autista();
                break;
            }
            case 5: {
                if (this.getId_trattore() == 0) break;
                retVal = this.getTarga_trattore();
                break;
            }
            case 6: {
                if (this.getId_rimorchio() == 0) break;
                retVal = this.getTarga_rimorchio();
                break;
            }
            case 7: {
                if (this.getRag_soc_vettore() == null) {
                    return "";
                }
                retVal = this.getRag_soc_vettore();
                break;
            }
            case 8: {
                retVal = this.getOrdini_in_viaggio();
                break;
            }
            case 9: {
                retVal = "" + this.getClienti_in_viaggio();
                break;
            }
            case 10: {
                retVal = this.getN_ordini_clienti_in_viaggio();
                break;
            }
            default: {
                retVal = "";
            }
        }
        return retVal;
    }

    public Object getColValueRK(int col) {
        String retVal = "";
        switch (col) {
            case 0: {
                retVal = "" + this.getTarga_trattore();
                break;
            }
            case 1: {
                retVal = "" + this.getNumero_viaggio() + "/" + this.getAnno();
                break;
            }
            case 2: {
                if (this.getCognome_autista() == null) {
                    return "";
                }
                retVal = this.getCognome_autista();
                break;
            }
            case 3: {
                retVal = "(" + this.getAr() + ")" + this.getTratta_complessiva();
                break;
            }
            case 4: {
                retVal = "" + this.getData_partenza_it();
                break;
            }
            case 5: {
                retVal = "" + this.getData_arrivo_it();
                break;
            }
            case 6: {
                retVal = "" + this.getKm_partenza();
                break;
            }
            case 7: {
                retVal = "" + this.getKm_arrivo();
                break;
            }
            case 8: {
                retVal = "" + this.getKm_percorsi();
                break;
            }
            case 9: {
                retVal = "" + this.getKm_a_vuoto();
                break;
            }
            default: {
                retVal = "";
            }
        }
        return retVal;
    }
}

