/*
 * Decompiled with CFR 0.152.
 */
package trasporti.viaggi;

import gestionale.configurazioni.Configurazioni;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.Vector;
import trasporti.viaggi.Viaggio;
import utils.Funzioni;
import utils.Money;
import utils.MyTrace;

public class InsiemeViaggi {
    public Vector vettoreV = new Vector();
    int colCount;
    public String[] headers;

    public int caricamento(String where, String order_by, boolean con_righe) {
        this.vettoreV = new Vector();
        String query = "SELECT mtra_viaggi.*, anag_anagrafica.ragione_sociale, anag_anagrafica.codice as codice_vettore, mtra_autisti.cognome, mtra_autisti.nome, mtra_mezzi.targa as targa , mtra_mezzi.descrizione as descrizione_trattore , rimorchi.targa as targa_rimorchio , mtra_mezzi.id_centro_di_responsabilita as id_cdr_trattore , ordini.numero_ordine,  ordini.n_ordini_cli,  ordini.rs_cli,  ordini.prezzo,  GROUP_CONCAT(ordini.n_ordini_cli SEPARATOR ', ') AS n_ordini_cli ,   GROUP_CONCAT(DISTINCT CONCAT(ordini.numero_ordine,'/',ordini.anno) ORDER BY ordini.numero_ordine ASC SEPARATOR ', ') AS ordini , GROUP_CONCAT(ordini.rs_cli SEPARATOR ', ') AS clienti    FROM (SELECT mtra_ordini.*,                   anag_anagrafica.ragione_sociale as rs_cli,                   group_concat( DISTINCT  n_ordine SEPARATOR ',') as n_ordini_cli                   FROM mtra_prese_consegne                   LEFT JOIN mtra_ordini on mtra_prese_consegne.id_ordine=mtra_ordini.id_ordine                     LEFT JOIN anag_anagrafica ON mtra_ordini.id_anagrafica=anag_anagrafica.idanagrafica                   GROUP BY mtra_prese_consegne.id_ordine) as ordini , mtra_viaggi  LEFT JOIN anag_anagrafica ON mtra_viaggi.id_anagrafica=anag_anagrafica.idanagrafica  LEFT JOIN mtra_autisti ON mtra_viaggi.id_autista=mtra_autisti.id_autista  LEFT JOIN mtra_mezzi ON mtra_viaggi.id_mezzo=mtra_mezzi.id_macchina  LEFT JOIN mtra_mezzi as rimorchi ON mtra_viaggi.id_rimorchio=rimorchi.id_macchina  LEFT JOIN mtra_ordini_viaggi_rif on mtra_viaggi.id_viaggio=mtra_ordini_viaggi_rif.id_viaggio   ";
        query = query + " " + where + " and ordini.id_ordine=mtra_ordini_viaggi_rif.id_ordine ";
        query = query + " group by mtra_viaggi.id_viaggio " + order_by;
        try {
            ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query);
            while (res.next()) {
                Viaggio v = new Viaggio();
                v.setId(res.getInt("id_viaggio"));
                v.setId_autista(res.getInt("id_autista"));
                v.setId_trattore(res.getInt("id_mezzo"));
                v.setTarga_trattore(res.getString("targa"));
                v.setTarga_rimorchio(res.getString("targa_rimorchio"));
                v.setDescrizione_trattore(res.getString("descrizione_trattore"));
                v.setId_rimorchio(res.getInt("id_rimorchio"));
                v.setDescrizione(res.getString("descrizione"));
                v.setData_partenza(res.getString("data_partenza"));
                v.setData_arrivo(res.getString("data_arrivo"));
                v.setOra_arrivo(res.getString("ora_arrivo"));
                v.setOra_partenza(res.getString("ora_partenza"));
                v.setId_avettore(res.getInt("id_anagrafica"));
                v.setRag_soc_vettore(res.getString("ragione_sociale"));
                v.setCodice_vettore(res.getString("codice_vettore"));
                v.setDesc_breve(res.getString("desc_breve"));
                v.setAr(res.getString("andata_ritorno"));
                v.setKm_percorsi(res.getInt("km_percorsi"));
                v.setKm_a_vuoto(res.getInt("km_a_vuoto"));
                v.setCognome_autista(res.getString("cognome"));
                v.setNome_autista(res.getString("nome"));
                v.setConfermato(res.getInt("confermato"));
                v.setNumero_viaggio(res.getInt("numero_viaggio"));
                v.setAnno(res.getInt("anno"));
                v.setKm_tot(res.getDouble("km_tot"));
                v.setKm_partenza(res.getDouble("km_partenza"));
                v.setKm_arrivo(res.getDouble("km_arrivo"));
                v.setOrdini_in_viaggio(res.getString("ordini"));
                v.setClienti_in_viaggio(res.getString("clienti"));
                v.setN_ordini_clienti_in_viaggio(res.getString("n_ordini_cli"));
                v.setPrezzo(new Money(res.getDouble("prezzo")));
                v.setId_cdr_trattore(res.getInt("id_cdr_trattore"));
                if (v.getId_avettore() != 0) {
                    v.setPv("V");
                } else {
                    v.setPv("P");
                }
                if (con_righe) {
                    v.seleziona_dettagli();
                }
                this.vettoreV.addElement(v);
            }
            Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        }
        catch (Exception e) {
            this.vettoreV = new Vector();
            MyTrace.log.severe("Seleziona Viaggi non riuscito");
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            Configurazioni.eccezione.gestisci("4.2", null);
        }
        return this.vettoreV.size();
    }

    public int caricamento_analitica(String query) {
        this.vettoreV = new Vector();
        try {
            ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query);
            while (res.next()) {
                Viaggio v = new Viaggio();
                v.setId(res.getInt("id_viaggio"));
                v.setData_partenza(res.getString("data_partenza"));
                v.setData_arrivo(res.getString("data_arrivo"));
                this.vettoreV.addElement(v);
            }
            Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        }
        catch (Exception e) {
            this.vettoreV = new Vector();
            MyTrace.log.severe("Seleziona Viaggi non riuscito");
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            Configurazioni.eccezione.gestisci("4.2", null);
        }
        return this.vettoreV.size();
    }

    public int caricamento_da_ordine(String where, String order_by) {
        this.vettoreV = new Vector();
        double somma_km = 0.0;
        Money tot_in_fattura = new Money(BigDecimal.ZERO);
        String query = "select mtra_viaggi.id_viaggio, SUM(DISTINCT mtra_viaggi.km_percorsi) as km_viaggio, SUM(documenti_attivi_righe.importo) as importo_in_fattura, mo.numero_ordine,mo.anno,  anag_anagrafica.ragione_sociale   from mtra_viaggi left join mtra_ordini_viaggi_rif on mtra_ordini_viaggi_rif.id_viaggio=mtra_viaggi.id_viaggio left join mtra_ordini on mtra_ordini.id_ordine=mtra_ordini_viaggi_rif.id_ordine ,mtra_ordini_viaggi_righe  left join documenti_attivi_righe on documenti_attivi_righe.iddocumenti_attivi_righe = mtra_ordini_viaggi_righe.id_riga_doc left join mtra_ordini as mo on mo.id_ordine=mtra_ordini_viaggi_righe.id_ordine  LEFT JOIN anag_anagrafica ON mo.id_anagrafica=anag_anagrafica.idanagrafica ";
        query = query + " " + where;
        query = query + " GROUP BY mtra_viaggi.id_viaggio " + order_by;
        try {
            ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query);
            while (res.next()) {
                Viaggio v = new Viaggio();
                v.setId(res.getInt("id_viaggio"));
                v.setKm_percorsi(res.getDouble("km_viaggio"));
                v.setClienti_in_viaggio(res.getString("ragione_sociale"));
                v.setOrdini_in_viaggio(res.getInt("numero_ordine") + "/" + res.getInt("anno"));
                somma_km += v.getKm_percorsi();
                tot_in_fattura = new Money(res.getDouble("importo_in_fattura"));
                this.vettoreV.add(v);
            }
            Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        }
        catch (Exception e) {
            this.vettoreV = new Vector();
            MyTrace.log.severe("Seleziona Viaggi non riuscito");
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            Configurazioni.eccezione.gestisci("4.2", null);
        }
        for (Viaggio v : this.vettoreV) {
            if (somma_km != 0.0) {
                v.setFatturato(tot_in_fattura.times(v.getKm_percorsi()).div(somma_km));
            } else {
                v.setFatturato(new Money(BigDecimal.ZERO));
            }
            v.setTot_ordine_fattura(tot_in_fattura);
            v.setTot_km_ordine(somma_km);
        }
        return this.vettoreV.size();
    }
}

