/*
 * Decompiled with CFR 0.152.
 */
package trasporti.tratte;

import gestionale.MyDesktopWindow;
import gestionale.cap.InsiemeCAP;
import gestionale.configurazioni.ConfigurazioneFinestre;
import gestionale.configurazioni.Configurazioni;
import gestionale.configurazioni.MyProprietaFrame;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.regex.PatternSyntaxException;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.RowFilter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableRowSorter;
import trasporti.listini.MyTraListini;
import trasporti.tratte.InsiemeTratte;
import trasporti.tratte.Tratta;
import trasporti.tratte.TratteFixedModel;
import trasporti.tratte.TratteTableModel;
import utils.AvvioSuThread;
import utils.Funzioni;
import utils.FunzioniTrasporti;
import utils.GenericTableRenderer;
import utils.Performance;
import utils.RicercaCellEditor;
import utils.RicercaCellRenderer;
import utils.ToolTipHeader;

public class MyTratteGeneriche
extends JInternalFrame
implements ListSelectionListener,
MouseListener,
InternalFrameListener {
    JToolBar jToolBarMod;
    TratteTableModel ttm;
    InsiemeTratte insieme_t;
    JScrollPane scroll;
    JTable jTableTratte;
    TratteFixedModel tfm;
    JScrollPane fixedScroll;
    JTable fixedTable;
    private TableRowSorter<TratteTableModel> sorter;
    RowFilter<TratteTableModel, Object> rf = null;
    ArrayList<RowFilter<TratteTableModel, Object>> andFilters = new ArrayList();
    boolean in_filter = false;
    boolean in_modifica = false;
    boolean in_new = false;
    boolean non_tutte_le_righe = false;
    Tratta t_selezione;
    Funzioni f = new Funzioni();
    private FunzioniTrasporti ft = new FunzioniTrasporti();
    public JInternalFrame chiamante;
    public int row_chiamante;
    public boolean f_c5_open = false;
    public boolean f_te_open = false;
    public boolean f_al_open = false;
    InsiemeCAP insieme_cap;
    InsiemeCAP insieme_cap_a;
    private JButton jButtonClean;
    private JButton jButtonElimina;
    private JToggleButton jButtonFiltra;
    private JButton jButtonFirst;
    private JButton jButtonForm;
    private JButton jButtonLast;
    private JButton jButtonModifica;
    private JButton jButtonNext;
    private JButton jButtonNuovo;
    private JButton jButtonPrevious;
    private JButton jButtonRefresh;
    private JButton jButtonStampa;
    private JLabel jLabelCF;
    private JLabel jLabelCodice;
    private JLabel jLabelCodiceBarreProdotto;
    private JLabel jLabelNote;
    private JLabel jLabelVia;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanelDettaglio;
    private JPanel jPanelElenco;
    private JScrollPane jScrollPane1;
    private JToolBar.Separator jSeparator1;
    private JToolBar.Separator jSeparator2;
    private JToolBar.Separator jSeparator3;
    private JTabbedPane jTabbedPane1;
    private JTextField jTextCodice;
    private JTextArea jTextDescrizione;
    private JTextField jTextKm;
    private JTextField jTextProvArrivo;
    private JTextField jTextProvPartenza;
    private JToolBar jToolBar1;
    private JPanel p;

    public MyTratteGeneriche() {
        Performance perf = new Performance("+++ ISTANZA  MyTratteGeneriche +++");
        if (!MyDesktopWindow.profilo.controllaPermesso("TRATTE_VISUALIZZA")) {
            Configurazioni.eccezione.gestisci("7.1", null);
            this.dispose();
        }
        this.ttm = new TratteTableModel();
        this.insieme_t = new InsiemeTratte();
        this.jTableTratte = new JTable(this.ttm);
        this.jTableTratte.setSelectionMode(0);
        this.sorter = new TableRowSorter<TratteTableModel>(this.ttm);
        for (int i = 0; i < this.ttm.getColumnCount(); ++i) {
            RowFilter rf_local = RowFilter.regexFilter("(?i)", i);
            this.andFilters.add(i, rf_local);
        }
        this.tfm = new TratteFixedModel();
        this.tfm.setFIXED_NUM(0);
        this.fixedTable = new JTable(this.tfm);
        this.fixedTable.setAutoResizeMode(4);
        this.addInternalFrameListener(this);
        this.initComponents();
        this.crea_toolbar();
        this.aggiungi_tabelle();
        AvvioSuThread avvio_separato = new AvvioSuThread(this, "caricamento_dati_iniziale");
        ListSelectionModel listSelectionModel = this.jTableTratte.getSelectionModel();
        listSelectionModel.addListSelectionListener(this);
        this.controlla_diritti();
        this.setLocation(ConfigurazioneFinestre.GetPoint(this.getClass().getName(), new Point(200, 0)));
        this.setSize(ConfigurazioneFinestre.GetDimension(this.getClass().getName(), new Dimension(700, 350)));
        perf.fine();
    }

    public void caricamento_dati_iniziale() {
        this.filtra();
        this.formatta();
        this.visualizzazione();
        this.repaint();
    }

    private void controlla_diritti() {
        if (!MyDesktopWindow.profilo.controllaPermesso("Tratte_Modifica")) {
            this.jButtonModifica.setEnabled(false);
            this.jButtonNuovo.setEnabled(false);
            this.jButtonElimina.setEnabled(false);
        }
    }

    private void crea_toolbar() {
        this.jToolBarMod = new JToolBar();
        JButton jButtonSalva = new JButton();
        JButton jButtonAnnulla = new JButton();
        jButtonSalva.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/document-save-as.png")));
        jButtonSalva.setText("Salva");
        jButtonSalva.setFocusable(true);
        jButtonSalva.setVerticalTextPosition(3);
        jButtonSalva.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyTratteGeneriche.this.jButtonSalvaActionPerformed(evt);
            }
        });
        this.jToolBarMod.add(jButtonSalva);
        jButtonAnnulla.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/edit-undo.png")));
        jButtonAnnulla.setText("Annulla");
        jButtonAnnulla.setFocusable(true);
        jButtonAnnulla.setVerticalTextPosition(3);
        jButtonAnnulla.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyTratteGeneriche.this.jButtonAnnullaActionPerformed(evt);
            }
        });
        this.jToolBarMod.add(jButtonAnnulla);
    }

    private void aggiungi_tabelle() {
        this.scroll = new JScrollPane(this.jTableTratte){

            @Override
            public void setColumnHeaderView(Component view) {
            }
        };
        this.scroll.setHorizontalScrollBarPolicy(31);
        this.fixedScroll = new JScrollPane(this.fixedTable);
        this.fixedScroll.setVerticalScrollBarPolicy(22);
        this.fixedScroll.setPreferredSize(new Dimension(400, 25));
        JScrollBar bar = this.fixedScroll.getVerticalScrollBar();
        JScrollBar dummyBar = new JScrollBar(){

            @Override
            public void paint(Graphics g) {
            }
        };
        dummyBar.setPreferredSize(bar.getPreferredSize());
        this.fixedScroll.setVerticalScrollBar(dummyBar);
        final JScrollBar bar1 = this.scroll.getHorizontalScrollBar();
        JScrollBar bar2 = this.fixedScroll.getHorizontalScrollBar();
        bar2.addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                bar1.setValue(e.getValue());
            }
        });
        this.jTableTratte.setModel(this.ttm);
        this.jTableTratte.setAutoCreateRowSorter(true);
        this.jTableTratte.setRowSorter(this.sorter);
        this.jTableTratte.setFillsViewportHeight(true);
        this.p.add((Component)this.scroll, "Center");
        this.p.add((Component)this.fixedScroll, "North");
    }

    public void visualizzazione() {
        this.jTextCodice.setEnabled(this.in_modifica);
        this.jTextProvPartenza.setEnabled(this.in_modifica);
        this.jTextDescrizione.setEnabled(this.in_modifica);
        this.jTextProvArrivo.setEnabled(this.in_modifica);
        this.jTextKm.setEnabled(this.in_modifica);
        if (this.in_modifica) {
            this.getContentPane().remove(this.jToolBar1);
            this.getContentPane().add((Component)this.jToolBarMod, "North");
            this.jTabbedPane1.setEnabledAt(0, false);
        } else {
            this.getContentPane().remove(this.jToolBarMod);
            this.getContentPane().add((Component)this.jToolBar1, "North");
            this.jTabbedPane1.setEnabledAt(0, true);
        }
        this.getContentPane().validate();
        this.getContentPane().repaint();
    }

    public void formatta() {
        this.jTableTratte.getSelectionModel().setSelectionInterval(0, 0);
        this.jTableTratte.setDefaultRenderer(Object.class, new GenericTableRenderer());
        this.fixedTable.setRowHeight(30);
        this.fixedTable.setDefaultEditor(String.class, new TextEditor());
        this.fixedTable.setDefaultRenderer(Object.class, new RicercaCellRenderer());
        this.jTableTratte.addMouseListener(this);
        this.header_tebella();
    }

    public void header_tebella() {
        try {
            String[] toolTipStr = new String[]{"Codice Tratta", "Chilometri Tratta", "Descrizione"};
            ToolTipHeader header1 = new ToolTipHeader(this.jTableTratte.getColumnModel());
            ToolTipHeader header2 = new ToolTipHeader(this.fixedTable.getColumnModel());
            header1.setToolTipStrings(toolTipStr);
            header2.setToolTipStrings(toolTipStr);
            this.fixedTable.setTableHeader(header2);
            this.jTableTratte.setTableHeader(header1);
            header1.setResizingAllowed(false);
            header2.setResizingAllowed(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void filtra() {
        String query = "select mtra_tratte.*  from mtra_tratte WHERE generica=1 ORDER BY cod_tratta ASC ";
        if (Configurazioni.righe_ricerca != 0) {
            query = query + " LIMIT 0," + Configurazioni.righe_ricerca;
        }
        this.insieme_t.caricamento(query);
        this.ttm.setDataTratta(this.insieme_t.vettoreT);
        if (Configurazioni.righe_ricerca != 0 && this.insieme_t.vettoreT.size() >= Configurazioni.righe_ricerca) {
            this.non_tutte_le_righe = true;
        }
    }

    public void seleziona(int row) {
        this.t_selezione = new Tratta();
        this.t_selezione = (Tratta)this.insieme_t.vettoreT.elementAt(row);
        this.t_selezione.seleziona_province();
        this.riempi_campi();
    }

    public void azzera() {
        this.jTextCodice.setText("");
        this.jTextDescrizione.setText("");
        this.jTextKm.setText("");
        this.jTextProvArrivo.setText("");
        this.jTextProvPartenza.setText("");
        this.visualizzazione();
    }

    public void riempi_campi() {
        this.jTextCodice.setText(this.t_selezione.getCod_tratta());
        this.jTextDescrizione.setText(this.t_selezione.getDescrizione());
        this.jTextKm.setText(this.f.formattaNumero(Double.toString(this.t_selezione.getKm())));
        this.jTextProvArrivo.setText(this.t_selezione.getProvincia_a());
        this.jTextProvPartenza.setText(this.t_selezione.getProvincia_p());
        this.visualizzazione();
    }

    private void costruisci() {
        this.t_selezione.setGenerica(1);
        this.t_selezione.setCod_tratta(this.jTextCodice.getText());
        this.t_selezione.setDescrizione(this.jTextDescrizione.getText());
        this.t_selezione.setKm(Double.valueOf(this.jTextKm.getText()));
        this.t_selezione.setProvincia_p(this.jTextProvPartenza.getText());
        this.t_selezione.setInsieme_cap_p(new InsiemeCAP());
        String query_p = "SELECT * from cap where cd_provincia='" + this.t_selezione.getProvincia_p() + "'";
        this.t_selezione.getInsieme_cap_p().caricamento(query_p);
        this.t_selezione.setProvincia_a(this.jTextProvArrivo.getText());
        this.t_selezione.setInsieme_cap_a(new InsiemeCAP());
        String query_a = "SELECT * from cap where cd_provincia='" + this.t_selezione.getProvincia_a() + "'";
        this.t_selezione.getInsieme_cap_a().caricamento(query_a);
    }

    private boolean check() {
        if (this.jTextCodice.getText().equals("")) {
            JOptionPane.showMessageDialog(this, "Inserire il codice identificativo per la tratta");
            return false;
        }
        if (this.in_new && this.ft.id_tratta_da_codice(this.jTextCodice.getText()) != 0) {
            JOptionPane.showMessageDialog(this, "Esiste gi\u00e0 una Tratta con questo Codice");
            return false;
        }
        if (this.jTextProvPartenza.getText().equals("")) {
            JOptionPane.showMessageDialog(this, "Inserire la provincia di pertenza");
            return false;
        }
        if (!this.f.esiste_provincia(this.jTextProvPartenza.getText())) {
            JOptionPane.showMessageDialog(this, "Provincia di pertenza non riconosciuta");
            return false;
        }
        if (this.jTextProvArrivo.getText().equals("")) {
            JOptionPane.showMessageDialog(this, "Inserire la provincia di arrivo");
            return false;
        }
        if (!this.f.esiste_provincia(this.jTextProvArrivo.getText())) {
            JOptionPane.showMessageDialog(this, "Provincia di arrivo non riconosciuta");
            return false;
        }
        return true;
    }

    private void initComponents() {
        this.jToolBar1 = new JToolBar();
        this.jButtonNuovo = new JButton();
        this.jButtonModifica = new JButton();
        this.jButtonElimina = new JButton();
        this.jButtonForm = new JButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.jButtonFirst = new JButton();
        this.jButtonPrevious = new JButton();
        this.jButtonNext = new JButton();
        this.jButtonLast = new JButton();
        this.jSeparator2 = new JToolBar.Separator();
        this.jButtonRefresh = new JButton();
        this.jButtonFiltra = new JToggleButton();
        this.jButtonClean = new JButton();
        this.jSeparator3 = new JToolBar.Separator();
        this.jButtonStampa = new JButton();
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanelElenco = new JPanel();
        this.p = new JPanel();
        this.jPanelDettaglio = new JPanel();
        this.jPanel2 = new JPanel();
        this.jPanel3 = new JPanel();
        this.jLabelCodice = new JLabel();
        this.jTextCodice = new JTextField();
        this.jLabelCodiceBarreProdotto = new JLabel();
        this.jTextKm = new JTextField();
        this.jLabelNote = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jTextDescrizione = new JTextArea();
        this.jLabelCF = new JLabel();
        this.jTextProvPartenza = new JTextField();
        this.jLabelVia = new JLabel();
        this.jTextProvArrivo = new JTextField();
        this.setClosable(true);
        this.setDefaultCloseOperation(2);
        this.setIconifiable(true);
        this.setMaximizable(true);
        this.setResizable(true);
        this.setTitle("Trasporti \\ Tratte Generiche");
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent evt) {
                MyTratteGeneriche.this.posizione_finestra(evt);
            }

            @Override
            public void componentResized(ComponentEvent evt) {
                MyTratteGeneriche.this.finestra_ridimensionata(evt);
            }
        });
        this.jToolBar1.setRollover(true);
        this.jButtonNuovo.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/document-new.png")));
        this.jButtonNuovo.setText("Nuovo");
        this.jButtonNuovo.setFocusable(false);
        this.jButtonNuovo.setVerticalTextPosition(3);
        this.jButtonNuovo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyTratteGeneriche.this.jButtonNuovoActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonNuovo);
        this.jButtonModifica.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/accessories-text-editor.png")));
        this.jButtonModifica.setText("Modifica");
        this.jButtonModifica.setFocusable(false);
        this.jButtonModifica.setHorizontalAlignment(11);
        this.jButtonModifica.setVerticalTextPosition(3);
        this.jButtonModifica.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyTratteGeneriche.this.jButtonModificaActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonModifica);
        this.jButtonElimina.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/user-trash.png")));
        this.jButtonElimina.setText("Elimina");
        this.jButtonElimina.setFocusable(false);
        this.jButtonElimina.setHorizontalAlignment(11);
        this.jButtonElimina.setVerticalTextPosition(3);
        this.jButtonElimina.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyTratteGeneriche.this.jButtonEliminaActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonElimina);
        this.jButtonForm.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/preferences-system.png")));
        this.jButtonForm.setText("Propriet\u00e0");
        this.jButtonForm.setFocusable(false);
        this.jButtonForm.setHorizontalAlignment(11);
        this.jButtonForm.setVerticalTextPosition(3);
        this.jButtonForm.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyTratteGeneriche.this.jButtonFormActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonForm);
        this.jToolBar1.add(this.jSeparator1);
        this.jButtonFirst.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/go-first.png")));
        this.jButtonFirst.setFocusable(false);
        this.jButtonFirst.setHorizontalTextPosition(0);
        this.jButtonFirst.setVerticalTextPosition(3);
        this.jButtonFirst.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyTratteGeneriche.this.jButtonFirstActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonFirst);
        this.jButtonPrevious.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/go-previous.png")));
        this.jButtonPrevious.setFocusable(false);
        this.jButtonPrevious.setHorizontalTextPosition(0);
        this.jButtonPrevious.setVerticalTextPosition(3);
        this.jButtonPrevious.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyTratteGeneriche.this.jButtonPreviousActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonPrevious);
        this.jButtonNext.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/go-next.png")));
        this.jButtonNext.setFocusable(false);
        this.jButtonNext.setHorizontalTextPosition(0);
        this.jButtonNext.setVerticalTextPosition(3);
        this.jButtonNext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyTratteGeneriche.this.jButtonNextActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonNext);
        this.jButtonLast.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/go-last.png")));
        this.jButtonLast.setFocusable(false);
        this.jButtonLast.setHorizontalTextPosition(0);
        this.jButtonLast.setVerticalTextPosition(3);
        this.jButtonLast.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyTratteGeneriche.this.jButtonLastActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonLast);
        this.jToolBar1.add(this.jSeparator2);
        this.jButtonRefresh.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/view-refresh.png")));
        this.jButtonRefresh.setFocusable(false);
        this.jButtonRefresh.setHorizontalTextPosition(0);
        this.jButtonRefresh.setVerticalTextPosition(3);
        this.jButtonRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyTratteGeneriche.this.jButtonRefreshActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonRefresh);
        this.jButtonFiltra.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/edit-find.png")));
        this.jButtonFiltra.setFocusable(false);
        this.jButtonFiltra.setHorizontalTextPosition(0);
        this.jButtonFiltra.setVerticalTextPosition(3);
        this.jButtonFiltra.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyTratteGeneriche.this.jButtonFiltraActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonFiltra);
        this.jButtonClean.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/edit-clear.png")));
        this.jButtonClean.setFocusable(false);
        this.jButtonClean.setHorizontalTextPosition(0);
        this.jButtonClean.setVerticalTextPosition(3);
        this.jButtonClean.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyTratteGeneriche.this.jButtonCleanActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonClean);
        this.jToolBar1.add(this.jSeparator3);
        this.jButtonStampa.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/document-print.png")));
        this.jButtonStampa.setFocusable(false);
        this.jButtonStampa.setHorizontalTextPosition(0);
        this.jButtonStampa.setVerticalTextPosition(3);
        this.jToolBar1.add(this.jButtonStampa);
        this.getContentPane().add((Component)this.jToolBar1, "North");
        this.jPanelElenco.setLayout(new BorderLayout());
        this.p.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.p.setLayout(new BorderLayout());
        this.jPanelElenco.add((Component)this.p, "Center");
        this.jTabbedPane1.addTab("Elenco", this.jPanelElenco);
        this.jPanelDettaglio.setLayout(new BorderLayout());
        this.jPanel2.setLayout(new BorderLayout());
        this.jPanel3.setLayout(new GridBagLayout());
        this.jLabelCodice.setText("Codice Tratta");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel3.add((Component)this.jLabelCodice, gridBagConstraints);
        this.jTextCodice.setMinimumSize(new Dimension(200, 30));
        this.jTextCodice.setPreferredSize(new Dimension(200, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel3.add((Component)this.jTextCodice, gridBagConstraints);
        this.jLabelCodiceBarreProdotto.setText("Km");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.jPanel3.add((Component)this.jLabelCodiceBarreProdotto, gridBagConstraints);
        this.jTextKm.setMinimumSize(new Dimension(100, 30));
        this.jTextKm.setPreferredSize(new Dimension(100, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel3.add((Component)this.jTextKm, gridBagConstraints);
        this.jLabelNote.setText("Descrizione/Note");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.jPanel3.add((Component)this.jLabelNote, gridBagConstraints);
        this.jScrollPane1.setMinimumSize(new Dimension(400, 76));
        this.jScrollPane1.setPreferredSize(new Dimension(400, 76));
        this.jTextDescrizione.setColumns(60);
        this.jTextDescrizione.setRows(5);
        this.jScrollPane1.setViewportView(this.jTextDescrizione);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel3.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jLabelCF.setText("Provincia Partenza");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.jPanel3.add((Component)this.jLabelCF, gridBagConstraints);
        this.jTextProvPartenza.setMinimumSize(new Dimension(50, 27));
        this.jTextProvPartenza.setPreferredSize(new Dimension(50, 27));
        this.jTextProvPartenza.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                MyTratteGeneriche.this.jTextProvPartenzaFocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel3.add((Component)this.jTextProvPartenza, gridBagConstraints);
        this.jLabelVia.setText("Provincia Arrivo");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.jPanel3.add((Component)this.jLabelVia, gridBagConstraints);
        this.jTextProvArrivo.setMinimumSize(new Dimension(50, 27));
        this.jTextProvArrivo.setPreferredSize(new Dimension(50, 27));
        this.jTextProvArrivo.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                MyTratteGeneriche.this.jTextProvArrivoFocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel3.add((Component)this.jTextProvArrivo, gridBagConstraints);
        this.jPanel2.add((Component)this.jPanel3, "Center");
        this.jPanelDettaglio.add((Component)this.jPanel2, "Center");
        this.jTabbedPane1.addTab("Dettaglio", this.jPanelDettaglio);
        this.getContentPane().add((Component)this.jTabbedPane1, "Center");
        this.pack();
    }

    private void jButtonSalvaActionPerformed(ActionEvent evt) {
        if (this.in_new) {
            if (this.check()) {
                this.costruisci();
                boolean check2 = this.t_selezione.inserisciTratta(true);
                if (check2) {
                    this.in_new = false;
                    this.in_modifica = false;
                    this.filtra();
                    this.visualizzazione();
                    this.jTabbedPane1.setSelectedIndex(0);
                } else {
                    JOptionPane.showMessageDialog(this, "Si \u00e8 verificato un errore al momento dell'inserimento dei dati nel database,\nRicontrollare i campi riempiti e non.\nSe il problema persiste contattare Kronos");
                }
            }
        } else if (this.check()) {
            this.costruisci();
            boolean check2 = this.t_selezione.modificaTratta(true);
            if (check2) {
                this.in_modifica = false;
                this.filtra();
                this.visualizzazione();
                this.jTabbedPane1.setSelectedIndex(0);
            } else {
                JOptionPane.showMessageDialog(this, "Si \u00e8 verificato un errore al momento della modifica dei dati nel database,\nRicontrollare i campi riempiti e non.\nSe il problema persiste contattare Kronos");
            }
        }
    }

    private void jButtonAnnullaActionPerformed(ActionEvent evt) {
        int res = JOptionPane.showConfirmDialog(this, "Abbandonare le modifiche?");
        if (res == 0) {
            this.in_modifica = false;
            this.visualizzazione();
            this.jTabbedPane1.setSelectedIndex(0);
        }
    }

    private void jButtonNuovoActionPerformed(ActionEvent evt) {
        this.in_new = true;
        this.jTableTratte.getSelectionModel().clearSelection();
        this.t_selezione = new Tratta();
        this.riempi_campi();
        this.in_modifica = true;
        this.jTabbedPane1.setSelectedIndex(1);
        this.visualizzazione();
    }

    private void jButtonModificaActionPerformed(ActionEvent evt) {
        this.in_modifica = true;
        this.visualizzazione();
        if (this.jTabbedPane1.getSelectedIndex() == 0) {
            this.jTabbedPane1.setSelectedIndex(1);
        }
    }

    private void jButtonEliminaActionPerformed(ActionEvent evt) {
    }

    private void jButtonFormActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        MyProprietaFrame oggetto = new MyProprietaFrame();
        this.getDesktopPane().add(oggetto);
        oggetto.setLocation(200, 0);
        oggetto.setVisible(true);
        oggetto.moveToFront();
        this.setCursor(new Cursor(0));
    }

    private void jButtonFirstActionPerformed(ActionEvent evt) {
        if (this.ttm.getRowCount() != 0) {
            this.jTableTratte.getSelectionModel().setSelectionInterval(0, 0);
        }
    }

    private void jButtonPreviousActionPerformed(ActionEvent evt) {
        if (this.jTableTratte.getSelectedRow() > 0 && this.ttm.getRowCount() != 0) {
            this.jTableTratte.getSelectionModel().setSelectionInterval(this.jTableTratte.getSelectedRow() - 1, this.jTableTratte.getSelectedRow() - 1);
        }
    }

    private void jButtonNextActionPerformed(ActionEvent evt) {
        if (this.ttm.getRowCount() != 0) {
            this.jTableTratte.getSelectionModel().setSelectionInterval(this.jTableTratte.getSelectedRow() + 1, this.jTableTratte.getSelectedRow() + 1);
        }
    }

    private void jButtonLastActionPerformed(ActionEvent evt) {
        if (this.ttm.getRowCount() != 0) {
            this.jTableTratte.getSelectionModel().setSelectionInterval(this.ttm.getRowCount() - 1, this.ttm.getRowCount() - 1);
        }
    }

    private void jButtonRefreshActionPerformed(ActionEvent evt) {
        AvvioSuThread ridisegno_separato = new AvvioSuThread(this, "caricamento_dati_iniziale");
    }

    private void jButtonFiltraActionPerformed(ActionEvent evt) {
        if (!this.in_filter) {
            this.in_filter = true;
            String[] a_ric = new String[]{"", "", "", ""};
            this.tfm.addRow(a_ric);
            this.fixedScroll.setViewportView(this.fixedTable);
            this.fixedScroll.setPreferredSize(new Dimension(400, 65));
            this.p.add((Component)this.fixedScroll, "North");
            this.p.repaint();
            this.repaint();
            this.fixedTable.setCellSelectionEnabled(true);
            this.fixedTable.changeSelection(0, 0, false, false);
            this.fixedTable.requestFocus();
        } else {
            this.in_filter = false;
            this.tfm.deleteRow();
            this.tfm = new TratteFixedModel();
            this.fixedTable.setModel(this.tfm);
            this.fixedScroll.setViewportView(this.fixedTable);
            this.fixedScroll.setPreferredSize(new Dimension(400, 25));
            this.sorter.setRowFilter(null);
            this.p.add((Component)this.fixedScroll, "North");
            this.p.repaint();
            this.repaint();
        }
        this.formatta();
    }

    private void jButtonCleanActionPerformed(ActionEvent evt) {
        if (this.in_filter) {
            this.in_filter = true;
            this.sorter.setRowFilter(null);
            String[] a_ric = new String[]{"", "", "", ""};
            this.tfm = new TratteFixedModel();
            this.fixedTable.setModel(this.tfm);
            this.tfm.addRow(a_ric);
            this.andFilters = new ArrayList();
            for (int i = 0; i < this.ttm.getColumnCount(); ++i) {
                RowFilter rf_local = RowFilter.regexFilter("(?i)", i);
                this.andFilters.add(i, rf_local);
            }
            this.fixedScroll.setViewportView(this.fixedTable);
            this.fixedScroll.setPreferredSize(new Dimension(400, 65));
            this.p.add((Component)this.fixedScroll, "North");
            this.p.repaint();
            this.repaint();
        }
        this.formatta();
    }

    private void jTextProvPartenzaFocusLost(FocusEvent evt) {
    }

    private void jTextProvArrivoFocusLost(FocusEvent evt) {
    }

    private void posizione_finestra(ComponentEvent evt) {
        ConfigurazioneFinestre.SetPoint(this.getClass().getName(), this.getLocation());
    }

    private void finestra_ridimensionata(ComponentEvent evt) {
        ConfigurazioneFinestre.SetDimension(this.getClass().getName(), this.getSize());
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new MyTratteGeneriche().setVisible(true);
            }
        });
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        int viewRow = this.jTableTratte.getSelectedRow();
        int modelRow = 1000000000;
        if (this.in_filter) {
            if (viewRow >= 0) {
                modelRow = this.jTableTratte.convertRowIndexToModel(viewRow);
            }
        } else {
            modelRow = viewRow;
        }
        if (modelRow <= this.ttm.getRowCount() - 1 && modelRow >= 0) {
            this.seleziona(modelRow);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2) {
            JTable jtb = (JTable)e.getSource();
            int viewRow = jtb.getSelectedRow();
            int modelRow = 1000000000;
            if (this.in_filter) {
                if (viewRow >= 0) {
                    modelRow = this.jTableTratte.convertRowIndexToModel(viewRow);
                }
            } else {
                modelRow = viewRow;
            }
            if (modelRow <= this.ttm.getRowCount() - 1 && modelRow >= 0) {
                Tratta t = new Tratta();
                t = (Tratta)this.insieme_t.vettoreT.elementAt(modelRow);
                if (this.chiamante != null) {
                    if (this.chiamante.getClass() == MyTraListini.class && ((MyTraListini)this.chiamante).aiuto_riga_t) {
                        ((MyTraListini)this.chiamante).jTableTratte.getCellEditor().getTableCellEditorComponent(((MyTraListini)this.chiamante).jTableTratte, t.getCod_tratta(), false, this.row_chiamante, 0);
                        ((MyTraListini)this.chiamante).jTableTratte.getCellEditor().stopCellEditing();
                        ((MyTraListini)this.chiamante).aiuto_riga_t = false;
                    }
                    this.dispose();
                }
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void internalFrameOpened(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameClosing(InternalFrameEvent e) {
        if (this.chiamante != null) {
            if (this.chiamante.getClass() == MyTraListini.class && ((MyTraListini)this.chiamante).aiuto_riga_t) {
                ((MyTraListini)this.chiamante).aiuto_riga_t = false;
            }
            this.dispose();
        }
    }

    @Override
    public void internalFrameClosed(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameIconified(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameDeiconified(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameActivated(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameDeactivated(InternalFrameEvent e) {
    }

    public class TextEditor
    extends RicercaCellEditor {
        RowFilter<TratteTableModel, Object> rf_local = null;

        @Override
        public void newFilter(int col) {
            try {
                this.rf_local = RowFilter.regexFilter("(?i)" + this.tf.getText(), col);
                MyTratteGeneriche.this.andFilters.set(col, this.rf_local);
            }
            catch (PatternSyntaxException e) {
                Funzioni.inviaBugPerEmail(e);
                Funzioni.LogStackTrace(e);
                return;
            }
            MyTratteGeneriche.this.rf = RowFilter.andFilter(MyTratteGeneriche.this.andFilters);
            MyTratteGeneriche.this.sorter.setRowFilter(MyTratteGeneriche.this.rf);
            MyTratteGeneriche.this.formatta();
        }
    }
}

