/*
 * Decompiled with CFR 0.152.
 */
package trasporti.report_viaggi_per_fornitore;

import gestionale.configurazioni.Configurazioni;
import gestionale.personalizzazione.stampe.IntestazioneFatturaAttiva;
import gestionale.personalizzazione.stampe.PiedePaginaGenericoIntestato;
import java.awt.Color;
import java.math.BigDecimal;
import java.util.Iterator;
import trasporti.viaggi.InsiemeViaggiFornitore;
import trasporti.viaggi.ViaggiFornitore;
import utils.BannerWorking;
import utils.Funzioni;
import utils.FunzioniDate;
import utils.Money;
import utils.MyTrace;
import utils.stampe.GestoreStampe;
import utils.stampe.OggettoToPrint;

public class StampaViaggiFornitori
implements Runnable {
    Funzioni f = new Funzioni();
    FunzioniDate fda = new FunzioniDate();
    int y;
    int y_inizio;
    Thread thread;
    float[] dash = new float[]{1.0f, 1.0f};
    int i = 0;
    String intestazione;
    InsiemeViaggiFornitore i_v_f;

    public StampaViaggiFornitori(String intestazione, InsiemeViaggiFornitore i) {
        MyTrace.log.info("STAMPA VIAGGI FORNITORE ");
        Configurazioni.getIstanza();
        this.y = this.y_inizio = Configurazioni.inizio_stampe;
        this.intestazione = intestazione;
        this.i_v_f = i;
        MyTrace.log.info("STAMPA VIAGGI FORNITORE  (STOP)");
    }

    public void avvia() {
        this.thread = new Thread(this);
        MyTrace.log.info("avvio Procedura su Thread");
        this.thread.start();
    }

    @Override
    public void run() {
        BannerWorking attesa = new BannerWorking("ELABORAZIONE SU THREAD STAMPA VIAGGI FORNITORE");
        attesa.start();
        this.elabora_formattazione_stampa();
        attesa.stop();
    }

    private void elabora_formattazione_stampa() {
        try {
            MyTrace.log.info("STAMPA VIAGGI FORNITORE : XXXXXXXXXXXXXXXXXXXXXXXXXXXXXX  INIZIO STAMPA XXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
            GestoreStampe stampa = new GestoreStampe();
            stampa.aggiungi_pj();
            this.stampa_intestazione(stampa, this.y);
            Money margine_riga = new Money(BigDecimal.ZERO);
            Money money_Tot_Ricavo_parziale = new Money(BigDecimal.ZERO);
            Money money_Tot_Ricavo_nolo = new Money(BigDecimal.ZERO);
            Money money_Tot_Differenza = new Money(BigDecimal.ZERO);
            Money money_Totale_documento_Ricavo_parziale = new Money(BigDecimal.ZERO);
            Money money_Totale_documento_nolo = new Money(BigDecimal.ZERO);
            Money money_Totale_documento_differenza = new Money(BigDecimal.ZERO);
            boolean B_stampa_int_fornitore = true;
            String ragione_sociale_memorizzata = "";
            boolean primapagina = false;
            int progressivo = 1;
            int numero = 0;
            String data_partenza = "";
            String data_arrivo = "";
            String descrizione = "";
            Money money_Ricavo_nolo = new Money(BigDecimal.ZERO);
            Iterator iteratore_valori = this.i_v_f.list.iterator();
            while (iteratore_valori.hasNext()) {
                stampa.setFont(stampa.Font_Calibri_8);
                ViaggiFornitore v = (ViaggiFornitore)iteratore_valori.next();
                String ragione_sociale = v.getRagione_sociale();
                if (!ragione_sociale.equals(ragione_sociale_memorizzata) && primapagina) {
                    B_stampa_int_fornitore = true;
                    this.y -= 10;
                    stampa.setFont(stampa.Font_Calibri_8_B);
                    stampa.appendStringaOvunqueFormattazioneDestra("" + money_Tot_Ricavo_parziale, 349, this.y + 90, 45);
                    stampa.appendStringaOvunqueFormattazioneDestra("" + money_Tot_Ricavo_nolo, 394, this.y + 90, 45);
                    stampa.appendStringaOvunqueFormattazioneDestra("" + money_Tot_Differenza, 436, this.y + 90, 45);
                    money_Tot_Ricavo_parziale = new Money(BigDecimal.ZERO);
                    money_Tot_Ricavo_nolo = new Money(BigDecimal.ZERO);
                    money_Tot_Differenza = new Money(BigDecimal.ZERO);
                    this.y += 15;
                    stampa.setFont(stampa.Font_Calibri_8);
                }
                if (B_stampa_int_fornitore) {
                    stampa.appendRoundRect(18, this.y + 80, 250, 18, 10, 10);
                    stampa.appendTextOvunque(v.getRagione_sociale(), 35, this.y + 90);
                    this.y += 25;
                    ragione_sociale_memorizzata = v.getRagione_sociale();
                    B_stampa_int_fornitore = false;
                    primapagina = true;
                }
                numero = v.getNumero_viaggio();
                data_partenza = v.getData_partenza();
                data_arrivo = v.getData_arrivo();
                descrizione = v.getDescrizione();
                money_Tot_Ricavo_parziale.plusplus(v.getRicavo_riga());
                money_Ricavo_nolo = v.getRicavo_tot_nolo();
                money_Tot_Ricavo_nolo.plusplus(money_Ricavo_nolo);
                margine_riga = v.getRicavo_riga().minus(money_Ricavo_nolo);
                if (margine_riga.isPlus()) {
                    money_Tot_Differenza.plusplus(margine_riga);
                    money_Totale_documento_differenza.plusplus(margine_riga);
                }
                money_Totale_documento_Ricavo_parziale.plusplus(v.getRicavo_riga());
                money_Totale_documento_nolo.plusplus(money_Ricavo_nolo);
                this.y += 15;
                stampa.appendTextOvunque("" + progressivo, 30, this.y + 75);
                stampa.appendTextOvunque("" + numero, 50, this.y + 75);
                stampa.appendTextOvunque(this.fda.gira_data(data_partenza), 77, this.y + 75);
                stampa.appendTextOvunque(this.fda.gira_data(data_arrivo), 125, this.y + 75);
                if (descrizione.length() > 46) {
                    String accorciata = descrizione.substring(0, 46);
                    stampa.appendTextOvunque(accorciata, 173, this.y + 75);
                } else {
                    stampa.appendTextOvunque(descrizione, 173, this.y + 75);
                }
                stampa.appendStringaOvunqueFormattazioneDestra("" + v.getRicavo_riga(), 348, this.y + 75, 45);
                stampa.appendStringaOvunqueFormattazioneDestra("" + money_Ricavo_nolo, 393, this.y + 75, 45);
                if (margine_riga.isMinus()) {
                    stampa.appendStringaOvunqueFormattazioneDestra("0.00", 435, this.y + 75, 45);
                } else {
                    stampa.appendStringaOvunqueFormattazioneDestra("" + margine_riga, 435, this.y + 75, 45);
                }
                stampa.appendTextOvunque("" + v.getNumero_fattura(), 493, this.y + 75);
                ++progressivo;
                this.y += 12;
                stampa.appendLineTratteggiata(30, this.y + 75 - 9, 573, this.y + 75 - 9, this.dash, Color.gray);
                if (this.y <= 670) continue;
                stampa.paginanuova();
                this.y = this.y_inizio;
                this.stampa_intestazione(stampa, this.y);
            }
            stampa.setFont(stampa.Font_Calibri_8_B);
            stampa.appendStringaOvunqueFormattazioneDestra("" + money_Tot_Ricavo_parziale, 349, this.y + 80, 45);
            stampa.appendStringaOvunqueFormattazioneDestra("" + money_Tot_Ricavo_nolo, 394, this.y + 80, 45);
            stampa.appendStringaOvunqueFormattazioneDestra("" + money_Tot_Differenza, 436, this.y + 80, 45);
            this.y += 15;
            String S_money_Tot_Ricavo_mio = "" + money_Totale_documento_Ricavo_parziale;
            String S_money_Tot_Ricavo_loro = "" + money_Totale_documento_nolo;
            String S_money_Tot_differenza = "" + money_Totale_documento_differenza;
            stampa.setFont(stampa.Font_Calibri_12_B);
            this.y += 8;
            stampa.appendLine(30, this.y + 75, 573, this.y + 75);
            stampa.appendLine(30, this.y + 80, 573, this.y + 80);
            if (this.y > 620) {
                stampa.paginanuova();
                this.y = this.y_inizio;
                this.stampa_intestazione(stampa, this.y);
                this.y -= 20;
            }
            this.y += 20;
            stampa.appendRoundRect(170, this.y + 75, 250, 50, 10, 10);
            String ricavo_parziale = "Ricavo Parziale";
            String nolo = "Nolo";
            String Margine = "Margine";
            stampa.appendTextOvunque(ricavo_parziale, 190, this.y + 90);
            stampa.appendStringaOvunqueFormattazioneDestra(S_money_Tot_Ricavo_mio, 350, this.y + 90, 45);
            stampa.appendTextOvunque(nolo, 190, this.y + 105);
            stampa.appendStringaOvunqueFormattazioneDestra(S_money_Tot_Ricavo_loro, 350, this.y + 105, 45);
            stampa.appendTextOvunque(Margine, 190, this.y + 120);
            stampa.appendStringaOvunqueFormattazioneDestra(S_money_Tot_differenza, 350, this.y + 120, 45);
            stampa.setFont(stampa.Font_Calibri_8);
            String date_now = this.fda.dataCorrente().replaceAll("-", "");
            String ora_now = this.fda.OraCorrente().replaceAll(":", "");
            String nome_file = this.f.pulisci_nome_file(date_now + ora_now + "_Viaggi_Singolo_Fornitore");
            stampa.getSeg().getMy_pj_corrente().getPj().setJobName(nome_file);
            stampa.setInt((OggettoToPrint)new IntestazioneFatturaAttiva());
            stampa.setIntPP((OggettoToPrint)new IntestazioneFatturaAttiva());
            stampa.setPiedePaginaGenericoIntestato((OggettoToPrint)new PiedePaginaGenericoIntestato("Fornitori"));
            stampa.print();
            MyTrace.log.info(" XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX STAMPA VIAGGI FORNITORE FINE XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
        }
        catch (Exception ex) {
            MyTrace.log.severe("ERRORE: eccezione elabora_formattazione_stampa() nella stampa viaggi fornitore");
            ex.printStackTrace();
            Funzioni.inviaBugPerEmail(ex);
            Funzioni.LogStackTrace(ex);
        }
        catch (Error err) {
            MyTrace.log.severe("ERRORE: elabora_formattazione_stampa() errore di avvio o di linkaggio");
            err.printStackTrace();
        }
    }

    public void stampa_intestazione(GestoreStampe stampa, int altezza) {
        MyTrace.log.info("STAMPA INTESTAZIONE VIAGGI FORNITORE    START");
        stampa.appendRoundRect(18, altezza += 10, 555, 50, 10, 10);
        stampa.setFont(stampa.Font_Calibri_12_B);
        stampa.appendTextOvunque(this.intestazione, 30, altezza + 10 + 3);
        stampa.setFont(stampa.Font_Calibri_10_B);
        stampa.appendTextOvunque("N\u00b0", 52, altezza + 10 + 15 + 18);
        stampa.appendTextOvunque("Inizio", 79, altezza + 10 + 15 + 18);
        stampa.appendTextOvunque("Fine", 125, altezza + 10 + 15 + 18);
        stampa.appendTextOvunque("Tratta", 173, altezza + 10 + 15 + 18);
        stampa.appendTextOvunque("Ricavo", 367, altezza + 10 + 15 + 18);
        stampa.appendTextOvunque("Nolo", 417, altezza + 10 + 15 + 18);
        stampa.appendTextOvunque("Margine", 452, altezza + 10 + 15 + 18);
        stampa.appendTextOvunque("Fattura", 513, altezza + 10 + 15 + 18);
        MyTrace.log.info("STAMPA VIAGGI FORNITORE    STOP");
    }
}

