/*
 * Decompiled with CFR 0.152.
 */
package trasporti.report_viaggi_per_fornitore;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import trasporti.viaggi.ViaggiFornitore;
import utils.Funzioni;
import utils.FunzioniDate;
import utils.Money;
import utils.MyTrace;

public class ReportVFTableModel
extends AbstractTableModel {
    ArrayList<String[]> cache;
    int colCount;
    String[] headers;
    boolean modo_ric = false;
    FunzioniDate fda = new FunzioniDate();

    public ReportVFTableModel() {
        this.cache = new ArrayList(8);
    }

    public void setModo_ric(boolean modo_ric) {
        this.modo_ric = modo_ric;
    }

    @Override
    public String getColumnName(int i) {
        String retVal = "";
        switch (i) {
            case 0: {
                retVal = "N. Viaggio";
                break;
            }
            case 1: {
                retVal = "Partenza";
                break;
            }
            case 2: {
                retVal = "Arrivo";
                break;
            }
            case 3: {
                retVal = "Tratta";
                break;
            }
            case 4: {
                retVal = "Ricavo";
                break;
            }
            case 5: {
                retVal = "Nolo";
                break;
            }
            case 6: {
                retVal = "Margine";
                break;
            }
            case 7: {
                retVal = "Fattura";
                break;
            }
            default: {
                retVal = this.headers[i];
            }
        }
        return retVal;
    }

    @Override
    public int getRowCount() {
        return this.cache.size();
    }

    @Override
    public int getColumnCount() {
        return 8;
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (!this.cache.isEmpty()) {
            String[] riga = this.cache.get(row);
            return riga[col];
        }
        return "";
    }

    public Class getColumnClass(int c) {
        return String.class;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return false;
    }

    public void setDataReportVV(Vector vettoreViaggi) {
        try {
            String[] riga;
            this.cache = new ArrayList();
            Iterator i = vettoreViaggi.iterator();
            int id_anagrafica_mem = 0;
            Money ricavo = new Money(BigDecimal.ZERO);
            Money nolo = new Money(BigDecimal.ZERO);
            Money margine = new Money(BigDecimal.ZERO);
            Money ricavo_tot = new Money(BigDecimal.ZERO);
            Money nolo_tot = new Money(BigDecimal.ZERO);
            Money margine_tot = new Money(BigDecimal.ZERO);
            while (i.hasNext()) {
                ViaggiFornitore v = (ViaggiFornitore)i.next();
                if (v.getId_fornitore() != id_anagrafica_mem) {
                    if (!this.cache.isEmpty()) {
                        riga = new String[]{"", "", "", "", "", "", "", ""};
                        riga[4] = ricavo.toString();
                        riga[5] = nolo.toString();
                        riga[6] = margine.toString();
                        ricavo = new Money(BigDecimal.ZERO);
                        nolo = new Money(BigDecimal.ZERO);
                        margine = new Money(BigDecimal.ZERO);
                        this.cache.add(riga);
                    }
                    riga = new String[]{"", "", "", "", "", "", "", ""};
                    riga[0] = v.getRagione_sociale();
                    id_anagrafica_mem = v.getId_fornitore();
                    this.cache.add(riga);
                }
                riga = new String[]{"", "", "", "", "", "", "", ""};
                Money margine_riga = v.getRicavo_riga().minus(v.getRicavo_tot_nolo());
                riga[0] = "" + v.getNumero_viaggio();
                riga[1] = this.fda.gira_data(v.getData_partenza());
                riga[2] = this.fda.gira_data(v.getData_arrivo());
                riga[3] = v.getDescrizione();
                riga[4] = "" + v.getRicavo_riga();
                riga[5] = "" + v.getRicavo_tot_nolo();
                if (margine_riga.isPlus()) {
                    riga[6] = "" + v.getRicavo_riga().minus(v.getRicavo_tot_nolo());
                    margine.plusplus(v.getRicavo_riga().minus(v.getRicavo_tot_nolo()));
                    margine_tot.plusplus(v.getRicavo_riga().minus(v.getRicavo_tot_nolo()));
                } else {
                    riga[6] = new BigDecimal(BigInteger.ZERO).toString();
                }
                riga[7] = "" + v.getNumero_fattura();
                ricavo.plusplus(v.getRicavo_riga());
                ricavo_tot.plusplus(v.getRicavo_riga());
                nolo.plusplus(v.getRicavo_tot_nolo());
                nolo_tot.plusplus(v.getRicavo_tot_nolo());
                this.cache.add(riga);
            }
            riga = new String[]{"", "", "", "", "", "", "", ""};
            riga[4] = "" + ricavo;
            riga[5] = "" + nolo;
            riga[6] = "" + ricavo.minus(nolo);
            this.cache.add(riga);
            riga = new String[]{"", "", "", "", "", "", "", ""};
            riga[0] = "TOTALE";
            riga[4] = "" + ricavo_tot;
            riga[5] = "" + nolo_tot;
            riga[6] = "" + margine_tot;
            this.cache.add(riga);
            this.fireTableChanged(null);
        }
        catch (Exception ex) {
            MyTrace.log.severe("ERRORE:  eccezione setDataRegistro errore di istanziazione ");
            ex.printStackTrace();
            Funzioni.inviaBugPerEmail(ex);
            Funzioni.LogStackTrace(ex);
        }
        catch (Error err) {
            MyTrace.log.severe("ERRORE: setDataRegistro errore di avvio o di linkaggio dello specifico modulo");
            err.printStackTrace();
        }
    }
}

