/*
 * Decompiled with CFR 0.152.
 */
package trasporti.report_viaggi_per_fornitore;

import gestionale.configurazioni.ConfigurazioneFinestre;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.table.DefaultTableModel;
import trasporti.ordini.InsiemeRigheOrdineViaggio;
import trasporti.ordini.RigaOrdineViaggio;
import trasporti.report_viaggi_per_fornitore.ReportVFTableModel;
import trasporti.report_viaggi_per_fornitore.ReportVFTableRenderer;
import trasporti.report_viaggi_per_fornitore.StampaViaggiFornitori;
import trasporti.viaggi.InsiemeViaggiFornitore;
import trasporti.viaggi.ViaggiFornitore;
import utils.ClientiFornitoriField;
import utils.DateField;
import utils.FunzioniDate;
import utils.MyTrace;
import utils.TimeFormatter;

public class MyReportViaggi
extends JInternalFrame {
    private DateField jTextDataDA;
    private DateField jTextDataA;
    private TimeFormatter df = null;
    FunzioniDate fda;
    public boolean f_mezzi_open = false;
    public ClientiFornitoriField jTextClientiFornitori;
    ReportVFTableModel rvftm;
    private JButton jButtonFiltra;
    private JButton jButtonStampa;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabelDescrizioneFornitore;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JTabbedPane jTabbedPane1;
    private JTable jTable1;
    private JToolBar jToolBar1;

    public MyReportViaggi() {
        MyTrace.log.info("FORM: MyReportViaggi   START");
        this.fda = new FunzioniDate();
        this.rvftm = new ReportVFTableModel();
        this.initComponents();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.df = new TimeFormatter();
        this.jTextDataDA = new DateField(this.df);
        this.jTextDataDA.setMinimumSize(new Dimension(100, 27));
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 10, 10, 0);
        this.jPanel1.add((Component)this.jTextDataDA, gridBagConstraints);
        this.jTextDataA = new DateField(this.df);
        this.jTextDataA.setMinimumSize(new Dimension(100, 27));
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 10, 10, 0);
        this.jPanel1.add((Component)this.jTextDataA, gridBagConstraints);
        this.setLocation(ConfigurazioneFinestre.GetPoint(this.getClass().getName(), new Point(200, 0)));
        this.setSize(ConfigurazioneFinestre.GetDimension(this.getClass().getName(), new Dimension(600, 500)));
        this.jTextClientiFornitori = new ClientiFornitoriFieldLocal(this, "F");
        this.jTextClientiFornitori.setPreferredSize(new Dimension(100, 27));
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel1.add((Component)this.jTextClientiFornitori, gridBagConstraints);
        this.jTextClientiFornitori.tipo = "F";
        this.jLabelDescrizioneFornitore.setText("*** Non Definito ***");
        this.azzera();
        MyTrace.log.info("FORM: MyReportViaggi   END");
    }

    private void azzera() {
        this.jTextDataDA.setText("01-01-" + this.fda.annoCorrente());
        this.jTextDataA.setText(this.fda.dataCorrenteIt());
    }

    private void posizione_finestra(ComponentEvent evt) {
        ConfigurazioneFinestre.SetPoint(this.getClass().getName(), this.getLocation());
    }

    private void finestra_ridimensionata(ComponentEvent evt) {
        ConfigurazioneFinestre.SetDimension(this.getClass().getName(), this.getSize());
    }

    private void initComponents() {
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabelDescrizioneFornitore = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.jButtonFiltra = new JButton();
        this.jPanel2 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jTable1 = new JTable(this.rvftm);
        this.jToolBar1 = new JToolBar();
        this.jButtonStampa = new JButton();
        this.setClosable(true);
        this.setIconifiable(true);
        this.setMaximizable(true);
        this.setResizable(true);
        this.setTitle("Trasporti \\ Viaggi Fornitore");
        this.setName("Trasporti \\ Viaggi Fornitore");
        this.jPanel1.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent evt) {
                MyReportViaggi.this.jPanel1ComponentMoved(evt);
            }

            @Override
            public void componentResized(ComponentEvent evt) {
                MyReportViaggi.this.jPanel1ComponentResized(evt);
            }
        });
        this.jPanel1.setLayout(new GridBagLayout());
        this.jLabel1.setText("Dalla Data");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.jPanel1.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel2.setText("Alla Data");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.jPanel1.add((Component)this.jLabel2, gridBagConstraints);
        this.jLabel3.setText("Fornitore");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.jPanel1.add((Component)this.jLabel3, gridBagConstraints);
        this.jLabelDescrizioneFornitore.setText("Descrizione Fornitore");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        this.jPanel1.add((Component)this.jLabelDescrizioneFornitore, gridBagConstraints);
        this.jSeparator1.setOrientation(1);
        this.jSeparator1.setMinimumSize(new Dimension(0, 10));
        this.jSeparator1.setPreferredSize(new Dimension(0, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        this.jPanel1.add((Component)this.jSeparator1, gridBagConstraints);
        this.jButtonFiltra.setText("FITLTRA");
        this.jButtonFiltra.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyReportViaggi.this.jButtonFiltraActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        this.jPanel1.add((Component)this.jButtonFiltra, gridBagConstraints);
        this.jTabbedPane1.addTab("Ricerca", this.jPanel1);
        this.jPanel2.setLayout(new BorderLayout());
        this.jTable1.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.jScrollPane1.setViewportView(this.jTable1);
        this.jPanel2.add((Component)this.jScrollPane1, "Center");
        this.jToolBar1.setRollover(true);
        this.jButtonStampa.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/document-print.png")));
        this.jButtonStampa.setText("STAMPA");
        this.jButtonStampa.setFocusable(false);
        this.jButtonStampa.setHorizontalAlignment(11);
        this.jButtonStampa.setVerticalTextPosition(3);
        this.jButtonStampa.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyReportViaggi.this.jButtonStampaActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonStampa);
        this.jPanel2.add((Component)this.jToolBar1, "First");
        this.jTabbedPane1.addTab("Elenco", this.jPanel2);
        this.getContentPane().add((Component)this.jTabbedPane1, "Center");
        this.pack();
    }

    private void jButtonStampaActionPerformed(ActionEvent evt) {
        String intestazione = "Lista dei viaggi effettuati dai fornitori dal " + this.jTextDataDA.getText() + " al " + this.jTextDataA.getText();
        InsiemeViaggiFornitore i_v_f = new InsiemeViaggiFornitore();
        String order_by = " ";
        String Where = "";
        Where = Where + "WHERE mtra_viaggi.id_anagrafica is not null ";
        Where = Where + "AND mtra_viaggi.data_partenza between '" + this.fda.gira_data(this.jTextDataDA.getText()) + "' AND '" + this.fda.gira_data(this.jTextDataA.getText()) + "' ";
        if (!this.jTextClientiFornitori.getText().equals("")) {
            Where = Where + "AND mtra_viaggi.id_anagrafica ='" + this.jTextClientiFornitori.getAnagrafica().getIdanag() + "' ";
            intestazione = "Lista dei viaggi effettuati dal fornitore " + this.jTextClientiFornitori.getAnagrafica().getRagione_sociale() + " dal " + this.jTextDataDA.getText() + " al " + this.jTextDataA.getText();
            order_by = "  ";
        } else {
            order_by = " order by mtra_viaggi.id_anagrafica  ";
        }
        i_v_f.caricamento_viaggi(Where, order_by);
        InsiemeRigheOrdineViaggio insieme_righe_fp = new InsiemeRigheOrdineViaggio();
        insieme_righe_fp.caricamento(Where, order_by);
        for (ViaggiFornitore viaggio : i_v_f.list) {
            for (RigaOrdineViaggio rov : insieme_righe_fp.vettoreR) {
                if (rov.getId_viaggio() != viaggio.getId_viaggio()) continue;
                if (rov.getNc() == 0) {
                    viaggio.getRicavo_tot_nolo().plusplus(rov.getP_tot_riga());
                } else {
                    viaggio.getRicavo_tot_nolo().plusplus(rov.getP_tot_riga().negate());
                }
                String num_fattura_passiva = rov.getNumero_fattura_passiva();
                if (num_fattura_passiva.equals("")) {
                    viaggio.setNumero_fattura("               NO F.P.");
                    continue;
                }
                viaggio.setNumero_fattura(num_fattura_passiva + " del " + this.fda.gira_data(rov.getData_fattura_passiva()) + " ");
            }
        }
        StampaViaggiFornitori stampa_viaggi_fornitore = new StampaViaggiFornitori(intestazione, i_v_f);
        MyTrace.log.config("HO COSTRUITO L'OGGETTO STAMPA VIAGGI SINGOLO FORNITORE");
        stampa_viaggi_fornitore.avvia();
    }

    private void jPanel1ComponentMoved(ComponentEvent evt) {
        this.posizione_finestra(evt);
    }

    private void jPanel1ComponentResized(ComponentEvent evt) {
        this.finestra_ridimensionata(evt);
    }

    private void jButtonFiltraActionPerformed(ActionEvent evt) {
        String intestazione = "Lista dei viaggi effettuati dai fornitori dal " + this.jTextDataDA.getText() + " al " + this.jTextDataA.getText();
        InsiemeViaggiFornitore i_v_f = new InsiemeViaggiFornitore();
        String order_by = " ";
        String Where = "";
        Where = Where + "WHERE mtra_viaggi.id_anagrafica is not null ";
        Where = Where + "AND mtra_viaggi.data_partenza between '" + this.fda.gira_data(this.jTextDataDA.getText()) + "' AND '" + this.fda.gira_data(this.jTextDataA.getText()) + "' ";
        if (!this.jTextClientiFornitori.getText().equals("")) {
            Where = Where + "AND mtra_viaggi.id_anagrafica ='" + this.jTextClientiFornitori.getAnagrafica().getIdanag() + "' ";
            intestazione = "Lista dei viaggi effettuati dal fornitore " + this.jTextClientiFornitori.getAnagrafica().getRagione_sociale() + " dal " + this.jTextDataDA.getText() + " al " + this.jTextDataA.getText();
            order_by = "  ";
        } else {
            order_by = " order by mtra_viaggi.id_anagrafica  ";
        }
        i_v_f.caricamento_viaggi(Where, order_by);
        InsiemeRigheOrdineViaggio insieme_righe_fp = new InsiemeRigheOrdineViaggio();
        insieme_righe_fp.caricamento(Where, order_by);
        for (ViaggiFornitore viaggio : i_v_f.list) {
            for (RigaOrdineViaggio rov : insieme_righe_fp.vettoreR) {
                if (rov.getId_viaggio() != viaggio.getId_viaggio()) continue;
                if (rov.getNc() == 0) {
                    viaggio.getRicavo_tot_nolo().plusplus(rov.getP_tot_riga());
                } else {
                    viaggio.getRicavo_tot_nolo().plusplus(rov.getP_tot_riga().negate());
                }
                String num_fattura_passiva = rov.getNumero_fattura_passiva();
                if (num_fattura_passiva.equals("")) {
                    viaggio.setNumero_fattura("               NO F.P.");
                    continue;
                }
                viaggio.setNumero_fattura(num_fattura_passiva + " del " + this.fda.gira_data(rov.getData_fattura_passiva()) + " ");
            }
        }
        this.rvftm = new ReportVFTableModel();
        this.rvftm.setDataReportVV(i_v_f.list);
        this.jTable1.setModel(this.rvftm);
        this.jTable1.setRowHeight(27);
        this.jTable1.setDefaultRenderer(Object.class, new ReportVFTableRenderer());
        this.jTabbedPane1.setSelectedIndex(1);
    }

    class ClientiFornitoriFieldLocal
    extends ClientiFornitoriField {
        ClientiFornitoriFieldLocal(JInternalFrame frame, String t) {
            super(frame, t);
        }

        @Override
        public void focusLost(FocusEvent e) {
            this.completaAutomaticamente();
            if (this.getAnagrafica() != null && this.getAnagrafica().getRagione_sociale() != null && !this.getAnagrafica().getRagione_sociale().equals("")) {
                MyReportViaggi.this.jLabelDescrizioneFornitore.setText(this.getAnagrafica().getRagione_sociale());
            } else {
                MyReportViaggi.this.jLabelDescrizioneFornitore.setText("** Non definito **");
            }
        }
    }
}

