/*
 * Decompiled with CFR 0.152.
 */
package trasporti.report_ordini;

import gestionale.personalizzazione.stampe.PiedePaginaGenericoIntestato;
import java.awt.Color;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import trasporti.report_ordini.FunzioniReportOrdini;
import utils.BannerWorking;
import utils.Funzioni;
import utils.FunzioniDate;
import utils.Money;
import utils.MyTrace;
import utils.stampe.GestoreStampe;
import utils.stampe.OggettoToPrint;

public class StampaOrdiniTuttiClienti
implements Runnable {
    Funzioni f;
    FunzioniDate fda;
    int y;
    int y_inizio_senza_intestazione;
    Thread thread;
    String dataDA;
    String dataDA_girata;
    String dataA;
    String dataA_girata;
    String tipo;
    Object[] riga;
    ArrayList<Object> ordini_da_cliente_2;
    Vector lista_clienti;
    FunzioniReportOrdini trasporti_report;
    int i = 0;
    float[] dash = new float[]{1.0f, 1.0f};

    public StampaOrdiniTuttiClienti(String tipo, String dataDA, String dataA, Vector lista_clienti, FunzioniReportOrdini trasporti_report) {
        MyTrace.log.info("STAMPA ORDINI TUTTI CLIENTI   (START)");
        this.tipo = tipo;
        this.dataDA = dataDA;
        this.dataA = dataA;
        this.lista_clienti = lista_clienti;
        this.trasporti_report = trasporti_report;
        this.riga = new Object[6];
        this.f = new Funzioni();
        this.fda = new FunzioniDate();
        this.dataDA_girata = this.fda.gira_data(dataDA);
        this.dataA_girata = this.fda.gira_data(dataA);
        this.y = this.y_inizio_senza_intestazione = 10;
        MyTrace.log.info("STAMPA ORDINI TUTTI CLIENTI    (STOP)");
    }

    public void avvia() {
        this.thread = new Thread(this);
        MyTrace.log.info("avvio Procedura su Thread");
        this.thread.start();
    }

    @Override
    public void run() {
        BannerWorking attesa = new BannerWorking("ELABORAZIONE SU THREAD STAMPA ORDINI TUTTI CLIENTI");
        attesa.start();
        this.elabora_formattazione_stampa(this.lista_clienti);
        attesa.stop();
    }

    private void elabora_formattazione_stampa(Vector lista_clienti) {
        try {
            MyTrace.log.info("STAMPA ORDINI  TUTTI CLIENTI: XXXXXXXXXXXXXXXXXXXXXXXXXXXXXX  INIZIO STAMPA XXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
            GestoreStampe stampa = new GestoreStampe();
            stampa.aggiungi_pj();
            stampa.setFont(stampa.Font_Calibri_10_B);
            this.stampa_intestazione(stampa, this.y);
            stampa.setFont(stampa.Font_Calibri_10);
            String rag_soc_primo = "";
            if (!this.trasporti_report.ragione_soc.isEmpty()) {
                String o_rag_soc_primo = this.trasporti_report.ragione_soc.elementAt(0);
                rag_soc_primo = o_rag_soc_primo.toString();
                stampa.appendTextOvunque("Cliente: ", 30, this.y + 75);
                stampa.setFont(stampa.Font_Calibri_14_B);
                stampa.appendTextOvunque(rag_soc_primo, 100, this.y + 75);
                stampa.appendLine(30, this.y + 80, 573, this.y + 80);
                ++this.i;
            }
            int indice_per_stampa_solo_prima_pagina = 0;
            Money money_Tot_Ordini_Fatturati = new Money(BigDecimal.ZERO);
            Money money__Tot_Ordini__Non_Fatturati = new Money(BigDecimal.ZERO);
            Money money_Tot_Ordini = new Money(BigDecimal.ZERO);
            for (ArrayList this.ordini_da_cliente_2 : lista_clienti) {
                Money money_Tot_Ordini_Fatturati_Cliente = new Money(BigDecimal.ZERO);
                Money money__Tot_Ordini__Non_Fatturati_Cliente = new Money(BigDecimal.ZERO);
                Money money_Tot_Ordini_Cliente = new Money(BigDecimal.ZERO);
                Iterator<Object> iteratore_valori = this.ordini_da_cliente_2.iterator();
                while (iteratore_valori.hasNext()) {
                    stampa.setFont(stampa.Font_Calibri_10);
                    this.riga = (Object[])iteratore_valori.next();
                    String ordine = (String)this.riga[1];
                    String descrizione = (String)this.riga[2];
                    String data = (String)this.riga[3];
                    String importo = ((Money)this.riga[4]).toString();
                    String fatturato = (String)this.riga[5];
                    if (indice_per_stampa_solo_prima_pagina == 0) {
                        this.y += 20;
                        ++indice_per_stampa_solo_prima_pagina;
                    }
                    stampa.appendTextOvunque(ordine, 30, this.y + 75);
                    stampa.appendTextOvunque(descrizione, 100, this.y + 75);
                    stampa.appendTextOvunque(data, 310, this.y + 75);
                    stampa.appendStringaOvunqueFormattazioneDestra(importo, 430, this.y + 75, 45);
                    stampa.appendTextOvunque(fatturato, 520, this.y + 75);
                    this.y += 12;
                    stampa.appendLineTratteggiata(30, this.y + 75 - 9, 573, this.y + 75 - 9, this.dash, Color.gray);
                    if (this.y > 670) {
                        stampa.paginanuova();
                        this.y = this.y_inizio_senza_intestazione;
                        this.stampa_intestazione(stampa, this.y);
                    }
                    money_Tot_Ordini.plusplus((Money)this.riga[4]);
                    money_Tot_Ordini_Cliente.plusplus((Money)this.riga[4]);
                    if (this.riga[5].equals("Si")) {
                        money_Tot_Ordini_Fatturati.plusplus((Money)this.riga[4]);
                        money_Tot_Ordini_Fatturati_Cliente.plusplus((Money)this.riga[4]);
                        continue;
                    }
                    money__Tot_Ordini__Non_Fatturati.plusplus((Money)this.riga[4]);
                    money__Tot_Ordini__Non_Fatturati_Cliente.plusplus((Money)this.riga[4]);
                }
                String S_money_Tot_Ordini_Fatturati_Cliente = "" + money_Tot_Ordini_Fatturati_Cliente;
                String S_money__Tot_Ordini__Non_Fatturati_Cliente = "" + money__Tot_Ordini__Non_Fatturati_Cliente;
                String S_money_Tot_Ordini_Cliente = "" + money_Tot_Ordini_Cliente;
                stampa.setFont(stampa.Font_Calibri_10_B);
                if (this.y > 670) {
                    stampa.paginanuova();
                    this.y = this.y_inizio_senza_intestazione;
                    this.stampa_intestazione(stampa, this.y);
                }
                stampa.appendLine(310, this.y + 75 - 9, 573, this.y + 75 - 9, Color.GRAY);
                this.y += 2;
                String tot_ordini_fatturati = "Tot. Ordini Fatturati";
                String tot_ordini_non_fatturati = "Tot. Ordini Non Fatturati";
                String tot_ordini = "Tot. Ordini";
                if (this.tipo.equals("2")) {
                    stampa.appendTextOvunque(tot_ordini_fatturati, 310, this.y + 75);
                    stampa.appendTextOvunque(tot_ordini_non_fatturati, 310, this.y + 85);
                    stampa.appendTextOvunque(tot_ordini, 310, this.y + 95);
                    stampa.appendStringaOvunqueFormattazioneDestra(S_money_Tot_Ordini_Fatturati_Cliente, 430, this.y + 75, 45);
                    stampa.appendStringaOvunqueFormattazioneDestra(S_money__Tot_Ordini__Non_Fatturati_Cliente, 430, this.y + 85, 45);
                    stampa.appendStringaOvunqueFormattazioneDestra(S_money_Tot_Ordini_Cliente, 430, this.y + 95, 45);
                    this.y += 45;
                } else if (this.tipo.equals("1")) {
                    stampa.appendTextOvunque(tot_ordini_fatturati, 310, this.y + 75);
                    stampa.appendStringaOvunqueFormattazioneDestra(S_money_Tot_Ordini_Fatturati_Cliente, 430, this.y + 75, 45);
                    this.y += 25;
                } else if (this.tipo.equals("0")) {
                    stampa.appendTextOvunque(tot_ordini_non_fatturati, 310, this.y + 75);
                    stampa.appendStringaOvunqueFormattazioneDestra(S_money__Tot_Ordini__Non_Fatturati_Cliente, 430, this.y + 75, 45);
                    this.y += 25;
                }
                if (this.y > 670) {
                    stampa.paginanuova();
                    this.y = this.y_inizio_senza_intestazione;
                    this.stampa_intestazione(stampa, this.y);
                }
                if (this.i < this.trasporti_report.ragione_soc.size()) {
                    stampa.setFont(stampa.Font_Calibri_10);
                    String o_rag_soc = this.trasporti_report.ragione_soc.elementAt(this.i);
                    String rag_soc = o_rag_soc.toString();
                    stampa.appendTextOvunque("Cliente: ", 30, this.y + 75);
                    stampa.setFont(stampa.Font_Calibri_14_B);
                    stampa.appendTextOvunque(rag_soc, 100, this.y + 75);
                    stampa.appendLine(30, this.y + 80, 573, this.y + 80);
                    ++this.i;
                }
                this.y += 20;
                if (this.y <= 670) continue;
                stampa.paginanuova();
                this.y = this.y_inizio_senza_intestazione;
                this.stampa_intestazione(stampa, this.y);
            }
            String S_money_Tot_Ordini_Fatturati = "" + money_Tot_Ordini_Fatturati;
            String S_money__Tot_Ordini__Non_Fatturati = "" + money__Tot_Ordini__Non_Fatturati;
            String S_money_Tot_Ordini = "" + money_Tot_Ordini;
            if (this.y > 660) {
                stampa.paginanuova();
                this.y = this.y_inizio_senza_intestazione;
                this.stampa_intestazione(stampa, this.y);
            } else {
                this.y -= 20;
            }
            stampa.appendLine(30, this.y + 75, 573, this.y + 75);
            stampa.appendLine(30, this.y + 80, 573, this.y + 80);
            this.y += 20;
            stampa.appendRoundRect(170, this.y + 75, 250, 50, 10, 10);
            stampa.setFont(stampa.Font_Calibri_12_B);
            String tot_ordini_fatturati = "Totale Ordini Fatturati";
            String tot_ordini_non_fatturati = "Totale Ordini Non Fatturati";
            String tot_ordini = "Totale Ordini";
            if (this.tipo.equals("2")) {
                stampa.appendTextOvunque(tot_ordini_fatturati, 190, this.y + 90);
                stampa.appendTextOvunque(tot_ordini_non_fatturati, 190, this.y + 104);
                stampa.appendTextOvunque(tot_ordini, 190, this.y + 118);
                stampa.appendStringaOvunqueFormattazioneDestra(S_money_Tot_Ordini_Fatturati, 350, this.y + 90, 45);
                stampa.appendStringaOvunqueFormattazioneDestra(S_money__Tot_Ordini__Non_Fatturati, 350, this.y + 104, 45);
                stampa.appendStringaOvunqueFormattazioneDestra(S_money_Tot_Ordini, 350, this.y + 118, 45);
            } else if (this.tipo.equals("1")) {
                stampa.appendTextOvunque(tot_ordini_fatturati, 190, this.y + 104);
                stampa.appendStringaOvunqueFormattazioneDestra(S_money_Tot_Ordini_Fatturati, 350, this.y + 104, 45);
            } else if (this.tipo.equals("0")) {
                stampa.appendTextOvunque(tot_ordini_non_fatturati, 190, this.y + 104);
                stampa.appendStringaOvunqueFormattazioneDestra(S_money__Tot_Ordini__Non_Fatturati, 350, this.y + 104, 45);
            }
            stampa.setFont(stampa.Font_Calibri_8);
            String date_now = this.fda.dataCorrente().replaceAll("-", "");
            String ora_now = this.fda.OraCorrente().replaceAll(":", "");
            String nome_file = this.f.pulisci_nome_file(date_now + ora_now + "_Conteggio_Ordini_Con_Fatturato_Tutti_Clienti_Dal_" + this.dataDA_girata + "_Al_" + this.dataA_girata);
            stampa.getSeg().getMy_pj_corrente().getPj().setJobName(nome_file);
            stampa.setPiedePaginaGenericoIntestato((OggettoToPrint)new PiedePaginaGenericoIntestato("Ordini"));
            stampa.print();
            MyTrace.log.info(" XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX STAMPA ORDINI TUTTI CLIENTI FINE XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
        }
        catch (Exception ex) {
            MyTrace.log.severe("ERRORE: eccezione elabora() nella stampa fatturato per cliente");
            ex.printStackTrace();
            Funzioni.inviaBugPerEmail(ex);
            Funzioni.LogStackTrace(ex);
        }
        catch (Error err) {
            MyTrace.log.severe("ERRORE: elabora() errore di avvio o di linkaggio");
            err.printStackTrace();
        }
    }

    public void stampa_intestazione(GestoreStampe stampa, int altezza) {
        MyTrace.log.info("STAMPA INTESTAZIONE ORDINI TUTTI CLIENTI    START");
        stampa.appendRoundRect(18, altezza += 10, 555, 35, 10, 10);
        stampa.setFont(stampa.Font_Calibri_12_B);
        stampa.appendTextOvunque("Ordini con fatturato dal " + this.dataDA_girata + " al " + this.dataA_girata, 30, altezza + 10 + 3);
        stampa.setFont(stampa.Font_Calibri_10_B);
        stampa.appendTextOvunque("Ordine N\u00b0", 30, altezza + 10 + 18);
        stampa.appendTextOvunque("Descrizione", 100, altezza + 10 + 18);
        stampa.appendTextOvunque("Data Ordine", 310, altezza + 10 + 18);
        stampa.appendTextOvunque("Importo Totale", 430, altezza + 10 + 18);
        stampa.appendTextOvunque("Fatturato", 520, altezza + 10 + 18);
        MyTrace.log.info("STAMPA INTESTAZIONE ORDINI TUTTI CLIENTI   STOP");
    }
}

