/*
 * Decompiled with CFR 0.152.
 */
package trasporti.report_ordini;

import gestionale.personalizzazione.stampe.PiedePaginaGenericoIntestato;
import java.awt.Color;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import utils.BannerWorking;
import utils.ClientiFornitoriField;
import utils.Funzioni;
import utils.FunzioniDate;
import utils.Money;
import utils.MyTrace;
import utils.stampe.GestoreStampe;
import utils.stampe.OggettoToPrint;

public class StampaOrdiniDelCliente
implements Runnable {
    Funzioni f;
    FunzioniDate fda;
    int y;
    int y_inizio_senza_intestazione;
    Thread thread;
    String dataDA;
    String dataDA_girata;
    String dataA;
    String dataA_girata;
    String tipo;
    String ragione_sociale;
    int id_anagrafica;
    ClientiFornitoriField jTextClientiFornitori;
    ArrayList<Object> ordini_da_cliente_2;
    Object[] riga;
    float[] dash = new float[]{1.0f, 1.0f};

    public StampaOrdiniDelCliente(String tipo, ClientiFornitoriField jTextClientiFornitori, String dataDA, String dataA, ArrayList<Object> ordini_da_cliente_2) {
        MyTrace.log.info("STAMPA ORDINI DEL CLIENTE   (START)");
        this.dataA = dataA;
        this.dataDA = dataDA;
        this.tipo = tipo;
        this.id_anagrafica = jTextClientiFornitori.getAnagrafica().getIdanag();
        this.ragione_sociale = jTextClientiFornitori.getAnagrafica().getRagione_sociale();
        this.ordini_da_cliente_2 = ordini_da_cliente_2;
        this.riga = new Object[6];
        this.f = new Funzioni();
        this.fda = new FunzioniDate();
        this.dataDA_girata = this.fda.gira_data(dataDA);
        this.dataA_girata = this.fda.gira_data(dataA);
        this.y = this.y_inizio_senza_intestazione = 10;
        MyTrace.log.info("STAMPA ORDINI DEL CLIENTE   (STOP)");
    }

    public void avvia() {
        this.thread = new Thread(this);
        MyTrace.log.info("avvio Procedura su Thread");
        this.thread.start();
    }

    @Override
    public void run() {
        BannerWorking attesa = new BannerWorking("ELABORAZIONE SU THREAD STAMPA ORDINI DEL CLIENTE");
        attesa.start();
        this.elabora_formattazione_stampa(this.ordini_da_cliente_2);
        attesa.stop();
    }

    private void elabora_formattazione_stampa(ArrayList<Object> ordini_da_cliente_2) {
        boolean vuoto = false;
        boolean vero = false;
        try {
            MyTrace.log.info("STAMPA ORDINI DEL CLIENTE: XXXXXXXXXXXXXXXXXXXXXXXXXXXXXX  INIZIO STAMPA XXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
            GestoreStampe stampa = new GestoreStampe();
            stampa.aggiungi_pj();
            stampa.setFont(stampa.Font_Calibri_10_B);
            this.stampa_intestazione(stampa, this.y);
            stampa.setFont(stampa.Font_Calibri_10);
            Money money_Tot_Ordini_Fatturati = new Money(BigDecimal.ZERO);
            Money money__Tot_Ordini__Non_Fatturati = new Money(BigDecimal.ZERO);
            Money money_Tot_Ordini = new Money(BigDecimal.ZERO);
            Iterator<Object> iteratore_valori = ordini_da_cliente_2.iterator();
            while (iteratore_valori.hasNext()) {
                vuoto = false;
                stampa.setFont(stampa.Font_Calibri_10);
                this.riga = (Object[])iteratore_valori.next();
                String ordine = (String)this.riga[1];
                String descrizione = (String)this.riga[2];
                String data = (String)this.riga[3];
                String importo = ((Money)this.riga[4]).toString();
                String fatturato = (String)this.riga[5];
                stampa.appendTextOvunque(ordine, 30, this.y + 75);
                stampa.appendTextOvunque(descrizione, 100, this.y + 75);
                stampa.appendTextOvunque(data, 340, this.y + 75);
                stampa.appendStringaOvunqueFormattazioneDestra(importo, 430, this.y + 75, 45);
                stampa.appendTextOvunque(fatturato, 520, this.y + 75);
                this.y += 12;
                stampa.appendLineTratteggiata(30, this.y + 75 - 9, 573, this.y + 75 - 9, this.dash, Color.gray);
                if (this.y > 670) {
                    stampa.paginanuova();
                    this.y = this.y_inizio_senza_intestazione;
                    vuoto = true;
                    vero = true;
                }
                if (this.y == this.y_inizio_senza_intestazione + 12 && vero) {
                    this.stampa_intestazione(stampa, this.y_inizio_senza_intestazione);
                    vero = false;
                }
                money_Tot_Ordini.plusplus((Money)this.riga[4]);
                if (this.riga[5].equals("Si")) {
                    money_Tot_Ordini_Fatturati.plusplus((Money)this.riga[4]);
                    continue;
                }
                money__Tot_Ordini__Non_Fatturati.plusplus((Money)this.riga[4]);
            }
            String S_money_Tot_Ordini_Fatturati = "" + money_Tot_Ordini_Fatturati;
            String S_money__Tot_Ordini__Non_Fatturati = "" + money__Tot_Ordini__Non_Fatturati;
            String S_money_Tot_Ordini = "" + money_Tot_Ordini;
            stampa.setFont(stampa.Font_Calibri_12_B);
            if (vuoto) {
                this.y = this.y_inizio_senza_intestazione;
                this.stampa_intestazione_vuota(stampa, this.y);
            }
            if (this.y > 620) {
                stampa.paginanuova();
                this.y = this.y_inizio_senza_intestazione;
                this.stampa_intestazione_vuota(stampa, this.y);
            }
            this.y += 8;
            stampa.appendLine(30, this.y + 75, 573, this.y + 75);
            stampa.appendLine(30, this.y + 80, 573, this.y + 80);
            this.y += 20;
            stampa.appendRoundRect(170, this.y + 75, 250, 50, 10, 10);
            String tot_ordini_fatturati = "Totale Ordini Fatturati";
            String tot_ordini_non_fatturati = "Totale Ordini Non Fatturati";
            String tot_ordini = "Totale Ordini";
            if (this.tipo.equals("2")) {
                stampa.appendTextOvunque(tot_ordini_fatturati, 190, this.y + 90);
                stampa.appendTextOvunque(tot_ordini_non_fatturati, 190, this.y + 104);
                stampa.appendTextOvunque(tot_ordini, 190, this.y + 118);
                stampa.appendStringaOvunqueFormattazioneDestra(S_money_Tot_Ordini_Fatturati, 350, this.y + 90, 45);
                stampa.appendStringaOvunqueFormattazioneDestra(S_money__Tot_Ordini__Non_Fatturati, 350, this.y + 104, 45);
                stampa.appendStringaOvunqueFormattazioneDestra(S_money_Tot_Ordini, 350, this.y + 118, 45);
            } else if (this.tipo.equals("1")) {
                stampa.appendTextOvunque(tot_ordini_fatturati, 190, this.y + 104);
                stampa.appendStringaOvunqueFormattazioneDestra(S_money_Tot_Ordini_Fatturati, 350, this.y + 104, 45);
            } else if (this.tipo.equals("0")) {
                stampa.appendTextOvunque(tot_ordini_non_fatturati, 190, this.y + 104);
                stampa.appendStringaOvunqueFormattazioneDestra(S_money__Tot_Ordini__Non_Fatturati, 350, this.y + 104, 45);
            }
            stampa.setFont(stampa.Font_Calibri_8);
            String date_now = this.fda.dataCorrente().replaceAll("-", "");
            String ora_now = this.fda.OraCorrente().replaceAll(":", "");
            String nome_file = this.f.pulisci_nome_file(date_now + ora_now + "_Conteggio_Ordini_Con_Fatturato_Del_Cliente_" + this.ragione_sociale + "_Dal_" + this.dataDA_girata + "_Al_" + this.dataA_girata);
            stampa.getSeg().getMy_pj_corrente().getPj().setJobName(nome_file);
            stampa.setPiedePaginaGenericoIntestato((OggettoToPrint)new PiedePaginaGenericoIntestato("Ordini"));
            stampa.print();
            MyTrace.log.info(" XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX STAMPA ORDINI DEL CLIENTE FINE XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
        }
        catch (Exception ex) {
            MyTrace.log.severe("ERRORE: eccezione elabora() nella stampa fatturato per cliente");
            ex.printStackTrace();
            Funzioni.inviaBugPerEmail(ex);
            Funzioni.LogStackTrace(ex);
        }
        catch (Error err) {
            MyTrace.log.severe("ERRORE: elabora() errore di avvio o di linkaggio");
            err.printStackTrace();
        }
    }

    public void stampa_intestazione(GestoreStampe stampa, int altezza) {
        MyTrace.log.info("STAMPA INTESTAZIONE  ORDINI UN CLIENTE    START");
        stampa.appendRoundRect(18, altezza += 10, 555, 35, 10, 10);
        stampa.setFont(stampa.Font_Calibri_12_B);
        stampa.appendTextOvunque("Ordini con fatturato del cliente " + this.ragione_sociale + " dal " + this.dataDA_girata + " al " + this.dataA_girata, 30, altezza + 10 + 3);
        stampa.setFont(stampa.Font_Calibri_10_B);
        stampa.appendTextOvunque("Ordine N\u00b0", 30, altezza + 10 + 18);
        stampa.appendTextOvunque("Descrizione", 100, altezza + 10 + 18);
        stampa.appendTextOvunque("Data Ordine", 340, altezza + 10 + 18);
        stampa.appendTextOvunque("Importo Totale", 430, altezza + 10 + 18);
        stampa.appendTextOvunque("Fatturato", 520, altezza + 10 + 18);
        MyTrace.log.info("STAMPA INTESTAZIONE  ORDINI UN CLIENTE    STOP");
    }

    public void stampa_intestazione_vuota(GestoreStampe stampa, int altezza) {
        MyTrace.log.info("STAMPA INTESTAZIONE VUOTA ORDINI  START");
        stampa.appendRoundRect(18, altezza += 10, 555, 35, 10, 10);
        stampa.setFont(stampa.Font_Calibri_12_B);
        stampa.appendTextOvunque("Ordini con fatturato del cliente " + this.ragione_sociale + " dal " + this.dataDA_girata + " al " + this.dataA_girata, 30, altezza + 10 + 11);
        stampa.setFont(stampa.Font_Calibri_10_B);
        MyTrace.log.info("STAMPA INTESTAZIONE VUOTA ORDINI  STOP");
    }
}

