/*
 * Decompiled with CFR 0.152.
 */
package trasporti.report_km;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import utils.Funzioni;
import utils.MyTrace;

public class ReportKmTableRenderer
extends DefaultTableCellRenderer
implements TableCellRenderer {
    private static final Color SELECTED_COLOR = new Color(61, 128, 223);
    private static final Color ALTERNATE_COLOR = new Color(232, 242, 254);
    JLabel testLabel = null;
    JCheckBox testbox = null;
    Border paddingBorder = BorderFactory.createEmptyBorder(12, 10, 12, 10);
    Border bordo_della_cella = BorderFactory.createCompoundBorder(new JLabel().getBorder(), this.paddingBorder);
    Funzioni f = new Funzioni();
    public static final DefaultTableCellRenderer DEFAULT_RENDERER = new DefaultTableCellRenderer();

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
        try {
            if (value != null) {
                this.setText(value.toString());
                this.setOpaque(true);
                this.setFont(new Font("Tahoma", 0, 12));
                this.setForeground(new Color(0, 0, 102));
                this.setBorder(this.bordo_della_cella);
                if (this.f.isNumber(value.toString())) {
                    this.setHorizontalAlignment(4);
                } else {
                    this.setHorizontalAlignment(2);
                }
                if (isSelected) {
                    this.setForeground(Color.WHITE);
                    this.setBackground(SELECTED_COLOR);
                } else {
                    String col8 = table.getModel().getValueAt(row, 8).toString();
                    String col9 = table.getModel().getValueAt(row, 9).toString();
                    String col0 = table.getModel().getValueAt(row, 0).toString();
                    if (col8.equals("") && col9.equals("")) {
                        this.setBackground(new Color(204, 0, 0));
                        this.setForeground(Color.white);
                    } else if (col0.equals("")) {
                        this.setBackground(new Color(204, 204, 204));
                        this.setForeground(Color.white);
                    } else if (col0.equals("TOTALE")) {
                        this.setBackground(new Color(51, 153, 255));
                        this.setForeground(Color.white);
                    } else {
                        this.setForeground(table.getForeground());
                        if (row % 2 == 0) {
                            this.setBackground(ALTERNATE_COLOR);
                        } else {
                            this.setBackground(table.getBackground());
                        }
                    }
                }
                return this;
            }
        }
        catch (Exception ex) {
            MyTrace.log.severe("ERRORE:  eccezione getTableCellRendererComponent errore di istanziazione ");
            ex.printStackTrace();
            Funzioni.inviaBugPerEmail(ex);
            Funzioni.LogStackTrace(ex);
        }
        catch (Error err) {
            MyTrace.log.severe("ERRORE: getTableCellRendererComponent errore di avvio o di linkaggio dello specifico modulo");
            err.printStackTrace();
        }
        return null;
    }
}

