/*
 * Decompiled with CFR 0.152.
 */
package trasporti.prese_consegne;

import java.util.Date;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.table.AbstractTableModel;
import trasporti.prese_consegne.PresaConsegna;
import utils.Funzioni;
import utils.FunzioniDate;
import utils.FunzioniTrasporti;
import utils.Quantita;

public class PreseConsegneEditTableModel
extends AbstractTableModel {
    Vector cache;
    int colCount;
    String[] headers;
    Funzioni f = new Funzioni();
    FunzioniDate fda = new FunzioniDate();
    FunzioniTrasporti ft = new FunzioniTrasporti();

    public PreseConsegneEditTableModel() {
        this.cache = new Vector();
    }

    @Override
    public String getColumnName(int i) {
        String retVal = "";
        switch (i) {
            case 0: {
                retVal = "P/C";
                break;
            }
            case 1: {
                retVal = "Data";
                break;
            }
            case 2: {
                retVal = "Ora";
                break;
            }
            case 3: {
                retVal = "Num. Ordine";
                break;
            }
            case 4: {
                retVal = "Luogo";
                break;
            }
            case 5: {
                retVal = "Quantita";
                break;
            }
            case 6: {
                retVal = "Unita Misura";
                break;
            }
            case 7: {
                retVal = "Tipologia";
                break;
            }
            case 8: {
                retVal = "Note";
                break;
            }
            default: {
                retVal = this.headers[i];
            }
        }
        return retVal;
    }

    @Override
    public int getRowCount() {
        return this.cache.size();
    }

    @Override
    public int getColumnCount() {
        return 9;
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (!this.cache.isEmpty()) {
            PresaConsegna pc = (PresaConsegna)this.cache.elementAt(row);
            return pc.getColValue(col);
        }
        return "";
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        PresaConsegna pc = (PresaConsegna)this.cache.elementAt(row);
        if (col == 0) {
            pc.setTipo(value.toString());
        }
        if (col == 1) {
            pc.setData(this.fda.gira_data(value.toString()));
        }
        if (col == 2) {
            pc.setOra(value.toString());
        }
        if (col == 3) {
            pc.setN_ordine(value.toString());
        }
        if (col == 4) {
            // empty if block
        }
        if (col == 5) {
            pc.setQuantita(new Quantita(value.toString()));
        }
        if (col == 6) {
            pc.setId_um(this.f.id_um(value.toString()));
            pc.setUnitaMisura(value.toString());
        }
        if (col == 7) {
            pc.setId_tipologia_merce(this.ft.id_tipologia_merce(value.toString()));
            pc.setTipologia_merce(value.toString());
        }
        if (col == 8) {
            pc.setDettaglio(value.toString());
        }
        this.fireTableRowsUpdated(row, row);
    }

    public Class getColumnClass(int c) {
        if (c == 0) {
            return JCheckBox.class;
        }
        if (c == 6) {
            return JComboBox.class;
        }
        if (c == 7) {
            return JButton.class;
        }
        if (c == 1) {
            return Date.class;
        }
        return this.getValueAt(0, c).getClass();
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return true;
    }

    public void setDataPC(Vector vettorePC) {
        this.cache = new Vector();
        Iterator i = vettorePC.iterator();
        while (i.hasNext()) {
            this.cache.addElement(i.next());
        }
        this.fireTableChanged(null);
    }
}

