/*
 * Decompiled with CFR 0.152.
 */
package trasporti.pedane_ddu;

import anagrafiche.clienti_fornitori.Anagrafica;
import gestionale.MyDesktopWindow;
import gestionale.configurazioni.Configurazioni;
import gestionale.primanota.PNRiga;
import gestionale.primanota.Registrazione;
import java.sql.ResultSet;
import java.sql.SQLException;
import trasporti.pedane.Pedana;
import utils.Funzioni;
import utils.FunzioniDate;
import utils.MyTrace;

public class DDU_pedane {
    private String n_doc;
    private String data_doc;
    private String data_doc_it;
    private String descrizione;
    private String data_fat;
    private String data_fat_it;
    private String n_fat;
    private String quantita;
    private String codice_acliente;
    private String ragione_cliente;
    private int id;
    private int anno_doc;
    private int id_acliente;
    private int anno_fat;
    private int id_registro;
    private boolean sel;
    private boolean canc;
    private Anagrafica acliente;
    private Registrazione r;
    private Funzioni f = new Funzioni();
    private FunzioniDate fda = new FunzioniDate();
    private Exception e;
    PNRiga riga;
    Pedana pedana;

    public int getAnno_doc() {
        return this.anno_doc;
    }

    public void setAnno_doc(int anno_doc) {
        this.anno_doc = anno_doc;
    }

    public int getAnno_fat() {
        return this.anno_fat;
    }

    public void setAnno_fat(int anno_fat) {
        this.anno_fat = anno_fat;
    }

    public boolean isCanc() {
        return this.canc;
    }

    public void setCanc(boolean canc) {
        this.canc = canc;
    }

    public String getData_doc() {
        return this.data_doc;
    }

    public void setData_doc(String data_doc) {
        this.data_doc = data_doc;
    }

    public String getData_doc_it() {
        return this.fda.gira_data(this.data_doc);
    }

    public String getData_fat() {
        return this.data_fat;
    }

    public void setData_fat(String data_fat) {
        this.data_fat = data_fat;
    }

    public String getData_fat_it() {
        return this.fda.gira_data(this.data_fat);
    }

    public String getDescrizione() {
        return this.descrizione;
    }

    public void setDescrizione(String descrizione) {
        this.descrizione = descrizione;
    }

    public Funzioni getF() {
        return this.f;
    }

    public void setF(Funzioni f) {
        this.f = f;
    }

    public FunzioniDate getFda() {
        return this.fda;
    }

    public void setFda(FunzioniDate fda) {
        this.fda = fda;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getId_registro() {
        return this.id_registro;
    }

    public void setId_registro(int id_registro) {
        this.id_registro = id_registro;
    }

    public String getN_doc() {
        return this.n_doc;
    }

    public void setN_doc(String n_doc) {
        this.n_doc = n_doc;
    }

    public String getN_fat() {
        return this.n_fat;
    }

    public void setN_fat(String n_fat) {
        this.n_fat = n_fat;
    }

    public String getTipo_das() {
        return "";
    }

    public Registrazione getR() {
        return this.r;
    }

    public void setR(Registrazione r) {
        this.r = r;
    }

    public boolean isSel() {
        return this.sel;
    }

    public void setSel(boolean sel) {
        this.sel = sel;
    }

    public Pedana getPedana() {
        return this.pedana;
    }

    public void setPedana(Pedana pedana) {
        this.pedana = pedana;
    }

    public PNRiga getRiga() {
        return this.riga;
    }

    public void setRiga(PNRiga riga) {
        this.riga = riga;
    }

    public String getRagione_cliente() {
        return this.ragione_cliente;
    }

    public void setRagione_cliente(String ragione_cliente) {
        this.ragione_cliente = ragione_cliente;
    }

    public Anagrafica getAcliente() {
        return this.acliente;
    }

    public void setAcliente(Anagrafica acliente) {
        this.acliente = acliente;
    }

    public String getCodice_acliente() {
        return this.codice_acliente;
    }

    public void setCodice_acliente(String codice_acliente) {
        this.codice_acliente = codice_acliente;
    }

    public int getId_acliente() {
        return this.id_acliente;
    }

    public void setId_acliente(int id_acliente) {
        this.id_acliente = id_acliente;
    }

    public void seleziona_da_id(int id) {
        String where = " where id='" + id + "'";
        this.seleziona(where, "");
    }

    public void seleziona(String where, String order_by) {
        String query_seleziona_DAS = "SELECT * FROM mtra_pedane_ddu";
        query_seleziona_DAS = query_seleziona_DAS + " " + where;
        query_seleziona_DAS = query_seleziona_DAS + " " + order_by;
        ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query_seleziona_DAS);
        try {
            while (res.next()) {
                this.setAnno_doc(res.getInt("anno_ddu"));
                this.setData_doc(res.getString("data_ddu"));
                this.setDescrizione(res.getString("descrizione"));
                this.setId_acliente(res.getInt("id_anagrafica"));
                this.setId_registro(res.getInt("id_registro"));
                this.setN_doc(res.getString("numero_ddu"));
                this.setId(res.getInt("id"));
            }
        }
        catch (SQLException ex) {
            Funzioni.inviaBugPerEmail(this.e);
            Funzioni.LogStackTrace(this.e);
        }
        Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
    }

    public void seleziona_da_numero_das(String numero_das) {
        String where = " where numero='" + numero_das + "' ";
        this.seleziona(where, "");
    }

    public boolean modifica(boolean da_fuori) {
        String q_trace;
        boolean r_trace;
        String query_mod;
        boolean r_mod;
        if (!da_fuori) {
            String q_start = "START TRANSACTION;";
            boolean r_start = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_start);
        }
        if (!(r_mod = Configurazioni.getIstanza().connessione.eseguiAggiornamento(query_mod = "UPDATE mtra_pedane_ddu SET numero_ddu='" + this.getN_doc() + "'," + " data_ddu='" + this.getData_doc() + "', " + " anno_ddu='" + this.getAnno_doc() + "',  " + " id_anagrafica='" + this.getId_acliente() + "', " + " descrizione='" + this.getDescrizione().replaceAll("'", "''") + "' " + " WHERE id='" + this.getId() + "'"))) {
            String q_roll = "ROLLBACK";
            MyTrace.log.severe("DDU_Modifica PEDANA non riuscita");
            Configurazioni.eccezione.gestisci("3.2", null);
            return false;
        }
        this.getPedana().setId_ddu(this.getId());
        this.getPedana().modifica_da_ddu(false);
        boolean res_registro = true;
        boolean ry = true;
        if (this.getTipo_das().equals("FP") && this.getR() != null) {
            if (this.getId_registro() == 0) {
                res_registro = this.getR().inserisciRegistrazione(false);
                String query = "UPDATE mtra_pedane_ddu SET id_registro=" + this.getR().getIdregistro() + " WHERE id=" + this.getId() + "";
                ry = Configurazioni.getIstanza().connessione.eseguiAggiornamento(query);
            } else {
                res_registro = this.getR().modificaRegistrazione(false);
            }
        }
        if (!(r_trace = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_trace = "INSERT INTO sys_trace(id_operatore,nome_tabella,id_soggetto,data,azione,query) VALUES('" + MyDesktopWindow.profilo.id + "','mtra_pedane_ddu','" + this.getId() + "',NOW(),'MOD','" + query_mod.replaceAll("'", "''") + "')"))) {
            MyTrace.log.severe("DDU_Modifica PEDANE non riuscita per trace");
            Configurazioni.eccezione.gestisci("3.3", null);
            return false;
        }
        if (!da_fuori) {
            String q_commit = "COMMIT";
            boolean r_commit = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_commit);
            if (r_commit) {
                return true;
            }
            MyTrace.log.severe("DDU_Modifica PEDANE non riuscito per commit");
            Configurazioni.eccezione.gestisci("3.4", null);
            return false;
        }
        this.getPedana().modifica_da_ddu(true);
        return true;
    }

    public boolean inserisci(boolean da_fuori) {
        String q_trace;
        boolean r_trace;
        String query_ins;
        boolean r_ins;
        if (!da_fuori) {
            String q_start = "START TRANSACTION;";
            boolean r_start = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_start);
        }
        if (!(r_ins = Configurazioni.getIstanza().connessione.eseguiAggiornamento(query_ins = "INSERT INTO mtra_pedane_ddu(numero_ddu,data_ddu,descrizione,id_anagrafica,anno_ddu) VALUES ('" + this.getN_doc() + "'," + "'" + this.getData_doc() + "'," + "'" + this.getDescrizione().replaceAll("'", "''") + "'," + " " + this.getId_acliente() + "," + "'" + this.getAnno_doc() + "')"))) {
            String q_commit = "ROLLBACK";
            boolean r_commit = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_commit);
            MyTrace.log.severe("Inserimento DDU non riuscito");
            Configurazioni.eccezione.gestisci("2.2", null);
            return false;
        }
        String strSQL = "SELECT @@identity FROM mtra_pedane_ddu";
        ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(strSQL);
        int id_inserito = 0;
        try {
            while (res.next()) {
                id_inserito = res.getInt("@@identity");
            }
        }
        catch (Exception e) {
            MyTrace.log.severe("ECCEZIONE: inserimento non riuscito .");
            e.printStackTrace();
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
        }
        Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        this.setId(id_inserito);
        this.getPedana().setId_ddu(this.getId());
        this.getPedana().inserisci(true);
        boolean res_registro = true;
        boolean ry = true;
        if (this.getTipo_das().equals("FP") && this.getR() != null) {
            res_registro = this.getR().inserisciRegistrazione(false);
            String query = "UPDATE mtra_das SET id_registro=" + this.getR().getIdregistro() + " WHERE id=" + this.getId() + "";
            ry = Configurazioni.getIstanza().connessione.eseguiAggiornamento(query);
        }
        if (!((r_trace = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_trace = "INSERT INTO sys_trace(id_operatore,nome_tabella,id_soggetto,data,azione,query) VALUES('" + MyDesktopWindow.profilo.id + "','mtra_ddu','" + this.getId() + "',NOW(),'INS','" + query_ins.replaceAll("'", "''") + "')")) && res_registro && ry)) {
            MyTrace.log.severe("Inserimento DDU PEDANE non riuscito per trace");
            Configurazioni.eccezione.gestisci("2.3", null);
            String q_roll = "ROLLBACK";
            boolean r_commit = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_roll);
            return false;
        }
        if (!da_fuori) {
            String q_commit = "COMMIT";
            boolean r_commit = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_commit);
            if (r_commit) {
                return true;
            }
            MyTrace.log.severe("Inserimento DDU PEDANE non riuscito per commit");
            Configurazioni.eccezione.gestisci("2.4", null);
            return false;
        }
        return true;
    }

    public boolean elimina(boolean da_fuori) {
        String q_start = "START TRANSACTION;";
        boolean r_start = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_start);
        String query_del = "DELETE FROM mtra_pedane_ddu WHERE id='" + this.getId() + "'";
        boolean r_del = Configurazioni.getIstanza().connessione.eseguiAggiornamento(query_del);
        if (!r_start || !r_del) {
            MyTrace.log.severe("Elimina DDU PEDANA non riuscita");
            Configurazioni.eccezione.gestisci("3.5", null);
            return false;
        }
        String q_trace = "INSERT INTO sys_trace(id_operatore,nome_tabella,id_soggetto,data,azione,query) VALUES('" + MyDesktopWindow.profilo.id + "','mtra_pedane_ddu','" + this.getId() + "',NOW(),'DEL','" + query_del.replaceAll("'", "''") + "')";
        boolean r_trace = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_trace);
        if (!r_trace) {
            MyTrace.log.severe("Elimina DDU PEDANA non riuscita per trace");
            Configurazioni.eccezione.gestisci("3.6", null);
            return false;
        }
        String q_commit = "COMMIT";
        boolean r_commit = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_commit);
        if (r_commit) {
            return true;
        }
        MyTrace.log.severe("Elimina DDU PEDANA non riuscito per commit");
        Configurazioni.eccezione.gestisci("3.4", null);
        return false;
    }

    public void seleziona_dettagli() {
        Anagrafica c = new Anagrafica();
        c.seleziona_da_id(this.getId_acliente());
        this.setAcliente(c);
        Pedana pedana = new Pedana();
        pedana.seleziona_da_ddu(this.getId());
        this.setPedana(pedana);
    }

    Object getColValue(int col) {
        String retVal = "";
        switch (col) {
            case 0: {
                if (this.getN_doc().equals("")) {
                    retVal = "";
                    break;
                }
                retVal = this.getN_doc() + "/" + this.getAnno_doc();
                break;
            }
            case 1: {
                retVal = this.fda.gira_data(this.getData_doc());
                break;
            }
            case 2: {
                retVal = this.getCodice_acliente();
                break;
            }
            case 3: {
                retVal = this.getRagione_cliente();
                break;
            }
            case 4: {
                retVal = this.getDescrizione();
                break;
            }
            default: {
                retVal = "";
            }
        }
        return retVal;
    }

    public Object getColValueScelta(int col) {
        String retVal = "";
        switch (col) {
            case 0: {
                if (this.isSel()) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            case 1: {
                if (this.getN_doc().equals("")) {
                    retVal = "";
                    break;
                }
                retVal = this.getN_doc() + "/" + this.getAnno_doc();
                break;
            }
            case 2: {
                retVal = this.fda.gira_data(this.getData_doc());
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                retVal = this.getDescrizione();
                break;
            }
            default: {
                retVal = "";
            }
        }
        return retVal;
    }
}

