/*
 * Decompiled with CFR 0.152.
 */
package trasporti.ordini;

import anagrafiche.clienti_fornitori.Anagrafica;
import java.util.ArrayList;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.table.AbstractTableModel;
import trasporti.listini.Opzione;
import trasporti.ordini.RigaOrdineViaggio;
import utils.Funzioni;
import utils.FunzioniDate;
import utils.Money;
import utils.Quantita;

public class RigheOrdiniTableModel
extends AbstractTableModel {
    public ArrayList<RigaOrdineViaggio> cache;
    int colCount;
    String[] headers;
    Funzioni f = new Funzioni();
    FunzioniDate fda = new FunzioniDate();

    public RigheOrdiniTableModel() {
        this.cache = new ArrayList();
    }

    @Override
    public String getColumnName(int i) {
        String retVal = "";
        switch (i) {
            case 0: {
                retVal = "T/O";
                break;
            }
            case 1: {
                retVal = "Codice";
                break;
            }
            case 2: {
                retVal = "Descrizione";
                break;
            }
            case 3: {
                retVal = "Quantit\u00e0";
                break;
            }
            case 4: {
                retVal = "UM";
                break;
            }
            case 5: {
                retVal = "Prezzo/UM";
                break;
            }
            case 6: {
                retVal = "Prezzo Forfait";
                break;
            }
            case 7: {
                retVal = "Prezzo Tot";
                break;
            }
            case 8: {
                retVal = "Fatturare a:";
                break;
            }
            default: {
                retVal = this.headers[i];
            }
        }
        return retVal;
    }

    @Override
    public int getRowCount() {
        return this.cache.size();
    }

    @Override
    public int getColumnCount() {
        return 9;
    }

    @Override
    public Object getValueAt(int row, int col) {
        RigaOrdineViaggio p = new RigaOrdineViaggio();
        if (!this.cache.isEmpty()) {
            p = this.cache.get(row);
            return p.getColValueRiga(col);
        }
        return "";
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        RigaOrdineViaggio ro = this.cache.get(row);
        if (col == 1) {
            Opzione o = new Opzione();
            o.setCod_opzione(value.toString());
            o.seleziona();
            ro.setId_opzione(o.getId());
            ro.setOpzione(o);
            ro.setCodice_riga(o.getCod_opzione());
            ro.setDescrizione_riga(o.getDescrizione());
        }
        if (col == 3) {
            ro.setQuantita(new Quantita(value.toString()));
        }
        if (col == 5) {
            ro.setP_um(new Money(value.toString()));
        }
        if (col == 6) {
            ro.setP_for(new Money(value.toString()));
        }
        if (col == 8) {
            Anagrafica a = new Anagrafica();
            a.seleziona_da_ragione(value.toString(), "C");
            ro.setFatturare_a(a.getRagione_sociale());
            ro.setId_fatturare_a(a.getIdanag());
        }
        this.fireTableRowsUpdated(row, row);
    }

    public Class getColumnClass(int c) {
        if (c == 1) {
            return JCheckBox.class;
        }
        if (c == 8) {
            return JComboBox.class;
        }
        return this.getValueAt(0, c).getClass();
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        if (this.getValueAt(row, 0).toString().equals("O")) {
            return col == 1 || col == 3 || col == 5 || col == 6 || col == 8;
        }
        if (this.getValueAt(row, 0).toString().equals("T")) {
            return col == 5 || col == 6 || col == 3 || col == 8;
        }
        return false;
    }

    public void setDataRiga(ArrayList<RigaOrdineViaggio> vettorePNR) {
        this.cache = new ArrayList();
        for (RigaOrdineViaggio ro : vettorePNR) {
            this.cache.add(ro);
            System.out.println("set=" + ro.getP().toString());
        }
        this.fireTableChanged(null);
    }
}

