/*
 * Decompiled with CFR 0.152.
 */
package trasporti.ordini;

import gestionale.MyDesktopWindow;
import gestionale.configurazioni.Configurazioni;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import trasporti.listini.Opzione;
import trasporti.listini.Prezzo;
import trasporti.ordini.Ordine;
import trasporti.tratte.Tratta;
import utils.Funzioni;
import utils.FunzioniDate;
import utils.Money;
import utils.MyTrace;
import utils.Quantita;

public class RigaOrdineViaggio {
    int id;
    int id_tratta;
    int id_opzione;
    int id_ordine;
    int id_um;
    int id_viaggio;
    int id_fp;
    int id_fatturare_a;
    int id_aliquota;
    int nc;
    int id_riga_documento;
    int id_fa_righe_old;
    String t_o;
    String desc_breve_viaggio;
    String data_viaggio;
    String note;
    String num_bolla = "";
    String n_oridini_cliente;
    String numero_viaggio;
    String codice_riga = "";
    String descrizione_riga = "";
    String numero_ordine;
    String data_ordine;
    String data_bolla;
    String fatturare_a;
    String codice_um = "";
    String rif_ordine = "";
    String codice_aliquota;
    String numero_fattura_attiva = "";
    String data_fattura_attiva;
    String numero_fattura_passiva = "";
    String data_fattura_passiva;
    String data_prima_presa;
    String[] numeri_bolle;
    String[] date_bolle;
    double km_viaggio = 0.0;
    boolean sel;
    boolean da_el_fp;
    boolean modificato = false;
    Tratta tratta;
    Opzione opzione;
    Quantita quantita = new Quantita(BigDecimal.ZERO);
    double um;
    Money p = new Money(BigDecimal.ZERO);
    Money p_um = new Money(BigDecimal.ZERO);
    Money p_for = new Money(BigDecimal.ZERO);
    Money p_tot = new Money(BigDecimal.ZERO);
    Prezzo prezzo;
    Funzioni f = new Funzioni();
    FunzioniDate fda = new FunzioniDate();

    public String toString() {
        return this.getDescrizione_riga();
    }

    public int getId_riga_documento() {
        return this.id_riga_documento;
    }

    public void setId_riga_documento(int id_riga_documento) {
        this.id_riga_documento = id_riga_documento;
    }

    public int getNc() {
        return this.nc;
    }

    public void setNc(int nc) {
        this.nc = nc;
    }

    public String getData_fattura_attiva() {
        return this.data_fattura_attiva;
    }

    public void setData_fattura_attiva(String data_fattura_attiva) {
        this.data_fattura_attiva = data_fattura_attiva;
    }

    public String getData_prima_presa() {
        return this.data_prima_presa;
    }

    public void setData_prima_presa(String data_prima_presa) {
        this.data_prima_presa = data_prima_presa;
    }

    public String getNumero_fattura_attiva() {
        return this.numero_fattura_attiva;
    }

    public void setNumero_fattura_attiva(String numero_fattura_attiva) {
        this.numero_fattura_attiva = numero_fattura_attiva;
    }

    public boolean isModificato() {
        return this.modificato;
    }

    public void setModificato(boolean modificato) {
        this.modificato = modificato;
    }

    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public String[] getDate_bolle() {
        return this.date_bolle;
    }

    public void setDate_bolle(String[] date_bolle) {
        this.date_bolle = date_bolle;
    }

    public String[] getNumeri_bolle() {
        return this.numeri_bolle;
    }

    public void setNumeri_bolle(String[] numeri_bolle) {
        this.numeri_bolle = numeri_bolle;
    }

    public String getNum_bolla() {
        return this.num_bolla;
    }

    public void setNum_bolla(String num_bolla) {
        if (num_bolla != null) {
            this.num_bolla = num_bolla;
        }
    }

    public String getData_bolla() {
        return this.data_bolla;
    }

    public void setData_bolla(String data_bolla) {
        this.data_bolla = data_bolla;
    }

    public String getData_bolla_it() {
        return this.fda.gira_data(this.data_bolla);
    }

    public String getRif_ordine() {
        return this.rif_ordine;
    }

    public void setRif_ordine(String rif_ordine) {
        this.rif_ordine = rif_ordine;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getId_opzione() {
        return this.id_opzione;
    }

    public void setId_opzione(int id_opzione) {
        this.id_opzione = id_opzione;
    }

    public int getId_tratta() {
        return this.id_tratta;
    }

    public void setId_tratta(int id_tratta) {
        this.id_tratta = id_tratta;
    }

    public Prezzo getPrezzo() {
        return this.prezzo;
    }

    public void setPrezzo(Prezzo prezzo) {
        this.prezzo = prezzo;
    }

    public int getId_fp() {
        return this.id_fp;
    }

    public void setId_fp(int id_fp) {
        this.id_fp = id_fp;
    }

    public String getData_viaggio() {
        return this.data_viaggio;
    }

    public String getData_viaggio_it() {
        return this.fda.gira_data(this.data_viaggio);
    }

    public void setData_viaggio(String data_viaggio) {
        this.data_viaggio = data_viaggio;
    }

    public String getNumero_viaggio() {
        return this.numero_viaggio;
    }

    public void setNumero_viaggio(String numero_viaggio) {
        this.numero_viaggio = numero_viaggio;
    }

    public boolean isDa_el_fp() {
        return this.da_el_fp;
    }

    public void setDa_el_fp(boolean da_el_fp) {
        this.da_el_fp = da_el_fp;
    }

    public Opzione getOpzione() {
        return this.opzione;
    }

    public void setOpzione(Opzione opzione) {
        this.opzione = opzione;
    }

    public Tratta getTratta() {
        return this.tratta;
    }

    public void setTratta(Tratta tratta) {
        this.tratta = tratta;
    }

    public Quantita getQuantita() {
        return this.quantita;
    }

    public void setQuantita(Quantita quantita) {
        this.quantita = quantita;
        if (!this.p_um.isZero()) {
            this.p = this.p_um.multiply(this.getQuantita());
        }
    }

    public double getUm() {
        return this.um;
    }

    public void setUm(double um) {
        this.um = um;
    }

    public int getId_ordine() {
        return this.id_ordine;
    }

    public void setId_ordine(int id_ordine) {
        this.id_ordine = id_ordine;
    }

    public String getT_o() {
        return this.t_o;
    }

    public void setT_o(String t_o) {
        this.t_o = t_o;
    }

    public String getCodice_riga() {
        return this.codice_riga;
    }

    public void setCodice_riga(String codice_riga) {
        this.codice_riga = codice_riga;
    }

    public String getDescrizione_riga() {
        return this.descrizione_riga;
    }

    public void setDescrizione_riga(String descrizione_riga) {
        this.descrizione_riga = descrizione_riga;
    }

    public Money getP_for() {
        return this.p_for;
    }

    public void setP_for(Money p_for) {
        this.p_for = p_for;
        if (!this.getP_for().isZero()) {
            this.p = p_for;
        }
    }

    public Money getP_um() {
        return this.p_um;
    }

    public void setP_um(Money p_um) {
        this.p_um = p_um;
        if (!this.getP_um().isZero()) {
            this.p = p_um.multiply(this.getQuantita());
        }
    }

    public Money getP() {
        return this.p;
    }

    public void setP(Money p) {
        this.p = p;
    }

    public void setP_tot_ordine(Money p_tot) {
        this.p_tot = p_tot;
    }

    public Money getP_tot_ordine() {
        return this.p_tot;
    }

    public Money getP_tot_riga() {
        if (this.getP_for().isZero()) {
            return this.getP_um().multiply(this.getQuantita());
        }
        return this.getP_for();
    }

    public int getId_fa_righe_old() {
        return this.id_fa_righe_old;
    }

    public void setId_fa_righe_old(int id_fa_righe_old) {
        this.id_fa_righe_old = id_fa_righe_old;
    }

    public boolean isSel() {
        return this.sel;
    }

    public void setSel(boolean sel) {
        this.sel = sel;
    }

    public String getData_ordine() {
        return this.data_ordine;
    }

    public void setData_ordine(String data_ordine) {
        this.data_ordine = data_ordine;
    }

    public String getNumero_ordine() {
        return this.numero_ordine;
    }

    public void setNumero_ordine(String numero_ordine) {
        this.numero_ordine = numero_ordine;
    }

    public int getId_um() {
        return this.id_um;
    }

    public void setId_um(int id_um) {
        this.id_um = id_um;
    }

    public String getData_ordine_it() {
        return this.fda.gira_data(this.data_ordine);
    }

    public int getId_viaggio() {
        return this.id_viaggio;
    }

    public void setId_viaggio(int id_viaggio) {
        this.id_viaggio = id_viaggio;
    }

    public String getDesc_breve_viaggio() {
        return this.desc_breve_viaggio;
    }

    public void setDesc_breve_viaggio(String desc_breve_viaggio) {
        this.desc_breve_viaggio = desc_breve_viaggio;
    }

    public String getFatturare_a() {
        return this.fatturare_a;
    }

    public void setFatturare_a(String fatturare_a) {
        this.fatturare_a = fatturare_a;
    }

    public int getId_fatturare_a() {
        return this.id_fatturare_a;
    }

    public void setId_fatturare_a(int id_fatturare_a) {
        this.id_fatturare_a = id_fatturare_a;
    }

    public String getCodice_um() {
        return this.codice_um;
    }

    public void setCodice_um(String codice_um) {
        this.codice_um = codice_um;
    }

    public String getCodice_aliquota() {
        if (this.codice_aliquota != null) {
            return this.codice_aliquota;
        }
        return Configurazioni.hm.get("codice_iva_predefinito");
    }

    public void setCodice_aliquota(String codice_aliquota) {
        this.codice_aliquota = codice_aliquota;
    }

    public int getId_aliquota() {
        if (this.id_aliquota != 0) {
            return this.id_aliquota;
        }
        return this.f.id_aliquota_da_codice(Configurazioni.hm.get("codice_iva_predefinito"));
    }

    public void setId_aliquota(int id_aliquota) {
        this.id_aliquota = id_aliquota;
    }

    public String getN_oridini_cliente() {
        return this.n_oridini_cliente;
    }

    public void setN_oridini_cliente(String n_oridini_cliente) {
        this.n_oridini_cliente = n_oridini_cliente;
    }

    public String getData_fattura_passiva() {
        return this.data_fattura_passiva;
    }

    public void setData_fattura_passiva(String data_fattura_passiva) {
        this.data_fattura_passiva = data_fattura_passiva;
    }

    public String getNumero_fattura_passiva() {
        return this.numero_fattura_passiva;
    }

    public void setNumero_fattura_passiva(String numero_fattura_passiva) {
        this.numero_fattura_passiva = numero_fattura_passiva;
    }

    public double getKm_viaggio() {
        return this.km_viaggio;
    }

    public void setKm_viaggio(double km_viaggio) {
        this.km_viaggio = km_viaggio;
    }

    public boolean iinserisci(boolean da_solo) {
        String query_ins;
        boolean retval;
        if (da_solo) {
            Configurazioni.getIstanza().connessione.start_transaction();
        }
        if (!(retval = Configurazioni.getIstanza().connessione.eseguiAggiornamento(query_ins = "INSERT INTO mtra_ordini_viaggi_righe(id_ordine,tratta_opzione,id_tratta,id_opzione,prezzo_um,quantita,prezzo_for,id_um,id_viaggio,rif_ordine,id_aliquota,id_riga_doc,id_fp,fatturare_a,nc,codice_riga,descrizione_riga ) VALUES (" + this.f.zero_to_null(this.getId_ordine()) + "," + "'" + this.getT_o() + "'," + "" + this.f.zero_to_null(this.getId_tratta()) + "," + "" + this.f.zero_to_null(this.getId_opzione()) + "," + "'" + this.getP_um() + "'," + "'" + this.getQuantita() + "'," + "" + this.getP_for() + "," + "" + this.f.zero_to_null(this.getId_um()) + "," + "" + this.f.zero_to_null(this.getId_viaggio()) + "," + "'" + this.getRif_ordine() + "'," + "" + this.getId_aliquota() + "," + "" + this.f.zero_to_null(this.getId_riga_documento()) + "," + "" + this.f.zero_to_null(this.getId_fp()) + "," + "" + this.getId_fatturare_a() + "," + "" + this.getNc() + "," + "'" + this.getCodice_riga().replaceAll("'", "''") + "'," + "'" + this.getDescrizione_riga().replaceAll("'", "''") + "' " + ")"))) {
            MyTrace.log.severe("Inserimento non riuscito");
            Configurazioni.eccezione.gestisci("2.2", null);
            Configurazioni.getIstanza().connessione.rollback();
            return false;
        }
        String strSQL = "SELECT @@identity FROM mtra_ordini_viaggi_righe";
        ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(strSQL);
        int id_inserito = 0;
        try {
            while (res.next()) {
                id_inserito = res.getInt("@@identity");
            }
        }
        catch (Exception e) {
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            e.printStackTrace();
        }
        Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        this.setId(id_inserito);
        if (da_solo) {
            Configurazioni.getIstanza().connessione.commit();
        }
        return true;
    }

    public boolean mmodifica(boolean da_solo) {
        String query_mod;
        boolean r_mod;
        if (da_solo) {
            Configurazioni.getIstanza().connessione.start_transaction();
        }
        if (!(r_mod = Configurazioni.getIstanza().connessione.eseguiAggiornamento(query_mod = "Update mtra_ordini_viaggi_righe SET prezzo_for=" + this.getP_for() + "," + "prezzo_um=" + this.getP_um() + "," + "quantita=" + this.getQuantita() + " " + " WHERE idRiga=" + this.getId() + ""))) {
            MyTrace.log.severe("Modifica Riga Ordine non riuscita");
            Configurazioni.eccezione.gestisci("3.2", null);
            Configurazioni.getIstanza().connessione.rollback();
            return false;
        }
        boolean res_o = true;
        if (da_solo && this.getId_ordine() != 0) {
            Ordine o = new Ordine();
            o.setId(this.getId_ordine());
            o.seleziona_righe();
            o.aggiornaPrezzoTotale(false);
        }
        if (!res_o) {
            MyTrace.log.severe("Modifica Ordine non riuscita");
            Configurazioni.eccezione.gestisci("3.2", null);
            Configurazioni.getIstanza().connessione.rollback();
            return false;
        }
        String q_trace = "INSERT INTO sys_trace(id_operatore,nome_tabella,id_soggetto,data,azione,query) VALUES('" + MyDesktopWindow.profilo.id + "','mtra_riga_ordine','" + this.getId() + "',NOW(),'MOD','" + query_mod.replaceAll("'", "''") + "')";
        boolean r_trace = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_trace);
        if (!r_trace) {
            MyTrace.log.severe("Modifica Riga Ordine  non riuscita per trace");
            Configurazioni.eccezione.gestisci("3.3", null);
            String q_commit = "ROLLBACK";
            boolean r_commit = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_commit);
            return false;
        }
        if (da_solo) {
            Configurazioni.getIstanza().connessione.commit();
        }
        return true;
    }

    public boolean fattura() {
        String query_mod = "Update mtra_ordini_viaggi_righe SET id_riga_doc=" + this.f.zero_to_null(this.getId_riga_documento()) + "," + "id_aliquota=" + this.getId_aliquota() + "," + "prezzo_for=" + this.getP_for() + "," + "prezzo_um=" + this.getP_um() + "," + "quantita=" + this.getQuantita() + " " + " WHERE idRiga=" + this.getId() + "";
        boolean r_mod = Configurazioni.getIstanza().connessione.eseguiAggiornamento(query_mod);
        if (!r_mod) {
            MyTrace.log.severe("Modifica Riga Ordine non riuscita");
            Configurazioni.eccezione.gestisci("3.2", null);
            Configurazioni.getIstanza().connessione.rollback();
            return false;
        }
        String q_trace = "INSERT INTO sys_trace(id_operatore,nome_tabella,id_soggetto,data,azione,query) VALUES('" + MyDesktopWindow.profilo.id + "','mtra_riga_ordine','" + this.getId() + "',NOW(),'MOD','" + query_mod.replaceAll("'", "''") + "')";
        boolean r_trace = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_trace);
        if (!r_trace) {
            MyTrace.log.severe("Modifica Fattura Attiva non riuscita per trace");
            Configurazioni.eccezione.gestisci("3.3", null);
            Configurazioni.getIstanza().connessione.rollback();
            return false;
        }
        return true;
    }

    public boolean fpv() {
        String query_mod = "Update mtra_ordini_viaggi_righe SET id_aliquota='" + this.getId_aliquota() + "'," + "quantita=" + this.getQuantita() + "," + "id_fp=" + this.f.zero_to_null(this.getId_fp()) + " " + " WHERE idRiga=" + this.getId() + "";
        boolean r_mod = Configurazioni.getIstanza().connessione.eseguiAggiornamento(query_mod);
        if (!r_mod) {
            MyTrace.log.severe("Modifica Riga Ordine non riuscita");
            Configurazioni.eccezione.gestisci("3.2", null);
            String q_commit = "ROLLBACK";
            boolean r_commit = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_commit);
            return false;
        }
        String q_trace = "INSERT INTO sys_trace(id_operatore,nome_tabella,id_soggetto,data,azione,query) VALUES('" + MyDesktopWindow.profilo.id + "','mtra_riga_ordine','" + this.getId() + "',NOW(),'MOD','" + query_mod.replaceAll("'", "''") + "')";
        boolean r_trace = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_trace);
        if (!r_trace) {
            MyTrace.log.severe("Modifica Fattura Attiva non riuscita per trace");
            Configurazioni.eccezione.gestisci("3.3", null);
            String q_commit = "ROLLBACK";
            boolean r_commit = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_commit);
            return false;
        }
        return true;
    }

    public boolean elimina() {
        String q = "DELETE FROM mtra_ordini_viaggi_righe where idRiga=" + this.getId();
        boolean r_mod = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q);
        return r_mod;
    }

    public void seleziona() {
        String query_seleziona = "select mtra_ordini_viaggi_righe.*, conf_aliquote_iva.codice as codice_aliquota  from mtra_ordini_viaggi_righe  LEFT JOIN conf_aliquote_iva on mtra_ordini_viaggi_righe.id_aliquota=conf_aliquote_iva.idAliquota  where idRiga=" + this.getId();
        ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query_seleziona);
        try {
            ResultSetMetaData meta = res.getMetaData();
            while (res.next()) {
                this.setId_tratta(res.getInt("id_tratta"));
                this.setId_opzione(res.getInt("id_opzione"));
                this.setId_ordine(res.getInt("id_ordine"));
                this.setP_um(new Money(res.getDouble("prezzo_um")));
                this.setP_for(new Money(res.getDouble("prezzo_for")));
                this.setT_o(res.getString("tratta_opzione"));
                this.setQuantita(new Quantita(res.getDouble("quantita")));
                this.setId_riga_documento(res.getInt("id_riga_doc"));
                this.setId_um(res.getInt("id_um"));
                this.setId_viaggio(res.getInt("id_viaggio"));
                this.setRif_ordine(res.getString("rif_ordine"));
                this.setId_aliquota(res.getInt("id_aliquota"));
                this.setCodice_aliquota(res.getString("codice_aliquota"));
                this.setId_fatturare_a(res.getInt("fatturare_a"));
                this.setCodice_riga(res.getString("codice_riga"));
                this.setDescrizione_riga(res.getString("descrizione_riga"));
                this.setNc(res.getInt("nc"));
            }
        }
        catch (Exception e) {
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            e.printStackTrace();
        }
        Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
    }

    public void seleziona_da_riga_fattura(String where) {
        String query_seleziona = "Select mtra_ordini_viaggi_righe.*,mtra_ordini.id_ordine,mtra_ordini.numero_ordine, mtra_ordini.anno,mtra_ordini.data_ordine  FROM mtra_ordini_viaggi_righe  LEFT JOIN mtra_ordini ON mtra_ordini_viaggi_righe.id_ordine=mtra_ordini.id_ordine ";
        query_seleziona = query_seleziona + " " + where;
        ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query_seleziona);
        try {
            ResultSetMetaData meta = res.getMetaData();
            while (res.next()) {
                this.setId(res.getInt("idRiga"));
                this.setId_tratta(res.getInt("id_tratta"));
                this.setId_opzione(res.getInt("id_opzione"));
                this.setId_ordine(res.getInt("id_ordine"));
                this.setP_um(new Money(res.getDouble("prezzo_um")));
                this.setP_for(new Money(res.getDouble("prezzo_for")));
                this.setT_o(res.getString("tratta_opzione"));
                this.setQuantita(new Quantita(res.getDouble("quantita")));
                this.setId_riga_documento(res.getInt("id_riga_doc"));
                this.setId_um(res.getInt("id_um"));
                this.setRif_ordine(res.getString("rif_ordine"));
                this.setNumero_ordine(res.getInt("numero_ordine") + "/" + res.getInt("anno"));
                this.setData_ordine(res.getString("data_ordine"));
                this.setCodice_riga(res.getString("codice_riga"));
                this.setDescrizione_riga(res.getString("descrizione_riga"));
            }
        }
        catch (Exception e) {
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            e.printStackTrace();
        }
        Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
    }

    public void seleziona_dettagli() {
        if (this.getT_o().equals("T")) {
            this.setTratta(new Tratta());
            this.getTratta().seleziona(this.getId_tratta());
        }
        if (this.getT_o().equals("O")) {
            this.setOpzione(new Opzione());
            this.getOpzione().seleziona(this.getId_opzione());
        }
    }

    public Object getColValueRiga(int col) {
        String retVal = "";
        switch (col) {
            case 0: {
                retVal = this.getT_o();
                break;
            }
            case 1: {
                retVal = this.getCodice_riga();
                break;
            }
            case 2: {
                retVal = this.getDescrizione_riga();
                break;
            }
            case 3: {
                retVal = this.f.formattaNumero("" + this.getQuantita(), "#0.000");
                break;
            }
            case 4: {
                retVal = this.getCodice_um();
                break;
            }
            case 5: {
                if (this.getNc() == 1) {
                    retVal = "" + this.getP_um().negate();
                    break;
                }
                retVal = "" + this.getP_um();
                break;
            }
            case 6: {
                if (this.getNc() == 1) {
                    retVal = "" + this.getP_for().negate();
                    break;
                }
                retVal = "" + this.getP_for();
                break;
            }
            case 7: {
                if (this.getNc() == 1) {
                    retVal = "" + this.getP().negate();
                    break;
                }
                retVal = "" + this.getP();
                break;
            }
            case 8: {
                retVal = this.getFatturare_a();
                break;
            }
            default: {
                retVal = "";
            }
        }
        return retVal;
    }

    Object getColValue(int col) {
        String retVal = "";
        switch (col) {
            case 0: {
                retVal = this.getNumero_ordine();
                break;
            }
            case 1: {
                retVal = this.getFatturare_a();
                break;
            }
            case 2: {
                retVal = this.getT_o();
                break;
            }
            case 3: {
                retVal = this.getCodice_riga();
                break;
            }
            case 4: {
                retVal = this.getDescrizione_riga();
                break;
            }
            case 5: {
                retVal = this.f.formattaNumero("" + this.getQuantita(), "#0.000");
                break;
            }
            case 6: {
                retVal = this.getCodice_um();
                break;
            }
            case 7: {
                retVal = "" + this.getP_um();
                break;
            }
            case 8: {
                retVal = "" + this.getP_for();
                break;
            }
            case 9: {
                retVal = this.getP().toString();
                break;
            }
            default: {
                retVal = "";
            }
        }
        return retVal;
    }

    public Object getColValueGiacenza(int col, String o_v) {
        String retVal = "";
        switch (col) {
            case 0: {
                if (this.isSel()) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            case 1: {
                retVal = "" + this.getNumero_ordine();
                break;
            }
            case 2: {
                if (o_v.equals("o")) {
                    retVal = "" + this.getN_oridini_cliente();
                }
                if (!o_v.equals("v")) break;
                retVal = "" + this.getNumero_viaggio();
                break;
            }
            case 3: {
                if (o_v.equals("o")) {
                    retVal = "" + this.fda.gira_data(this.getData_prima_presa());
                }
                if (!o_v.equals("v")) break;
                retVal = "" + this.getData_viaggio_it();
                break;
            }
            case 4: {
                retVal = "" + this.getT_o();
                break;
            }
            case 5: {
                retVal = "" + this.getT_o() + ": " + this.getCodice_riga();
                break;
            }
            case 6: {
                retVal = this.f.formattaNumero("" + this.getQuantita(), "#0.000");
                break;
            }
            case 7: {
                retVal = "" + this.getP_um();
                break;
            }
            case 8: {
                retVal = "" + this.getP_for();
                break;
            }
            case 9: {
                retVal = "" + this.getP_tot_riga();
                break;
            }
            case 10: {
                retVal = "" + this.getNote();
                break;
            }
            default: {
                retVal = "";
            }
        }
        return retVal;
    }

    Object getColValueRigaFP(int col) {
        String retVal = "";
        switch (col) {
            case 0: {
                retVal = "Viaggio N\u00b0 " + this.getNumero_viaggio() + " del " + this.fda.gira_data(this.getData_viaggio());
                break;
            }
            case 1: {
                retVal = this.getDescrizione_riga();
                break;
            }
            case 2: {
                retVal = this.f.formattaNumero("" + this.getQuantita(), "#0.000");
                break;
            }
            case 3: {
                retVal = this.getCodice_um();
                break;
            }
            case 4: {
                retVal = "" + this.getP_um();
                break;
            }
            case 5: {
                retVal = "" + this.getP_for();
                break;
            }
            case 6: {
                retVal = "" + this.getP();
                break;
            }
            case 7: {
                retVal = "" + this.getCodice_aliquota();
                break;
            }
            default: {
                retVal = "";
            }
        }
        return retVal;
    }

    Object getColValueRigaSFP(int col) {
        String retVal = "";
        switch (col) {
            case 0: {
                if (this.isSel()) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            case 1: {
                retVal = this.getNumero_fattura_passiva() + " del " + this.fda.gira_data(this.getData_fattura_passiva());
                break;
            }
            case 2: {
                retVal = "Viaggio N\u00b0 " + this.getNumero_viaggio() + " del " + this.fda.gira_data(this.getData_viaggio());
                break;
            }
            case 3: {
                retVal = this.getDescrizione_riga();
                break;
            }
            case 4: {
                retVal = "" + this.getP();
                break;
            }
            case 5: {
                retVal = "" + this.getCodice_aliquota();
                break;
            }
            default: {
                retVal = "";
            }
        }
        return retVal;
    }
}

