/*
 * Decompiled with CFR 0.152.
 */
package trasporti.ordini;

import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.table.AbstractTableModel;
import trasporti.ordini.RigaOrdineViaggio;
import utils.Funzioni;
import utils.FunzioniDate;
import utils.Money;
import utils.Quantita;

public class ROFatturePassiveTableModel
extends AbstractTableModel {
    public ArrayList<RigaOrdineViaggio> cache;
    int colCount;
    String[] headers;
    boolean prezzo_editabile = false;
    Funzioni f = new Funzioni();
    FunzioniDate fda = new FunzioniDate();

    public ROFatturePassiveTableModel(boolean prezzo_editabile) {
        this.cache = new ArrayList();
        this.prezzo_editabile = prezzo_editabile;
    }

    @Override
    public String getColumnName(int i) {
        String retVal = "";
        switch (i) {
            case 0: {
                retVal = "Viaggio";
                break;
            }
            case 1: {
                retVal = "Descrizione";
                break;
            }
            case 2: {
                retVal = "Quantit\u00e0";
                break;
            }
            case 3: {
                retVal = "UM";
                break;
            }
            case 4: {
                retVal = "Prezzo/UM";
                break;
            }
            case 5: {
                retVal = "Prezzo Forfait";
                break;
            }
            case 6: {
                retVal = "Prezzo Tot";
                break;
            }
            case 7: {
                retVal = "Codice Aliquota";
                break;
            }
            default: {
                retVal = this.headers[i];
            }
        }
        return retVal;
    }

    @Override
    public int getRowCount() {
        return this.cache.size();
    }

    @Override
    public int getColumnCount() {
        return 8;
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (!this.cache.isEmpty()) {
            RigaOrdineViaggio p = this.cache.get(row);
            return p.getColValueRigaFP(col);
        }
        return "";
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        RigaOrdineViaggio ro = this.cache.get(row);
        if (col == 7) {
            ro.setCodice_aliquota(value.toString());
            ro.setId_aliquota(this.f.id_aliquota_da_codice(value.toString()));
        }
        if (col == 2) {
            ro.setQuantita(new Quantita(value.toString()));
            if (!ro.getP_um().isZero()) {
                ro.setP(ro.getP_um().multiply(ro.getQuantita()));
            }
        }
        if (col == 3) {
            ro.setId_um(this.f.id_um(value.toString()));
            ro.setCodice_um(value.toString());
        }
        if (col == 4) {
            ro.setP_um(new Money(Double.parseDouble(value.toString())));
            ro.setP(ro.getP_um().multiply(ro.getQuantita()));
        }
        if (col == 5) {
            ro.setP_for(new Money(Double.parseDouble(value.toString())));
            ro.setP(ro.getP_for());
        }
        this.fireTableRowsUpdated(row, row);
    }

    public Class getColumnClass(int c) {
        try {
            return this.getValueAt(0, c).getClass();
        }
        catch (NullPointerException e) {
            return String.class;
        }
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        if (!this.prezzo_editabile) {
            return col == 7 || col == 2;
        }
        return col == 7 || col == 2 || col == 3 || col == 4 || col == 5;
    }

    public void setDataRiga(ArrayList<RigaOrdineViaggio> vettorePNR) {
        this.cache = new ArrayList();
        Iterator<RigaOrdineViaggio> i = vettorePNR.iterator();
        while (i.hasNext()) {
            this.cache.add(i.next());
        }
        this.fireTableChanged(null);
    }
}

