/*
 * Decompiled with CFR 0.152.
 */
package trasporti.ordini;

import anagrafiche.clienti_fornitori.Anagrafica;
import com.mysql.jdbc.ResultSetMetaData;
import gestionale.MyDesktopWindow;
import gestionale.configurazioni.Configurazioni;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.Iterator;
import java.util.Vector;
import trasporti.bolle.Bolla;
import trasporti.bolle.InsiemeBolle;
import trasporti.listini.TraListino;
import trasporti.ordini.InsiemeRigheOrdineViaggio;
import trasporti.ordini.RigaOrdineViaggio;
import trasporti.prese_consegne.InsiemePC;
import trasporti.prese_consegne.PresaConsegna;
import trasporti.tratte.Tratta;
import trasporti.viaggi.InsiemeViaggi;
import utils.Funzioni;
import utils.FunzioniDate;
import utils.Money;
import utils.MyTrace;

public class Ordine {
    private String data_ordine;
    private String note = "";
    private String tratta_complessiva;
    private String ragione_sociale;
    private int id;
    private int id_acliente;
    private int id_tratta;
    private int n_ordine;
    private int confermato;
    private int anno_ordine;
    private int num_pc;
    private int num_pc_assegnate;
    private int id_acliente1;
    private int id_acliente2;
    private Anagrafica a_cliente;
    private Anagrafica a_cliente1;
    private Anagrafica a_cliente2;
    private double km_tot;
    private Money prezzo;
    InsiemePC insieme_pc;
    InsiemePC insieme_pc_da_eliminare;
    private InsiemeViaggi insieme_viaggi;
    private InsiemeRigheOrdineViaggio insieme_r;
    private InsiemeBolle insieme_b;
    private Vector p_assegnati = new Vector();
    private boolean sistemato;
    Vector c_assegnati = new Vector();
    private Funzioni f = new Funzioni();
    private FunzioniDate fda = new FunzioniDate();
    private TraListino listino;
    private Tratta tratta;
    private Tratta[] array_tratte;
    private Bolla bolla;

    public Ordine() {
        this.insieme_r = new InsiemeRigheOrdineViaggio();
    }

    public String getData_ordine() {
        return this.data_ordine;
    }

    public String getData_ordineIt() {
        return this.fda.gira_data(this.data_ordine);
    }

    public void setData_ordine(String data_ordine) {
        this.data_ordine = data_ordine;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public Anagrafica getA_cliente() {
        return this.a_cliente;
    }

    public void setA_cliente(Anagrafica a_cliente) {
        this.a_cliente = a_cliente;
    }

    public int getId_acliente() {
        return this.id_acliente;
    }

    public void setId_acliente(int id_acliente) {
        this.id_acliente = id_acliente;
    }

    public Anagrafica getA_cliente1() {
        return this.a_cliente1;
    }

    public void setA_cliente1(Anagrafica a_cliente1) {
        this.a_cliente1 = a_cliente1;
    }

    public Anagrafica getA_cliente2() {
        return this.a_cliente2;
    }

    public void setA_cliente2(Anagrafica a_cliente2) {
        this.a_cliente2 = a_cliente2;
    }

    public int getId_acliente1() {
        return this.id_acliente1;
    }

    public void setId_acliente1(int id_acliente1) {
        this.id_acliente1 = id_acliente1;
    }

    public int getId_acliente2() {
        return this.id_acliente2;
    }

    public void setId_acliente2(int id_acliente2) {
        this.id_acliente2 = id_acliente2;
    }

    public InsiemePC getInsieme_pc() {
        return this.insieme_pc;
    }

    public void setInsieme_pc(InsiemePC insieme_pc) {
        this.insieme_pc = insieme_pc;
    }

    public double getKm_tot() {
        return this.km_tot;
    }

    public void setKm_tot(double km_tot) {
        this.km_tot = km_tot;
    }

    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public Money getPrezzo() {
        return this.prezzo;
    }

    public void setPrezzo(Money prezzo) {
        this.prezzo = prezzo;
    }

    public String getTratta_complessiva() {
        return this.tratta_complessiva;
    }

    public void setTratta_complessiva(String tratta_complessiva) {
        this.tratta_complessiva = tratta_complessiva;
    }

    public String getRagione_sociale() {
        return this.ragione_sociale;
    }

    public void setRagione_sociale(String ragione_sociale) {
        this.ragione_sociale = ragione_sociale;
    }

    public TraListino getListino() {
        return this.listino;
    }

    public void setListino(TraListino listino) {
        this.listino = listino;
    }

    public Tratta getTratta() {
        return this.tratta;
    }

    public void setTratta(Tratta tratta) {
        this.tratta = tratta;
    }

    public InsiemeRigheOrdineViaggio getInsieme_r() {
        return this.insieme_r;
    }

    public void setInsieme_r(InsiemeRigheOrdineViaggio insieme_r) {
        this.insieme_r = insieme_r;
    }

    public int getId_tratta() {
        return this.id_tratta;
    }

    public void setId_tratta(int id_tratta) {
        this.id_tratta = id_tratta;
    }

    public Vector getP_assegnati() {
        return this.p_assegnati;
    }

    public void setP_assegnati(Vector p_assegnati) {
        this.p_assegnati = p_assegnati;
    }

    public Vector getC_assegnati() {
        return this.c_assegnati;
    }

    public void setC_assegnati(Vector c_assegnati) {
        this.c_assegnati = c_assegnati;
    }

    public boolean isSistemato() {
        return this.sistemato;
    }

    public void setSistemato(boolean sistemato) {
        this.sistemato = sistemato;
    }

    public int getAnno_ordine() {
        return this.anno_ordine;
    }

    public void setAnno_ordine(int anno_ordine) {
        this.anno_ordine = anno_ordine;
    }

    public int getN_ordine() {
        return this.n_ordine;
    }

    public void setN_ordine(int n_ordine) {
        this.n_ordine = n_ordine;
    }

    public int getConfermato() {
        return this.confermato;
    }

    public void setConfermato(int confermato) {
        this.confermato = confermato;
    }

    public Tratta[] getArray_tratte() {
        return this.array_tratte;
    }

    public void setArray_tratte(Tratta[] array_tratte) {
        this.array_tratte = array_tratte;
    }

    public Bolla getBolla() {
        return this.bolla;
    }

    public void setBolla(Bolla bolla) {
        this.bolla = bolla;
    }

    public InsiemePC getInsieme_pc_da_eliminare() {
        return this.insieme_pc_da_eliminare;
    }

    public void setInsieme_pc_da_eliminare(InsiemePC insieme_pc_da_eliminare) {
        this.insieme_pc_da_eliminare = insieme_pc_da_eliminare;
    }

    public int getNum_pc() {
        return this.num_pc;
    }

    public void setNum_pc(int num_pc) {
        this.num_pc = num_pc;
    }

    public int getNum_pc_assegnate() {
        return this.num_pc_assegnate;
    }

    public void setNum_pc_assegnate(int num_pc_assegnate) {
        this.num_pc_assegnate = num_pc_assegnate;
    }

    public InsiemeViaggi getInsieme_viaggi() {
        return this.insieme_viaggi;
    }

    public void setInsieme_viaggi(InsiemeViaggi insieme_viaggi) {
        this.insieme_viaggi = insieme_viaggi;
    }

    public InsiemeBolle getInsieme_b() {
        return this.insieme_b;
    }

    public void setInsieme_b(InsiemeBolle insieme_b) {
        this.insieme_b = insieme_b;
    }

    public boolean inserisciOrdine(boolean da_solo) {
        String query_ins;
        boolean r_ins;
        if (da_solo) {
            Configurazioni.getIstanza().connessione.start_transaction();
        }
        if (!(r_ins = Configurazioni.getIstanza().connessione.eseguiAggiornamento(query_ins = "INSERT INTO mtra_ordini(id_anagrafica,id_anagrafica1,id_anagrafica2,prezzo,data_ordine,tratta_complessiva,note,km_tot) VALUES (" + this.getId_acliente() + "," + "" + this.getId_acliente1() + "," + "" + this.getId_acliente2() + "," + "" + this.getPrezzo() + "," + "'" + this.getData_ordine() + "'," + "'" + this.getTratta_complessiva().replaceAll("'", "''") + "'," + "'" + this.getNote().replaceAll("'", "''") + "'," + "" + this.getKm_tot() + ")"))) {
            MyTrace.log.severe("Inserimento ordeine non riuscito");
            Configurazioni.eccezione.gestisci("2.2", null);
            Configurazioni.getIstanza().connessione.rollback();
            return false;
        }
        String strSQL = "SELECT @@identity FROM mtra_ordini";
        ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(strSQL);
        int id_inserito = 0;
        try {
            while (res.next()) {
                id_inserito = res.getInt("@@identity");
            }
        }
        catch (Exception e) {
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            e.printStackTrace();
        }
        Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        this.setId(id_inserito);
        boolean res1 = true;
        for (PresaConsegna pc : this.getInsieme_pc().vettorePC) {
            pc.setId_ordine(this.getId());
            res1 = pc.inserisciPC(false);
        }
        if (!res1) {
            MyTrace.log.severe("Inserimento ordine non riuscito per PC");
            Configurazioni.eccezione.gestisci("2.2", null);
            Configurazioni.getIstanza().connessione.rollback();
            return false;
        }
        boolean res3 = true;
        if (this.getTratta().getId() == 0) {
            res3 = this.getTratta().inserisciTratta(false);
        }
        if (this.getArray_tratte() != null) {
            for (int j = 0; j < this.getArray_tratte().length; ++j) {
                if (this.getArray_tratte()[j].getId() != 0) continue;
                res3 = this.getArray_tratte()[j].inserisciTratta(false);
            }
        }
        if (!res3) {
            MyTrace.log.severe("Inserimento ordine non riuscito per tratta");
            Configurazioni.eccezione.gestisci("2.2", null);
            Configurazioni.getIstanza().connessione.rollback();
            return false;
        }
        boolean res5 = true;
        for (RigaOrdineViaggio ro : this.getInsieme_r().vettoreR) {
            ro.setId_ordine(this.getId());
            if (ro.getT_o().equals("T") && ro.getId_tratta() == 0) {
                ro.setId_tratta(this.getTratta().getId());
            }
            res5 = ro.iinserisci(false);
        }
        if (!res5) {
            MyTrace.log.severe("Inserimento ordine non riuscito per riga");
            Configurazioni.eccezione.gestisci("2.2", null);
            Configurazioni.getIstanza().connessione.rollback();
            return false;
        }
        this.aggiornaPrezzoTotale(false);
        boolean res_c = true;
        if (this.getConfermato() == 1) {
            res_c = this.conferma_ordine();
        }
        if (!res_c) {
            MyTrace.log.severe("Inserimento ordine non riuscito per conferma");
            Configurazioni.eccezione.gestisci("2.2", null);
            Configurazioni.getIstanza().connessione.rollback();
            return false;
        }
        String q_trace = "INSERT INTO sys_trace(id_operatore,nome_tabella,id_soggetto,data,azione,query) VALUES('" + MyDesktopWindow.profilo.id + "','mmag_ordini','" + this.getId() + "',NOW(),'INS','" + query_ins.replaceAll("'", "''") + "')";
        boolean r_trace = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_trace);
        if (!r_trace) {
            MyTrace.log.severe("Inserimento ordine non riuscito per trace");
            Configurazioni.eccezione.gestisci("2.3", null);
            Configurazioni.getIstanza().connessione.rollback();
            return false;
        }
        if (da_solo) {
            Configurazioni.getIstanza().connessione.commit();
        }
        return true;
    }

    public boolean modificaOrdine(boolean da_solo) {
        Iterator k;
        String query_mod;
        boolean r_mod;
        if (da_solo) {
            Configurazioni.getIstanza().connessione.start_transaction();
        }
        if (!(r_mod = Configurazioni.getIstanza().connessione.eseguiAggiornamento(query_mod = "UPDATE mtra_ordini SET  id_anagrafica=" + this.getId_acliente() + "," + " id_anagrafica1=" + this.getId_acliente1() + "," + " id_anagrafica2=" + this.getId_acliente2() + "," + " note='" + this.getNote().replaceAll("'", "''") + "', " + " prezzo=" + this.getPrezzo() + ", " + " data_ordine='" + this.getData_ordine() + "', " + " km_tot=" + this.getKm_tot() + "," + " tratta_complessiva='" + this.getTratta_complessiva().replaceAll("'", "''") + "' " + " WHERE id_ordine='" + this.getId() + "'"))) {
            MyTrace.log.severe("Modifica ordine non riuscita");
            Configurazioni.eccezione.gestisci("3.2", null);
            Configurazioni.getIstanza().connessione.rollback();
            return false;
        }
        boolean res1 = true;
        for (PresaConsegna o : this.getInsieme_pc().vettorePC) {
            o.setId_ordine(this.getId());
            if (o.getId_pc() == 0) {
                res1 = o.inserisciPC(false);
                continue;
            }
            res1 = o.modificaPC(false);
        }
        if (!res1) {
            MyTrace.log.severe("Modifica ordine non riuscita per prese/consegne");
            Configurazioni.eccezione.gestisci("3.2", null);
            Configurazioni.getIstanza().connessione.rollback();
            return false;
        }
        boolean res2 = true;
        if (this.getInsieme_pc_da_eliminare() != null && !this.getInsieme_pc_da_eliminare().vettorePC.isEmpty()) {
            for (PresaConsegna pc : this.getInsieme_pc_da_eliminare().vettorePC) {
                res2 = pc.modificaPC(false);
            }
        }
        if (!res2) {
            MyTrace.log.severe("Modifica ordine non riuscita per eliminazione pc");
            Configurazioni.eccezione.gestisci("3.2", null);
            Configurazioni.getIstanza().connessione.rollback();
            return false;
        }
        boolean res4 = true;
        if (this.getTratta().getId() == 0) {
            res4 = this.getTratta().inserisciTratta(false);
        }
        if (this.getArray_tratte() != null) {
            for (int j = 0; j < this.getArray_tratte().length; ++j) {
                if (this.getArray_tratte()[j].getId() != 0) continue;
                res4 = this.getArray_tratte()[j].inserisciTratta(false);
            }
        }
        if (!res4) {
            MyTrace.log.severe("Modifica ordine non riuscita per inserimento tratta o array tratte");
            Configurazioni.eccezione.gestisci("3.2", null);
            Configurazioni.getIstanza().connessione.rollback();
            return false;
        }
        boolean res3 = true;
        String w = " where id_ordine=" + this.getId();
        res3 = this.getInsieme_r().eliminaRighe(w);
        if (!res4) {
            MyTrace.log.severe("Modifica ordine non riuscita per eliminazione rov");
            Configurazioni.eccezione.gestisci("3.2", null);
            Configurazioni.getIstanza().connessione.rollback();
            return false;
        }
        boolean res5 = true;
        for (RigaOrdineViaggio ro : this.getInsieme_r().vettoreR) {
            ro.setId_ordine(this.getId());
            if (ro.getT_o().equals("T") && ro.getId_tratta() == 0) {
                ro.setId_tratta(this.getTratta().getId());
            }
            res5 = ro.iinserisci(false);
        }
        if (!res5) {
            MyTrace.log.severe("Modifica ordine non riuscita per inserimento rov");
            Configurazioni.eccezione.gestisci("3.2", null);
            Configurazioni.getIstanza().connessione.rollback();
            return false;
        }
        boolean res6 = this.aggiornaPrezzoTotale(false);
        if (!res6) {
            MyTrace.log.severe("Modifica ordine non riuscita per aggiornamento totale");
            Configurazioni.eccezione.gestisci("3.2", null);
            Configurazioni.getIstanza().connessione.rollback();
            return false;
        }
        boolean res_b = true;
        if (!this.getInsieme_b().vettoreV.isEmpty() && (k = this.insieme_b.vettoreV.iterator()).hasNext()) {
            Bolla b = (Bolla)k.next();
            b.setId_cliente(this.getId_acliente());
            res_b = b.modifica(false);
        }
        if (!res_b) {
            MyTrace.log.severe("Modifica ordine non riuscita per inserimento rov");
            Configurazioni.eccezione.gestisci("3.2", null);
            Configurazioni.getIstanza().connessione.rollback();
            return false;
        }
        boolean res_c = true;
        if (this.getConfermato() == 1) {
            res_c = this.conferma_ordine();
        }
        if (!res_c) {
            MyTrace.log.severe("Modifica ordine non riuscita per conferma");
            Configurazioni.eccezione.gestisci("3.2", null);
            Configurazioni.getIstanza().connessione.rollback();
            return false;
        }
        String q_trace = "INSERT INTO sys_trace(id_operatore,nome_tabella,id_soggetto,data,azione,query) VALUES('" + MyDesktopWindow.profilo.id + "','mtra_ordini','" + this.getId() + "',NOW(),'MOD','" + query_mod.replaceAll("'", "''") + "')";
        boolean r_trace = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_trace);
        if (!r_trace) {
            MyTrace.log.severe("Modifica Ordine non riuscita per trace");
            Configurazioni.eccezione.gestisci("3.3", null);
            Configurazioni.getIstanza().connessione.rollback();
            return false;
        }
        if (da_solo) {
            boolean r_commit = Configurazioni.getIstanza().connessione.commit();
        }
        return true;
    }

    public boolean salva_prezzi() {
        Configurazioni.getIstanza().connessione.start_transaction();
        boolean res4 = true;
        res4 = this.getListino().getId() == 0 ? this.getListino().inserisci(true) : this.getListino().modifica(true);
        if (!res4) {
            Configurazioni.getIstanza().connessione.rollback();
            MyTrace.log.severe("Inserimento aRTICOLO non riuscito per trace");
            Configurazioni.eccezione.gestisci("2.3", null);
            return false;
        }
        Configurazioni.getIstanza().connessione.commit();
        return true;
    }

    public void controlla_sistemazione() {
        Iterator i = this.getInsieme_pc().vettorePC.iterator();
        int count = 0;
        while (i.hasNext()) {
            PresaConsegna pc = (PresaConsegna)i.next();
            if (!pc.isAssegnato()) continue;
            ++count;
        }
        if (count == this.getInsieme_pc().vettorePC.size()) {
            this.setSistemato(true);
        } else {
            this.setSistemato(false);
        }
    }

    public boolean conferma_ordine() {
        String query_mod = "UPDATE mtra_ordini SET numero_ordine=" + this.f.zero_to_null(this.getN_ordine()) + "," + " anno='" + this.getAnno_ordine() + "', " + " confermato=" + this.getConfermato() + " " + " WHERE id_ordine='" + this.getId() + "'";
        boolean r_mod = Configurazioni.getIstanza().connessione.eseguiAggiornamento(query_mod);
        if (!r_mod) {
            Configurazioni.getIstanza().connessione.rollback();
            MyTrace.log.severe("Conferma ordine non riuscita");
            Configurazioni.eccezione.gestisci("3.2", null);
            return false;
        }
        return true;
    }

    public boolean aggiornaPrezzoTotale(boolean da_solo) {
        if (da_solo) {
            Configurazioni.getIstanza().connessione.start_transaction();
        }
        Iterator<RigaOrdineViaggio> i = this.getInsieme_r().vettoreR.iterator();
        Money tot = new Money(BigDecimal.ZERO);
        while (i.hasNext()) {
            RigaOrdineViaggio ro = i.next();
            tot = tot.plus(ro.getP_tot_riga());
        }
        this.setPrezzo(tot);
        String query_mod = "UPDATE mtra_ordini SET prezzo= " + this.getPrezzo() + " " + " WHERE id_ordine=" + this.getId() + " ";
        boolean r_mod = Configurazioni.getIstanza().connessione.eseguiAggiornamento(query_mod);
        if (!r_mod) {
            Configurazioni.getIstanza().connessione.rollback();
            MyTrace.log.severe("Conferma ordine non riuscita");
            Configurazioni.eccezione.gestisci("3.2", null);
            return false;
        }
        if (da_solo) {
            Configurazioni.getIstanza().connessione.commit();
        }
        return true;
    }

    public void seleziona_anagrafica() {
        this.setA_cliente(new Anagrafica());
        this.getA_cliente().seleziona_da_id(this.getId_acliente());
        if (this.getId_acliente1() != 0) {
            this.setA_cliente1(new Anagrafica());
            this.getA_cliente1().seleziona_da_id(this.getId_acliente1());
        }
        if (this.getId_acliente2() != 0) {
            this.setA_cliente2(new Anagrafica());
            this.getA_cliente2().seleziona_da_id(this.getId_acliente2());
        }
    }

    public void seleziona_dettagli() {
        this.seleziona_anagrafica();
        String w = " WHERE mtra_ordini.id_ordine= " + this.getId() + " ";
        String order_by = "   ORDER BY ordine,mtra_prese_consegne.data ";
        this.setInsieme_pc(new InsiemePC());
        this.getInsieme_pc().caricamento(w, order_by);
        this.seleziona_bolle();
        this.seleziona_righe();
    }

    public void seleziona_bolle() {
        this.setInsieme_b(new InsiemeBolle());
        String where = " WHERE mtra_bolle.id_ordine=" + this.getId() + "";
        this.getInsieme_b().caricamento(where, "");
    }

    public void seleziona_righe() {
        String w2 = " WHERE mtra_ordini_viaggi_righe.id_ordine='" + this.getId() + "'";
        InsiemeRigheOrdineViaggio i_r = new InsiemeRigheOrdineViaggio();
        i_r.caricamento(w2, "");
        this.setInsieme_r(i_r);
    }

    public boolean eliminaOrdine(boolean da_solo) {
        if (da_solo) {
            Configurazioni.getIstanza().connessione.start_transaction();
        }
        boolean res1 = true;
        boolean res2 = true;
        for (PresaConsegna pc : this.getInsieme_pc().vettorePC) {
            res1 = pc.eliminaPC(false);
        }
        if (!res1) {
            Configurazioni.getIstanza().connessione.rollback();
            MyTrace.log.severe("eliminazione ordine non riuscita per pc");
            Configurazioni.eccezione.gestisci("3.2", null);
            return false;
        }
        String query_del = "DELETE FROM mtra_ordini WHERE id_ordine=" + this.getId();
        boolean r_del = Configurazioni.getIstanza().connessione.eseguiAggiornamento(query_del);
        if (!r_del) {
            Configurazioni.getIstanza().connessione.rollback();
            MyTrace.log.severe("Delete ordine non riuscito");
            Configurazioni.eccezione.gestisci("2.2", null);
            return false;
        }
        String q_trace = "INSERT INTO sys_trace(id_operatore,nome_tabella,id_soggetto,data,azione,query) VALUES('" + MyDesktopWindow.profilo.id + "','mtra_ordini','" + this.getId() + "',NOW(),'DEL','" + query_del.replaceAll("'", "''") + "')";
        boolean r_trace = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_trace);
        if (!r_trace) {
            Configurazioni.getIstanza().connessione.rollback();
            MyTrace.log.severe("Delete Ordine non riuscito per trace");
            Configurazioni.eccezione.gestisci("2.3", null);
            return false;
        }
        if (da_solo) {
            Configurazioni.getIstanza().connessione.commit();
        }
        return true;
    }

    public void seleziona(String where) {
        String query_seleziona = "SELECT mtra_ordini.*,  anag_anagrafica.ragione_sociale from mtra_ordini LEFT JOIN anag_anagrafica on mtra_ordini.id_anagrafica=anag_anagrafica.idAnagrafica  ";
        query_seleziona = query_seleziona + where;
        ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query_seleziona);
        try {
            ResultSetMetaData meta = (ResultSetMetaData)res.getMetaData();
            while (res.next()) {
                this.setId(res.getInt("id_ordine"));
                this.setId_acliente(res.getInt("id_anagrafica"));
                this.setData_ordine(res.getString("data_ordine"));
                this.setRagione_sociale(res.getString("ragione_sociale"));
                this.setN_ordine(res.getInt("numero_ordine"));
                this.setAnno_ordine(res.getInt("anno"));
                this.setTratta_complessiva(res.getString("tratta_complessiva"));
            }
        }
        catch (Exception e) {
            MyTrace.log.severe("Seleziona Pedana non riuscito ");
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            Configurazioni.eccezione.gestisci("4.1", null);
        }
        Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
    }

    public void seleziona_viaggi() {
        this.setInsieme_viaggi(new InsiemeViaggi());
        String where = "WHERE mtra_ordini_viaggi_rif.id_ordine=" + this.getId();
        this.getInsieme_viaggi().caricamento(where, " ORDER BY mtra_viaggi.id_mezzo", false);
    }

    Object getColValue(int col) {
        String retVal = "";
        switch (col) {
            case 0: {
                if (this.getConfermato() == 1) {
                    retVal = "" + this.getN_ordine() + "/" + this.getAnno_ordine();
                    break;
                }
                retVal = "";
                break;
            }
            case 1: {
                retVal = "" + this.getRagione_sociale();
                break;
            }
            case 2: {
                retVal = "" + this.getData_ordineIt();
                break;
            }
            case 3: {
                retVal = this.getTratta_complessiva();
                break;
            }
            default: {
                retVal = "";
            }
        }
        return retVal;
    }

    public Object getColValueB(int col) {
        String retVal = "";
        switch (col) {
            case 0: {
                if (this.isSistemato()) {
                    retVal = "OK";
                    break;
                }
                retVal = "NO";
                break;
            }
            case 1: {
                retVal = "" + this.getRagione_sociale();
                break;
            }
            case 2: {
                retVal = "" + this.getData_ordineIt();
                break;
            }
            case 3: {
                retVal = this.getTratta_complessiva();
                break;
            }
            case 4: {
                retVal = this.getN_ordine() + "/" + this.getAnno_ordine();
                break;
            }
            default: {
                retVal = "";
            }
        }
        return retVal;
    }
}

