/*
 * Decompiled with CFR 0.152.
 */
package trasporti.ordini;

import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.table.AbstractTableModel;
import trasporti.ordini.RigaOrdineViaggio;
import utils.Funzioni;
import utils.FunzioniDate;
import utils.Money;
import utils.Quantita;

public class GiacenzaOrdiniTableModel
extends AbstractTableModel {
    ArrayList<RigaOrdineViaggio> cache;
    int colCount;
    String[] headers;
    boolean modo_ric = false;
    boolean in_modifica = false;
    Funzioni f = new Funzioni();
    FunzioniDate fda = new FunzioniDate();

    public GiacenzaOrdiniTableModel() {
        this.cache = new ArrayList();
    }

    public void setModo_ric(boolean modo_ric) {
        this.modo_ric = modo_ric;
    }

    public void setIn_modifica(boolean in_modifica) {
        this.in_modifica = in_modifica;
    }

    @Override
    public String getColumnName(int i) {
        String retVal = "";
        switch (i) {
            case 0: {
                retVal = "";
                break;
            }
            case 1: {
                retVal = "Ordine Leo";
                break;
            }
            case 2: {
                retVal = "N\u00b0 Ordine Cliente";
                break;
            }
            case 3: {
                retVal = "Data Prima presa";
                break;
            }
            case 4: {
                retVal = "T/O";
                break;
            }
            case 5: {
                retVal = "Descrizione";
                break;
            }
            case 6: {
                retVal = "Quantit\u00e0";
                break;
            }
            case 7: {
                retVal = "Prezzo/UM";
                break;
            }
            case 8: {
                retVal = "Prezzo Forfait";
                break;
            }
            case 9: {
                retVal = "Prezzo Tot";
                break;
            }
            case 10: {
                retVal = "Note";
                break;
            }
            case 11: {
                retVal = "Dettagli Ordine";
                break;
            }
            default: {
                retVal = this.headers[i];
            }
        }
        return retVal;
    }

    @Override
    public int getRowCount() {
        return this.cache.size();
    }

    @Override
    public int getColumnCount() {
        return 12;
    }

    @Override
    public Object getValueAt(int row, int col) {
        RigaOrdineViaggio ro = new RigaOrdineViaggio();
        if (!this.cache.isEmpty()) {
            ro = this.cache.get(row);
            return ro.getColValueGiacenza(col, "o");
        }
        return "";
    }

    public Class getColumnClass(int c) {
        if (c == 11) {
            return JButton.class;
        }
        return this.getValueAt(0, c).getClass();
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        RigaOrdineViaggio rov = this.cache.get(row);
        if (this.in_modifica) {
            rov.setModificato(true);
        }
        if (col == 0) {
            if ((Boolean)value == Boolean.TRUE) {
                rov.setSel(true);
            } else {
                rov.setSel(false);
            }
        }
        if (col == 6) {
            rov.setQuantita(new Quantita(value.toString()));
        }
        if (col == 7) {
            rov.setP_um(new Money(value.toString()));
        }
        if (col == 8) {
            rov.setP_for(new Money(value.toString()));
        }
        this.fireTableRowsUpdated(row, row);
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        if (!(this.in_modifica || col != 0 && col != 11)) {
            return true;
        }
        return this.in_modifica && (col == 6 || col == 7 || col == 8);
    }

    public void setDataRigaOrdine(ArrayList<RigaOrdineViaggio> vettoreOM) {
        this.cache = new ArrayList();
        Iterator<RigaOrdineViaggio> i = vettoreOM.iterator();
        while (i.hasNext()) {
            this.cache.add(i.next());
        }
        this.fireTableChanged(null);
    }
}

