/*
 * Decompiled with CFR 0.152.
 */
package trasporti.manutenzione_ddi;

import anagrafiche.clienti_fornitori.Anagrafica;
import gestionale.MyDesktopWindow;
import gestionale.configurazioni.Configurazioni;
import gestionale.primanota.InsiemeRegistrazioni;
import gestionale.primanota.Registrazione;
import java.sql.ResultSet;
import java.sql.SQLException;
import trasporti.magazzino_manutenzione.InsiemeOggettiMagazzinoManutenzione;
import trasporti.magazzino_manutenzione.OggettoMagazzinoManutenzione;
import utils.Funzioni;
import utils.FunzioniDate;
import utils.MyTrace;

public class DDIManutenzione {
    private String n_doc;
    private String data_doc;
    private String data_doc_it;
    private String descrizione;
    private String data_fat;
    private String data_fat_it;
    private String n_fat;
    private String data_nc;
    private String data_nc_it;
    private String n_nc;
    private String ragione_sociale;
    private String codice_fornitore;
    private int id;
    private int anno_doc;
    private int id_afornitore;
    private int anno_fat;
    private int id_registro;
    private int anno_nc;
    private InsiemeOggettiMagazzinoManutenzione insieme_om;
    private boolean sel;
    private boolean canc;
    private Anagrafica afornitore;
    private Registrazione r;
    private Funzioni f = new Funzioni();
    private FunzioniDate fda = new FunzioniDate();

    public int getAnno_doc() {
        return this.anno_doc;
    }

    public void setAnno_doc(int anno_doc) {
        this.anno_doc = anno_doc;
    }

    public String getData_doc() {
        return this.data_doc;
    }

    public void setData_doc(String data_doc) {
        this.data_doc = data_doc;
    }

    public String getDescrizione() {
        return this.descrizione;
    }

    public void setDescrizione(String descrizione) {
        this.descrizione = descrizione;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getN_doc() {
        return this.n_doc;
    }

    public void setN_doc(String n_doc) {
        this.n_doc = n_doc;
    }

    public int getAnno_nc() {
        return this.anno_nc;
    }

    public void setAnno_nc(int anno_nc) {
        this.anno_nc = anno_nc;
    }

    public String getData_nc() {
        return this.data_nc;
    }

    public void setData_nc(String data_nc) {
        this.data_nc = data_nc;
    }

    public String getData_nc_it() {
        return this.fda.gira_data(this.data_nc);
    }

    public void setData_nc_it(String data_nc_it) {
        this.data_nc_it = data_nc_it;
    }

    public String getN_nc() {
        return this.n_nc;
    }

    public void setN_nc(String n_nc) {
        this.n_nc = n_nc;
    }

    public String getTipo_ddi() {
        if (!this.getN_fat().equals("")) {
            return "FP";
        }
        if (this.getN_nc() != null && !this.getN_nc().equals("")) {
            return "NC";
        }
        return "DDT";
    }

    public String getData_doc_it() {
        return this.fda.gira_data(this.data_doc);
    }

    public String getData_fat_it() {
        return this.fda.gira_data(this.data_fat);
    }

    public Anagrafica getAfornitore() {
        return this.afornitore;
    }

    public void setAfornitore(Anagrafica afornitore) {
        this.afornitore = afornitore;
    }

    public int getId_afornitore() {
        return this.id_afornitore;
    }

    public void setId_afornitore(int id_afornitore) {
        this.id_afornitore = id_afornitore;
    }

    public int getAnno_fat() {
        return this.anno_fat;
    }

    public void setAnno_fat(int anno_fat) {
        this.anno_fat = anno_fat;
    }

    public String getData_fat() {
        return this.data_fat;
    }

    public void setData_fat(String data_fat) {
        this.data_fat = data_fat;
    }

    public String getN_fat() {
        return this.n_fat;
    }

    public void setN_fat(String n_fat) {
        this.n_fat = n_fat;
    }

    public InsiemeOggettiMagazzinoManutenzione getInsieme_om() {
        return this.insieme_om;
    }

    public void setInsieme_om(InsiemeOggettiMagazzinoManutenzione insieme_om) {
        this.insieme_om = insieme_om;
    }

    public Registrazione getR() {
        return this.r;
    }

    public void setR(Registrazione r) {
        this.r = r;
    }

    public int getId_registro() {
        return this.id_registro;
    }

    public void setId_registro(int id_registro) {
        this.id_registro = id_registro;
    }

    public boolean isSel() {
        return this.sel;
    }

    public void setSel(boolean sel) {
        this.sel = sel;
    }

    public boolean isCanc() {
        return this.canc;
    }

    public void setCanc(boolean canc) {
        this.canc = canc;
    }

    public String getCodice_fornitore() {
        return this.codice_fornitore;
    }

    public void setCodice_fornitore(String codice_fornitore) {
        this.codice_fornitore = codice_fornitore;
    }

    public String getRagione_sociale() {
        return this.ragione_sociale;
    }

    public void setRagione_sociale(String ragione_sociale) {
        this.ragione_sociale = ragione_sociale;
    }

    public boolean inserisci(boolean da_fuori) {
        String q_trace;
        boolean r_trace;
        String query_ins;
        boolean r_ins;
        if (!da_fuori) {
            String q_start = "START TRANSACTION;";
            boolean r_start = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_start);
        }
        if (!(r_ins = Configurazioni.getIstanza().connessione.eseguiAggiornamento(query_ins = "INSERT INTO mtra_man_ddi(numero_ddt,numero_fattura,data_ddt,data_fattura,descrizione,id_anagrafica,anno_fattura,anno_ddt,numero_nc,data_nc,anno_nc) VALUES ('" + this.getN_doc() + "'," + "'" + this.getN_fat() + "'," + "'" + this.getData_doc() + "'," + "'" + this.getData_fat() + "'," + "'" + this.getDescrizione().replaceAll("'", "''") + "'," + "" + this.getId_afornitore() + "," + "'" + this.getAnno_fat() + "'," + "'" + this.getAnno_doc() + "'," + "'" + this.getN_nc() + "'," + "'" + this.getData_nc() + "'," + "'" + this.getAnno_nc() + "')"))) {
            MyTrace.log.severe("Inserimento DDI non riuscito");
            Configurazioni.eccezione.gestisci("2.2", null);
            String q_commit = "ROLLBACK";
            boolean r_commit = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_commit);
            return false;
        }
        String strSQL = "SELECT @@identity FROM mtra_man_ddi";
        ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(strSQL);
        int id_inserito = 0;
        try {
            while (res.next()) {
                id_inserito = res.getInt("@@identity");
            }
        }
        catch (Exception e) {
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            e.printStackTrace();
        }
        Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        this.setId(id_inserito);
        if (this.getInsieme_om() != null && !this.getInsieme_om().vettoreOM.isEmpty()) {
            for (OggettoMagazzinoManutenzione om : this.getInsieme_om().vettoreOM) {
                om.setId_ddi(id_inserito);
                if (this.getTipo_ddi().equals("NC")) {
                    om.setQuantita(om.getQuantita().negate());
                }
                boolean ris_om = om.inserisci(true);
                om.getA().setUltimo_costo_acquisto(om.getPrezzo_acquisto());
                om.getA().modifica(true);
            }
        }
        boolean res_registro = true;
        boolean ry = true;
        if ((this.getTipo_ddi().equals("FP") || this.getTipo_ddi().equals("NC")) && this.getR() != null) {
            res_registro = this.getR().inserisciRegistrazione(false);
            String query = "UPDATE mtra_man_ddi SET id_registro=" + this.getR().getIdregistro() + " WHERE id=" + this.getId() + "";
            ry = Configurazioni.getIstanza().connessione.eseguiAggiornamento(query);
        }
        if (!((r_trace = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_trace = "INSERT INTO sys_trace(id_operatore,nome_tabella,id_soggetto,data,azione,query) VALUES('" + MyDesktopWindow.profilo.id + "','mtra_man_ddi','" + this.getId() + "',NOW(),'INS','" + query_ins.replaceAll("'", "''") + "')")) && res_registro && ry)) {
            MyTrace.log.severe("Inserimento DDI non riuscito per trace");
            Configurazioni.eccezione.gestisci("2.3", null);
            String q_roll = "ROLLBACK";
            boolean r_commit = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_roll);
            return false;
        }
        if (!da_fuori) {
            String q_commit = "COMMIT";
            boolean r_commit = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_commit);
            if (r_commit) {
                return true;
            }
            MyTrace.log.severe("Inserimento DDI non riuscito per commit");
            Configurazioni.eccezione.gestisci("2.4", null);
            return false;
        }
        return true;
    }

    public boolean modifica(boolean da_fuori) {
        String q_trace;
        boolean r_trace;
        String query_mod;
        boolean r_mod;
        if (!da_fuori) {
            String q_start = "START TRANSACTION;";
            boolean r_start = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_start);
        }
        if (!(r_mod = Configurazioni.getIstanza().connessione.eseguiAggiornamento(query_mod = "UPDATE mtra_man_ddi SET numero_ddt='" + this.getN_doc() + "'," + " numero_fattura='" + this.getN_fat() + "', " + " data_ddt='" + this.getData_doc() + "', " + " numero_nc='" + this.getN_nc() + "', " + " data_nc='" + this.getData_nc() + "', " + " data_fattura='" + this.getData_fat() + "', " + " anno_fattura='" + this.getAnno_fat() + "',  " + " anno_ddt='" + this.getAnno_doc() + "',  " + " id_anagrafica='" + this.getId_afornitore() + "', " + " descrizione='" + this.getDescrizione().replaceAll("'", "''") + "' " + " WHERE id='" + this.getId() + "'"))) {
            MyTrace.log.severe("DDI_Modifica non riuscita");
            Configurazioni.eccezione.gestisci("3.2", null);
            String q_commit = "ROLLBACK";
            boolean r_commit = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_commit);
            return false;
        }
        for (OggettoMagazzinoManutenzione om : this.getInsieme_om().vettoreOM) {
            if (this.getTipo_ddi().equals("NC")) {
                om.setQuantita(om.getQuantita().negate());
            }
            if (om.getId() == 0) {
                om.inserisci(true);
                om.getA().setUltimo_costo_acquisto(om.getPrezzo_acquisto());
                om.getA().modifica(true);
                continue;
            }
            om.modifica(true);
            om.getA().setUltimo_costo_acquisto(om.getPrezzo_acquisto());
            om.getA().modifica(true);
        }
        boolean res_registro = true;
        boolean ry = true;
        if ((this.getTipo_ddi().equals("FP") || this.getTipo_ddi().equals("NC")) && this.getR() != null) {
            if (this.getId_registro() == 0) {
                res_registro = this.getR().inserisciRegistrazione(false);
                String query = "UPDATE mtra_man_ddi SET id_registro=" + this.getR().getIdregistro() + " WHERE id=" + this.getId() + "";
                ry = Configurazioni.getIstanza().connessione.eseguiAggiornamento(query);
            } else {
                res_registro = this.getR().modificaRegistrazione(false);
            }
        }
        if (!(r_trace = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_trace = "INSERT INTO sys_trace(id_operatore,nome_tabella,id_soggetto,data,azione,query) VALUES('" + MyDesktopWindow.profilo.id + "','mtra_man_ddi','" + this.getId() + "',NOW(),'MOD','" + query_mod.replaceAll("'", "''") + "')"))) {
            MyTrace.log.severe("DDI_Modifica non riuscita per trace");
            Configurazioni.eccezione.gestisci("3.3", null);
            return false;
        }
        if (!da_fuori) {
            String q_commit = "COMMIT";
            boolean r_commit = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_commit);
            if (r_commit) {
                return true;
            }
            MyTrace.log.severe("DDI_Modifica non riuscito per commit");
            Configurazioni.eccezione.gestisci("3.4", null);
            return false;
        }
        return true;
    }

    public boolean modifica_diff(boolean da_solo) {
        String query_mod;
        boolean r_mod;
        if (da_solo) {
            String q_start = "START TRANSACTION;";
            boolean r_start = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_start);
        }
        if (!(r_mod = Configurazioni.getIstanza().connessione.eseguiAggiornamento(query_mod = "UPDATE mtra_man_ddi SET numero_fattura='" + this.getN_fat() + "', " + " data_fattura='" + this.getData_fat() + "', " + " anno_fattura='" + this.getAnno_fat() + "',  " + " id_registro='" + this.getId_registro() + "' " + " WHERE id='" + this.getId() + "'"))) {
            MyTrace.log.severe("DDI_Modifica non riuscita");
            Configurazioni.eccezione.gestisci("3.2", null);
            return false;
        }
        String q_trace = "INSERT INTO sys_trace(id_operatore,nome_tabella,id_soggetto,data,azione,query) VALUES('" + MyDesktopWindow.profilo.id + "','mtra_man_ddi','" + this.getId() + "',NOW(),'MOD','" + query_mod.replaceAll("'", "''") + "')";
        boolean r_trace = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_trace);
        if (!r_trace) {
            MyTrace.log.severe("DDI_Modifica non riuscita per trace");
            Configurazioni.eccezione.gestisci("3.3", null);
            return false;
        }
        if (da_solo) {
            String q_commit = "COMMIT";
            boolean r_commit = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_commit);
            if (r_commit) {
                return true;
            }
            MyTrace.log.severe("DDI_Modifica non riuscito per commit");
            Configurazioni.eccezione.gestisci("3.4", null);
            return false;
        }
        return true;
    }

    public void seleziona_dettagli() {
        this.setInsieme_om(new InsiemeOggettiMagazzinoManutenzione());
        InsiemeOggettiMagazzinoManutenzione i_om = new InsiemeOggettiMagazzinoManutenzione();
        String w = " WHERE id_ddi='" + this.getId() + "' and (id_ddu is null || id_ddu=0) ";
        int quanti = i_om.caricamento(w, "");
        this.setInsieme_om(i_om);
        if (this.getTipo_ddi().equals("NC")) {
            for (OggettoMagazzinoManutenzione om : this.getInsieme_om().vettoreOM) {
                om.setQuantita(om.getQuantita().negate());
            }
        }
        if (this.getId_registro() != 0) {
            String q = " WHERE idRegistro=" + this.getId_registro();
            InsiemeRegistrazioni ir = new InsiemeRegistrazioni();
            ir.caricamento_veloce(q, "");
            Registrazione r = new Registrazione();
            r = (Registrazione)ir.vettoreRegistrazioni.elementAt(0);
            this.setR(r);
            this.getR().selezionaDati();
            this.setAfornitore(this.getR().getAnagrafica());
        } else {
            Anagrafica f = new Anagrafica();
            f.seleziona_da_id(this.getId_afornitore());
            f.seleziona_dettagli();
            this.setAfornitore(f);
        }
    }

    public void seleziona(int id) {
        String query_seleziona_DDI = "SELECT * FROM mtra_man_ddi where id=" + id;
        ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query_seleziona_DDI);
        try {
            while (res.next()) {
                this.setAnno_doc(res.getInt("anno_ddt"));
                this.setN_doc(res.getString("numero_ddt"));
            }
        }
        catch (SQLException ex) {
            MyTrace.log.severe(ex.toString());
        }
        Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
    }

    Object getColValue(int col) {
        String retVal = "";
        switch (col) {
            case 0: {
                if (this.getN_doc().equals("")) {
                    retVal = "";
                    break;
                }
                retVal = this.getN_doc() + "/" + this.getAnno_doc();
                break;
            }
            case 1: {
                if (this.getN_fat().equals("")) {
                    if (this.getN_nc() == null || this.getN_nc().equals("")) {
                        retVal = "";
                        break;
                    }
                    retVal = this.getN_nc() + "/" + this.getAnno_nc();
                    break;
                }
                retVal = this.getN_fat() + "/" + this.getAnno_fat();
                break;
            }
            case 2: {
                retVal = this.fda.gira_data(this.getData_doc());
                break;
            }
            case 3: {
                if (this.getData_fat() == null || this.getData_fat().equals("0000-00-00")) {
                    if (this.getData_nc() != null && !this.getData_nc().equals("0000-00-00")) {
                        retVal = this.getData_nc_it();
                        break;
                    }
                    retVal = "";
                    break;
                }
                retVal = this.getData_fat_it();
                break;
            }
            case 5: {
                retVal = this.getRagione_sociale();
                break;
            }
            case 4: {
                retVal = "F" + this.getCodice_fornitore();
                break;
            }
            case 6: {
                retVal = this.getDescrizione();
                break;
            }
            default: {
                retVal = "";
            }
        }
        return retVal;
    }

    Object getColValueScelta(int col) {
        String retVal = "";
        switch (col) {
            case 0: {
                if (this.isSel()) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            case 1: {
                if (this.getN_doc().equals("")) {
                    retVal = "";
                    break;
                }
                retVal = this.getN_doc() + "/" + this.getAnno_doc();
                break;
            }
            case 2: {
                retVal = this.fda.gira_data(this.getData_doc());
                break;
            }
            case 3: {
                retVal = this.getRagione_sociale();
                break;
            }
            case 4: {
                retVal = this.getDescrizione();
                break;
            }
            default: {
                retVal = "";
            }
        }
        return retVal;
    }
}

