/*
 * Decompiled with CFR 0.152.
 */
package trasporti.magazzino_manutenzione;

import java.awt.Dimension;
import java.util.regex.PatternSyntaxException;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.RowFilter;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableRowSorter;
import trasporti.magazzino_manutenzione.SpringUtilitiesManutenzione;
import utils.Funzioni;

public class TableFilterDemoManutenzione
extends JPanel {
    private boolean DEBUG = false;
    private JTable table;
    private JTextField filterText;
    private JTextField statusText;
    private TableRowSorter<MyTableModel> sorter;

    public TableFilterDemoManutenzione() {
        this.setLayout(new BoxLayout(this, 1));
        MyTableModel model = new MyTableModel();
        this.sorter = new TableRowSorter<MyTableModel>(model);
        this.table = new JTable(model);
        this.table.setRowSorter(this.sorter);
        this.table.setPreferredScrollableViewportSize(new Dimension(500, 70));
        this.table.setFillsViewportHeight(true);
        this.table.setSelectionMode(0);
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent event) {
                int viewRow = TableFilterDemoManutenzione.this.table.getSelectedRow();
                if (viewRow < 0) {
                    TableFilterDemoManutenzione.this.statusText.setText("");
                } else {
                    int modelRow = TableFilterDemoManutenzione.this.table.convertRowIndexToModel(viewRow);
                    TableFilterDemoManutenzione.this.statusText.setText(String.format("Selected Row in view: %d. Selected Row in model: %d.", viewRow, modelRow));
                }
            }
        });
        JScrollPane scrollPane = new JScrollPane(this.table);
        this.add(scrollPane);
        JPanel form = new JPanel(new SpringLayout());
        JLabel l1 = new JLabel("Filter Text:", 11);
        form.add(l1);
        this.filterText = new JTextField();
        this.filterText.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                TableFilterDemoManutenzione.this.newFilter();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                TableFilterDemoManutenzione.this.newFilter();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                TableFilterDemoManutenzione.this.newFilter();
            }
        });
        l1.setLabelFor(this.filterText);
        form.add(this.filterText);
        JLabel l2 = new JLabel("Status:", 11);
        form.add(l2);
        this.statusText = new JTextField();
        l2.setLabelFor(this.statusText);
        form.add(this.statusText);
        SpringUtilitiesManutenzione.makeCompactGrid(form, 2, 2, 6, 6, 6, 6);
        this.add(form);
    }

    private void newFilter() {
        RowFilter rf = null;
        try {
            rf = RowFilter.regexFilter(this.filterText.getText(), 0);
        }
        catch (PatternSyntaxException e) {
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            return;
        }
        this.sorter.setRowFilter(rf);
    }

    private static void createAndShowGUI() {
        JFrame frame = new JFrame("TableFilterDemo");
        frame.setDefaultCloseOperation(3);
        TableFilterDemoManutenzione newContentPane = new TableFilterDemoManutenzione();
        newContentPane.setOpaque(true);
        frame.setContentPane(newContentPane);
        frame.pack();
        frame.setVisible(true);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TableFilterDemoManutenzione.createAndShowGUI();
            }
        });
    }

    class MyTableModel
    extends AbstractTableModel {
        private String[] columnNames = new String[]{"First Name", "Last Name", "Sport", "# of Years", "Vegetarian"};
        private Object[][] data = new Object[][]{{"Kathy", "Smith", "Snowboarding", new Integer(5), new Boolean(false)}, {"John", "Doe", "Rowing", new Integer(3), new Boolean(true)}, {"Sue", "Black", "Knitting", new Integer(2), new Boolean(false)}, {"Jane", "White", "Speed reading", new Integer(20), new Boolean(true)}, {"Joe", "Brown", "Pool", new Integer(10), new Boolean(false)}};

        MyTableModel() {
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return this.data.length;
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        @Override
        public Object getValueAt(int row, int col) {
            return this.data[row][col];
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col >= 2;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            if (TableFilterDemoManutenzione.this.DEBUG) {
                System.out.println("Setting value at " + row + "," + col + " to " + value + " (an instance of " + value.getClass() + ")");
            }
            this.data[row][col] = value;
            this.fireTableCellUpdated(row, col);
            if (TableFilterDemoManutenzione.this.DEBUG) {
                System.out.println("New value of data:");
                this.printDebugData();
            }
        }

        private void printDebugData() {
            int numRows = this.getRowCount();
            int numCols = this.getColumnCount();
            for (int i = 0; i < numRows; ++i) {
                System.out.print("    row " + i + ":");
                for (int j = 0; j < numCols; ++j) {
                    System.out.print("  " + this.data[i][j]);
                }
                System.out.println();
            }
            System.out.println("--------------------------");
        }
    }
}

