/*
 * Decompiled with CFR 0.152.
 */
package trasporti.listini;

import gestionale.auth.Gruppo;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import trasporti.listini.TraListino;
import utils.Funzioni;
import utils.FunzioniDate;
import utils.MyTrace;

public class TraListiniTableModel
extends AbstractTableModel {
    Vector cache;
    int colCount;
    String[] headers;
    boolean modo_ric = false;
    Funzioni f = new Funzioni();
    FunzioniDate fda = new FunzioniDate();

    public TraListiniTableModel() {
        this.cache = new Vector();
    }

    public void setModo_ric(boolean modo_ric) {
        this.modo_ric = modo_ric;
    }

    @Override
    public String getColumnName(int i) {
        String retVal = "";
        switch (i) {
            case 0: {
                retVal = "Contratto";
                break;
            }
            case 1: {
                retVal = "Cod. C/F";
                break;
            }
            case 2: {
                retVal = "Cliente/Fornitore";
                break;
            }
            case 3: {
                retVal = "Tipologia";
                break;
            }
            case 4: {
                retVal = "Nome Listino";
                break;
            }
            default: {
                retVal = this.headers[i];
            }
        }
        return retVal;
    }

    @Override
    public int getRowCount() {
        return this.cache.size();
    }

    @Override
    public int getColumnCount() {
        return 5;
    }

    @Override
    public Object getValueAt(int row, int col) {
        TraListino om = new TraListino();
        if (this.cache.size() != 0) {
            om = (TraListino)this.cache.elementAt(row);
            return om.getColValue(col);
        }
        return "";
    }

    public Class getColumnClass(int c) {
        Class<?> classe = null;
        try {
            classe = this.getValueAt(0, c).getClass();
        }
        catch (Exception e) {
            MyTrace.log.severe("ECCEZIONE: getColumnClass() di TraListiniTableModel colonna=" + c);
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            e.printStackTrace();
        }
        return classe;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return false;
    }

    public void addRow(Gruppo g) {
        this.cache.add(0, g);
        this.fireTableDataChanged();
    }

    public void setDataTraListini(Vector vettoreOM) {
        this.cache = new Vector();
        Iterator i = vettoreOM.iterator();
        while (i.hasNext()) {
            this.cache.addElement(i.next());
        }
        this.fireTableChanged(null);
    }
}

