/*
 * Decompiled with CFR 0.152.
 */
package trasporti.listini;

import java.util.Iterator;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import trasporti.listini.Prezzo;
import trasporti.tratte.Tratta;
import utils.Funzioni;
import utils.FunzioniDate;
import utils.FunzioniTrasporti;
import utils.Money;

public class PrezziTratteTableModel
extends AbstractTableModel {
    Vector cache;
    int colCount;
    String[] headers;
    Funzioni f = new Funzioni();
    FunzioniDate fda = new FunzioniDate();
    private FunzioniTrasporti ft = new FunzioniTrasporti();

    public PrezziTratteTableModel() {
        this.cache = new Vector();
    }

    @Override
    public String getColumnName(int i) {
        String retVal = "";
        switch (i) {
            case 0: {
                retVal = "";
                break;
            }
            case 1: {
                retVal = "Codice Tratta";
                break;
            }
            case 2: {
                retVal = "Descrizione";
                break;
            }
            case 3: {
                retVal = "Km";
                break;
            }
            case 4: {
                retVal = "Prezzo";
                break;
            }
            default: {
                retVal = this.headers[i];
            }
        }
        return retVal;
    }

    @Override
    public int getRowCount() {
        return this.cache.size();
    }

    @Override
    public int getColumnCount() {
        return 5;
    }

    @Override
    public Object getValueAt(int row, int col) {
        Prezzo p = new Prezzo();
        if (this.cache.size() != 0) {
            p = (Prezzo)this.cache.elementAt(row);
            return p.getColValueTratta(col);
        }
        return "";
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        Prezzo p = new Prezzo();
        p = (Prezzo)this.cache.elementAt(row);
        if (col == 1) {
            Tratta t = new Tratta();
            t.seleziona(this.ft.id_tratta_da_codice(value.toString()));
            p.setId_tratta(t.getId());
            p.setTratta(t);
        }
        if (col == 4) {
            p.setPrezzo(new Money(value.toString()));
        }
        this.fireTableRowsUpdated(row, row);
    }

    public Class getColumnClass(int c) {
        return this.getValueAt(0, c).getClass();
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col == 1 || col == 4;
    }

    public void setDataTratta(Vector vettorePNR) {
        this.cache = new Vector();
        Iterator i = vettorePNR.iterator();
        while (i.hasNext()) {
            this.cache.addElement(i.next());
        }
        this.fireTableChanged(null);
    }
}

