/*
 * Decompiled with CFR 0.152.
 */
package trasporti.listini;

import java.util.Iterator;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.table.AbstractTableModel;
import trasporti.listini.Opzione;
import trasporti.listini.Prezzo;
import utils.Funzioni;
import utils.FunzioniDate;
import utils.FunzioniTrasporti;
import utils.Money;

public class PrezziOpzioniTableModel
extends AbstractTableModel {
    Vector cache;
    int colCount;
    String[] headers;
    Funzioni f = new Funzioni();
    FunzioniDate fda = new FunzioniDate();
    private FunzioniTrasporti ft = new FunzioniTrasporti();

    public PrezziOpzioniTableModel() {
        this.cache = new Vector();
    }

    @Override
    public String getColumnName(int i) {
        String retVal = "";
        switch (i) {
            case 0: {
                retVal = "Codice Opzione";
                break;
            }
            case 1: {
                retVal = "Descrizione";
                break;
            }
            case 2: {
                retVal = "Prezzo";
                break;
            }
            default: {
                retVal = this.headers[i];
            }
        }
        return retVal;
    }

    @Override
    public int getRowCount() {
        return this.cache.size();
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public Object getValueAt(int row, int col) {
        Prezzo p = new Prezzo();
        if (this.cache.size() != 0) {
            p = (Prezzo)this.cache.elementAt(row);
            return p.getColValueOpzione(col);
        }
        return "";
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        Prezzo p = new Prezzo();
        p = (Prezzo)this.cache.elementAt(row);
        if (col == 0) {
            Opzione o = new Opzione();
            o.seleziona(this.ft.id_opzione_da_codice(value.toString()));
            p.setId_opzione(o.getId());
            p.setOpzione(o);
        }
        if (col == 2) {
            p.setPrezzo(new Money(value.toString()));
        }
        this.fireTableRowsUpdated(row, row);
    }

    public Class getColumnClass(int c) {
        if (c == 0) {
            return JCheckBox.class;
        }
        return this.getValueAt(0, c).getClass();
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col == 0 || col == 2;
    }

    public void setDataOpzione(Vector vettorePNR) {
        this.cache = new Vector();
        Iterator i = vettorePNR.iterator();
        while (i.hasNext()) {
            this.cache.addElement(i.next());
        }
        this.fireTableChanged(null);
    }
}

