/*
 * Decompiled with CFR 0.152.
 */
package trasporti.indirizzi;

import anagrafiche.clienti_fornitori.Anagrafica;
import gestionale.MyDesktopWindow;
import gestionale.cap.CAP;
import gestionale.configurazioni.Configurazioni;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import utils.Funzioni;
import utils.MyTrace;

public class IndirizzoPresaConsegna {
    private String codice_pt = "";
    private String indirizzo = "";
    private String denominazione = "";
    private String ragione_sociale = "";
    private String localita_selezionata = "";
    private String piva = "";
    private String telefono;
    private String note;
    private int id;
    private int id_cap;
    private int id_acliente;
    private int abilita;
    private CAP cap = new CAP();
    private Anagrafica a_cliente;
    private Funzioni f = new Funzioni();
    private boolean sel = false;

    public String getCodice_pt() {
        return this.codice_pt;
    }

    public void setCodice_pt(String codice_pt) {
        this.codice_pt = codice_pt;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getId_cap() {
        return this.id_cap;
    }

    public void setId_cap(int id_cap) {
        this.id_cap = id_cap;
    }

    public int getAbilita() {
        return this.abilita;
    }

    public void setAbilita(int abilita) {
        this.abilita = abilita;
    }

    public String getIndirizzo() {
        return this.indirizzo;
    }

    public void setIndirizzo(String indirizzo) {
        this.indirizzo = indirizzo;
    }

    public CAP getCap() {
        return this.cap;
    }

    public void setCap(CAP cap) {
        this.cap = cap;
    }

    public String getRagione_sociale() {
        return this.ragione_sociale;
    }

    public void setRagione_sociale(String ragione_sociale) {
        this.ragione_sociale = ragione_sociale;
    }

    public Anagrafica getA_cliente() {
        return this.a_cliente;
    }

    public void setA_cliente(Anagrafica a_cliente) {
        this.a_cliente = a_cliente;
    }

    public int getId_acliente() {
        return this.id_acliente;
    }

    public void setId_acliente(int id_acliente) {
        this.id_acliente = id_acliente;
    }

    public String getLocalita_selezionata() {
        return this.localita_selezionata;
    }

    public void setLocalita_selezionata(String localita_selezionata) {
        this.localita_selezionata = localita_selezionata;
    }

    public String getIndirizzoCompleto() {
        if (this.getCap() != null) {
            if (this.getCap().getCap() != null) {
                return this.getLocalita_selezionata() + " - " + this.getIndirizzo() + " -- " + this.getCap().getCap() + " --- " + this.getCap().getCd_provincia();
            }
            return "";
        }
        return "";
    }

    public boolean isSel() {
        return this.sel;
    }

    public void setSel(boolean sel) {
        this.sel = sel;
    }

    public String toString() {
        if (this.indirizzo != null && this.getCap() != null) {
            return this.indirizzo + "\n" + this.getCap().getCap() + " " + this.getLocalita_selezionata() + " \n" + this.getCap().getCd_provincia();
        }
        return "";
    }

    public String getDenominazione() {
        return this.denominazione;
    }

    public void setDenominazione(String denominazione) {
        this.denominazione = denominazione;
    }

    public String getPiva() {
        return this.piva;
    }

    public void setPiva(String piva) {
        this.piva = piva;
    }

    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public String getTelefono() {
        return this.telefono;
    }

    public void setTelefono(String telefono) {
        this.telefono = telefono;
    }

    public boolean inserisci(boolean da_fuori) {
        String query_ins;
        boolean r_ins;
        if (!da_fuori) {
            String q_start = "START TRANSACTION;";
            boolean r_start = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_start);
        }
        if (!(r_ins = Configurazioni.getIstanza().connessione.eseguiAggiornamento(query_ins = "INSERT INTO mtra_indirizzi_pc(id_anagrafica,denominazione,codice_indirizzo,indirizzo,id_cap,localita_selezionata,p_iva_cf,telefono,note,abilita) VALUES ( " + this.f.zero_to_null(this.getId_acliente()) + "," + "'" + this.getDenominazione().replaceAll("'", "''") + "'," + "'" + this.getCodice_pt().replaceAll("'", "''") + "'," + "'" + this.getIndirizzo().replaceAll("'", "''") + "'," + "'" + this.getId_cap() + "'," + "'" + this.getLocalita_selezionata().replaceAll("'", "''") + "'," + "'" + this.getTelefono().replaceAll("'", "''") + "'," + "'" + this.getNote().replaceAll("'", "''") + "'," + "'" + this.getPiva() + "',1)"))) {
            String q_commit = "ROLLBACK";
            boolean r_commit = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_commit);
            MyTrace.log.severe("Inserimento mtra_indirizzi_pc non riuscito");
            Configurazioni.eccezione.gestisci("2.2", null);
            return false;
        }
        String strSQL = "SELECT @@identity FROM mtra_indirizzi_pc";
        ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(strSQL);
        int id_inserito = 0;
        try {
            while (res.next()) {
                id_inserito = res.getInt("@@identity");
            }
        }
        catch (Exception e) {
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            e.printStackTrace();
        }
        Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        this.setId(id_inserito);
        String q_trace = "INSERT INTO sys_trace(id_operatore,nome_tabella,id_soggetto,data,azione,query) VALUES('" + MyDesktopWindow.profilo.id + "','mtra_indirizzi_pc','" + this.getId() + "',NOW(),'INS','" + query_ins.replaceAll("'", "''") + "')";
        boolean r_trace = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_trace);
        if (!r_trace) {
            MyTrace.log.severe("Inserimento mtra_indirizzi_pc non riuscito per trace");
            Configurazioni.eccezione.gestisci("2.3", null);
            return false;
        }
        if (!da_fuori) {
            String q_commit = "COMMIT";
            boolean r_commit = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_commit);
            if (r_commit) {
                return true;
            }
            MyTrace.log.severe("Inserimento Indirizzo non riuscito per commit");
            Configurazioni.eccezione.gestisci("2.4", null);
            return false;
        }
        return true;
    }

    public boolean modifica(boolean da_fuori) {
        String q_start = "START TRANSACTION;";
        boolean r_start = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_start);
        String query_mod = "UPDATE mtra_indirizzi_pc SET codice_indirizzo='" + this.getCodice_pt().replaceAll("'", "''") + "'," + " denominazione='" + this.getDenominazione().replaceAll("'", "''") + "' ," + " indirizzo='" + this.getIndirizzo().replaceAll("'", "''") + "' ," + " id_cap='" + this.getId_cap() + "', " + " localita_selezionata='" + this.getLocalita_selezionata().replaceAll("'", "''") + "', " + " telefono='" + this.getTelefono().replaceAll("'", "''") + "', " + " note='" + this.getNote().replaceAll("'", "''") + "', " + " p_iva_cf='" + this.getPiva() + "' " + " WHERE idIndirizzi_pc='" + this.getId() + "'";
        boolean r_mod = Configurazioni.getIstanza().connessione.eseguiAggiornamento(query_mod);
        if (!r_start || !r_mod) {
            MyTrace.log.severe("Modifica mtra_indirizzi_pc non riuscita");
            Configurazioni.eccezione.gestisci("3.2", null);
            return false;
        }
        String q_trace = "INSERT INTO sys_trace(id_operatore,nome_tabella,id_soggetto,data,azione,query) VALUES('" + MyDesktopWindow.profilo.id + "','mtra_indirizzi_pc','" + this.getId() + "',NOW(),'MOD','" + query_mod.replaceAll("'", "''") + "')";
        boolean r_trace = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_trace);
        if (!r_trace) {
            MyTrace.log.severe("Modifica mtra_indirizzi_pc non riuscita per trace");
            Configurazioni.eccezione.gestisci("3.3", null);
            return false;
        }
        if (!da_fuori) {
            String q_commit = "COMMIT";
            boolean r_commit = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_commit);
            if (r_commit) {
                return true;
            }
            MyTrace.log.severe("Modifica mtra_indirizzi_pc non riuscito per commit");
            Configurazioni.eccezione.gestisci("3.4", null);
            return false;
        }
        return true;
    }

    public void seleziona_dettagli() {
        this.setA_cliente(new Anagrafica());
        this.getA_cliente().setIdanag(this.getId_acliente());
        this.getA_cliente().seleziona_da_id(this.getId_acliente());
    }

    public void seleziona_da_id() {
        String where = "  WHERE idIndirizzi_pc=" + this.getId();
        this.seleziona(where, "");
    }

    public void seleziona(String where, String order_by) {
        String q = "SELECT * from mtra_indirizzi_pc ";
        q = q + " " + where;
        q = q + " " + order_by;
        ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(q);
        try {
            ResultSetMetaData meta = res.getMetaData();
            while (res.next()) {
                this.setId(res.getInt("idIndirizzi_pc"));
                this.setCodice_pt(res.getString("codice_indirizzo"));
                this.setIndirizzo(res.getString("indirizzo"));
                this.setDenominazione(res.getString("denominazione"));
                this.setId_acliente(res.getInt("id_anagrafica"));
                this.setId_cap(res.getInt("id_cap"));
                this.setCap(new CAP());
                this.getCap().setId(this.getId_cap());
                this.getCap().seleziona();
                this.setLocalita_selezionata(res.getString("localita_selezionata"));
                this.setPiva(res.getString("p_iva_cf"));
                this.setTelefono(res.getString("telefono"));
                this.setNote(res.getString("note"));
            }
        }
        catch (Exception e) {
            MyTrace.log.severe("Seleziona mtra_indirizzi_pc non riuscito ");
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            Configurazioni.eccezione.gestisci("4.1", null);
        }
        Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
    }

    public void seleziona_magazzino() {
        String where = " WHERE id_anagrafica=0";
        this.seleziona(where, "");
    }

    public boolean elimina() {
        String q_start = "START TRANSACTION;";
        boolean r_start = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_start);
        String query_del = "UPDATE mtra_indirizzi_pc SET abilita='0' WHERE idIndirizzo_pc='" + this.getId() + "'";
        boolean r_del = Configurazioni.getIstanza().connessione.eseguiAggiornamento(query_del);
        if (!r_start || !r_del) {
            MyTrace.log.severe("Elimina mtra_indirizzi_pc non riuscita");
            Configurazioni.eccezione.gestisci("3.5", null);
            return false;
        }
        String q_trace = "INSERT INTO sys_trace(id_operatore,nome_tabella,id_soggetto,data,azione,query) VALUES('" + MyDesktopWindow.profilo.id + "','mtra_indirizzi_pc','" + this.getId() + "',NOW(),'DEL','" + query_del.replaceAll("'", "''") + "')";
        boolean r_trace = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_trace);
        if (!r_trace) {
            MyTrace.log.severe("Elimina mtra_indirizzi_pc non riuscita per trace");
            Configurazioni.eccezione.gestisci("3.6", null);
            return false;
        }
        String q_commit = "COMMIT";
        boolean r_commit = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_commit);
        if (r_commit) {
            return true;
        }
        MyTrace.log.severe("Modifica mtra_indirizzi_pc non riuscito per commit");
        Configurazioni.eccezione.gestisci("3.4", null);
        return false;
    }

    public Object getColValuePC(int col) {
        String retVal = "";
        switch (col) {
            case 0: {
                if (this.getRagione_sociale() == null) {
                    retVal = "";
                    break;
                }
                retVal = "" + this.getRagione_sociale();
                break;
            }
            case 1: {
                retVal = "" + this.getDenominazione();
                break;
            }
            case 2: {
                retVal = this.getLocalita_selezionata();
                break;
            }
            case 3: {
                retVal = this.getCap().getCd_provincia();
                break;
            }
            default: {
                retVal = "";
            }
        }
        return retVal;
    }
}

