/*
 * Decompiled with CFR 0.152.
 */
package trasporti.fatturazione;

import gestionale.configurazioni.Configurazioni;
import gestionale.documenti.InsiemeDocumenti;
import gestionale.primanota.Registrazione;
import java.sql.ResultSet;
import java.util.ArrayList;
import trasporti.fatturazione.TraFatturaAttiva;
import utils.Funzioni;
import utils.Money;
import utils.MyTrace;

public class InsiemeTraFA
extends InsiemeDocumenti {
    public ArrayList<TraFatturaAttiva> vettoreFA = new ArrayList();

    @Override
    public int caricamento(String where, String order_by) {
        this.vettoreFA = new ArrayList();
        String q = super.getQq();
        q = q + " " + where;
        q = q + " " + order_by;
        try {
            ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(q);
            while (res.next()) {
                TraFatturaAttiva f = new TraFatturaAttiva();
                f.setIdDocumento(res.getInt("iddocumenti_attivi"));
                f.setId_causale_contabile(res.getInt("id_causale_contabile"));
                f.setId_tipo(res.getInt("id_tipo"));
                f.setString_tipo(res.getString("tipo_fa"));
                f.setDestinazione(res.getString("destinazione"));
                f.setNumero(res.getInt("numero"));
                f.setCodifica(res.getString("codifica"));
                f.setAnno(res.getInt("anno"));
                f.setDescrizione(res.getString("descrizione"));
                f.setId_contatore(res.getInt("id_contatore"));
                f.setId_registro(res.getInt("idregistro"));
                f.setId_fa_old(res.getInt("id_fa_old"));
                Registrazione r = new Registrazione();
                r.setIdregistro(res.getInt("idregistro"));
                r.setNum_reg(res.getInt("num_reg"));
                r.setData_reg(res.getString("data_reg"));
                r.setNum_doc(res.getString("num_doc"));
                r.setData_doc(res.getString("data_doc"));
                r.setAnno_prot(res.getInt("anno_prot"));
                r.setId_causale_contabile_e_basta(res.getInt("id_causale_contabile"));
                r.setCodice_causale_contabile(res.getString("codice_causale"));
                r.setTipo_cf(res.getString("tipo_cf"));
                r.setId_anag_e_basta(res.getInt("id_anagrafica"));
                r.setRagione_sociale_cf(res.getString("ragione_sociale"));
                r.setCodice_cf(res.getString("codice"));
                r.setImporto_doc(new Money(res.getDouble("importo_doc")));
                r.setId_registro_iva(res.getInt("id_conf_registri_iva"));
                r.setId_trattamento_economico(res.getInt("id_conf_trattamento_economico"));
                r.setNote(res.getString("note"));
                r.setIban_cf(res.getString("iban_cf"));
                r.setId_banca_appoggio(res.getInt("id_banca_appoggio"));
                r.setDesc_banca(res.getString("desc_banca"));
                r.setIban_banca(res.getString("iban_banca"));
                r.setAnno_reg(res.getInt("anno_reg"));
                r.setProtocollo_iva(res.getInt("protocollo_iva"));
                r.setIva_proporzionale(res.getInt("iva_proporzionale"));
                r.setId_tipo_modello(res.getInt("id_modelli_cc"));
                r.setCodice_ri(res.getString("codice_ri"));
                f.setR(r);
                this.vettoreFA.add(f);
            }
            Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        }
        catch (Exception e) {
            this.vettoreFA = new ArrayList();
            MyTrace.log.severe("Seleziona Fatture Attive non riuscito");
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            Configurazioni.eccezione.gestisci("4.2", null);
        }
        return this.vettoreFA.size();
    }

    public int caricamento_ricavi(String where, String order_by) {
        String query = "SELECT documenti_attivi_righe.id_documenti_attivi, documenti_attivi.numero, documenti_attivi.codifica, documenti_attivi.anno, registro.data_doc, SUM(IF(mtra_viaggi.id_anagrafica is null OR mtra_viaggi.id_anagrafica = 0,documenti_attivi_righe.importo,0)) as importo_diretto,  SUM(IF(mtra_viaggi.id_anagrafica is not null,documenti_attivi_righe.importo,0)) as importo_indiretto , SUM(documenti_attivi_righe.importo) as totale_calcolato FROM documenti_attivi_righe LEFT JOIN documenti_attivi on documenti_attivi_righe.id_documenti_attivi=documenti_attivi.iddocumenti_attivi LEFT JOIN registro on documenti_attivi.id_registro=registro.idregistro LEFT JOIN mtra_ordini_viaggi_righe on documenti_attivi_righe.iddocumenti_attivi_righe=mtra_ordini_viaggi_righe.id_riga_doc LEFT JOIN mtra_ordini_viaggi_rif on mtra_ordini_viaggi_righe.id_ordine=mtra_ordini_viaggi_rif.id_ordine LEFT JOIN mtra_viaggi on mtra_ordini_viaggi_rif.id_viaggio=mtra_viaggi.id_viaggio";
        query = query + " " + where;
        query = query + " GROUP BY  documenti_attivi_righe.id_documenti_attivi  " + order_by;
        try {
            ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query);
            while (res.next()) {
                TraFatturaAttiva f = new TraFatturaAttiva();
                f.setIdDocumento(res.getInt("id_documenti_attivi"));
                f.setNumero(res.getInt("numero"));
                f.setCodifica(res.getString("codifica"));
                f.setAnno(res.getInt("anno"));
                Registrazione r = new Registrazione();
                r.setData_doc(res.getString("data_doc"));
                f.setR(r);
                f.setRicavi_diretti(new Money(res.getDouble("importo_diretto")));
                f.setRicavi_indiretti(new Money(res.getDouble("importo_indiretto")));
                f.setTotale_ricavi(new Money(res.getDouble("totale_calcolato")));
                this.vettoreFA.add(f);
            }
            Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        }
        catch (Exception e) {
            this.vettoreFA = new ArrayList();
            MyTrace.log.severe("Seleziona Fatture Attive non riuscito");
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            Configurazioni.eccezione.gestisci("4.2", null);
        }
        return this.vettoreFA.size();
    }
}

