/*
 * Decompiled with CFR 0.152.
 */
package trasporti.bolle;

import anagrafiche.clienti_fornitori.Anagrafica;
import java.util.Date;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.table.AbstractTableModel;
import trasporti.bolle.Bolla;
import trasporti.ordini.Ordine;
import utils.Funzioni;
import utils.FunzioniDate;
import utils.FunzioniTrasporti;
import utils.MyTrace;

public class BolleTableModel
extends AbstractTableModel {
    Vector cache;
    int colCount;
    String[] headers;
    boolean modo_modifica = false;
    FunzioniDate fda = new FunzioniDate();
    FunzioniTrasporti ft = new FunzioniTrasporti();

    public BolleTableModel() {
        this.cache = new Vector();
    }

    public boolean isModo_modifica() {
        return this.modo_modifica;
    }

    public void setModo_modifica(boolean modo_modifica) {
        this.modo_modifica = modo_modifica;
    }

    @Override
    public String getColumnName(int i) {
        String retVal = "";
        switch (i) {
            case 0: {
                retVal = "N. Ordine";
                break;
            }
            case 1: {
                retVal = "Cliente";
                break;
            }
            case 2: {
                retVal = "Tratta Complessiva";
                break;
            }
            case 3: {
                retVal = "Data Bolla";
                break;
            }
            case 4: {
                retVal = "Numero Bolla";
                break;
            }
            case 5: {
                retVal = "Bolla";
                break;
            }
            case 6: {
                retVal = "Inserisci Bolla";
                break;
            }
            case 7: {
                retVal = "Vedi Bolla";
                break;
            }
            case 8: {
                retVal = "Elimina Bolla";
                break;
            }
            default: {
                retVal = this.headers[i];
            }
        }
        return retVal;
    }

    @Override
    public int getRowCount() {
        return this.cache.size();
    }

    @Override
    public int getColumnCount() {
        return 9;
    }

    @Override
    public Object getValueAt(int row, int col) {
        Object ritorno = "";
        Bolla b = new Bolla();
        if (!this.cache.isEmpty()) {
            b = (Bolla)this.cache.elementAt(row);
            ritorno = col == 0 || col == 1 || col == 2 || col == 3 || col == 4 || col == 5 ? b.getColValue(col) : "Change";
        } else {
            ritorno = "";
        }
        return ritorno;
    }

    public Class getColumnClass(int col) {
        try {
            if (col == 3) {
                return Date.class;
            }
            if (col == 6) {
                return JCheckBox.class;
            }
            if (col == 7) {
                return JComboBox.class;
            }
            if (col == 8) {
                return JButton.class;
            }
            if (col == 0) {
                return JPanel.class;
            }
            if (col == 1) {
                return JRadioButton.class;
            }
            return this.getValueAt(0, col).getClass();
        }
        catch (Exception ex) {
            MyTrace.log.severe("ERRORE:  eccezione getColumnClass()");
            ex.printStackTrace();
            Funzioni.inviaBugPerEmail(ex);
            Funzioni.LogStackTrace(ex);
        }
        catch (Error err) {
            MyTrace.log.severe("ERRORE: getColumnClass() errore di avvio o di linkaggio");
            err.printStackTrace();
        }
        return Object.class;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        if (col == 0 || col == 1 || col == 6 || col == 8 || col == 3 || col == 4) {
            return this.isModo_modifica();
        }
        return col == 7;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        String v;
        Bolla b = (Bolla)this.cache.elementAt(row);
        if (col == 0 && !(v = value.toString()).equals("")) {
            String n = v.substring(0, v.indexOf("/"));
            String anno = v.substring(v.indexOf("/") + 1, v.length());
            Ordine o = new Ordine();
            o.seleziona(" where numero_ordine=" + n + " AND anno=" + anno);
            b.setId_ordine(o.getId());
            b.setRagione_sociale(o.getRagione_sociale());
            b.setId_cliente(o.getId_acliente());
            b.setNumero_ordine("" + o.getN_ordine());
            b.setAnno_ordine(o.getAnno_ordine());
            b.setTratta_complessiva(o.getTratta_complessiva());
            this.fireTableRowsUpdated(row, row);
        }
        if (col == 1) {
            Anagrafica a = new Anagrafica();
            a.seleziona_da_ragione(value.toString(), "C");
            b.setRagione_sociale(a.getRagione_sociale());
            b.setId_cliente(a.getIdanag());
        }
        if (col == 3) {
            b.setData_bolla(this.fda.gira_data(value.toString()));
            this.fireTableCellUpdated(row, col);
        }
        if (col == 4) {
            b.setNumero_bolla(value.toString());
            this.fireTableCellUpdated(row, col);
        }
    }

    public void setDataBolle(Vector vettoreK) {
        this.cache = new Vector();
        for (Bolla b : vettoreK) {
            if (b.isDa_eliminare()) continue;
            this.cache.addElement(b);
        }
        this.fireTableChanged(null);
    }
}

