/*
 * Decompiled with CFR 0.152.
 */
package trasporti.autista;

import anagrafiche.mezzi.MyMezzi;
import gestionale.MyDesktopWindow;
import gestionale.configurazioni.ConfigurazioneFinestre;
import gestionale.configurazioni.Configurazioni;
import gestionale.configurazioni.MyProprietaFrame;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import java.util.regex.PatternSyntaxException;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.RowFilter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableRowSorter;
import trasporti.autista.Autista;
import trasporti.autista.AutistiFixedModel;
import trasporti.autista.AutistiTableModel;
import trasporti.autista.InsiemeAutisti;
import trasporti.borderaux.MyBorderaux;
import trasporti.report_km.MyReportKm;
import trasporti.viaggi.InsiemeViaggi;
import trasporti.viaggi.MyViaggi;
import trasporti.viaggi.OccupatiTableRenderer;
import trasporti.viaggi.Viaggio;
import utils.DateField;
import utils.Funzioni;
import utils.FunzioniDate;
import utils.GenericTableRenderer;
import utils.MyTrace;
import utils.RicercaCellEditor;
import utils.RicercaCellRenderer;
import utils.TimeFormatter;
import utils.ToolTipHeader;

public class MyAutisti
extends JInternalFrame
implements ListSelectionListener,
MouseListener,
InternalFrameListener {
    String civetta_permessi;
    public static int size_diritti = 2;
    public static String[] array_diritti = new String[]{"Autisti_Visualizza", "Autisti_Modifica"};
    JToolBar jToolBarMod;
    AutistiTableModel atm;
    InsiemeAutisti insieme_a;
    JScrollPane scroll;
    JTable jTableAutisti;
    AutistiFixedModel afm;
    JScrollPane fixedScroll;
    JTable fixedTable;
    private TableRowSorter<AutistiTableModel> sorter;
    RowFilter<AutistiTableModel, Object> rf = null;
    ArrayList<RowFilter<AutistiTableModel, Object>> andFilters = new ArrayList();
    Funzioni f = new Funzioni();
    FunzioniDate fda = new FunzioniDate();
    private boolean in_modifica = false;
    private boolean non_tutte_le_righe = false;
    public Autista a_selezione;
    private boolean in_new = false;
    private boolean in_filter = false;
    public JInternalFrame chiamante;
    public boolean occupati = false;
    public String occupati_in_data;
    Vector autisti_assegnati;
    public boolean f_mezzi_open;
    private DateField jTextDataNascita;
    private DateField jTextDataAssunzione;
    private DateField jTextDataRilascioPatente;
    TimeFormatter df = null;
    TimeFormatter df_1 = null;
    TimeFormatter df_2 = null;
    private JButton jButtonClean;
    private JButton jButtonElimina;
    private JToggleButton jButtonFiltra;
    private JButton jButtonFirst;
    private JButton jButtonForm;
    private JButton jButtonLast;
    private JButton jButtonModifica;
    private JButton jButtonNext;
    private JButton jButtonNuovo;
    private JButton jButtonPrevious;
    private JButton jButtonRefresh;
    private JButton jButtonStampa;
    private JCheckBox jCheckJolly;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JLabel jLabelCognome;
    private JLabel jLabelIndirizzo;
    private JLabel jLabelNome;
    private JLabel jLabelTelefono;
    private JLabel jLabelTrattorePredefinito;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanelDettaglio;
    private JPanel jPanelElenco;
    private JToolBar.Separator jSeparator1;
    private JToolBar.Separator jSeparator2;
    private JToolBar.Separator jSeparator3;
    private JSeparator jSeparator4;
    private JSeparator jSeparator5;
    private JSeparator jSeparator6;
    private JSeparator jSeparator7;
    private JSeparator jSeparator8;
    private JTabbedPane jTabbedPane1;
    private JTextField jTextCodiceFiscale;
    private JTextField jTextCognome;
    private JTextField jTextIndirizzo;
    private JTextField jTextLocalita;
    private JTextField jTextLuogoNascita;
    private JTextField jTextNome;
    private JTextField jTextNumeroPatente;
    private JTextField jTextProvincia;
    private JTextField jTextRilascioPatente;
    private JTextField jTextTelefono;
    public JTextField jTextTrattorePredefinito;
    private JToolBar jToolBar1;
    private JPanel p;

    public MyAutisti() {
        if (!MyDesktopWindow.profilo.controllaPermesso("Autisti_Visualizza")) {
            Configurazioni.eccezione.gestisci("7.1", null);
            this.dispose();
        }
        this.atm = new AutistiTableModel();
        this.insieme_a = new InsiemeAutisti();
        this.jTableAutisti = new JTable(this.atm);
        this.jTableAutisti.setSelectionMode(0);
        this.sorter = new TableRowSorter<AutistiTableModel>(this.atm);
        for (int i = 0; i < this.atm.getColumnCount(); ++i) {
            RowFilter rf_local = RowFilter.regexFilter("(?i)", i);
            this.andFilters.add(i, rf_local);
        }
        this.afm = new AutistiFixedModel();
        this.afm.setFIXED_NUM(0);
        this.fixedTable = new JTable(this.afm);
        this.fixedTable.setAutoResizeMode(4);
        this.initComponents();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.df = new TimeFormatter();
        this.df_1 = new TimeFormatter();
        this.df_2 = new TimeFormatter();
        this.jTextDataNascita = new DateField(this.df);
        this.jTextDataNascita.setMinimumSize(new Dimension(120, 30));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel3.add((Component)this.jTextDataNascita, gridBagConstraints);
        this.jTextDataNascita.setText("");
        this.jTextDataAssunzione = new DateField(this.df_1);
        this.jTextDataAssunzione.setMinimumSize(new Dimension(120, 30));
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel3.add((Component)this.jTextDataAssunzione, gridBagConstraints);
        this.jTextDataAssunzione.setText("");
        this.jTextDataRilascioPatente = new DateField(this.df_2);
        this.jTextDataRilascioPatente.setMinimumSize(new Dimension(120, 30));
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        this.jPanel3.add((Component)this.jTextDataRilascioPatente, gridBagConstraints);
        this.jTextDataRilascioPatente.setText("");
        this.crea_toolbar();
        this.aggiungi_tabelle();
        if (!this.occupati) {
            this.filtra();
        }
        ListSelectionModel listSelectionModel = this.jTableAutisti.getSelectionModel();
        listSelectionModel.addListSelectionListener(this);
        this.formatta();
        this.visualizzazione();
        this.controlla_diritti();
        this.addInternalFrameListener(this);
        this.setLocation(ConfigurazioneFinestre.GetPoint(this.getClass().getName(), new Point(200, 0)));
        this.setSize(ConfigurazioneFinestre.GetDimension(this.getClass().getName(), new Dimension(650, 550)));
    }

    private void aggiungi_tabelle() {
        this.scroll = new JScrollPane(this.jTableAutisti){

            @Override
            public void setColumnHeaderView(Component view) {
            }
        };
        this.scroll.setHorizontalScrollBarPolicy(31);
        this.fixedScroll = new JScrollPane(this.fixedTable);
        this.fixedScroll.setVerticalScrollBarPolicy(22);
        this.fixedScroll.setPreferredSize(new Dimension(400, 25));
        JScrollBar bar = this.fixedScroll.getVerticalScrollBar();
        JScrollBar dummyBar = new JScrollBar(){

            @Override
            public void paint(Graphics g) {
            }
        };
        dummyBar.setPreferredSize(bar.getPreferredSize());
        this.fixedScroll.setVerticalScrollBar(dummyBar);
        final JScrollBar bar1 = this.scroll.getHorizontalScrollBar();
        JScrollBar bar2 = this.fixedScroll.getHorizontalScrollBar();
        bar2.addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                bar1.setValue(e.getValue());
            }
        });
        this.jTableAutisti.setModel(this.atm);
        this.jTableAutisti.setAutoCreateRowSorter(true);
        this.jTableAutisti.setRowSorter(this.sorter);
        this.jTableAutisti.setFillsViewportHeight(true);
        this.p.add((Component)this.scroll, "Center");
        this.p.add((Component)this.fixedScroll, "North");
    }

    private void controlla_diritti() {
    }

    private void crea_toolbar() {
        this.jToolBarMod = new JToolBar();
        JButton jButtonSalva = new JButton();
        JButton jButtonAnnulla = new JButton();
        jButtonSalva.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/document-save-as.png")));
        jButtonSalva.setText("Salva");
        jButtonSalva.setFocusable(true);
        jButtonSalva.setVerticalTextPosition(3);
        jButtonSalva.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyAutisti.this.jButtonSalvaActionPerformed(evt);
            }
        });
        this.jToolBarMod.add(jButtonSalva);
        jButtonAnnulla.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/edit-undo.png")));
        jButtonAnnulla.setText("Annulla");
        jButtonAnnulla.setFocusable(true);
        jButtonAnnulla.setVerticalTextPosition(3);
        jButtonAnnulla.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyAutisti.this.jButtonAnnullaActionPerformed(evt);
            }
        });
        this.jToolBarMod.add(jButtonAnnulla);
    }

    public void visualizzazione() {
        this.jTextCognome.setEnabled(this.in_modifica);
        this.jTextTelefono.setEnabled(this.in_modifica);
        this.jTextNome.setEnabled(this.in_modifica);
        this.jTextTrattorePredefinito.setEnabled(this.in_modifica);
        this.jTextIndirizzo.setEnabled(this.in_modifica);
        this.jTextLocalita.setEnabled(this.in_modifica);
        this.jTextProvincia.setEnabled(this.in_modifica);
        this.jTextCodiceFiscale.setEnabled(this.in_modifica);
        this.jTextDataNascita.setEnabled(this.in_modifica);
        this.jTextLuogoNascita.setEnabled(this.in_modifica);
        this.jTextDataAssunzione.setEnabled(this.in_modifica);
        this.jTextNumeroPatente.setEnabled(this.in_modifica);
        this.jTextRilascioPatente.setEnabled(this.in_modifica);
        this.jTextDataRilascioPatente.setEnabled(this.in_modifica);
        this.jCheckJolly.setEnabled(this.in_modifica);
        if (this.in_modifica) {
            this.getContentPane().remove(this.jToolBar1);
            this.getContentPane().add((Component)this.jToolBarMod, "North");
            this.jTabbedPane1.setEnabledAt(0, false);
        } else {
            this.getContentPane().remove(this.jToolBarMod);
            this.getContentPane().add((Component)this.jToolBar1, "North");
            this.jTabbedPane1.setEnabledAt(0, true);
        }
        this.getContentPane().validate();
        this.getContentPane().repaint();
    }

    public void filtra() {
        this.autisti_assegnati = new Vector();
        String w = " WHERE mtra_autisti.abilita='1' ";
        String o = " ";
        if (Configurazioni.righe_ricerca != 0) {
            o = o + " LIMIT 0," + Configurazioni.righe_ricerca;
        }
        this.insieme_a.caricamento(w, o);
        if (this.occupati) {
            String where5 = " WHERE mtra_viaggi.data_partenza='" + this.occupati_in_data + "' ";
            InsiemeViaggi insieme_v = new InsiemeViaggi();
            insieme_v.caricamento(where5, "", true);
            for (Viaggio v : insieme_v.vettoreV) {
                for (Autista a : this.insieme_a.vettoreAutisti) {
                    if (v.getId_autista() != a.getIdautista() || a.getJolly() == 1) continue;
                    a.setAssegnato(true);
                }
            }
            Iterator i = this.insieme_a.vettoreAutisti.iterator();
            while (i.hasNext()) {
                this.autisti_assegnati.add(((Autista)i.next()).isAssegnato());
            }
        }
        this.atm.setDataAutisti(this.insieme_a.vettoreAutisti);
        if (Configurazioni.righe_ricerca != 0 && this.insieme_a.vettoreAutisti.size() >= Configurazioni.righe_ricerca && !this.occupati) {
            this.non_tutte_le_righe = true;
        }
    }

    public void formatta() {
        this.jTableAutisti.getSelectionModel().setSelectionInterval(0, 0);
        if (!this.occupati) {
            this.jTableAutisti.setDefaultRenderer(Object.class, new GenericTableRenderer());
        } else {
            this.jTableAutisti.setDefaultRenderer(Object.class, new OccupatiTableRenderer(this.autisti_assegnati));
        }
        this.fixedTable.setRowHeight(30);
        this.fixedTable.setDefaultEditor(String.class, new TextEditor());
        this.fixedTable.setDefaultRenderer(Object.class, new RicercaCellRenderer());
        TableColumn gruppoColumn = this.fixedTable.getColumnModel().getColumn(2);
        this.jTableAutisti.addMouseListener(this);
        this.header_tebella();
    }

    public void header_tebella() {
        try {
            String[] toolTipStr = new String[]{"Cognome", "Nome", "Numero di Telefono", "Trattore Predefinito"};
            ToolTipHeader header1 = new ToolTipHeader(this.jTableAutisti.getColumnModel());
            ToolTipHeader header2 = new ToolTipHeader(this.fixedTable.getColumnModel());
            header1.setToolTipStrings(toolTipStr);
            header2.setToolTipStrings(toolTipStr);
            this.fixedTable.setTableHeader(header2);
            this.jTableAutisti.setTableHeader(header1);
            header1.setResizingAllowed(false);
            header2.setResizingAllowed(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void seleziona(int row) {
        this.a_selezione = new Autista();
        this.a_selezione = (Autista)this.insieme_a.vettoreAutisti.elementAt(row);
        this.riempi_campi();
    }

    public void riempi_campi() {
        this.jTextCognome.setText(this.a_selezione.getCognome());
        this.jTextNome.setText(this.a_selezione.getNome());
        this.jTextTelefono.setText(this.a_selezione.getTelefono());
        this.jTextTrattorePredefinito.setText(this.a_selezione.getModello_mezzo() + " " + this.a_selezione.getTarga_mezzo());
        this.jTextIndirizzo.setText(this.a_selezione.getIndirizzo());
        this.jTextLocalita.setText(this.a_selezione.getLocalita());
        this.jTextProvincia.setText(this.a_selezione.getProvincia());
        this.jTextCodiceFiscale.setText(this.a_selezione.getCod_fiscale());
        this.jTextDataNascita.setText(this.fda.gira_data(this.a_selezione.getData_nascita()));
        this.jTextLuogoNascita.setText(this.a_selezione.getLuogo_nascita());
        this.jTextDataAssunzione.setText(this.fda.gira_data(this.a_selezione.getData_assunzione()));
        this.jTextNumeroPatente.setText(this.a_selezione.getNumero_patente());
        this.jTextRilascioPatente.setText(this.a_selezione.getPatente_rilasciata_da());
        this.jTextDataRilascioPatente.setText(this.fda.gira_data(this.a_selezione.getData_rilascio_patente()));
        if (this.a_selezione.getJolly() == 1) {
            this.jCheckJolly.setSelected(true);
        } else {
            this.jCheckJolly.setSelected(false);
        }
    }

    private void costruisci() {
        this.a_selezione.setCognome(this.jTextCognome.getText());
        this.a_selezione.setNome(this.jTextNome.getText());
        this.a_selezione.setTelefono(this.jTextTelefono.getText());
        this.a_selezione.setIndirizzo(this.jTextIndirizzo.getText());
        this.a_selezione.setLocalita(this.jTextLocalita.getText());
        this.a_selezione.setProvincia(this.jTextProvincia.getText());
        this.a_selezione.setCod_fiscale(this.jTextCodiceFiscale.getText());
        this.a_selezione.setData_nascita(this.fda.gira_data(this.jTextDataNascita.getText()));
        this.a_selezione.setLuogo_nascita(this.jTextLuogoNascita.getText());
        this.a_selezione.setData_assunzione(this.fda.gira_data(this.jTextDataAssunzione.getText()));
        this.a_selezione.setNumero_patente(this.jTextNumeroPatente.getText());
        this.a_selezione.setPatente_rilasciata_da(this.jTextRilascioPatente.getText());
        this.a_selezione.setData_rilascio_patente(this.fda.gira_data(this.jTextDataRilascioPatente.getText()));
        if (this.jCheckJolly.isSelected()) {
            this.a_selezione.setJolly(1);
        } else {
            this.a_selezione.setJolly(0);
        }
        if (this.jTextDataNascita.getText().equals("  -  -    ") || this.jTextDataAssunzione.getText().equals("  -  -    ") || this.jTextDataRilascioPatente.getText().equals("  -  -    ")) {
            if (this.jTextDataNascita.getText().equals("  -  -    ")) {
                this.jTextDataNascita.setText("00-00-0000");
                this.a_selezione.setData_nascita(this.fda.gira_data(this.jTextDataNascita.getText()));
            }
            if (this.jTextDataAssunzione.getText().equals("  -  -    ")) {
                this.jTextDataAssunzione.setText("00-00-0000");
                this.a_selezione.setData_assunzione(this.fda.gira_data(this.jTextDataAssunzione.getText()));
            }
            if (this.jTextDataRilascioPatente.getText().equals("  -  -    ")) {
                this.jTextDataRilascioPatente.setText("00-00-0000");
                this.a_selezione.setData_rilascio_patente(this.fda.gira_data(this.jTextDataRilascioPatente.getText()));
            }
        }
    }

    private boolean check() {
        if (this.jTextNome.getText().equals("")) {
            JOptionPane.showMessageDialog(this, "Inserire il nome dell'Autista");
            return false;
        }
        if (this.jTextCognome.getText().equals("")) {
            JOptionPane.showMessageDialog(this, "Inserire il cognome dell'Autista");
            return false;
        }
        if (this.jTextProvincia.getText().length() > 2 || this.jTextProvincia.getText().length() == 1) {
            JOptionPane.showMessageDialog(this, "Inserire correttamente la 'sigla' della Provincia");
            this.jTextProvincia.setText("");
            return false;
        }
        if (this.df.giorno.equals("  ") || this.df.mese.equals("  ") || this.df.anno.equals("    ")) {
            JOptionPane.showMessageDialog(this, "Inserire la data nel formato gg-mm-aaaa");
            this.jTextDataNascita.setText("");
            this.df.giorno = "00";
            this.df.mese = "00";
            this.df.anno = "0000";
            return false;
        }
        if (this.df_1.giorno.equals("  ") || this.df_1.mese.equals("  ") || this.df_1.anno.equals("    ")) {
            JOptionPane.showMessageDialog(this, "Inserire la data nel formato gg-mm-aaaa");
            this.jTextDataAssunzione.setText("");
            this.df_1.giorno = "00";
            this.df_1.mese = "00";
            this.df_1.anno = "0000";
            return false;
        }
        if (this.df_2.giorno.equals("  ") || this.df_2.mese.equals("  ") || this.df_2.anno.equals("    ")) {
            JOptionPane.showMessageDialog(this, "Inserire la data nel formato gg-mm-aaaa");
            this.jTextDataRilascioPatente.setText("");
            this.df_2.giorno = "00";
            this.df_2.mese = "00";
            this.df_2.anno = "0000";
            return false;
        }
        return true;
    }

    private void jButtonSalvaActionPerformed(ActionEvent evt) {
        if (this.in_new) {
            if (this.check()) {
                this.costruisci();
                boolean check2 = this.a_selezione.inserisci(false);
                if (check2) {
                    this.in_new = false;
                    this.in_modifica = false;
                    this.filtra();
                    this.visualizzazione();
                    this.jTabbedPane1.setSelectedIndex(0);
                } else {
                    JOptionPane.showMessageDialog(this, "Si \u00e8 verificato un errore al momento dell'inserimento dei dati nel database,\nRicontrollare i campi riempiti e non.\nSe il problema persiste contattare Kronos");
                }
            }
        } else if (this.check()) {
            this.costruisci();
            boolean check2 = this.a_selezione.modifica(false);
            if (check2) {
                System.out.println("Nome " + this.a_selezione.getNome() + "   Cognome: " + this.a_selezione.getCognome() + "  Telefono: " + this.a_selezione.getTelefono() + "   id trattore: " + this.a_selezione.getId_trattore_preferito() + " idautista=" + this.a_selezione.getIdautista());
                this.in_modifica = false;
                this.filtra();
                this.visualizzazione();
                this.jTabbedPane1.setSelectedIndex(0);
            } else {
                JOptionPane.showMessageDialog(this, "Si \u00e8 verificato un errore al momento della modifica dei dati nel database,\nRicontrollare i campi riempiti e non.\nSe il problema persiste contattare Kronos");
            }
        }
    }

    private void jButtonAnnullaActionPerformed(ActionEvent evt) {
        int res = JOptionPane.showConfirmDialog(this, "Abbandonare le modifiche?");
        if (res == 0) {
            this.in_modifica = false;
            this.visualizzazione();
            this.jTabbedPane1.setSelectedIndex(0);
        }
    }

    private void initComponents() {
        this.jToolBar1 = new JToolBar();
        this.jButtonNuovo = new JButton();
        this.jButtonModifica = new JButton();
        this.jButtonElimina = new JButton();
        this.jButtonForm = new JButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.jButtonFirst = new JButton();
        this.jButtonPrevious = new JButton();
        this.jButtonNext = new JButton();
        this.jButtonLast = new JButton();
        this.jSeparator2 = new JToolBar.Separator();
        this.jButtonRefresh = new JButton();
        this.jButtonFiltra = new JToggleButton();
        this.jButtonClean = new JButton();
        this.jSeparator3 = new JToolBar.Separator();
        this.jButtonStampa = new JButton();
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanelElenco = new JPanel();
        this.p = new JPanel();
        this.jPanelDettaglio = new JPanel();
        this.jPanel2 = new JPanel();
        this.jPanel3 = new JPanel();
        this.jLabelNome = new JLabel();
        this.jLabelCognome = new JLabel();
        this.jTextCognome = new JTextField();
        this.jLabelTelefono = new JLabel();
        this.jTextTrattorePredefinito = new JTextField();
        this.jLabelTrattorePredefinito = new JLabel();
        this.jTextTelefono = new JTextField();
        this.jTextNome = new JTextField();
        this.jLabelIndirizzo = new JLabel();
        this.jTextIndirizzo = new JTextField();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.jLabel8 = new JLabel();
        this.jLabel9 = new JLabel();
        this.jTextLocalita = new JTextField();
        this.jTextProvincia = new JTextField();
        this.jTextCodiceFiscale = new JTextField();
        this.jTextLuogoNascita = new JTextField();
        this.jTextNumeroPatente = new JTextField();
        this.jTextRilascioPatente = new JTextField();
        this.jSeparator4 = new JSeparator();
        this.jSeparator5 = new JSeparator();
        this.jSeparator6 = new JSeparator();
        this.jSeparator7 = new JSeparator();
        this.jSeparator8 = new JSeparator();
        this.jCheckJolly = new JCheckBox();
        this.setClosable(true);
        this.setIconifiable(true);
        this.setMaximizable(true);
        this.setResizable(true);
        this.setTitle("Trasporti \\ Autisti");
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent evt) {
                MyAutisti.this.posizione_finestra(evt);
            }

            @Override
            public void componentResized(ComponentEvent evt) {
                MyAutisti.this.finestra_ridimensionata(evt);
            }
        });
        this.jToolBar1.setRollover(true);
        this.jButtonNuovo.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/document-new.png")));
        this.jButtonNuovo.setText("Nuovo");
        this.jButtonNuovo.setFocusable(false);
        this.jButtonNuovo.setVerticalTextPosition(3);
        this.jButtonNuovo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyAutisti.this.jButtonNuovoActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonNuovo);
        this.jButtonModifica.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/accessories-text-editor.png")));
        this.jButtonModifica.setText("Modifica");
        this.jButtonModifica.setFocusable(false);
        this.jButtonModifica.setHorizontalAlignment(11);
        this.jButtonModifica.setVerticalTextPosition(3);
        this.jButtonModifica.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyAutisti.this.jButtonModificaActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonModifica);
        this.jButtonElimina.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/user-trash.png")));
        this.jButtonElimina.setText("Elimina");
        this.jButtonElimina.setFocusable(false);
        this.jButtonElimina.setHorizontalAlignment(11);
        this.jButtonElimina.setVerticalTextPosition(3);
        this.jButtonElimina.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyAutisti.this.jButtonEliminaActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonElimina);
        this.jButtonForm.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/preferences-system.png")));
        this.jButtonForm.setText("Propriet\u00e0");
        this.jButtonForm.setFocusable(false);
        this.jButtonForm.setHorizontalAlignment(11);
        this.jButtonForm.setVerticalTextPosition(3);
        this.jButtonForm.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyAutisti.this.jButtonFormActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonForm);
        this.jToolBar1.add(this.jSeparator1);
        this.jButtonFirst.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/go-first.png")));
        this.jButtonFirst.setFocusable(false);
        this.jButtonFirst.setHorizontalTextPosition(0);
        this.jButtonFirst.setVerticalTextPosition(3);
        this.jButtonFirst.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyAutisti.this.jButtonFirstActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonFirst);
        this.jButtonPrevious.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/go-previous.png")));
        this.jButtonPrevious.setFocusable(false);
        this.jButtonPrevious.setHorizontalTextPosition(0);
        this.jButtonPrevious.setVerticalTextPosition(3);
        this.jButtonPrevious.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyAutisti.this.jButtonPreviousActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonPrevious);
        this.jButtonNext.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/go-next.png")));
        this.jButtonNext.setFocusable(false);
        this.jButtonNext.setHorizontalTextPosition(0);
        this.jButtonNext.setVerticalTextPosition(3);
        this.jButtonNext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyAutisti.this.jButtonNextActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonNext);
        this.jButtonLast.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/go-last.png")));
        this.jButtonLast.setFocusable(false);
        this.jButtonLast.setHorizontalTextPosition(0);
        this.jButtonLast.setVerticalTextPosition(3);
        this.jButtonLast.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyAutisti.this.jButtonLastActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonLast);
        this.jToolBar1.add(this.jSeparator2);
        this.jButtonRefresh.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/view-refresh.png")));
        this.jButtonRefresh.setFocusable(false);
        this.jButtonRefresh.setHorizontalTextPosition(0);
        this.jButtonRefresh.setVerticalTextPosition(3);
        this.jButtonRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyAutisti.this.jButtonRefreshActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonRefresh);
        this.jButtonFiltra.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/edit-find.png")));
        this.jButtonFiltra.setFocusable(false);
        this.jButtonFiltra.setHorizontalTextPosition(0);
        this.jButtonFiltra.setVerticalTextPosition(3);
        this.jButtonFiltra.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyAutisti.this.jButtonFiltraActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonFiltra);
        this.jButtonClean.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/edit-clear.png")));
        this.jButtonClean.setFocusable(false);
        this.jButtonClean.setHorizontalTextPosition(0);
        this.jButtonClean.setVerticalTextPosition(3);
        this.jButtonClean.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyAutisti.this.jButtonCleanActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonClean);
        this.jToolBar1.add(this.jSeparator3);
        this.jButtonStampa.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/document-print.png")));
        this.jButtonStampa.setFocusable(false);
        this.jButtonStampa.setHorizontalTextPosition(0);
        this.jButtonStampa.setVerticalTextPosition(3);
        this.jToolBar1.add(this.jButtonStampa);
        this.getContentPane().add((Component)this.jToolBar1, "North");
        this.jPanelElenco.setLayout(new BorderLayout());
        this.p.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.p.setLayout(new BorderLayout());
        this.jPanelElenco.add((Component)this.p, "Center");
        this.jTabbedPane1.addTab("Elenco", this.jPanelElenco);
        this.jPanelDettaglio.setLayout(new BorderLayout());
        this.jPanel2.setLayout(new GridBagLayout());
        this.jPanel3.setMinimumSize(new Dimension(600, 270));
        this.jPanel3.setPreferredSize(new Dimension(600, 300));
        this.jPanel3.setLayout(new GridBagLayout());
        this.jLabelNome.setText("Nome");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel3.add((Component)this.jLabelNome, gridBagConstraints);
        this.jLabelCognome.setText("Cognome");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel3.add((Component)this.jLabelCognome, gridBagConstraints);
        this.jTextCognome.setMinimumSize(new Dimension(120, 30));
        this.jTextCognome.setPreferredSize(new Dimension(150, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel3.add((Component)this.jTextCognome, gridBagConstraints);
        this.jLabelTelefono.setText("Numero Di Telefono");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel3.add((Component)this.jLabelTelefono, gridBagConstraints);
        this.jTextTrattorePredefinito.setMinimumSize(new Dimension(120, 30));
        this.jTextTrattorePredefinito.setPreferredSize(new Dimension(150, 30));
        this.jTextTrattorePredefinito.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                MyAutisti.this.jTextTrattorePredefinitoKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel3.add((Component)this.jTextTrattorePredefinito, gridBagConstraints);
        this.jLabelTrattorePredefinito.setText("Trattore Predefinito");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel3.add((Component)this.jLabelTrattorePredefinito, gridBagConstraints);
        this.jTextTelefono.setMinimumSize(new Dimension(120, 30));
        this.jTextTelefono.setPreferredSize(new Dimension(150, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        this.jPanel3.add((Component)this.jTextTelefono, gridBagConstraints);
        this.jTextNome.setMinimumSize(new Dimension(120, 30));
        this.jTextNome.setPreferredSize(new Dimension(150, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel3.add((Component)this.jTextNome, gridBagConstraints);
        this.jLabelIndirizzo.setText("Indirizzo");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel3.add((Component)this.jLabelIndirizzo, gridBagConstraints);
        this.jTextIndirizzo.setMinimumSize(new Dimension(250, 30));
        this.jTextIndirizzo.setPreferredSize(new Dimension(150, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel3.add((Component)this.jTextIndirizzo, gridBagConstraints);
        this.jLabel1.setText("Localit\u00e0");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel3.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel2.setText("Sigla Della Provincia");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel3.add((Component)this.jLabel2, gridBagConstraints);
        this.jLabel3.setText("Codice Fiscale");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel3.add((Component)this.jLabel3, gridBagConstraints);
        this.jLabel4.setText("Data Di Nascita");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel3.add((Component)this.jLabel4, gridBagConstraints);
        this.jLabel5.setText("Luogo Di Nascita");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel3.add((Component)this.jLabel5, gridBagConstraints);
        this.jLabel6.setText("Data Di Assunzione");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel3.add((Component)this.jLabel6, gridBagConstraints);
        this.jLabel7.setText("Numero Patente");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel3.add((Component)this.jLabel7, gridBagConstraints);
        this.jLabel8.setText("Rilasciata Da");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel3.add((Component)this.jLabel8, gridBagConstraints);
        this.jLabel9.setText("Data Rilascio");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel3.add((Component)this.jLabel9, gridBagConstraints);
        this.jTextLocalita.setMinimumSize(new Dimension(120, 30));
        this.jTextLocalita.setPreferredSize(new Dimension(150, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel3.add((Component)this.jTextLocalita, gridBagConstraints);
        this.jTextProvincia.setMinimumSize(new Dimension(50, 30));
        this.jTextProvincia.setPreferredSize(new Dimension(70, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        this.jPanel3.add((Component)this.jTextProvincia, gridBagConstraints);
        this.jTextCodiceFiscale.setMinimumSize(new Dimension(120, 30));
        this.jTextCodiceFiscale.setPreferredSize(new Dimension(150, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        this.jPanel3.add((Component)this.jTextCodiceFiscale, gridBagConstraints);
        this.jTextLuogoNascita.setMinimumSize(new Dimension(120, 30));
        this.jTextLuogoNascita.setPreferredSize(new Dimension(150, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel3.add((Component)this.jTextLuogoNascita, gridBagConstraints);
        this.jTextNumeroPatente.setMinimumSize(new Dimension(120, 30));
        this.jTextNumeroPatente.setPreferredSize(new Dimension(150, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel3.add((Component)this.jTextNumeroPatente, gridBagConstraints);
        this.jTextRilascioPatente.setMinimumSize(new Dimension(120, 30));
        this.jTextRilascioPatente.setPreferredSize(new Dimension(150, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel3.add((Component)this.jTextRilascioPatente, gridBagConstraints);
        this.jSeparator4.setOrientation(1);
        this.jSeparator4.setMinimumSize(new Dimension(0, 10));
        this.jSeparator4.setPreferredSize(new Dimension(0, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        this.jPanel3.add((Component)this.jSeparator4, gridBagConstraints);
        this.jSeparator5.setOrientation(1);
        this.jSeparator5.setMinimumSize(new Dimension(0, 10));
        this.jSeparator5.setPreferredSize(new Dimension(0, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 5;
        this.jPanel3.add((Component)this.jSeparator5, gridBagConstraints);
        this.jSeparator6.setOrientation(1);
        this.jSeparator6.setMinimumSize(new Dimension(0, 10));
        this.jSeparator6.setPreferredSize(new Dimension(0, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 8;
        this.jPanel3.add((Component)this.jSeparator6, gridBagConstraints);
        this.jSeparator7.setOrientation(1);
        this.jSeparator7.setMinimumSize(new Dimension(0, 10));
        this.jSeparator7.setPreferredSize(new Dimension(0, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 11;
        this.jPanel3.add((Component)this.jSeparator7, gridBagConstraints);
        this.jSeparator8.setOrientation(1);
        this.jSeparator8.setMinimumSize(new Dimension(0, 10));
        this.jSeparator8.setPreferredSize(new Dimension(0, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 14;
        this.jPanel3.add((Component)this.jSeparator8, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 1, 0, 0);
        this.jPanel2.add((Component)this.jPanel3, gridBagConstraints);
        this.jCheckJolly.setText("JOLLY");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel2.add((Component)this.jCheckJolly, gridBagConstraints);
        this.jPanelDettaglio.add((Component)this.jPanel2, "West");
        this.jTabbedPane1.addTab("Anagrafica", this.jPanelDettaglio);
        this.getContentPane().add((Component)this.jTabbedPane1, "Center");
        this.pack();
    }

    private void jButtonNuovoActionPerformed(ActionEvent evt) {
        this.in_new = true;
        this.jTableAutisti.getSelectionModel().clearSelection();
        this.a_selezione = new Autista();
        this.riempi_campi();
        this.in_modifica = true;
        this.jTabbedPane1.setSelectedIndex(1);
        this.visualizzazione();
    }

    private void jButtonModificaActionPerformed(ActionEvent evt) {
        this.in_modifica = true;
        this.visualizzazione();
        if (this.jTabbedPane1.getSelectedIndex() == 0) {
            this.jTabbedPane1.setSelectedIndex(1);
        }
    }

    private void jButtonEliminaActionPerformed(ActionEvent evt) {
        this.jTabbedPane1.setSelectedIndex(1);
        int res = JOptionPane.showConfirmDialog(this, "Sei sicuro di voler eleiminare questo Autista?");
        if (res == 0) {
            this.a_selezione.elimina(res);
            this.in_modifica = false;
            this.filtra();
        }
        this.visualizzazione();
        this.jTabbedPane1.setSelectedIndex(0);
    }

    private void jButtonFormActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        MyProprietaFrame oggetto = new MyProprietaFrame();
        this.getDesktopPane().add(oggetto);
        oggetto.setLocation(200, 0);
        oggetto.setVisible(true);
        oggetto.moveToFront();
        this.setCursor(new Cursor(0));
    }

    private void jButtonFirstActionPerformed(ActionEvent evt) {
        if (this.atm.getRowCount() != 0) {
            this.jTableAutisti.getSelectionModel().setSelectionInterval(0, 0);
        }
    }

    private void jButtonPreviousActionPerformed(ActionEvent evt) {
        try {
            if (this.jTableAutisti.getSelectedRow() > 0 && this.atm.getRowCount() != 0) {
                this.jTableAutisti.getSelectionModel().setSelectionInterval(this.jTableAutisti.getSelectedRow() - 1, this.jTableAutisti.getSelectedRow() - 1);
            }
        }
        catch (Exception err) {
            MyTrace.log.severe("RAGGIUNTO PRIMO");
            err.printStackTrace();
        }
    }

    private void jButtonNextActionPerformed(ActionEvent evt) {
        try {
            if (this.atm.getRowCount() != 0) {
                this.jTableAutisti.getSelectionModel().setSelectionInterval(this.jTableAutisti.getSelectedRow() + 1, this.jTableAutisti.getSelectedRow() + 1);
            }
        }
        catch (Exception err) {
            MyTrace.log.severe("RAGGIUNTO ULTIMO");
            err.printStackTrace();
        }
    }

    private void jButtonLastActionPerformed(ActionEvent evt) {
        if (this.atm.getRowCount() != 0) {
            this.jTableAutisti.getSelectionModel().setSelectionInterval(this.atm.getRowCount() - 1, this.atm.getRowCount() - 1);
        }
    }

    private void jButtonRefreshActionPerformed(ActionEvent evt) {
        this.filtra();
        this.formatta();
        this.visualizzazione();
    }

    private void jButtonFiltraActionPerformed(ActionEvent evt) {
        if (!this.in_filter) {
            this.in_filter = true;
            String[] a_ric = new String[]{"", "", "", ""};
            this.afm.addRow(a_ric);
            this.fixedScroll.setViewportView(this.fixedTable);
            this.fixedScroll.setPreferredSize(new Dimension(400, 65));
            this.p.add((Component)this.fixedScroll, "North");
            this.p.repaint();
            this.repaint();
            this.fixedTable.setCellSelectionEnabled(true);
            this.fixedTable.changeSelection(0, 0, false, false);
            this.fixedTable.requestFocus();
        } else {
            this.in_filter = false;
            this.afm.deleteRow();
            this.afm = new AutistiFixedModel();
            this.fixedTable.setModel(this.afm);
            this.fixedScroll.setViewportView(this.fixedTable);
            this.fixedScroll.setPreferredSize(new Dimension(400, 25));
            this.sorter.setRowFilter(null);
            this.p.add((Component)this.fixedScroll, "North");
            this.p.repaint();
            this.repaint();
        }
        this.formatta();
    }

    private void jButtonCleanActionPerformed(ActionEvent evt) {
        if (this.in_filter) {
            this.in_filter = true;
            this.sorter.setRowFilter(null);
            String[] a_ric = new String[]{"", "", "", ""};
            this.afm = new AutistiFixedModel();
            this.fixedTable.setModel(this.afm);
            this.afm.addRow(a_ric);
            this.andFilters = new ArrayList();
            for (int i = 0; i < this.atm.getColumnCount(); ++i) {
                RowFilter rf_local = RowFilter.regexFilter("(?i)", i);
                this.andFilters.add(i, rf_local);
            }
            this.fixedScroll.setViewportView(this.fixedTable);
            this.fixedScroll.setPreferredSize(new Dimension(400, 65));
            this.p.add((Component)this.fixedScroll, "North");
            this.p.repaint();
            this.repaint();
        }
        this.formatta();
    }

    private void posizione_finestra(ComponentEvent evt) {
        ConfigurazioneFinestre.SetPoint(this.getClass().getName(), this.getLocation());
    }

    private void finestra_ridimensionata(ComponentEvent evt) {
        ConfigurazioneFinestre.SetDimension(this.getClass().getName(), this.getSize());
    }

    private void jTextTrattorePredefinitoKeyPressed(KeyEvent evt) {
        int keyCode = evt.getKeyCode();
        if (!this.f_mezzi_open && keyCode == 115) {
            MyMezzi oggetto = new MyMezzi();
            oggetto.chiamante = this;
            oggetto.tipo = "T";
            oggetto.filtra();
            this.getDesktopPane().add(oggetto);
            oggetto.setVisible(true);
            oggetto.moveToFront();
            this.f_mezzi_open = true;
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        int viewRow = this.jTableAutisti.getSelectedRow();
        int modelRow = 1000000000;
        if (this.in_filter) {
            if (viewRow >= 0) {
                modelRow = this.jTableAutisti.convertRowIndexToModel(viewRow);
            }
        } else {
            modelRow = viewRow;
        }
        if (modelRow <= this.atm.getRowCount() - 1 && modelRow >= 0) {
            this.seleziona(modelRow);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        JTable jtb = (JTable)e.getSource();
        if (e.getClickCount() == 2) {
            int viewRow = jtb.getSelectedRow();
            int modelRow = 1000000000;
            if (this.in_filter) {
                if (viewRow >= 0) {
                    modelRow = this.jTableAutisti.convertRowIndexToModel(viewRow);
                }
            } else {
                modelRow = viewRow;
            }
            if (modelRow <= this.atm.getRowCount() - 1 && modelRow >= 0) {
                Autista a = new Autista();
                a = (Autista)this.insieme_a.vettoreAutisti.elementAt(modelRow);
                if (this.chiamante != null) {
                    if (!a.isAssegnato()) {
                        if (this.chiamante.getClass() == MyViaggi.class && ((MyViaggi)this.chiamante).f_autisti_open) {
                            ((MyViaggi)this.chiamante).jTextAutista.setText(a.getCognome());
                            ((MyViaggi)this.chiamante).v_selezione.setId_autista(a.getIdautista());
                            ((MyViaggi)this.chiamante).v_selezione.setAutista(a);
                            ((MyViaggi)this.chiamante).f_autisti_open = false;
                        }
                        if (this.chiamante.getClass() == MyBorderaux.class && ((MyBorderaux)this.chiamante).f_autisti_open) {
                            ((MyBorderaux)this.chiamante).jTextAutista.setText(a.getCognome());
                            ((MyBorderaux)this.chiamante).v_selezione.setId_autista(a.getIdautista());
                            ((MyBorderaux)this.chiamante).v_selezione.setAutista(a);
                            ((MyBorderaux)this.chiamante).f_autisti_open = false;
                        }
                        if (this.chiamante.getClass() == MyReportKm.class && ((MyReportKm)this.chiamante).f_autisti_open) {
                            ((MyReportKm)this.chiamante).jTextAutista.setText(a.getCognome());
                            ((MyReportKm)this.chiamante).jLabelIdAutista.setText("" + a.getIdautista());
                            ((MyReportKm)this.chiamante).f_autisti_open = false;
                        }
                        this.dispose();
                    } else {
                        JOptionPane.showMessageDialog(this, "Autista gi\u00e0 assegnato a un'altro viaggio!");
                    }
                }
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void internalFrameOpened(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameClosing(InternalFrameEvent e) {
        if (this.chiamante != null) {
            if (this.chiamante.getClass() == MyViaggi.class && ((MyViaggi)this.chiamante).f_autisti_open) {
                ((MyViaggi)this.chiamante).f_autisti_open = false;
            }
            if (this.chiamante.getClass() == MyBorderaux.class && ((MyBorderaux)this.chiamante).f_autisti_open) {
                ((MyBorderaux)this.chiamante).f_autisti_open = false;
            }
            this.dispose();
        }
    }

    @Override
    public void internalFrameClosed(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameIconified(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameDeiconified(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameActivated(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameDeactivated(InternalFrameEvent e) {
    }

    public class TextEditor
    extends RicercaCellEditor {
        RowFilter<AutistiTableModel, Object> rf_local = null;

        @Override
        public void newFilter(int col) {
            if (!MyAutisti.this.non_tutte_le_righe) {
                try {
                    this.rf_local = RowFilter.regexFilter("(?i)" + this.tf.getText(), col);
                    MyAutisti.this.andFilters.set(col, this.rf_local);
                }
                catch (PatternSyntaxException e) {
                    Funzioni.inviaBugPerEmail(e);
                    Funzioni.LogStackTrace(e);
                    return;
                }
                MyAutisti.this.rf = RowFilter.andFilter(MyAutisti.this.andFilters);
                MyAutisti.this.sorter.setRowFilter(MyAutisti.this.rf);
                MyAutisti.this.formatta();
            } else {
                String w = " WHERE 1";
                if (col == 0) {
                    w = w + " AND mtra_autisti.cognome LIKE '%" + this.tf.getText() + "%'";
                }
                if (col == 1) {
                    w = w + " AND mtra_autisti.nome LIKE '%" + this.tf.getText() + "%'";
                }
                if (col == 2) {
                    w = w + " AND mtra_autisti.telefono LIKE '%" + this.tf.getText() + "%'";
                }
                if (col == 3) {
                    w = w + " AND mtra_mezzi.modello LIKE '%" + this.tf.getText() + "%' OR mtra_mezzi.targa LIKE '%" + this.tf.getText() + "%'";
                }
                String o = " ORDER BY cognome ASC LIMIT 0," + Configurazioni.righe_ricerca;
                MyAutisti.this.insieme_a.caricamento(w, o);
                MyAutisti.this.atm.setDataAutisti(MyAutisti.this.insieme_a.vettoreAutisti);
                MyAutisti.this.formatta();
            }
        }
    }
}

