/*
 * Decompiled with CFR 0.152.
 */
package trasporti.analitica;

import anagrafiche.mezzi.InsiemeMezzi;
import anagrafiche.mezzi.Mezzo;
import cisterna.carico_gasolio.CaricoGasolio;
import cisterna.carico_gasolio.InsiemeCaricoGasolio;
import controlling.analitica.Analitica;
import controlling.analitica.InsiemeAnalitica;
import controlling.analitica.InsiemeVariabili;
import controlling.analitica_operativa.AnaliticaOperativaVariabili;
import controlling.centri_di_responsabilita.CentroDiResponsabilita;
import controlling.esportazione.MyEsportazione;
import controlling.regole.InsiemeRegole;
import controlling.regole.Regola;
import controlling.regole_operative.InsiemeRegoleOperative;
import controlling.regole_operative.RegolaOperativa;
import controlling.ribaltamento.RegolaRibaltamento;
import controlling.voci_di_analisi.VoceDiAnalisi;
import gestionale.configurazioni.Configurazioni;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JInternalFrame;
import trasporti.manutenzioni.InsiemeManutenzioni;
import trasporti.manutenzioni.Manutenzione;
import trasporti.ordini.InsiemeOrdini;
import trasporti.ordini.Ordine;
import trasporti.viaggi.InsiemeViaggi;
import trasporti.viaggi.InsiemeViaggiFornitore;
import trasporti.viaggi.ViaggiFornitore;
import trasporti.viaggi.Viaggio;
import utils.Funzioni;
import utils.FunzioniDate;
import utils.MyTrace;
import utils.Task;

public class EsportatoreTrasporti {
    Regola r_gasolio_altri;
    Regola r_man_altri;
    Regola r_0;
    Regola r_casa_spedizioni;
    Regola r_trasporti;
    VoceDiAnalisi vda_gasolio_altri;
    VoceDiAnalisi vda_man_altri;
    VoceDiAnalisi vda_gasolio;
    VoceDiAnalisi vda_man;
    VoceDiAnalisi vda_viaggi_vettori;
    VoceDiAnalisi vda_fatturato;
    CentroDiResponsabilita cdr_casa_spedizioni;
    CentroDiResponsabilita cdr_trasporti;
    JInternalFrame chiamante;
    InsiemeRegole insiemeRegole;
    Funzioni f = new Funzioni();
    FunzioniDate fda = new FunzioniDate();

    public JInternalFrame getChiamante() {
        return this.chiamante;
    }

    public Regola getR_0() {
        return this.r_0;
    }

    public void setR_0(Regola r_0) {
        this.r_0 = r_0;
    }

    public void setChiamante(JInternalFrame chiamante) {
        this.chiamante = chiamante;
    }

    public InsiemeRegole getInsiemeRegole() {
        return this.insiemeRegole;
    }

    public void setInsiemeRegole(InsiemeRegole insiemeRegole) {
        this.insiemeRegole = insiemeRegole;
    }

    public VoceDiAnalisi getVda_fatturato() {
        return this.vda_fatturato;
    }

    public void setVda_fatturato(VoceDiAnalisi vda_fatturato) {
        this.vda_fatturato = vda_fatturato;
    }

    public void append(String testo_da_inserire) {
        ((MyEsportazione)this.chiamante).jTextResult.append(testo_da_inserire + "\n");
        MyTrace.log.info("APPEND: " + testo_da_inserire);
    }

    public void gestione_eccezione_in_task(Task task, String descrizione) {
        this.append(descrizione + "");
        if (task.cancel(true)) {
            this.append("RICHIESTA INTERRUZIONE");
        }
    }

    public boolean trasporti_fase_01_costruisci_ambiente() {
        this.append("START ** MODULO TRASPORTI **  AMBIENTE");
        try {
            RegolaOperativa ro;
            Configurazioni.getIstanza();
            if (Configurazioni.hm.get("cdr_casa_spedizioni").equals("")) {
                this.append(" Creare una cdr per la casa di spedizioni: CASA DI SPEDIZIONI  Creare nel file di configurazioni la seguente riga:'cdr_casa_spedizioni = CASA DI SPEDIZIONI'");
                Configurazioni.getIstanza().connessione.rollback();
                return false;
            }
            this.cdr_casa_spedizioni = new CentroDiResponsabilita();
            StringBuilder stringBuilder = new StringBuilder().append(" WHERE centro_di_responsabilita='");
            Configurazioni.getIstanza();
            String w = stringBuilder.append(Configurazioni.hm.get("cdr_casa_spedizioni")).append("'").toString();
            this.cdr_casa_spedizioni.seleziona(w);
            if (this.cdr_casa_spedizioni.getIdcentri_di_responsabilita() == 0) {
                this.append("cdr_casa_spedizioni non trovato: lo inserisco");
                this.cdr_casa_spedizioni = new CentroDiResponsabilita();
                this.cdr_casa_spedizioni.setAttivo(1);
                this.cdr_casa_spedizioni.setCentro_di_responsabilita("CASA DI SPEDIZIONI");
                this.cdr_casa_spedizioni.setLivello(1);
                this.cdr_casa_spedizioni.setTipo("operativo");
                this.cdr_casa_spedizioni.iinserisci(false);
                this.append("cdr_casa_spedizioni NON TROVATA NEL DB => L'HO INSERITO");
            } else {
                this.append("cdr_casa_spedizioni TROVATA NEL DB");
            }
            Configurazioni.getIstanza();
            if (Configurazioni.hm.get("cdr_trasporti").equals("")) {
                this.append("Creare una cdr per tutti i camion: TUTTI I CAMION  Creare nel file di configurazioni la seguente riga:'cdr_casa_spedizioni = CASA DI SPEDIZIONI'");
                Configurazioni.getIstanza().connessione.rollback();
                return false;
            }
            this.cdr_trasporti = new CentroDiResponsabilita();
            StringBuilder stringBuilder2 = new StringBuilder().append(" WHERE centro_di_responsabilita='");
            Configurazioni.getIstanza();
            w = stringBuilder2.append(Configurazioni.hm.get("cdr_trasporti")).append("'").toString();
            this.cdr_trasporti.seleziona(w);
            if (this.cdr_trasporti.getIdcentri_di_responsabilita() == 0) {
                this.append(" CDR_TRASPORTI NON TROVATO, LO INSERISCO ");
                this.cdr_trasporti = new CentroDiResponsabilita();
                this.cdr_trasporti.setAttivo(1);
                Configurazioni.getIstanza();
                this.cdr_trasporti.setCentro_di_responsabilita(Configurazioni.hm.get("cdr_trasporti"));
                this.cdr_trasporti.setLivello(1);
                this.cdr_trasporti.setTipo("operativo");
                this.cdr_trasporti.iinserisci(false);
                this.append(" CDR TRASPORTI INSERITO ");
            } else {
                this.append(" CDR TRASPORTI TROVATO ");
            }
            this.cdr_trasporti.seleziona_dettagli();
            InsiemeMezzi insieme_m_cdr = new InsiemeMezzi();
            String www = " WHERE mtra_mezzi.id_centro_di_responsabilita!=0 AND mtra_mezzi.abilita=1";
            insieme_m_cdr.caricamento(www, "");
            if (this.cdr_trasporti.getInsieme_regole_ribaltamento().vettoreRegole.isEmpty() || this.cdr_trasporti.getInsieme_regole_ribaltamento().vettoreRegole.size() != insieme_m_cdr.vettoreMacchine.size()) {
                for (RegolaRibaltamento rr : this.cdr_trasporti.getInsieme_regole_ribaltamento().vettoreRegole) {
                    rr.elimina(false);
                }
                for (Mezzo m : insieme_m_cdr.vettoreMacchine) {
                    RegolaRibaltamento rr = new RegolaRibaltamento();
                    rr.setAttivo(1);
                    rr.setId_cdr_non_operativo(this.cdr_trasporti.getIdcentri_di_responsabilita());
                    rr.setId_cdr_operativo(m.getId_centro_responsabilita());
                    double p = 100.0 / (double)insieme_m_cdr.vettoreMacchine.size();
                    rr.setPercentuale(p);
                    boolean res = rr.inserisci(false);
                    if (res) continue;
                    this.append("PROBLEMA NELLA CREAZIONE DI UNA REGOLA DI RIBALTAMENTO IN :" + rr.toString());
                }
            }
            this.append("Regole ribaltamento trasporti TRASPORTI aggiornate ");
            this.r_trasporti = new Regola();
            StringBuilder stringBuilder3 = new StringBuilder().append(" WHERE ctrl_regole.nome='");
            Configurazioni.getIstanza();
            w = stringBuilder3.append(Configurazioni.hm.get("cdr_trasporti")).append("'").toString();
            this.r_trasporti.seleziona(w);
            if (this.r_trasporti.getId_regola() == 0) {
                this.append("R TRASPORTI NON TROVATO LO INSERISCO ");
                this.r_trasporti = new Regola();
                Configurazioni.getIstanza();
                this.r_trasporti.setNome(Configurazioni.hm.get("cdr_trasporti"));
                this.r_trasporti.setTotale(100);
                this.r_trasporti.setInsieme_ro(new InsiemeRegoleOperative());
                ro = new RegolaOperativa();
                ro.setAttivo(1);
                ro.setCdr(this.cdr_trasporti.getCentro_di_responsabilita());
                ro.setId_centri_di_responsabilita(this.cdr_trasporti.getIdcentri_di_responsabilita());
                ro.setQuota(100);
                this.r_trasporti.getInsieme_ro().vettoreRegoleOperative.add(ro);
                this.r_trasporti.iinserisci(false);
                this.append(" R TRASPORTI INSERITA CORRETTAMENTE ");
            } else {
                this.append(" REGOLA TRASPORTI TROVATA ");
            }
            this.r_trasporti.seleziona_dettagli();
            this.r_casa_spedizioni = new Regola();
            StringBuilder stringBuilder4 = new StringBuilder().append(" WHERE ctrl_regole.nome='");
            Configurazioni.getIstanza();
            w = stringBuilder4.append(Configurazioni.hm.get("cdr_casa_spedizioni")).append("'").toString();
            this.r_casa_spedizioni.seleziona(w);
            if (this.r_casa_spedizioni.getId_regola() == 0) {
                this.append("R CASA DI SPEDIZIONI NON TROVATA, LA INSERISCO ");
                this.r_casa_spedizioni = new Regola();
                Configurazioni.getIstanza();
                this.r_casa_spedizioni.setNome(Configurazioni.hm.get("cdr_casa_spedizioni"));
                this.r_casa_spedizioni.setTotale(100);
                this.r_casa_spedizioni.setInsieme_ro(new InsiemeRegoleOperative());
                ro = new RegolaOperativa();
                ro.setAttivo(1);
                ro.setCdr(this.cdr_casa_spedizioni.getCentro_di_responsabilita());
                ro.setId_centri_di_responsabilita(this.cdr_casa_spedizioni.getIdcentri_di_responsabilita());
                ro.setQuota(100);
                this.r_casa_spedizioni.getInsieme_ro().vettoreRegoleOperative.add(ro);
                this.r_casa_spedizioni.iinserisci(false);
                this.append("R CASA DI SPEDIZIONI inserita ");
            } else {
                this.append("R CASA DI SPEDIZIONI TROVATA ");
            }
            this.r_casa_spedizioni.seleziona_dettagli();
            Configurazioni.getIstanza();
            if (Configurazioni.hm.get("voce_di_analisi_carico_gasolio").equals("")) {
                this.append("Creare una voce di analisi per il gasolio chiamata: GASOLIO  Creare nel file di configurazioni la seguente riga:'voce_di_analisi_carico_gasolio = GASOLIO'");
                Configurazioni.getIstanza().connessione.rollback();
                return false;
            }
            this.vda_gasolio = new VoceDiAnalisi();
            StringBuilder stringBuilder5 = new StringBuilder().append(" WHERE descrizione_voce='");
            Configurazioni.getIstanza();
            this.vda_gasolio.seleziona(stringBuilder5.append(Configurazioni.hm.get("voce_di_analisi_carico_gasolio")).append("'").toString());
            if (this.vda_gasolio.getIdvoci_di_analisi() == 0) {
                this.append("vda gasolio non trovata, la inserisco ");
                this.vda_gasolio = new VoceDiAnalisi();
                Configurazioni.getIstanza();
                this.vda_gasolio.setDescrizione_voce(Configurazioni.hm.get("voce_di_analisi_carico_gasolio"));
                this.vda_gasolio.setTipo("costo");
                this.vda_gasolio.setDiretto(1);
                this.vda_gasolio.setId_regola_predefinita(this.r_trasporti.getId_regola());
                this.vda_gasolio.setNome_regola(this.r_trasporti.getNome());
                this.vda_gasolio.setReg(this.r_trasporti);
                this.vda_gasolio.inserisci(false);
                this.append("vda gasolio inserita ");
            } else {
                this.append("vda gasolio trovata ");
            }
            Configurazioni.getIstanza();
            if (Configurazioni.hm.get("voce_di_analisi_carico_gasolio_altri").equals("")) {
                this.append("Creare una voce di analisi per il gasolio chiamata: GASOLIO ALTRI  Creare nel file di configurazioni la seguente riga:'voce_di_analisi_carico_gasolio_altri = GASOLIO ALTRI'");
                Configurazioni.getIstanza().connessione.rollback();
                return false;
            }
            this.vda_gasolio_altri = new VoceDiAnalisi();
            StringBuilder stringBuilder6 = new StringBuilder().append(" WHERE descrizione_voce='");
            Configurazioni.getIstanza();
            this.vda_gasolio_altri.seleziona(stringBuilder6.append(Configurazioni.hm.get("voce_di_analisi_carico_gasolio_altri")).append("'").toString());
            if (this.vda_gasolio_altri.getIdvoci_di_analisi() == 0) {
                this.append("vda gasolio altri non trovata, la inserisco");
                this.vda_gasolio_altri = new VoceDiAnalisi();
                Configurazioni.getIstanza();
                this.vda_gasolio_altri.setDescrizione_voce(Configurazioni.hm.get("voce_di_analisi_carico_gasolio_altri"));
                this.vda_gasolio_altri.setTipo("costo");
                this.vda_gasolio_altri.setDiretto(1);
                this.vda_gasolio_altri.setId_regola_predefinita(this.r_0.getId_regola());
                this.vda_gasolio_altri.setNome_regola(this.r_0.getNome());
                this.vda_gasolio_altri.setReg(this.r_0);
                this.vda_gasolio_altri.inserisci(false);
                this.append("vda gasolio altri inserita");
            } else {
                this.append("vda gasolio altri trovata");
            }
            this.r_gasolio_altri = new Regola();
            w = " WHERE idregole=" + this.vda_gasolio_altri.getId_regola_predefinita() + " ";
            this.r_gasolio_altri.seleziona(w);
            this.r_gasolio_altri.seleziona_dettagli();
            this.append("r gasolio altri selezionata");
            Configurazioni.getIstanza();
            if (Configurazioni.hm.get("voce_di_analisi_manutenzione").equals("")) {
                this.append("Creare una voce di analisi per le manutenzioni chiamata: MANUTENZIONI  Creare nel file di configurazioni la seguente riga:'voce_di_analisi_manutenzione = MANUTENZIONI'");
                Configurazioni.getIstanza().connessione.rollback();
                return false;
            }
            this.vda_man = new VoceDiAnalisi();
            StringBuilder stringBuilder7 = new StringBuilder().append(" WHERE descrizione_voce='");
            Configurazioni.getIstanza();
            this.vda_man.seleziona(stringBuilder7.append(Configurazioni.hm.get("voce_di_analisi_manutenzione")).append("'").toString());
            if (this.vda_man.getIdvoci_di_analisi() == 0) {
                this.append("vda manutenzioni non trovata, la inserisco");
                this.vda_man = new VoceDiAnalisi();
                Configurazioni.getIstanza();
                this.vda_man.setDescrizione_voce(Configurazioni.hm.get("voce_di_analisi_manutenzione"));
                this.vda_man.setTipo("costo");
                this.vda_man.setDiretto(1);
                this.vda_man.setId_regola_predefinita(this.r_trasporti.getId_regola());
                this.vda_man.setNome_regola(this.r_trasporti.getNome());
                this.vda_man.setReg(this.r_trasporti);
                this.vda_man.inserisci(false);
                this.append("vda manutenzioni inserita");
            } else {
                this.append("vda manutenzioni trovata");
            }
            Configurazioni.getIstanza();
            if (Configurazioni.hm.get("voce_di_analisi_manutenzione_altri").equals("")) {
                this.append("Creare una voce di analisi per le manutenzioni chiamata: MANUTENZIONI ALTRI  Creare nel file di configurazioni la seguente riga:'voce_di_analisi_manutenzioni_altri = MANUTENZIONI ALTRI'");
                Configurazioni.getIstanza().connessione.rollback();
                return false;
            }
            this.vda_man_altri = new VoceDiAnalisi();
            StringBuilder stringBuilder8 = new StringBuilder().append(" WHERE descrizione_voce='");
            Configurazioni.getIstanza();
            this.vda_man_altri.seleziona(stringBuilder8.append(Configurazioni.hm.get("voce_di_analisi_manutenzione_altri")).append("'").toString());
            if (this.vda_man_altri.getIdvoci_di_analisi() == 0) {
                this.append("vda manutenzioni altri non trovata, la inserisco");
                this.vda_man_altri = new VoceDiAnalisi();
                Configurazioni.getIstanza();
                this.vda_man_altri.setDescrizione_voce(Configurazioni.hm.get("voce_di_analisi_manutenzione_altri"));
                this.vda_man_altri.setTipo("costo");
                this.vda_man_altri.setDiretto(1);
                this.vda_man_altri.setId_regola_predefinita(this.r_0.getId_regola());
                this.vda_man_altri.setNome_regola(this.r_0.getNome());
                this.vda_man_altri.setReg(this.r_0);
                this.vda_man_altri.inserisci(false);
                this.append("vda manutenzioni inserita");
            } else {
                this.append("vda manutenzioni selezionata");
            }
            this.r_man_altri = new Regola();
            w = " WHERE idregole=" + this.vda_man_altri.getId_regola_predefinita() + " ";
            this.r_man_altri.seleziona(w);
            this.r_man_altri.seleziona_dettagli();
            Configurazioni.getIstanza();
            if (Configurazioni.hm.get("voce_di_analisi_viaggi_terzi").equals("")) {
                this.append("Creare una voce di analisi per i viaggi dei vettori chiamata: VIAGGI TERZI  Creare nel file di configurazioni la seguente riga:'voce_di_analisi_viaggi_terzi = VIAGGI TERZI'");
                Configurazioni.getIstanza().connessione.rollback();
                return false;
            }
            this.vda_viaggi_vettori = new VoceDiAnalisi();
            StringBuilder stringBuilder9 = new StringBuilder().append(" WHERE descrizione_voce='");
            Configurazioni.getIstanza();
            this.vda_viaggi_vettori.seleziona(stringBuilder9.append(Configurazioni.hm.get("voce_di_analisi_viaggi_terzi")).append("'").toString());
            if (this.vda_viaggi_vettori.getIdvoci_di_analisi() == 0) {
                this.append("vda viaggi vettori non trovata, la inserisco");
                this.vda_viaggi_vettori = new VoceDiAnalisi();
                Configurazioni.getIstanza();
                this.vda_viaggi_vettori.setDescrizione_voce(Configurazioni.hm.get("voce_di_analisi_viaggi_terzi"));
                this.vda_viaggi_vettori.setTipo("costo");
                this.vda_viaggi_vettori.setDiretto(1);
                this.vda_viaggi_vettori.setId_regola_predefinita(this.r_casa_spedizioni.getId_regola());
                this.vda_viaggi_vettori.setNome_regola(this.r_casa_spedizioni.getNome());
                this.vda_viaggi_vettori.setReg(this.r_casa_spedizioni);
                this.vda_viaggi_vettori.inserisci(false);
                this.append("vda viaggi vettori inserita");
            } else {
                this.append("vda viaggi vettori selezionata");
            }
            this.append("costruzione ambiente trasporti riuscita");
            this.append("STOP ** MODULO TRASPORTI **  AMBIENTE");
            return true;
        }
        catch (Exception e) {
            this.append("ATTENZIONE RISCONTRATO PROBLEMA NELLA CREAZIONE DELL'AMBIENTE TRASPORTI");
            MyTrace.log.severe("ECCEZIONE su Regola.inserisci() ECCEZIONE:[" + e + "]");
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            return false;
        }
    }

    public boolean trasporti_fase_03_esporta_gasolio() {
        this.append("START ** MODULO TRASPORTI **  ESPORTA GASOLIO");
        boolean res_tot = false;
        try {
            InsiemeCaricoGasolio insiemeCaricoGasolio = new InsiemeCaricoGasolio();
            String where = " WHERE mtra_gasolio.targa!='0'";
            insiemeCaricoGasolio.caricamento_analitica(where, "");
            InsiemeAnalitica insieme_analitica = new InsiemeAnalitica();
            int size = insieme_analitica.caricamento(" WHERE tabella_origine='mtra_gasolio' ", "");
            for (CaricoGasolio carico : insiemeCaricoGasolio.vettoreGasolio) {
                boolean res_ins = true;
                InsiemeAnalitica insieme_record_trovati = insieme_analitica.cerca_record_analitica(carico.getId(), "mtra_gasolio");
                if (insieme_record_trovati.vettoreAnalitica.isEmpty()) {
                    MyTrace.log.info("RECORD NON PRESENTRE IN ANALITICA, LO INSERISCO");
                    res_tot = this.costruisci_e_inserisci_analitica(carico);
                    if (!res_tot) {
                        Configurazioni.getIstanza().connessione.rollback();
                        this.append("NON POSSO INSERIRE UN NUOVO RECORD IN CTRL_ANALITICA!!!!");
                        return false;
                    }
                } else {
                    boolean res;
                    Regola r = new Regola();
                    r = carico.getId_centro_di_responsabilita() != 0 ? this.insiemeRegole.cerca_regola_diretta(carico.getId_centro_di_responsabilita(), carico.getTarga()) : this.r_gasolio_altri;
                    Analitica prima = (Analitica)insieme_record_trovati.vettoreAnalitica.elementAt(0);
                    MyTrace.log.info("LA REGOLA MEMORIZZATA E'=" + prima.getId_regola());
                    MyTrace.log.info("LA REGOLA ATTUALE'=" + r.getId_regola());
                    if (prima.getId_regola() == r.getId_regola() || prima.getId_regola() == 0) {
                        MyTrace.log.info("STESSA REGOLA, MODIFICO");
                        for (Analitica a : insieme_record_trovati.vettoreAnalitica) {
                            a.setData_dal(carico.getData_movimento());
                            a.setData_al(carico.getData_movimento());
                            a.setImporto(carico.ultimo_costo_acquisto(carico.getData_movimento()).multiply(carico.getQuantita().getAmount()).times(a.getRapporto()).negate());
                            if (prima.getId_regola() == 0) {
                                a.setId_regola(r.getId_regola());
                            }
                            if (res = a.modifica(false)) continue;
                            Configurazioni.getIstanza().connessione.rollback();
                            this.append("NON POSSO MODIFICARE UN RECORD IN CTRL_ANALITICA!!!!");
                            return false;
                        }
                    } else {
                        MyTrace.log.info("LA REGOLA E' CAMBIATA");
                        for (Analitica a : insieme_record_trovati.vettoreAnalitica) {
                            res = a.elimina(false, where = " WHERE idanalitica=" + a.getIdanalitica() + "");
                            if (res) continue;
                            Configurazioni.getIstanza().connessione.rollback();
                            this.append("NON POSSO eliminare UN  RECORD IN CTRL_ANALITICA!!!!");
                            return false;
                        }
                        res_tot = this.costruisci_e_inserisci_analitica(carico);
                        if (!res_tot) {
                            Configurazioni.getIstanza().connessione.rollback();
                            this.append("NON POSSO INSERIRE UN NUOVO RECORD IN CTRL_ANALITICA!!!!");
                            return false;
                        }
                    }
                }
                if (res_ins) continue;
                Configurazioni.getIstanza().connessione.rollback();
                this.append("NON SONO RIUSCITO A INSERIRE NELL'ANALITICA UN CARICO GASOLIO ");
                return false;
            }
        }
        catch (Exception e) {
            MyTrace.log.severe("ECCEZIONE su MyEsportazione.analitica_gasolio() ECCEZIONE:[" + e + "]");
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            Configurazioni.getIstanza().connessione.rollback();
            this.append("ECCEZIONE su MyEsportazione.analitica_gasolio() ECCEZIONE:[" + e + "] ");
            return false;
        }
        this.append("TABELLA CTRL_ANALITICA RIEMPITA CORRETTAMENTE DI GASOLIO ");
        this.append("STOP ** MODULO TRASPORTI **  ESPORTA GASOLIO");
        return true;
    }

    private boolean costruisci_e_inserisci_analitica(CaricoGasolio carico) {
        boolean resTot = true;
        try {
            if (carico.getId_centro_di_responsabilita() == 0) {
                for (RegolaOperativa ro : this.r_gasolio_altri.getInsieme_ro().vettoreRegoleOperative) {
                    Analitica a = new Analitica();
                    a.setData_dal(carico.getData_movimento());
                    a.setData_al(carico.getData_movimento());
                    a.setId_centro_di_responsabilita(ro.getId_centri_di_responsabilita());
                    a.setImporto(carico.ultimo_costo_acquisto(carico.getData_movimento()).multiply(carico.quantita).times(ro.getQuota()).div(this.r_gasolio_altri.getTotale()).negate());
                    a.setId_vda(this.vda_gasolio_altri.getIdvoci_di_analisi());
                    a.setRapporto((double)ro.getQuota() / (double)this.r_gasolio_altri.getTotale());
                    a.setTabella_origine("mtra_gasolio");
                    a.setId_tabella_origine(carico.getId());
                    a.setId_regola(this.r_gasolio_altri.getId_regola());
                    resTot = a.inserisci(false);
                }
            } else {
                Regola r = this.insiemeRegole.cerca_regola_diretta(carico.getId_centro_di_responsabilita(), carico.getTarga());
                Analitica a = new Analitica();
                a.setData_dal(carico.getData_movimento());
                a.setData_al(carico.getData_movimento());
                a.setId_centro_di_responsabilita(carico.getId_centro_di_responsabilita());
                a.setImporto(carico.ultimo_costo_acquisto(carico.getData_movimento()).multiply(carico.getQuantita()).negate());
                a.setId_vda(this.vda_gasolio.getIdvoci_di_analisi());
                a.setRapporto(1.0);
                a.setTabella_origine("mtra_gasolio");
                a.setId_tabella_origine(carico.getId());
                a.setId_regola(r.getId_regola());
                resTot = a.inserisci(false);
            }
        }
        catch (Exception e) {
            MyTrace.log.severe("ECCEZIONE su inserimento ctrl_analitica sembra non esistere il centro di responsabilit\u00e0");
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            return false;
        }
        return resTot;
    }

    public boolean trasporti_fase_03_esporta_manutenzioni() {
        this.append("START ** MODULO TRASPORTI **  ESPORTA MANUTENZIONI");
        boolean res_tot = false;
        try {
            InsiemeManutenzioni insiemeManutenzioni = new InsiemeManutenzioni();
            String where = " WHERE mtra_manutenzioni.eseguita=1 ";
            insiemeManutenzioni.caricamento_analitica(where, "");
            InsiemeAnalitica insieme_analitica = new InsiemeAnalitica();
            int size = insieme_analitica.caricamento(" WHERE tabella_origine='mtra_manutenzioni' ", "");
            for (Manutenzione man : insiemeManutenzioni.vettoreManutenzioni) {
                boolean res_ins = true;
                InsiemeAnalitica insieme_record_trovati = insieme_analitica.cerca_record_analitica(man.getIdManutenzione(), "mtra_manutenzioni");
                if (insieme_record_trovati.vettoreAnalitica.isEmpty()) {
                    MyTrace.log.info("RECORD NON PRESENTRE IN ANALITICA, LO INSERISCO");
                    res_tot = this.costruisci_e_inserisci_analitica(man);
                    if (!res_tot) {
                        Configurazioni.getIstanza().connessione.rollback();
                        this.append("NON POSSO INSERIRE UN NUOVO RECORD IN CTRL_ANALITICA!!!!");
                        return false;
                    }
                } else {
                    boolean res;
                    Regola r = new Regola();
                    r = man.getId_centro_responsabilita() != 0 ? this.insiemeRegole.cerca_regola_diretta(man.getId_centro_responsabilita(), man.getTarga()) : this.r_man_altri;
                    Analitica prima = (Analitica)insieme_record_trovati.vettoreAnalitica.elementAt(0);
                    MyTrace.log.info("LA REGOLA MEMORIZZATA E'=" + prima.getId_regola());
                    MyTrace.log.info("LA REGOLA ATTUALE'=" + r.getId_regola());
                    if (prima.getId_regola() == r.getId_regola() || prima.getId_regola() == 0) {
                        MyTrace.log.info("STESSA REGOLA, MODIFICO");
                        for (Analitica a : insieme_record_trovati.vettoreAnalitica) {
                            a.setData_dal(man.getData());
                            a.setData_al(man.getData());
                            a.setImporto(man.getCosto_totale().times(a.getRapporto()));
                            if (prima.getId_regola() == 0) {
                                a.setId_regola(r.getId_regola());
                            }
                            if (res = a.modifica(false)) continue;
                            Configurazioni.getIstanza().connessione.rollback();
                            this.append("NON POSSO MODIFICARE UN RECORD IN CTRL_ANALITICA!!!!");
                            return false;
                        }
                    } else {
                        MyTrace.log.info("LA REGOLA E' CAMBIATA");
                        for (Analitica a : insieme_record_trovati.vettoreAnalitica) {
                            res = a.elimina(false, where = " WHERE idanalitica=" + a.getIdanalitica() + "");
                            if (res) continue;
                            Configurazioni.getIstanza().connessione.rollback();
                            this.append("NON POSSO eliminare UN  RECORD IN CTRL_ANALITICA!!!!");
                            return false;
                        }
                        res_tot = this.costruisci_e_inserisci_analitica(man);
                        if (!res_tot) {
                            Configurazioni.getIstanza().connessione.rollback();
                            this.append("NON POSSO INSERIRE UN NUOVO RECORD IN CTRL_ANALITICA!!!!");
                            return false;
                        }
                    }
                }
                if (res_ins) continue;
                Configurazioni.getIstanza().connessione.rollback();
                this.append("NON SONO RIUSCITO A INSERIRE NELL'ANALITICA UNA MANUTENZIONE ");
                return false;
            }
        }
        catch (Exception e) {
            MyTrace.log.severe("ECCEZIONE su MyEsportazione.analitica_gasolio() ECCEZIONE:[" + e + "]");
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            Configurazioni.getIstanza().connessione.rollback();
            this.append("ECCEZIONE su MyEsportazione.analitica_manutenzioni ECCEZIONE:[" + e + "] ");
            return false;
        }
        this.append("TABELLA CTRL_ANALITICA RIEMPITA CORRETTAMENTE DI manutenzioni ");
        this.append("STOP ** MODULO TRASPORTI **  ESPORTA MANUTENZIONI");
        return true;
    }

    private boolean costruisci_e_inserisci_analitica(Manutenzione man) {
        boolean resTot = true;
        if (man.getId_centro_responsabilita() == 0) {
            for (RegolaOperativa ro : this.r_man_altri.getInsieme_ro().vettoreRegoleOperative) {
                Analitica a = new Analitica();
                a.setData_dal(man.getData());
                a.setData_al(man.getData());
                a.setId_centro_di_responsabilita(ro.getId_centri_di_responsabilita());
                a.setImporto(man.getCosto_totale().times(ro.getQuota()).div(this.r_man_altri.getTotale()));
                a.setId_vda(this.vda_man_altri.getIdvoci_di_analisi());
                a.setRapporto((double)ro.getQuota() / (double)this.r_man_altri.getTotale());
                a.setTabella_origine("mtra_manutenzioni");
                a.setId_tabella_origine(man.getIdManutenzione());
                a.setId_regola(this.r_man_altri.getId_regola());
                resTot = a.inserisci(false);
            }
        } else {
            Regola r = this.insiemeRegole.cerca_regola_diretta(man.getId_centro_responsabilita(), man.getTarga());
            Analitica a = new Analitica();
            a.setData_dal(man.getData());
            a.setData_al(man.getData());
            a.setId_centro_di_responsabilita(man.getId_centro_responsabilita());
            a.setImporto(man.getCosto_previsto());
            a.setId_vda(this.vda_man.getIdvoci_di_analisi());
            a.setRapporto(1.0);
            a.setTabella_origine("mtra_manutenzioni");
            a.setId_tabella_origine(man.getIdManutenzione());
            a.setId_regola(r.getId_regola());
            resTot = a.inserisci(false);
        }
        return resTot;
    }

    public boolean trasporti_fase_03_esporta_viaggi_terzi() {
        this.append("START ** MODULO TRASPORTI **  ESPORTA VIAGGI TERZI");
        boolean res_tot = false;
        try {
            InsiemeViaggiFornitore insieme_viaggi = new InsiemeViaggiFornitore();
            String where = " WHERE mtra_viaggi.id_anagrafica is not null ";
            insieme_viaggi.caricamento_viaggi(where, "");
            InsiemeAnalitica insieme_analitica = new InsiemeAnalitica();
            int size = insieme_analitica.caricamento(" WHERE tabella_origine='mtra_viaggi' ", "");
            for (ViaggiFornitore viaggio : insieme_viaggi.list) {
                boolean res_ins = true;
                InsiemeAnalitica insieme_record_trovati = insieme_analitica.cerca_record_analitica(viaggio.getId_viaggio(), "mtra_viaggi");
                if (insieme_record_trovati.vettoreAnalitica.isEmpty()) {
                    MyTrace.log.info("RECORD NON PRESENTRE IN ANALITICA, LO INSERISCO");
                    res_tot = this.costruisci_e_inserisci_analitica(viaggio);
                    if (!res_tot) {
                        Configurazioni.getIstanza().connessione.rollback();
                        this.append("NON POSSO INSERIRE UN NUOVO RECORD IN CTRL_ANALITICA!!!!");
                        return false;
                    }
                } else {
                    boolean res;
                    Analitica prima = (Analitica)insieme_record_trovati.vettoreAnalitica.elementAt(0);
                    MyTrace.log.info("LA REGOLA MEMORIZZATA E'=" + prima.getId_regola());
                    MyTrace.log.info("LA REGOLA ATTUALE'=" + this.r_casa_spedizioni.getId_regola());
                    if (prima.getId_regola() == this.r_casa_spedizioni.getId_regola() || prima.getId_regola() == 0) {
                        MyTrace.log.info("STESSA REGOLA, MODIFICO");
                        for (Analitica a : insieme_record_trovati.vettoreAnalitica) {
                            a.setData_dal(viaggio.getData_partenza());
                            if (viaggio.getData_arrivo() == null || viaggio.getData_arrivo().equals("") || viaggio.getData_arrivo().equals("0000-00-00")) {
                                a.setData_al(viaggio.getData_partenza());
                            } else {
                                a.setData_al(viaggio.getData_arrivo());
                            }
                            a.setImporto(viaggio.getPrezzo_for().times(a.getRapporto()));
                            if (prima.getId_regola() == 0) {
                                a.setId_regola(this.r_casa_spedizioni.getId_regola());
                            }
                            if (res = a.modifica(false)) continue;
                            Configurazioni.getIstanza().connessione.rollback();
                            this.append("NON POSSO MODIFICARE UN RECORD IN CTRL_ANALITICA!!!!");
                            return false;
                        }
                    } else {
                        MyTrace.log.info("LA REGOLA E' CAMBIATA");
                        for (Analitica a : insieme_record_trovati.vettoreAnalitica) {
                            res = a.elimina(false, where = " WHERE idanalitica=" + a.getIdanalitica() + "");
                            if (res) continue;
                            Configurazioni.getIstanza().connessione.rollback();
                            this.append("NON POSSO eliminare UN  RECORD IN CTRL_ANALITICA!!!!");
                            return false;
                        }
                        res_tot = this.costruisci_e_inserisci_analitica(viaggio);
                        if (!res_tot) {
                            Configurazioni.getIstanza().connessione.rollback();
                            this.append("NON POSSO INSERIRE UN NUOVO RECORD IN CTRL_ANALITICA!!!!");
                            return false;
                        }
                    }
                }
                if (res_ins) continue;
                Configurazioni.getIstanza().connessione.rollback();
                this.append("NON SONO RIUSCITO A INSERIRE NELL'ANALITICA UN VIAGGIO TERZI ");
                return false;
            }
        }
        catch (Exception e) {
            MyTrace.log.severe("ECCEZIONE su MyEsportazione.esporta_viaggi_terzi() ECCEZIONE:[" + e + "]");
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            Configurazioni.getIstanza().connessione.rollback();
            this.append("ECCEZIONE su MyEsportazione.esporta_viaggi_terzi() ECCEZIONE:[" + e + "] ");
            return false;
        }
        this.append("TABELLA CTRL_ANALITICA RIEMPITA CORRETTAMENTE DI viaggi terzi  ");
        this.append("STOP ** MODULO TRASPORTI **  ESPORTA VIAGGI TERZI");
        return true;
    }

    private boolean costruisci_e_inserisci_analitica(ViaggiFornitore viaggio) {
        boolean resTot = true;
        for (RegolaOperativa ro : this.r_casa_spedizioni.getInsieme_ro().vettoreRegoleOperative) {
            Analitica a = new Analitica();
            a.setData_dal(viaggio.getData_partenza());
            if (viaggio.getData_arrivo() == null || viaggio.getData_arrivo().equals("") || viaggio.getData_arrivo().equals("0000-00-00")) {
                a.setData_al(viaggio.getData_partenza());
            } else {
                a.setData_al(viaggio.getData_arrivo());
            }
            a.setId_centro_di_responsabilita(ro.getId_centri_di_responsabilita());
            a.setImporto(viaggio.getPrezzo_for().times(ro.getQuota()).div(this.r_casa_spedizioni.getTotale()));
            a.setId_vda(this.vda_viaggi_vettori.getIdvoci_di_analisi());
            a.setRapporto((double)ro.getQuota() / (double)this.r_casa_spedizioni.getTotale());
            a.setTabella_origine("mtra_viaggi");
            a.setId_tabella_origine(viaggio.getId_viaggio());
            a.setId_regola(this.r_casa_spedizioni.getId_regola());
            resTot = a.inserisci(false);
        }
        return resTot;
    }

    public boolean trasporti_fase_04_esporta_fatturato_ordini(Task task) {
        this.append("START ** MODULO TRASPORTI **  ESPORTA FATTURATO ORDINI");
        try {
            String where = " WHERE mtra_ordini_viaggi_righe.idRiga is not null ";
            String order_by = "";
            InsiemeOrdini insieme_o = new InsiemeOrdini();
            task.settaAvanzamento(53);
            this.append("caricato insieme ordini");
            insieme_o.caricamento_analitica(where, order_by);
            task.settaAvanzamento(55);
            this.append("caricata analitica ordini");
            InsiemeAnalitica insieme_analitica = new InsiemeAnalitica();
            int size = insieme_analitica.caricamento(" WHERE tabella_origine='mtra_ordini' ", "");
            task.settaAvanzamento(57);
            this.append("creato insieme analitica");
            if (size != 0) {
                for (Analitica a : insieme_analitica.vettoreAnalitica) {
                    a.elimina(false, " WHERE idanalitica=" + a.getIdanalitica());
                }
            }
            task.settaAvanzamento(60);
            this.append("eliminati in analitica i vecchi record");
            Iterator i_g = insieme_o.vettoreO.iterator();
            long numero_righe = insieme_o.vettoreO.size();
            double passo = 40.0 / (double)numero_righe;
            this.append("Numero Ordini = " + numero_righe);
            while (i_g.hasNext()) {
                task.settaAvanzamento((int)(100.0 - passo * (double)(--numero_righe)));
                Ordine o = (Ordine)i_g.next();
                try {
                    boolean res = true;
                    if (o.getInsieme_viaggi() == null || o.getInsieme_viaggi().vettoreV.isEmpty()) {
                        MyTrace.log.severe("ANOMALIA Riga fattura senza viaggio... la assegno a REGOLA 0");
                        for (RegolaOperativa ro : this.r_0.getInsieme_ro().vettoreRegoleOperative) {
                            Analitica a = new Analitica();
                            a.setData_dal(o.getData_ordine());
                            a.setData_al(o.getData_ordine());
                            a.setId_centro_di_responsabilita(ro.getId_centri_di_responsabilita());
                            a.setImporto(o.getPrezzo().times(ro.getQuota()).div(this.r_0.getTotale()));
                            a.setId_vda(this.vda_fatturato.getIdvoci_di_analisi());
                            a.setRapporto((double)ro.getQuota() / (double)this.r_0.getTotale());
                            a.setTabella_origine("mtra_ordini");
                            a.setId_tabella_origine(o.getId());
                            a.setId_regola(this.r_0.getId_regola());
                            res = a.inserisci(false);
                        }
                        continue;
                    }
                    boolean set_importo_b = false;
                    Regola r = new Regola();
                    String data_competenza_da = o.getData_ordine();
                    String data_competenza_a = o.getData_ordine();
                    if (o.getInsieme_viaggi().vettoreV.size() == 1) {
                        Viaggio v_unico = (Viaggio)o.getInsieme_viaggi().vettoreV.elementAt(0);
                        if (v_unico.getId_trattore() != 0) {
                            r = this.insiemeRegole.cerca_regola_diretta(v_unico.getId_cdr_trattore(), v_unico.getTarga_trattore());
                            if (v_unico.getKm_percorsi() == 0.0) {
                                set_importo_b = true;
                            }
                        } else {
                            r = this.r_casa_spedizioni;
                        }
                    } else {
                        r.setNome("VIAGGIO DA DIVIDERE");
                        r.setInsieme_ro(new InsiemeRegoleOperative());
                        int somma_km = 0;
                        Vector<Double> km = new Vector<Double>();
                        for (Viaggio v : o.getInsieme_viaggi().vettoreV) {
                            somma_km = (int)((double)somma_km + v.getKm_percorsi());
                            km.add(v.getKm_percorsi());
                        }
                        r.setKm_percorsi_tot(somma_km);
                        Iterator i = o.getInsieme_viaggi().vettoreV.iterator();
                        int somma_km_assegnati = 0;
                        while (i.hasNext()) {
                            Viaggio v = (Viaggio)i.next();
                            if (v.getData_partenza() != null && this.fda.data1maggiore(data_competenza_da, v.getData_partenza()) == 1 && !v.getData_partenza().equals("0000-00-00")) {
                                data_competenza_da = v.getData_partenza();
                            }
                            if (v.getData_arrivo() != null && this.fda.data1maggiore(v.getData_arrivo(), data_competenza_a) == 1 && !v.getData_arrivo().equals("0000-00-00")) {
                                data_competenza_a = v.getData_arrivo();
                            }
                            RegolaOperativa ro = new RegolaOperativa();
                            ro.setAttivo(1);
                            if (v.getId_trattore() != 0) {
                                ro.setCdr(v.getTarga_trattore());
                                ro.setId_centri_di_responsabilita(v.getId_cdr_trattore());
                                ro.setQuota((int)v.getKm_percorsi());
                                somma_km_assegnati = (int)((double)somma_km_assegnati + v.getKm_percorsi());
                            } else {
                                ro.setCdr(this.cdr_casa_spedizioni.getCentro_di_responsabilita());
                                ro.setId_centri_di_responsabilita(this.cdr_casa_spedizioni.getIdcentri_di_responsabilita());
                                if (somma_km == 0) {
                                    somma_km = 100;
                                }
                                ro.setQuota(somma_km);
                                somma_km_assegnati += somma_km;
                            }
                            r.getInsieme_ro().vettoreRegoleOperative.add(ro);
                        }
                        r.setTotale(somma_km_assegnati);
                    }
                    for (RegolaOperativa ro : r.getInsieme_ro().vettoreRegoleOperative) {
                        if (ro.getQuota() == 0) continue;
                        Analitica a = new Analitica();
                        a.setData_dal(data_competenza_da);
                        a.setData_al(data_competenza_a);
                        a.setId_vda(this.vda_fatturato.getIdvoci_di_analisi());
                        a.setTabella_origine("mtra_ordini");
                        a.setId_tabella_origine(o.getId());
                        a.setId_centro_di_responsabilita(ro.getId_centri_di_responsabilita());
                        if (!set_importo_b) {
                            a.setImporto(o.getPrezzo().times(ro.getQuota()).div(r.getTotale()));
                        }
                        a.setRapporto(ro.getQuota() / r.getTotale());
                        res = a.inserisci(false);
                    }
                    if (res) continue;
                    Configurazioni.getIstanza().connessione.rollback();
                    this.append("NON POSSO INSERIRE UN NUOVO RECORD IN CTRL_ANALITICA!!!!");
                    return false;
                }
                catch (Exception e) {
                    MyTrace.log.severe("ECCEZIONE su di un record Trasporti per N\u00b0ordine =" + o.getN_ordine());
                    this.append("ECCEZIONE su di un record Trasporti per N\u00b0ordine =" + o.getN_ordine());
                    this.append("VERIFICARE che ai centri di responsabilit\u00e0 siano state assegnate le regole di ripartizione");
                    this.append("(probabilmente all'interno del modulo trasporti ai Trattori)");
                }
            }
        }
        catch (Exception e) {
            MyTrace.log.severe("ECCEZIONE su MyEsportazione fatturato attivo ECCEZIONE:[" + e + "]");
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            Configurazioni.getIstanza().connessione.rollback();
            this.append("ECCEZIONE su MyEsportazione fatturato attivo ECCEZIONE:[" + e + "]");
            return false;
        }
        this.append("TABELLA CTRL_ANALITICA RIEMPITA CORRETTAMENTE DI FATTURATO ATTIVO  ");
        this.append("STOP ** MODULO TRASPORTI **  ESPORTA FATTURATO ORDINI");
        return true;
    }

    public boolean trasporti_fase_05_esporta_produzione(InsiemeVariabili insiemeVariabili) {
        this.append("START ** MODULO TRASPORTI **  ESPORTA PRODUZIONE");
        boolean res_tot = false;
        try {
            InsiemeViaggi insieme_v = new InsiemeViaggi();
            int res = insieme_v.caricamento("where 1 ", "", false);
            for (Viaggio viaggio : insieme_v.vettoreV) {
                AnaliticaOperativaVariabili aov = new AnaliticaOperativaVariabili();
                aov.setInsiemeVariabili(insiemeVariabili);
                String da = "0000-00-00";
                if (viaggio.getData_partenza() != null) {
                    da = viaggio.getData_partenza();
                }
                aov.setData_dal(da);
                String d_al = "0000-00-00";
                d_al = viaggio.getData_arrivo() == null || viaggio.getData_arrivo().equals("") || viaggio.getData_arrivo().equals("0000-00-00") ? da : viaggio.getData_arrivo();
                aov.setData_al(d_al);
                if (viaggio.getId_avettore() != 0) {
                    aov.setId_centro_di_responsabilita(this.cdr_casa_spedizioni.getIdcentri_di_responsabilita());
                    aov.getQuantita().add(1.0);
                    aov.getQuantita().add(0.0);
                    aov.getQuantita().add(0.0);
                } else {
                    aov.setId_centro_di_responsabilita(viaggio.getId_cdr_trattore());
                    aov.getQuantita().add(1.0);
                    aov.getQuantita().add(viaggio.getKm_percorsi());
                    aov.getQuantita().add(viaggio.getKm_a_vuoto());
                }
                if (aov.getId_centro_di_responsabilita() == 0) continue;
                aov.inserisci(false);
            }
        }
        catch (Exception e) {
            MyTrace.log.severe("ECCEZIONE su esporta_produzione ECCEZIONE:[" + e + "]");
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            Configurazioni.getIstanza().connessione.rollback();
            this.append("ECCEZIONE su esporta_produzione ECCEZIONE:[" + e + "] ");
            return false;
        }
        this.append("TABELLA CTRL_ANALITICA OPERATIVA ");
        this.append("STOP ** MODULO TRASPORTI **  ESPORTA PRODUZIONE");
        return true;
    }
}

