/*
 * Decompiled with CFR 0.152.
 */
package magazzino.movimenti;

import gestionale.documenti.RigaDocumento;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.table.AbstractTableModel;
import magazzino.listini.PrezzoListino;
import magazzino.movimenti.MovimentoMagazzino;
import utils.Funzioni;
import utils.FunzioniDate;
import utils.Money;
import utils.Quantita;

public class MovimentoMagazzinoTableModel
extends AbstractTableModel {
    ArrayList<MovimentoMagazzino> cache;
    int colCount;
    String[] headers;
    boolean modo_ric = false;
    Funzioni f = new Funzioni();
    FunzioniDate fda = new FunzioniDate();

    public MovimentoMagazzinoTableModel() {
        this.cache = new ArrayList();
    }

    public void setModo_ric(boolean modo_ric) {
        this.modo_ric = modo_ric;
    }

    @Override
    public String getColumnName(int i) {
        String retVal = "";
        switch (i) {
            case 0: {
                retVal = "Codice Articolo";
                break;
            }
            case 1: {
                retVal = "Descrizione";
                break;
            }
            case 2: {
                retVal = "Causale";
                break;
            }
            case 3: {
                retVal = "Unit\u00e0 di misura";
                break;
            }
            case 4: {
                retVal = "Quantit\u00e0";
                break;
            }
            case 5: {
                retVal = "Quantit\u00e0 da Fatturare";
                break;
            }
            case 6: {
                retVal = "Quantit\u00e0 in transito";
                break;
            }
            case 7: {
                retVal = "Costo di acquisto";
                break;
            }
            default: {
                retVal = this.headers[i];
            }
        }
        return retVal;
    }

    @Override
    public int getRowCount() {
        return this.cache.size();
    }

    @Override
    public int getColumnCount() {
        return 8;
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (!this.cache.isEmpty()) {
            MovimentoMagazzino om = this.cache.get(row);
            return om.getColValue(col);
        }
        return "";
    }

    public Class getColumnClass(int c) {
        return this.getValueAt(0, c).getClass();
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        MovimentoMagazzino om = this.cache.get(row);
        if (col == 0) {
            if (!om.getA().getCodice_articolo().equals(value.toString())) {
                om.getA().setCodice_articolo(value.toString());
                String w = " WHERE codice_articolo='" + value.toString() + "'";
                om.getA().seleziona(w);
            }
            om.setId_articolo(om.getA().getId());
            om.getA().seleziona_prezzi();
            if (om.getA().getInsieme_pl() != null && !om.getA().getInsieme_pl().vettorePL.isEmpty()) {
                boolean trovato = false;
                if (om.getId_listino_appoggio() != 0) {
                    Iterator<PrezzoListino> i = om.getA().getInsieme_pl().vettorePL.iterator();
                    while (i.hasNext() && !trovato) {
                        PrezzoListino pl = i.next();
                        if (pl.getId_listino() != om.getId_listino_appoggio()) continue;
                        trovato = true;
                        om.setCosto_di_acquisto(pl.getPrezzo_listino());
                    }
                }
                if (!trovato) {
                    om.setCosto_di_acquisto(om.getA().getPl().getPrezzo_listino());
                }
            }
        }
        if (col == 4) {
            om.setQ_magazzino(new Quantita(value.toString()));
            if (om.getId_causale_movimento() == 14 || om.getId_causale_movimento() == 15) {
                om.setQ_da_fatturare(new Quantita(value.toString()));
            }
        }
        if (col == 5) {
            if (om.getId_causale_movimento() == 13 || om.getId_causale_movimento() == 12 || om.getId_causale_movimento() == 8 || om.getId_causale_movimento() == 14 || om.getId_causale_movimento() == 15) {
                om.setQ_da_fatturare(new Quantita(value.toString()));
            } else {
                om.setQ_da_fatturare_out(new Quantita(value.toString()));
            }
        }
        if (col == 6) {
            if (om.getId_causale_movimento() == 11 || om.getId_causale_movimento() == 13 || om.getId_causale_movimento() == 14 || om.getId_causale_movimento() == 15) {
                om.setQ_arrivo(new Quantita(value.toString()));
            } else {
                om.setQ_uscita(new Quantita(value.toString()));
            }
        }
        if (col == 7) {
            om.setCosto_di_acquisto(new Money(value.toString()));
        }
        this.fireTableRowsUpdated(row, row);
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col == 0 || col == 4 || col == 7;
    }

    public void setDataMagazzino(ArrayList<MovimentoMagazzino> vettoreOM) {
        this.cache = new ArrayList();
        for (MovimentoMagazzino om : vettoreOM) {
            this.cache.add(om);
        }
        this.fireTableChanged(null);
    }

    public void setDataMagazzinoRDoc(ArrayList<RigaDocumento> vettoreR) {
        this.cache = new ArrayList();
        for (RigaDocumento r : vettoreR) {
            for (MovimentoMagazzino om : r.getInsieme_om().vettoreOM) {
                this.cache.add(om);
            }
        }
        this.fireTableChanged(null);
    }
}

