/*
 * Decompiled with CFR 0.152.
 */
package magazzino.movimenti;

import gestionale.MyDesktopWindow;
import gestionale.configurazioni.Configurazioni;
import java.math.BigDecimal;
import java.sql.ResultSet;
import magazzino.articoli.Articolo;
import utils.Funzioni;
import utils.FunzioniDate;
import utils.Money;
import utils.MyTrace;
import utils.Quantita;

public class MovimentoMagazzino {
    int id;
    int id_articolo;
    int id_causale_movimento;
    int id_registro_in;
    int id_registro_f_in;
    int id_riga_doc_out;
    int id_riga_f_out;
    int id_registro_nc_out;
    int id_riga_nc_in;
    int id_ordine_cli;
    int id_ordine_for;
    int id_produzione;
    int id_listino_appoggio;
    int rapporto;
    Quantita q_uscita = new Quantita(BigDecimal.ZERO);
    Quantita q_arrivo = new Quantita(BigDecimal.ZERO);
    Quantita q_magazzino = new Quantita(BigDecimal.ZERO);
    Quantita q_da_fatturare = new Quantita(BigDecimal.ZERO);
    Quantita q_da_fatturare_out = new Quantita(BigDecimal.ZERO);
    Articolo a = new Articolo();
    Money costo_di_acquisto = new Money(BigDecimal.ZERO);
    String data_movimento;
    String descrizione_causale;
    String codice_causale;
    String rs_anagrafica;
    String codice_anagrafica;
    String string_ordine_for;
    String string_ddt_for;
    String string_ddt_cli;
    String string_ordine_cli = "";
    String string_f_for;
    String string_produzione;
    String string_f_cli;
    String string_nc_out;
    String string_nc_in;
    FunzioniDate fda = new FunzioniDate();
    Funzioni f = new Funzioni();

    public Money getCosto_di_acquisto() {
        return this.costo_di_acquisto;
    }

    public void setCosto_di_acquisto(Money costo_di_acquisto) {
        this.costo_di_acquisto = costo_di_acquisto;
    }

    public String getData_movimento() {
        return this.data_movimento;
    }

    public String getData_movimento_it() {
        return this.fda.gira_data(this.data_movimento);
    }

    public void setData_movimento(String data_acquisto) {
        this.data_movimento = data_acquisto;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getId_articolo() {
        return this.id_articolo;
    }

    public void setId_articolo(int id_articolo) {
        this.id_articolo = id_articolo;
    }

    public int getId_causale_movimento() {
        return this.id_causale_movimento;
    }

    public void setId_causale_movimento(int id_causale_movimento) {
        this.id_causale_movimento = id_causale_movimento;
    }

    public int getId_registro_in() {
        return this.id_registro_in;
    }

    public void setId_registro_in(int id_registro) {
        this.id_registro_in = id_registro;
    }

    public int getId_riga_doc_out() {
        return this.id_riga_doc_out;
    }

    public void setId_riga_doc_out(int id_riga_doc_out) {
        this.id_riga_doc_out = id_riga_doc_out;
    }

    public int getId_listino_appoggio() {
        return this.id_listino_appoggio;
    }

    public void setId_listino_appoggio(int id_listino_appoggio) {
        this.id_listino_appoggio = id_listino_appoggio;
    }

    public Quantita getQ_uscita() {
        return this.q_uscita;
    }

    public void setQ_uscita(Quantita q_uscita) {
        this.q_uscita = q_uscita;
    }

    public Quantita getQ_magazzino() {
        return this.q_magazzino;
    }

    public void setQ_magazzino(Quantita q_magazzino) {
        this.q_magazzino = q_magazzino;
    }

    public Quantita getQ_da_fatturare() {
        return this.q_da_fatturare;
    }

    public void setQ_da_fatturare(Quantita q_da_fatturare) {
        this.q_da_fatturare = q_da_fatturare;
    }

    public Articolo getA() {
        return this.a;
    }

    public void setA(Articolo a) {
        this.a = a;
    }

    public String getDescrizione_causale() {
        return this.descrizione_causale;
    }

    public void setDescrizione_causale(String descrizione_causale) {
        this.descrizione_causale = descrizione_causale;
    }

    public String getCodice_causale() {
        return this.codice_causale;
    }

    public void setCodice_causale(String codice_causale) {
        this.codice_causale = codice_causale;
    }

    public Quantita getQ_arrivo() {
        return this.q_arrivo;
    }

    public void setQ_arrivo(Quantita q_arrivo) {
        this.q_arrivo = q_arrivo;
    }

    public int getId_ordine_cli() {
        return this.id_ordine_cli;
    }

    public void setId_ordine_cli(int id_ordine_cli) {
        this.id_ordine_cli = id_ordine_cli;
    }

    public int getId_ordine_for() {
        return this.id_ordine_for;
    }

    public void setId_ordine_for(int id_ordine_for) {
        this.id_ordine_for = id_ordine_for;
    }

    public int getId_produzione() {
        return this.id_produzione;
    }

    public void setId_produzione(int id_produzione) {
        this.id_produzione = id_produzione;
    }

    public String getRs_anagrafica() {
        return this.rs_anagrafica;
    }

    public void setRs_anagrafica(String rs_anagrafica) {
        this.rs_anagrafica = rs_anagrafica;
    }

    public String getCodice_anagrafica() {
        return this.codice_anagrafica;
    }

    public void setCodice_anagrafica(String codice_anagrafica) {
        this.codice_anagrafica = codice_anagrafica;
    }

    public String getString_ordine_for() {
        return this.string_ordine_for;
    }

    public void setString_ordine_for(String string_ordine_for) {
        this.string_ordine_for = string_ordine_for;
    }

    public String getString_ddt_for() {
        return this.string_ddt_for;
    }

    public String getString_ddt_cli() {
        return this.string_ddt_cli;
    }

    public void setString_ddt_cli(String string_ddt_cli) {
        this.string_ddt_cli = string_ddt_cli;
    }

    public void setString_ddt_for(String string_ddt_for) {
        this.string_ddt_for = string_ddt_for;
    }

    public Quantita getQ_da_fatturare_out() {
        return this.q_da_fatturare_out;
    }

    public void setQ_da_fatturare_out(Quantita q_da_fatturare_out) {
        this.q_da_fatturare_out = q_da_fatturare_out;
    }

    public int getId_riga_f_out() {
        return this.id_riga_f_out;
    }

    public void setId_riga_f_out(int id_riga_f_out) {
        this.id_riga_f_out = id_riga_f_out;
    }

    public int getId_registro_f_in() {
        return this.id_registro_f_in;
    }

    public void setId_registro_f_in(int id_registro_f_in) {
        this.id_registro_f_in = id_registro_f_in;
    }

    public int getId_registro_nc_out() {
        return this.id_registro_nc_out;
    }

    public void setId_registro_nc_out(int id_registro_nc_out) {
        this.id_registro_nc_out = id_registro_nc_out;
    }

    public int getId_riga_nc_in() {
        return this.id_riga_nc_in;
    }

    public void setId_riga_nc_in(int id_riga_nc_in) {
        this.id_riga_nc_in = id_riga_nc_in;
    }

    public String getString_ordine_cli() {
        return this.string_ordine_cli;
    }

    public void setString_ordine_cli(String string_ordine_cli) {
        this.string_ordine_cli = string_ordine_cli;
    }

    public String getString_f_for() {
        return this.string_f_for;
    }

    public void setString_f_for(String string_f_for) {
        this.string_f_for = string_f_for;
    }

    public String getString_produzione() {
        return this.string_produzione;
    }

    public void setString_produzione(String string_produzione) {
        this.string_produzione = string_produzione;
    }

    public String getString_f_cli() {
        return this.string_f_cli;
    }

    public void setString_f_cli(String string_f_cli) {
        this.string_f_cli = string_f_cli;
    }

    public String getString_nc_out() {
        return this.string_nc_out;
    }

    public void setString_nc_out(String string_nc_out) {
        this.string_nc_out = string_nc_out;
    }

    public String getString_nc_in() {
        return this.string_nc_in;
    }

    public void setString_nc_in(String string_nc_in) {
        this.string_nc_in = string_nc_in;
    }

    public int getRapporto() {
        return this.rapporto;
    }

    public void setRapporto(int rapporto) {
        this.rapporto = rapporto;
    }

    public boolean inserisci(boolean da_solo) {
        String query_ins;
        boolean r_ins;
        if (da_solo) {
            Configurazioni.getIstanza().connessione.start_transaction();
        }
        if (!(r_ins = Configurazioni.getIstanza().connessione.eseguiAggiornamento(query_ins = "INSERT INTO mmag_movimenti(id_articolo,data_movimento,id_causale_movimento,id_registro_in,id_registro_f_in,id_riga_doc_out,id_riga_f_out,costo_acquisto,q_arrivo,q_magazzino,q_uscita,q_da_fatturare,q_da_fatturare_out,id_ordine_for,id_ordine_cli,id_produzione,id_registro_nc_out,id_riga_nc_in) VALUES (" + this.getId_articolo() + "," + "'" + this.getData_movimento() + "'," + "" + this.getId_causale_movimento() + "," + "" + this.f.zero_to_null(this.getId_registro_in()) + "," + "" + this.f.zero_to_null(this.getId_registro_f_in()) + "," + "" + this.f.zero_to_null(this.getId_riga_doc_out()) + "," + "" + this.f.zero_to_null(this.getId_riga_f_out()) + "," + "" + this.getCosto_di_acquisto() + "," + "" + this.getQ_arrivo() + "," + "" + this.getQ_magazzino() + "," + "" + this.getQ_uscita() + "," + "" + this.getQ_da_fatturare() + "," + "" + this.getQ_da_fatturare_out() + "," + "" + this.f.zero_to_null(this.getId_ordine_for()) + "," + "" + this.f.zero_to_null(this.getId_ordine_cli()) + "," + "" + this.f.zero_to_null(this.getId_produzione()) + "," + "" + this.f.zero_to_null(this.getId_registro_nc_out()) + "," + "" + this.f.zero_to_null(this.getId_riga_nc_in()) + ")"))) {
            Configurazioni.getIstanza().connessione.rollback();
            MyTrace.log.severe("Inserimento movimento in magazzino non riuscito");
            Configurazioni.eccezione.gestisci("2.2", null);
            return false;
        }
        this.setId(Configurazioni.getIstanza().connessione.id_inserito("mmag_movimenti"));
        String q_trace = "INSERT INTO sys_trace(id_operatore,nome_tabella,id_soggetto,data,azione,query) VALUES('" + MyDesktopWindow.profilo.id + "','mmag_movimenti','" + this.getId() + "',NOW(),'INS','" + query_ins.replaceAll("'", "''") + "')";
        boolean r_trace = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_trace);
        if (!r_trace) {
            MyTrace.log.severe("Inserimento movimento magazzino non riuscito per trace");
            Configurazioni.getIstanza().connessione.rollback();
            Configurazioni.eccezione.gestisci("2.3", null);
            return false;
        }
        if (da_solo) {
            Configurazioni.getIstanza().connessione.commit();
        }
        return true;
    }

    public boolean modifica(boolean da_solo) {
        String query_mod;
        boolean r_mod;
        if (da_solo) {
            Configurazioni.getIstanza().connessione.start_transaction();
        }
        if (!(r_mod = Configurazioni.getIstanza().connessione.eseguiAggiornamento(query_mod = "UPDATE mmag_movimenti  SET  id_articolo=" + this.getId_articolo() + "," + " q_arrivo=" + this.getQ_arrivo() + ", " + " q_magazzino=" + this.getQ_magazzino() + ", " + " q_uscita=" + this.getQ_uscita() + ", " + " q_da_fatturare=" + this.getQ_da_fatturare() + ", " + " q_da_fatturare_out=" + this.getQ_da_fatturare_out() + ", " + " data_movimento='" + this.getData_movimento() + "', " + " costo_acquisto=" + this.getCosto_di_acquisto() + ", " + " id_ordine_for=" + this.f.zero_to_null(this.getId_ordine_for()) + ", " + " id_registro_in=" + this.f.zero_to_null(this.getId_registro_in()) + ", " + " id_registro_f_in=" + this.f.zero_to_null(this.getId_registro_f_in()) + ", " + " id_riga_doc_out=" + this.f.zero_to_null(this.getId_riga_doc_out()) + ", " + " id_registro_nc_out=" + this.f.zero_to_null(this.getId_registro_nc_out()) + ", " + " id_riga_nc_in=" + this.f.zero_to_null(this.getId_riga_nc_in()) + ", " + " id_riga_f_out=" + this.f.zero_to_null(this.getId_riga_doc_out()) + ", " + " id_ordine_cli=" + this.getId_ordine_cli() + ", " + " id_produzione=" + this.f.zero_to_null(this.getId_produzione()) + " " + " WHERE idmmag_movimenti=" + this.getId() + ""))) {
            Configurazioni.getIstanza().connessione.rollback();
            MyTrace.log.severe("Modifica Movimento Magazzino non riuscita");
            Configurazioni.eccezione.gestisci("3.2", null);
            return false;
        }
        String q_trace = "INSERT INTO sys_trace(id_operatore,nome_tabella,id_soggetto,data,azione,query) VALUES('" + MyDesktopWindow.profilo.id + "','mmag_movimenti','" + this.getId() + "',NOW(),'MOD','" + query_mod.replaceAll("'", "''") + "')";
        boolean r_trace = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_trace);
        if (!r_trace) {
            Configurazioni.getIstanza().connessione.rollback();
            MyTrace.log.severe("Modifica Movimento Magazzino non riuscita per trace");
            Configurazioni.eccezione.gestisci("3.3", null);
            return false;
        }
        if (da_solo) {
            Configurazioni.getIstanza().connessione.commit();
        }
        return true;
    }

    public boolean elimina(boolean da_solo) {
        String query_del;
        boolean r_del;
        if (da_solo) {
            Configurazioni.getIstanza().connessione.start_transaction();
        }
        if (!(r_del = Configurazioni.getIstanza().connessione.eseguiAggiornamento(query_del = "DELETE FROM mmag_movimenti WHERE idmmag_movimenti=" + this.getId()))) {
            MyTrace.log.severe("Delete mmag_movimenti non riuscito");
            Configurazioni.getIstanza().connessione.rollback();
            Configurazioni.eccezione.gestisci("2.2", null);
            return false;
        }
        String q_trace = "INSERT INTO sys_trace(id_operatore,nome_tabella,id_soggetto,data,azione,query) VALUES('" + MyDesktopWindow.profilo.id + "','mmag_movimenti','" + this.getId() + "',NOW(),'DEL','" + query_del.replaceAll("'", "''") + "')";
        boolean r_trace = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_trace);
        if (!r_trace) {
            Configurazioni.getIstanza().connessione.rollback();
            MyTrace.log.severe("DElete mmag_movimenti non riuscito per trace");
            Configurazioni.eccezione.gestisci("2.3", null);
            return false;
        }
        if (da_solo) {
            Configurazioni.getIstanza().connessione.commit();
        }
        return true;
    }

    public void seleziona(String where) {
        String q = "SELECT v_mmag_movimenti.*  FROM v_mmag_movimenti ";
        q = q + " " + where;
        try {
            ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(q);
            while (res.next()) {
                this.setId(res.getInt("idmmag_movimenti"));
                this.setId_articolo(res.getInt("id_articolo"));
                this.setA(new Articolo());
                this.getA().setId(res.getInt("id_articolo"));
                this.getA().setCodice_articolo(res.getString("codice_articolo"));
                this.getA().setId_gruppo(res.getInt("id_gruppo"));
                this.getA().setDescrizione(res.getString("descrizione"));
                this.getA().setNome_gruppo(res.getString("nome_gruppo"));
                this.getA().setId_um(res.getInt("id_unita_di_misura"));
                this.getA().setCodice_um(res.getString("codice_um"));
                this.getA().setId_conto_c(res.getInt("id_conto_costi"));
                this.getA().setId_conto_r(res.getInt("id_conto_ricavi"));
                this.getA().setId_conto_stock(res.getInt("id_conto_stock"));
                this.getA().setId_aliquota(res.getInt("id_aliquota"));
                this.getA().setId_aliquota_vendite(res.getInt("id_aliquota_vendite"));
                this.getA().setCod_barre(res.getString("codice_a_barre"));
                this.getA().setUltimo_costo_acquisto(new Money(res.getDouble("ultimo_costo_di_acquisto")));
                this.getA().setNote(res.getString("note"));
                this.getA().setDecimali_quantita(res.getInt("decimali_quantita"));
                this.getA().setDecimali_prezzo(res.getInt("decimali_prezzo"));
                this.setQ_arrivo(new Quantita(res.getDouble("q_arrivo")));
                this.setQ_magazzino(new Quantita(res.getDouble("q_magazzino")));
                this.setQ_uscita(new Quantita(res.getDouble("q_uscita")));
                this.setQ_da_fatturare(new Quantita(res.getDouble("q_da_fatturare")));
                this.setQ_da_fatturare_out(new Quantita(res.getDouble("q_da_fatturare_out")));
                this.setData_movimento(res.getString("data_movimento"));
                this.setId_causale_movimento(res.getInt("id_causale_movimento"));
                this.setCodice_causale(res.getString("codice_causale"));
                this.setDescrizione_causale(res.getString("descrizione_causale"));
                this.setId_ordine_for(res.getInt("id_ordine_for"));
                this.setId_registro_in(res.getInt("id_registro_in"));
                this.setId_registro_f_in(res.getInt("id_registro_f_in"));
                this.setId_riga_doc_out(res.getInt("id_riga_doc_out"));
                this.setId_riga_f_out(res.getInt("id_riga_f_out"));
                this.setCosto_di_acquisto(new Money(res.getDouble("costo_acquisto")));
                this.setId_ordine_cli(res.getInt("id_ordine_cli"));
                this.setId_produzione(res.getInt("id_produzione"));
                this.setId_riga_nc_in(res.getInt("id_riga_nc_in"));
                this.setId_registro_nc_out(res.getInt("id_registro_nc_out"));
            }
            Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        }
        catch (Exception e) {
            MyTrace.log.severe("Seleziona Oggetto in magazzino non riuscito");
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            Configurazioni.eccezione.gestisci("4.2", null);
        }
    }

    Object getColValue(int col) {
        String retVal = "";
        switch (col) {
            case 0: {
                retVal = this.getA().getCodice_articolo();
                break;
            }
            case 1: {
                retVal = "" + this.getA().getDescrizione();
                break;
            }
            case 2: {
                retVal = "" + this.getCodice_causale() + "[" + this.getDescrizione_causale() + "]";
                break;
            }
            case 3: {
                retVal = "" + this.getA().getCodice_um();
                break;
            }
            case 4: {
                retVal = "" + this.getQ_magazzino();
                break;
            }
            case 5: {
                if (this.getId_causale_movimento() == 13 || this.getId_causale_movimento() == 12 || this.getId_causale_movimento() == 8 || this.getId_causale_movimento() == 14 || this.getId_causale_movimento() == 15) {
                    retVal = "" + this.getQ_da_fatturare();
                    break;
                }
                retVal = "" + this.getQ_da_fatturare_out();
                break;
            }
            case 6: {
                if (this.getId_causale_movimento() == 11 || this.getId_causale_movimento() == 13 || this.getId_causale_movimento() == 14 || this.getId_causale_movimento() == 15) {
                    retVal = "" + this.getQ_arrivo();
                    break;
                }
                retVal = "" + this.getQ_uscita();
                break;
            }
            case 7: {
                retVal = "" + this.getCosto_di_acquisto();
                break;
            }
            default: {
                retVal = "";
            }
        }
        return retVal;
    }

    Object getColValueOrdini(int col) {
        String retVal = "";
        switch (col) {
            case 0: {
                retVal = this.getA().getCodice_articolo();
                break;
            }
            case 1: {
                retVal = "" + this.getA().getDescrizione();
                break;
            }
            case 2: {
                retVal = "" + this.getCodice_causale() + "[" + this.getDescrizione_causale() + "]";
                break;
            }
            case 3: {
                retVal = "" + this.getA().getCodice_um();
                break;
            }
            case 4: {
                retVal = "" + this.getQ_arrivo();
                break;
            }
            case 5: {
                retVal = "" + this.getCosto_di_acquisto();
                break;
            }
            default: {
                retVal = "";
            }
        }
        return retVal;
    }

    public Object getColValueGiacenzeOrdini(int col) {
        String retVal = "";
        switch (col) {
            case 0: {
                retVal = "" + this.getA().getCodice_articolo();
                break;
            }
            case 1: {
                retVal = "" + this.getA().getDescrizione();
                break;
            }
            case 2: {
                retVal = "" + this.getA().getNome_gruppo();
                break;
            }
            case 3: {
                retVal = "" + this.getA().getCodice_um();
                break;
            }
            case 4: {
                retVal = "" + this.getQ_arrivo();
                break;
            }
            case 5: {
                if (this.getQ_arrivo().isZero()) {
                    retVal = "";
                    break;
                }
                retVal = "" + this.getString_ordine_for();
                break;
            }
            case 6: {
                if (this.getQ_arrivo().isZero()) {
                    retVal = "";
                    break;
                }
                retVal = "[" + this.getCodice_anagrafica() + "] - " + this.getRs_anagrafica();
                break;
            }
            default: {
                retVal = "";
            }
        }
        return retVal;
    }

    public Object getColValueGiacenzeDAFatturare(int col) {
        String retVal = "";
        switch (col) {
            case 0: {
                retVal = "" + this.getA().getCodice_articolo();
                break;
            }
            case 1: {
                retVal = "" + this.getA().getDescrizione();
                break;
            }
            case 2: {
                retVal = "" + this.getA().getNome_gruppo();
                break;
            }
            case 3: {
                retVal = "" + this.getA().getCodice_um();
                break;
            }
            case 4: {
                retVal = "" + this.getQ_da_fatturare();
                break;
            }
            case 5: {
                if (this.getQ_da_fatturare().isZero()) {
                    retVal = "";
                    break;
                }
                retVal = "" + this.getString_ddt_for();
                break;
            }
            case 6: {
                if (this.getQ_da_fatturare().isZero()) {
                    retVal = "";
                    break;
                }
                retVal = "[F" + this.getCodice_anagrafica() + "] - " + this.getRs_anagrafica();
                break;
            }
            default: {
                retVal = "";
            }
        }
        return retVal;
    }

    public Object getColValueGiacenzeDAFatturareA(int col) {
        String retVal = "";
        switch (col) {
            case 0: {
                retVal = "" + this.getA().getCodice_articolo();
                break;
            }
            case 1: {
                retVal = "" + this.getA().getDescrizione();
                break;
            }
            case 2: {
                retVal = "" + this.getA().getNome_gruppo();
                break;
            }
            case 3: {
                retVal = "" + this.getA().getCodice_um();
                break;
            }
            case 4: {
                retVal = "" + this.getQ_da_fatturare_out();
                break;
            }
            case 5: {
                if (this.getQ_da_fatturare_out().isZero()) {
                    retVal = "";
                    break;
                }
                retVal = "" + this.getString_ddt_cli();
                break;
            }
            case 6: {
                if (this.getQ_da_fatturare_out().isZero()) {
                    retVal = "";
                    break;
                }
                retVal = "[C" + this.getCodice_anagrafica() + "] - " + this.getRs_anagrafica();
                break;
            }
            default: {
                retVal = "";
            }
        }
        return retVal;
    }

    public Object getColValueGiacenzePERDDI(int col) {
        String retVal = "";
        switch (col) {
            case 0: {
                retVal = "" + this.getA().getCodice_articolo();
                break;
            }
            case 1: {
                retVal = "" + this.getA().getDescrizione();
                break;
            }
            case 2: {
                retVal = "" + this.getA().getNome_gruppo();
                break;
            }
            case 3: {
                retVal = "" + this.getA().getCodice_um();
                break;
            }
            case 4: {
                retVal = "" + this.getQ_magazzino();
                break;
            }
            case 5: {
                if (this.getQ_magazzino().isZero()) {
                    retVal = "";
                    break;
                }
                retVal = "" + this.getString_ddt_for();
                break;
            }
            case 6: {
                if (this.getQ_magazzino().isZero()) {
                    retVal = "";
                    break;
                }
                retVal = "[F" + this.getCodice_anagrafica() + "] - " + this.getRs_anagrafica();
                break;
            }
            default: {
                retVal = "";
            }
        }
        return retVal;
    }

    Object getColValueMovimenti(int col) {
        String retVal = "";
        switch (col) {
            case 0: {
                retVal = "" + this.fda.gira_data(this.getData_movimento());
                break;
            }
            case 1: {
                retVal = "" + this.getCodice_causale() + "[" + this.getDescrizione_causale() + "]";
                break;
            }
            case 2: {
                if (!this.getQ_arrivo().isZero()) {
                    retVal = "" + this.getQ_arrivo();
                    break;
                }
                retVal = "" + this.getQ_uscita();
                break;
            }
            case 3: {
                retVal = "" + this.getQ_magazzino();
                break;
            }
            case 4: {
                if (!this.getQ_da_fatturare().isZero()) {
                    retVal = "" + this.getQ_da_fatturare();
                    break;
                }
                retVal = "" + this.getQ_da_fatturare_out();
                break;
            }
            case 5: {
                switch (this.getId_causale_movimento()) {
                    case 1: {
                        retVal = "";
                        break;
                    }
                    case 2: {
                        retVal = "";
                        break;
                    }
                    case 3: {
                        if (this.getId_riga_doc_out() != 0) {
                            retVal = "" + this.getString_ddt_cli();
                        }
                        if (this.getId_riga_f_out() == 0) break;
                        retVal = "" + this.getString_f_cli();
                        break;
                    }
                    case 6: {
                        if (this.getId_produzione() == 0) break;
                        retVal = "" + this.getString_produzione();
                        break;
                    }
                    case 7: {
                        if (this.getId_registro_nc_out() == 0) break;
                        retVal = "" + this.getString_nc_out();
                        break;
                    }
                    case 8: {
                        if (this.getId_registro_in() != 0) {
                            retVal = "" + this.getString_ddt_for();
                        }
                        if (this.getId_registro_f_in() == 0) break;
                        retVal = "" + this.getString_f_for();
                        break;
                    }
                    case 9: {
                        if (this.getId_riga_nc_in() == 0) break;
                        retVal = "" + this.getString_nc_in();
                        break;
                    }
                    case 11: {
                        if (this.getId_ordine_for() == 0) break;
                        retVal = "" + this.getString_ordine_for();
                        break;
                    }
                    case 12: {
                        if (this.getId_registro_f_in() == 0) break;
                        retVal = "" + this.getString_f_for();
                        break;
                    }
                    case 13: {
                        if (this.getId_registro_in() != 0) {
                            retVal = "" + this.getString_ddt_for();
                        }
                        if (this.getId_registro_f_in() == 0) break;
                        retVal = "" + this.getString_f_for();
                        break;
                    }
                    case 14: {
                        if (this.getId_registro_in() == 0) break;
                        retVal = "" + this.getString_ddt_for();
                        break;
                    }
                    case 15: {
                        if (this.getId_registro_in() == 0) break;
                        retVal = "" + this.getString_ddt_for();
                        break;
                    }
                    case 16: {
                        if (this.getId_riga_doc_out() != 0) {
                            retVal = "" + this.getString_ddt_cli();
                        }
                        if (this.getId_riga_f_out() == 0) break;
                        retVal = "" + this.getString_f_cli();
                        break;
                    }
                    case 17: {
                        if (this.getId_riga_doc_out() != 0) {
                            retVal = "" + this.getString_ddt_cli();
                        }
                        if (this.getId_riga_f_out() == 0) break;
                        retVal = "" + this.getString_f_cli();
                        break;
                    }
                    case 18: {
                        if (this.getId_riga_f_out() == 0) break;
                        retVal = "" + this.getString_f_cli();
                    }
                }
                break;
            }
            default: {
                retVal = "";
            }
        }
        return retVal;
    }
}

