/*
 * Decompiled with CFR 0.152.
 */
package magazzino.materiale_richiesto;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import magazzino.articoli.Articolo;
import magazzino.listini.PrezzoListino;
import magazzino.materiale_richiesto.MaterialeRichiesto;
import utils.Money;
import utils.Quantita;

public class MaterialeRichiestoTableModel
extends AbstractTableModel {
    Vector cache = new Vector();
    int colCount;
    String[] headers;
    boolean modo_ric = false;

    public void setModo_ric(boolean modo_ric) {
        this.modo_ric = modo_ric;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        MaterialeRichiesto om = (MaterialeRichiesto)this.cache.elementAt(row);
        if (col == 0) {
            om.setPos(Integer.parseInt(value.toString()));
        }
        if (col == 1) {
            if (!om.getA().getCodice_articolo().equals(value.toString())) {
                om.setA(new Articolo());
                om.getA().setCodice_articolo(value.toString());
                String w = " WHERE codice_articolo='" + value.toString() + "'";
                om.getA().seleziona(w);
            }
            om.setId_articolo(om.getA().getId());
            om.getA().seleziona_prezzi();
            if (om.getQuantita().isZero()) {
                om.setQuantita(new Quantita(BigDecimal.ONE));
            }
            if (om.getPrezzo_unitario().isZero()) {
                boolean trovato = false;
                Iterator<PrezzoListino> i = om.getA().getInsieme_pl().vettorePL.iterator();
                while (i.hasNext() && !trovato) {
                    PrezzoListino pl = i.next();
                    if (pl.getId_listino() != om.getId_listino_fornitore_temp()) continue;
                    trovato = true;
                    om.setPrezzo_unitario(pl.getPrezzo_listino());
                }
                if (!trovato) {
                    om.setPrezzo_unitario(om.getA().getUltimo_costo_acquisto());
                }
                om.setPrezzo_totale(om.getPrezzo_unitario().multiply(om.getQuantita()));
            }
        }
        if (col == 4) {
            om.setQuantita(new Quantita(value.toString()));
            om.setPrezzo_totale(om.getPrezzo_unitario().multiply(om.getQuantita()));
        }
        if (col == 5) {
            om.setPrezzo_unitario(new Money(value.toString()));
            om.setPrezzo_totale(om.getPrezzo_unitario().multiply(om.getQuantita()));
        }
        if (col == 6) {
            om.setPrezzo_totale(new Money(value.toString()));
        }
        this.fireTableRowsUpdated(row, row);
    }

    @Override
    public String getColumnName(int i) {
        String retVal = "";
        switch (i) {
            case 0: {
                retVal = "Pos";
                break;
            }
            case 1: {
                retVal = "Codice Articolo";
                break;
            }
            case 2: {
                retVal = "Descrizione Articolo";
                break;
            }
            case 3: {
                retVal = "U.m.";
                break;
            }
            case 4: {
                retVal = "Quantit\u00e0";
                break;
            }
            case 5: {
                retVal = "Prezzo Unitario";
                break;
            }
            case 6: {
                retVal = "Tot";
                break;
            }
            default: {
                retVal = this.headers[i];
            }
        }
        return retVal;
    }

    @Override
    public int getRowCount() {
        return this.cache.size();
    }

    @Override
    public int getColumnCount() {
        return 7;
    }

    @Override
    public Object getValueAt(int row, int col) {
        MaterialeRichiesto a = new MaterialeRichiesto();
        if (!this.cache.isEmpty()) {
            a = (MaterialeRichiesto)this.cache.elementAt(row);
            return a.getColValue(col);
        }
        return "";
    }

    public Class getColumnClass(int c) {
        return this.getValueAt(0, c).getClass();
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col == 0 || col == 1 || col == 4 || col == 5 || col == 6;
    }

    public void setDataMateriale(ArrayList<MaterialeRichiesto> vettoreOrdini) {
        this.cache = new Vector();
        Iterator<MaterialeRichiesto> i = vettoreOrdini.iterator();
        while (i.hasNext()) {
            this.cache.addElement(i.next());
        }
        this.fireTableChanged(null);
    }
}

