/*
 * Decompiled with CFR 0.152.
 */
package magazzino.listini;

import gestionale.MyDesktopWindow;
import gestionale.configurazioni.Configurazioni;
import gestionale.configurazioni.MyProprietaFrame;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.regex.PatternSyntaxException;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.RowFilter;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableRowSorter;
import magazzino.articoli.Articolo;
import magazzino.articoli.MyArticoli;
import magazzino.listini.InsiemeListini;
import magazzino.listini.InsiemePrezziListino;
import magazzino.listini.ListiniFixedModel;
import magazzino.listini.ListiniTableModel;
import magazzino.listini.Listino;
import magazzino.listini.PrezziTableModel;
import magazzino.listini.PrezzoListino;
import trasporti.listini.MyTraListini;
import utils.AvvioSuThread;
import utils.DateField;
import utils.Funzioni;
import utils.FunzioniDate;
import utils.GenericTableRenderer;
import utils.MyTrace;
import utils.Performance;
import utils.RicercaCellEditor;
import utils.RicercaCellRenderer;
import utils.TextInsertEditor;
import utils.TimeFormatter;
import utils.ToolTipHeader;

public class MyListiniAcquisto
extends JInternalFrame
implements ListSelectionListener {
    JToolBar jToolBarMod;
    ListiniTableModel ltm;
    InsiemeListini insieme_l;
    JScrollPane scroll;
    JTable jTableListini;
    ListiniFixedModel lfm;
    JScrollPane fixedScroll;
    JTable fixedTable;
    private TableRowSorter<ListiniTableModel> sorter;
    RowFilter<ListiniTableModel, Object> rf = null;
    ArrayList<RowFilter<ListiniTableModel, Object>> andFilters = new ArrayList();
    DateField data_um;
    TimeFormatter mf = null;
    boolean in_filter = false;
    boolean in_modifica = false;
    boolean in_new = false;
    boolean non_tutte_le_righe = false;
    public boolean f_causali_open = false;
    public boolean f_te_open = false;
    public boolean f_ba_open = false;
    public boolean aiuto_riga_c = false;
    public Listino l_selezione;
    Funzioni f = new Funzioni();
    FunzioniDate fda = new FunzioniDate();
    public JInternalFrame chiamante;
    public int row_chiamante;
    public boolean aiuto_riga_t = false;
    PrezziTableModel pltm;
    static Point posizione_finestra = new Point(200, 0);
    static Dimension dimensione_finestra = new Dimension(700, 600);
    int riga_selezionata = 1000;
    private ButtonGroup buttonGroup1;
    private JButton jButtonAddRigaRow1;
    private JButton jButtonClean;
    private JButton jButtonElimina;
    private JButton jButtonEliminaRiga;
    private JToggleButton jButtonFiltra;
    private JButton jButtonFirst;
    private JButton jButtonForm;
    private JButton jButtonLast;
    private JButton jButtonModifica;
    private JButton jButtonNext;
    private JButton jButtonNuovo;
    private JButton jButtonPrevious;
    private JButton jButtonRefresh;
    private JButton jButtonStampa;
    private JLabel jLabel3;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabelCF2;
    private JPanel jPanel1;
    private JPanel jPanel3;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane4;
    private JScrollPane jScrollPane5;
    private JToolBar.Separator jSeparator1;
    private JToolBar.Separator jSeparator2;
    private JToolBar.Separator jSeparator3;
    private JTabbedPane jTabbedPane1;
    public JTable jTablePl;
    public JTextField jTextNomeListino;
    private JTextArea jTextNote;
    private JToolBar jToolBar1;
    private JToolBar jToolBar2;
    private JPanel p;

    public MyListiniAcquisto() {
        Performance perf = new Performance("+++ ISTANZA MyTraListini +++");
        if (!MyDesktopWindow.profilo.controllaPermesso("Listini_Visualizza")) {
            Configurazioni.eccezione.gestisci("7.1", null);
            this.dispose();
        }
        this.ltm = new ListiniTableModel();
        this.insieme_l = new InsiemeListini();
        this.jTableListini = new JTable(this.ltm);
        this.jTableListini.setSelectionMode(0);
        this.sorter = new TableRowSorter<ListiniTableModel>(this.ltm);
        for (int i = 0; i < this.ltm.getColumnCount(); ++i) {
            RowFilter rf_local = RowFilter.regexFilter("(?i)", i);
            this.andFilters.add(i, rf_local);
        }
        this.lfm = new ListiniFixedModel();
        this.lfm.setFIXED_NUM(0);
        this.fixedTable = new JTable(this.lfm);
        this.fixedTable.setAutoResizeMode(4);
        this.pltm = new PrezziTableModel();
        this.initComponents();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.mf = new TimeFormatter();
        this.data_um = new DateField(this.mf);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel6.add((Component)this.data_um, gridBagConstraints);
        this.jTablePl.setModel(this.pltm);
        this.crea_toolbar();
        this.aggiungi_tabelle();
        AvvioSuThread avvio_separato = new AvvioSuThread(this, "caricamento_dati_iniziale");
        ListSelectionModel listSelectionModel = this.jTableListini.getSelectionModel();
        listSelectionModel.addListSelectionListener(this);
        this.controlla_diritti();
        this.setLocation(posizione_finestra);
        this.setSize(dimensione_finestra);
        perf.fine();
    }

    public void caricamento_dati_iniziale() {
        this.filtra();
        this.formatta();
        this.visualizzazione();
        this.repaint();
    }

    private void controlla_diritti() {
        if (!MyDesktopWindow.profilo.controllaPermesso("TRASPORTI_Listini_Modifica")) {
            this.jButtonModifica.setEnabled(false);
            this.jButtonNuovo.setEnabled(false);
            this.jButtonElimina.setEnabled(false);
        }
    }

    private void crea_toolbar() {
        this.jToolBarMod = new JToolBar();
        JButton jButtonSalva = new JButton();
        JButton jButtonAnnulla = new JButton();
        jButtonSalva.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/document-save-as.png")));
        jButtonSalva.setText("Salva");
        jButtonSalva.setFocusable(true);
        jButtonSalva.setVerticalTextPosition(3);
        jButtonSalva.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyListiniAcquisto.this.jButtonSalvaActionPerformed(evt);
            }
        });
        this.jToolBarMod.add(jButtonSalva);
        jButtonAnnulla.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/edit-undo.png")));
        jButtonAnnulla.setText("Annulla");
        jButtonAnnulla.setFocusable(true);
        jButtonAnnulla.setVerticalTextPosition(3);
        jButtonAnnulla.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyListiniAcquisto.this.jButtonAnnullaActionPerformed(evt);
            }
        });
        this.jToolBarMod.add(jButtonAnnulla);
    }

    private void aggiungi_tabelle() {
        this.scroll = new JScrollPane(this.jTableListini){

            @Override
            public void setColumnHeaderView(Component view) {
            }
        };
        this.scroll.setHorizontalScrollBarPolicy(31);
        this.fixedScroll = new JScrollPane(this.fixedTable);
        this.fixedScroll.setVerticalScrollBarPolicy(22);
        this.fixedScroll.setPreferredSize(new Dimension(400, 25));
        JScrollBar bar = this.fixedScroll.getVerticalScrollBar();
        JScrollBar dummyBar = new JScrollBar(){

            @Override
            public void paint(Graphics g) {
            }
        };
        dummyBar.setPreferredSize(bar.getPreferredSize());
        this.fixedScroll.setVerticalScrollBar(dummyBar);
        final JScrollBar bar1 = this.scroll.getHorizontalScrollBar();
        JScrollBar bar2 = this.fixedScroll.getHorizontalScrollBar();
        bar2.addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                bar1.setValue(e.getValue());
            }
        });
        this.jTableListini.setModel(this.ltm);
        this.jTableListini.setAutoCreateRowSorter(true);
        this.jTableListini.setRowSorter(this.sorter);
        this.jTableListini.setFillsViewportHeight(true);
        this.p.add((Component)this.scroll, "Center");
        this.p.add((Component)this.fixedScroll, "North");
    }

    private void azzera() {
        this.jTextNomeListino.setText("");
        this.data_um.setText(this.fda.dataCorrenteIt());
        this.jTextNote.setText("");
        this.pltm = new PrezziTableModel();
        this.jTablePl.setModel(this.pltm);
    }

    public void visualizzazione() {
        this.jTextNomeListino.setEnabled(this.in_modifica);
        this.data_um.setEnabled(this.in_modifica);
        this.jTextNote.setEnabled(this.in_modifica);
        this.jTablePl.setEnabled(this.in_modifica);
        this.jButtonAddRigaRow1.setEnabled(this.in_modifica);
        if (this.in_modifica) {
            this.getContentPane().remove(this.jToolBar1);
            this.getContentPane().add((Component)this.jToolBarMod, "North");
            this.jTabbedPane1.setEnabledAt(0, false);
        } else {
            this.getContentPane().remove(this.jToolBarMod);
            this.getContentPane().add((Component)this.jToolBar1, "North");
            this.jTabbedPane1.setEnabledAt(0, true);
        }
        this.getContentPane().validate();
        this.getContentPane().repaint();
    }

    public void formatta() {
        this.jTableListini.getSelectionModel().setSelectionInterval(0, 0);
        this.jTableListini.setDefaultRenderer(Object.class, new GenericTableRenderer());
        this.fixedTable.setRowHeight(30);
        this.fixedTable.setDefaultEditor(String.class, new TextEditor());
        this.fixedTable.setDefaultRenderer(Object.class, new RicercaCellRenderer());
        JTableHeader h = this.fixedTable.getTableHeader();
        h.setResizingAllowed(false);
        this.header_tebella();
    }

    private void formatta_dettagli() {
        this.jTablePl.setRowHeight(27);
        this.jTablePl.setDefaultEditor(Object.class, new TextPrezziEditor());
        this.jTablePl.setDefaultRenderer(Object.class, new RicercaCellRenderer());
        ListSelectionModel listSelectionModel = this.jTablePl.getSelectionModel();
        listSelectionModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                MyListiniAcquisto.this.riga_selezionata = MyListiniAcquisto.this.jTablePl.getSelectedRow();
            }
        });
    }

    public void header_tebella() {
        try {
            String[] toolTipStr = new String[]{"Contratto", "Codice Cliente/Fornitore", "Ragione Sociale Cliente/Fornitre", "Tipologia", "Nome Listino"};
            ToolTipHeader header1 = new ToolTipHeader(this.jTableListini.getColumnModel());
            ToolTipHeader header2 = new ToolTipHeader(this.fixedTable.getColumnModel());
            header1.setToolTipStrings(toolTipStr);
            header2.setToolTipStrings(toolTipStr);
            this.fixedTable.setTableHeader(header2);
            this.jTableListini.setTableHeader(header1);
            header1.setResizingAllowed(false);
            header2.setResizingAllowed(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void filtra() {
        String where = "";
        String order_by = "";
        where = where + " WHERE mmag_listini.acquisto_vendita ='a' ";
        order_by = " ORDER BY mmag_listini.nome ASC ";
        if (Configurazioni.righe_ricerca != 0) {
            order_by = order_by + " LIMIT 0," + Configurazioni.righe_ricerca;
        }
        this.insieme_l.caricamento(where, order_by);
        this.ltm.setDataListini(this.insieme_l.vettoreListini);
        if (Configurazioni.righe_ricerca != 0 && this.insieme_l.vettoreListini.size() >= Configurazioni.righe_ricerca) {
            this.non_tutte_le_righe = true;
        }
    }

    public void seleziona(int row) {
        this.l_selezione = new Listino();
        this.azzera();
        this.l_selezione = this.insieme_l.vettoreListini.get(row);
        this.l_selezione.seleziona_dettagli();
        this.riempi_campi();
    }

    public void riempi_campi() {
        this.jTextNomeListino.setText(this.l_selezione.getNome());
        this.data_um.setText(this.l_selezione.getData_aggiornamentoIt());
        this.jTextNote.setText(this.l_selezione.getDescrizione());
        if (this.l_selezione.getInsieme_pl() != null && !this.l_selezione.getInsieme_pl().vettorePL.isEmpty()) {
            this.pltm.setData(this.l_selezione.getInsieme_pl().vettorePL);
        }
        this.jTablePl.setModel(this.pltm);
        this.formatta_dettagli();
        this.visualizzazione();
    }

    private void costruisci() {
        this.l_selezione.setDescrizione(this.jTextNote.getText());
        this.l_selezione.setNome(this.jTextNomeListino.getText());
        this.l_selezione.setData_aggiornamento(this.fda.gira_data(this.data_um.getText()));
    }

    private boolean check() {
        if (this.jTextNomeListino.getText().equals("")) {
            JOptionPane.showMessageDialog(this, "Inserire un nome per il listino");
            return false;
        }
        return true;
    }

    public void aiuto_articolo(int row, int col) {
        if (col == 0 && !this.aiuto_riga_t) {
            MyArticoli oggetto = new MyArticoli();
            oggetto.chiamante = this;
            oggetto.row_chiamante = row;
            this.getDesktopPane().add(oggetto);
            oggetto.setLocation(200, 100);
            oggetto.setVisible(true);
            oggetto.moveToFront();
            this.aiuto_riga_t = true;
        }
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jToolBar1 = new JToolBar();
        this.jButtonNuovo = new JButton();
        this.jButtonModifica = new JButton();
        this.jButtonElimina = new JButton();
        this.jButtonForm = new JButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.jButtonFirst = new JButton();
        this.jButtonPrevious = new JButton();
        this.jButtonNext = new JButton();
        this.jButtonLast = new JButton();
        this.jSeparator2 = new JToolBar.Separator();
        this.jButtonRefresh = new JButton();
        this.jButtonFiltra = new JToggleButton();
        this.jButtonClean = new JButton();
        this.jSeparator3 = new JToolBar.Separator();
        this.jButtonStampa = new JButton();
        this.jTabbedPane1 = new JTabbedPane();
        this.jScrollPane1 = new JScrollPane();
        this.jPanel1 = new JPanel();
        this.p = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.jPanel5 = new JPanel();
        this.jPanel3 = new JPanel();
        this.jScrollPane4 = new JScrollPane();
        this.jTablePl = new JTable(this.pltm);
        this.jToolBar2 = new JToolBar();
        this.jLabel7 = new JLabel();
        this.jButtonAddRigaRow1 = new JButton();
        this.jButtonEliminaRiga = new JButton();
        this.jPanel6 = new JPanel();
        this.jTextNomeListino = new JTextField();
        this.jLabel8 = new JLabel();
        this.jLabelCF2 = new JLabel();
        this.jScrollPane5 = new JScrollPane();
        this.jTextNote = new JTextArea();
        this.jLabel3 = new JLabel();
        this.setClosable(true);
        this.setDefaultCloseOperation(2);
        this.setIconifiable(true);
        this.setMaximizable(true);
        this.setResizable(true);
        this.setTitle("Magazzinoi \\ Listini di Acquisto");
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent evt) {
                MyListiniAcquisto.this.posizione_finestra(evt);
            }

            @Override
            public void componentResized(ComponentEvent evt) {
                MyListiniAcquisto.this.finestra_ridimensionata(evt);
            }
        });
        this.jToolBar1.setRollover(true);
        this.jButtonNuovo.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/document-new.png")));
        this.jButtonNuovo.setText("Nuovo");
        this.jButtonNuovo.setFocusable(false);
        this.jButtonNuovo.setVerticalTextPosition(3);
        this.jButtonNuovo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyListiniAcquisto.this.jButtonNuovoActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonNuovo);
        this.jButtonModifica.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/accessories-text-editor.png")));
        this.jButtonModifica.setText("Modifica");
        this.jButtonModifica.setFocusable(false);
        this.jButtonModifica.setHorizontalAlignment(11);
        this.jButtonModifica.setVerticalTextPosition(3);
        this.jButtonModifica.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyListiniAcquisto.this.jButtonModificaActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonModifica);
        this.jButtonElimina.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/user-trash.png")));
        this.jButtonElimina.setText("Elimina");
        this.jButtonElimina.setFocusable(false);
        this.jButtonElimina.setHorizontalAlignment(11);
        this.jButtonElimina.setVerticalTextPosition(3);
        this.jButtonElimina.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyListiniAcquisto.this.jButtonEliminaActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonElimina);
        this.jButtonForm.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/preferences-system.png")));
        this.jButtonForm.setText("Propriet\u00e0");
        this.jButtonForm.setFocusable(false);
        this.jButtonForm.setHorizontalAlignment(11);
        this.jButtonForm.setVerticalTextPosition(3);
        this.jButtonForm.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyListiniAcquisto.this.jButtonFormActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonForm);
        this.jToolBar1.add(this.jSeparator1);
        this.jButtonFirst.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/go-first.png")));
        this.jButtonFirst.setFocusable(false);
        this.jButtonFirst.setHorizontalTextPosition(0);
        this.jButtonFirst.setVerticalTextPosition(3);
        this.jButtonFirst.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyListiniAcquisto.this.jButtonFirstActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonFirst);
        this.jButtonPrevious.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/go-previous.png")));
        this.jButtonPrevious.setFocusable(false);
        this.jButtonPrevious.setHorizontalTextPosition(0);
        this.jButtonPrevious.setVerticalTextPosition(3);
        this.jButtonPrevious.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyListiniAcquisto.this.jButtonPreviousActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonPrevious);
        this.jButtonNext.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/go-next.png")));
        this.jButtonNext.setFocusable(false);
        this.jButtonNext.setHorizontalTextPosition(0);
        this.jButtonNext.setVerticalTextPosition(3);
        this.jButtonNext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyListiniAcquisto.this.jButtonNextActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonNext);
        this.jButtonLast.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/go-last.png")));
        this.jButtonLast.setFocusable(false);
        this.jButtonLast.setHorizontalTextPosition(0);
        this.jButtonLast.setVerticalTextPosition(3);
        this.jButtonLast.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyListiniAcquisto.this.jButtonLastActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonLast);
        this.jToolBar1.add(this.jSeparator2);
        this.jButtonRefresh.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/view-refresh.png")));
        this.jButtonRefresh.setFocusable(false);
        this.jButtonRefresh.setHorizontalTextPosition(0);
        this.jButtonRefresh.setVerticalTextPosition(3);
        this.jButtonRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyListiniAcquisto.this.jButtonRefreshActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonRefresh);
        this.jButtonFiltra.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/edit-find.png")));
        this.jButtonFiltra.setFocusable(false);
        this.jButtonFiltra.setHorizontalTextPosition(0);
        this.jButtonFiltra.setVerticalTextPosition(3);
        this.jButtonFiltra.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyListiniAcquisto.this.jButtonFiltraActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonFiltra);
        this.jButtonClean.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/edit-clear.png")));
        this.jButtonClean.setFocusable(false);
        this.jButtonClean.setHorizontalTextPosition(0);
        this.jButtonClean.setVerticalTextPosition(3);
        this.jButtonClean.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyListiniAcquisto.this.jButtonCleanActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonClean);
        this.jToolBar1.add(this.jSeparator3);
        this.jButtonStampa.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/document-print.png")));
        this.jButtonStampa.setFocusable(false);
        this.jButtonStampa.setHorizontalTextPosition(0);
        this.jButtonStampa.setVerticalTextPosition(3);
        this.jButtonStampa.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyListiniAcquisto.this.jButtonStampaActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonStampa);
        this.getContentPane().add((Component)this.jToolBar1, "North");
        this.jPanel1.setLayout(new BorderLayout());
        this.p.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.p.setLayout(new BorderLayout());
        this.jPanel1.add((Component)this.p, "Center");
        this.jScrollPane1.setViewportView(this.jPanel1);
        this.jTabbedPane1.addTab("Elenco", this.jScrollPane1);
        this.jPanel5.setLayout(new BorderLayout());
        this.jPanel3.setBorder(BorderFactory.createEtchedBorder());
        this.jPanel3.setPreferredSize(new Dimension(600, 200));
        this.jPanel3.setLayout(new BorderLayout());
        this.jTablePl.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.jScrollPane4.setViewportView(this.jTablePl);
        this.jPanel3.add((Component)this.jScrollPane4, "Center");
        this.jToolBar2.setRollover(true);
        this.jLabel7.setBackground(new Color(102, 153, 255));
        this.jLabel7.setFont(new Font("Tahoma", 1, 11));
        this.jLabel7.setText("Prezzi");
        this.jLabel7.setOpaque(true);
        this.jToolBar2.add(this.jLabel7);
        this.jButtonAddRigaRow1.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/list-add.png")));
        this.jButtonAddRigaRow1.setText("Aggiungi Riga");
        this.jButtonAddRigaRow1.setFocusable(false);
        this.jButtonAddRigaRow1.setVerticalTextPosition(3);
        this.jButtonAddRigaRow1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyListiniAcquisto.this.jButtonAddOpzioneActionPerformed(evt);
            }
        });
        this.jToolBar2.add(this.jButtonAddRigaRow1);
        this.jButtonEliminaRiga.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/list-remove.png")));
        this.jButtonEliminaRiga.setFocusable(false);
        this.jButtonEliminaRiga.setHorizontalAlignment(11);
        this.jButtonEliminaRiga.setLabel("Elimina Riga");
        this.jButtonEliminaRiga.setVerticalTextPosition(3);
        this.jButtonEliminaRiga.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyListiniAcquisto.this.jButtonEliminaRigaActionPerformed(evt);
            }
        });
        this.jToolBar2.add(this.jButtonEliminaRiga);
        this.jPanel3.add((Component)this.jToolBar2, "North");
        this.jPanel5.add((Component)this.jPanel3, "Center");
        this.jPanel6.setLayout(new GridBagLayout());
        this.jTextNomeListino.setMinimumSize(new Dimension(180, 27));
        this.jTextNomeListino.setPreferredSize(new Dimension(180, 27));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel6.add((Component)this.jTextNomeListino, gridBagConstraints);
        this.jLabel8.setText("Nome di Riferimento del listino");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.jPanel6.add((Component)this.jLabel8, gridBagConstraints);
        this.jLabelCF2.setText("Note");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel6.add((Component)this.jLabelCF2, gridBagConstraints);
        this.jTextNote.setColumns(20);
        this.jTextNote.setRows(3);
        this.jTextNote.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                MyListiniAcquisto.this.jTextNoteFocusGained(evt);
            }
        });
        this.jScrollPane5.setViewportView(this.jTextNote);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 10, 10);
        this.jPanel6.add((Component)this.jScrollPane5, gridBagConstraints);
        this.jLabel3.setText("Data Ultimo Aggiornamento");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.jPanel6.add((Component)this.jLabel3, gridBagConstraints);
        this.jPanel5.add((Component)this.jPanel6, "North");
        this.jScrollPane2.setViewportView(this.jPanel5);
        this.jTabbedPane1.addTab("Dettaglio", this.jScrollPane2);
        this.getContentPane().add((Component)this.jTabbedPane1, "Center");
        this.pack();
    }

    private void jButtonSalvaActionPerformed(ActionEvent evt) {
        if (this.in_new) {
            if (this.check()) {
                this.costruisci();
                boolean check2 = this.l_selezione.inserisciListino(true);
                if (check2) {
                    this.in_new = false;
                    this.in_modifica = false;
                    this.filtra();
                    this.formatta();
                    this.visualizzazione();
                    this.jTabbedPane1.setSelectedIndex(0);
                } else {
                    JOptionPane.showMessageDialog(this, "Si \u00e8 verificato un errore al momento dell'inserimento dei dati nel database,\nRicontrollare i campi riempiti e non.\nSe il problema persiste contattare Kronos");
                }
            }
        } else if (this.check()) {
            this.costruisci();
            boolean check2 = this.l_selezione.modificaListino(true);
            if (check2) {
                this.in_modifica = false;
                this.filtra();
                this.formatta();
                this.visualizzazione();
                this.jTabbedPane1.setSelectedIndex(0);
            } else {
                JOptionPane.showMessageDialog(this, "Si \u00e8 verificato un errore al momento della modifica dei dati nel database,\nRicontrollare i campi riempiti e non.\nSe il problema persiste contattare Kronos");
            }
        }
    }

    private void jButtonAnnullaActionPerformed(ActionEvent evt) {
        int res = JOptionPane.showConfirmDialog(this, "Abbandonare le modifiche?");
        if (res == 0) {
            this.in_modifica = false;
            if (this.in_new) {
                this.l_selezione = new Listino();
                this.in_new = false;
            }
            this.visualizzazione();
            this.jTabbedPane1.setSelectedIndex(0);
        }
    }

    private void jButtonNuovoActionPerformed(ActionEvent evt) {
        Performance perf = new Performance("+++ MyTraListini NUOVO) +++");
        this.in_new = true;
        this.jTableListini.getSelectionModel().clearSelection();
        this.azzera();
        this.l_selezione = new Listino();
        this.l_selezione.setA_v("a");
        this.l_selezione.setData_aggiornamento(this.fda.dataCorrente());
        this.l_selezione.setInsieme_pl(new InsiemePrezziListino());
        this.formatta_dettagli();
        this.in_modifica = true;
        this.jTabbedPane1.setSelectedIndex(1);
        this.visualizzazione();
        perf.fine();
    }

    private void jButtonModificaActionPerformed(ActionEvent evt) {
        Performance perf = new Performance("+++ MyListini MODIFICA) +++");
        if (this.l_selezione != null) {
            this.in_modifica = true;
            this.visualizzazione();
            if (this.jTabbedPane1.getSelectedIndex() == 0) {
                this.jTabbedPane1.setSelectedIndex(1);
            }
        }
        perf.fine();
    }

    private void jButtonEliminaActionPerformed(ActionEvent evt) {
    }

    private void jButtonFormActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        MyProprietaFrame oggetto = new MyProprietaFrame();
        this.getDesktopPane().add(oggetto);
        oggetto.setLocation(200, 0);
        oggetto.setVisible(true);
        oggetto.moveToFront();
        this.setCursor(new Cursor(0));
    }

    private void jButtonFirstActionPerformed(ActionEvent evt) {
        if (this.ltm.getRowCount() != 0) {
            this.jTableListini.getSelectionModel().setSelectionInterval(0, 0);
        }
    }

    private void jButtonPreviousActionPerformed(ActionEvent evt) {
        try {
            if (this.jTableListini.getSelectedRow() > 0 && this.ltm.getRowCount() != 0) {
                this.jTableListini.getSelectionModel().setSelectionInterval(this.jTableListini.getSelectedRow() - 1, this.jTableListini.getSelectedRow() - 1);
            }
        }
        catch (Exception err) {
            MyTrace.log.severe("RAGGIUNTO PRIMO");
            err.printStackTrace();
        }
    }

    private void jButtonNextActionPerformed(ActionEvent evt) {
        try {
            if (this.ltm.getRowCount() != 0) {
                this.jTableListini.getSelectionModel().setSelectionInterval(this.jTableListini.getSelectedRow() + 1, this.jTableListini.getSelectedRow() + 1);
            }
        }
        catch (Exception err) {
            MyTrace.log.severe("RAGGIUNTO ULTIMO");
            err.printStackTrace();
        }
    }

    private void jButtonLastActionPerformed(ActionEvent evt) {
        if (this.ltm.getRowCount() != 0) {
            this.jTableListini.getSelectionModel().setSelectionInterval(this.ltm.getRowCount() - 1, this.ltm.getRowCount() - 1);
        }
    }

    private void jButtonRefreshActionPerformed(ActionEvent evt) {
        this.filtra();
        this.formatta();
        this.visualizzazione();
    }

    private void jButtonFiltraActionPerformed(ActionEvent evt) {
        if (!this.in_filter) {
            this.in_filter = true;
            String[] a_ric = new String[]{""};
            this.lfm.addRow(a_ric);
            this.fixedScroll.setViewportView(this.fixedTable);
            this.fixedScroll.setPreferredSize(new Dimension(400, 65));
            this.p.add((Component)this.fixedScroll, "North");
            this.p.repaint();
            this.repaint();
            this.fixedTable.setCellSelectionEnabled(true);
            this.fixedTable.changeSelection(0, 0, false, false);
            this.fixedTable.requestFocus();
        } else {
            this.in_filter = false;
            this.lfm.deleteRow();
            this.lfm = new ListiniFixedModel();
            this.fixedTable.setModel(this.lfm);
            this.fixedScroll.setViewportView(this.fixedTable);
            this.fixedScroll.setPreferredSize(new Dimension(400, 25));
            this.sorter.setRowFilter(null);
            this.p.add((Component)this.fixedScroll, "North");
            this.p.repaint();
            this.repaint();
        }
        this.formatta();
    }

    private void jButtonCleanActionPerformed(ActionEvent evt) {
        if (this.in_filter) {
            this.in_filter = true;
            this.sorter.setRowFilter(null);
            String[] a_ric = new String[]{""};
            this.lfm = new ListiniFixedModel();
            this.fixedTable.setModel(this.lfm);
            this.lfm.addRow(a_ric);
            this.andFilters = new ArrayList();
            for (int i = 0; i < this.ltm.getColumnCount(); ++i) {
                RowFilter rf_local = RowFilter.regexFilter("(?i)", i);
                this.andFilters.add(i, rf_local);
            }
            this.fixedScroll.setViewportView(this.fixedTable);
            this.fixedScroll.setPreferredSize(new Dimension(400, 65));
            this.p.add((Component)this.fixedScroll, "North");
            this.p.repaint();
            this.repaint();
        }
        this.formatta();
    }

    private void jButtonStampaActionPerformed(ActionEvent evt) {
    }

    private void jButtonAddOpzioneActionPerformed(ActionEvent evt) {
        if (this.jTablePl.getCellEditor() != null) {
            this.jTablePl.getCellEditor().stopCellEditing();
        }
        PrezzoListino temp = new PrezzoListino();
        temp.setA(new Articolo());
        temp.setCodice_art_fornitore("");
        if (!this.in_new) {
            temp.setId_listino(this.l_selezione.getId());
        }
        if (this.l_selezione.getInsieme_pl() == null || this.l_selezione.getInsieme_pl().vettorePL.size() == 0) {
            this.l_selezione.setInsieme_pl(new InsiemePrezziListino());
        }
        this.l_selezione.getInsieme_pl().vettorePL.add(temp);
        this.pltm.setData(this.l_selezione.getInsieme_pl().vettorePL);
    }

    private void posizione_finestra(ComponentEvent evt) {
        posizione_finestra = this.getLocation();
    }

    private void finestra_ridimensionata(ComponentEvent evt) {
        dimensione_finestra = this.getSize();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new MyTraListini("C").setVisible(true);
            }
        });
    }

    private void jTextCFFocusLost(FocusEvent evt) {
    }

    private void jTextCFKeyPressed(KeyEvent evt) {
    }

    private void jTextNoteFocusGained(FocusEvent evt) {
        if (this.jTablePl.getCellEditor() != null) {
            this.jTablePl.getCellEditor().stopCellEditing();
        }
    }

    private void jButtonEliminaRigaActionPerformed(ActionEvent evt) {
        int res = JOptionPane.showConfirmDialog(this, "Sei sicuro di voler eleiminare la riga numero" + this.riga_selezionata + " selezionata?");
        if (res == 0) {
            PrezzoListino p_da_el = this.l_selezione.getInsieme_pl().vettorePL.get(this.riga_selezionata);
            if (this.l_selezione.getInsieme_pl_da_el() == null) {
                this.l_selezione.setInsieme_pl_da_el(new InsiemePrezziListino());
            }
            this.l_selezione.getInsieme_pl_da_el().vettorePL.add(p_da_el);
            this.l_selezione.getInsieme_pl().vettorePL.remove(this.riga_selezionata);
            this.pltm.setData(this.l_selezione.getInsieme_pl().vettorePL);
            this.jTablePl.setModel(this.pltm);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        int viewRow = this.jTableListini.getSelectedRow();
        int modelRow = 1000000000;
        if (this.in_filter) {
            if (viewRow >= 0) {
                modelRow = this.jTableListini.convertRowIndexToModel(viewRow);
            }
        } else {
            modelRow = viewRow;
        }
        if (modelRow <= this.ltm.getRowCount() - 1 && modelRow >= 0) {
            this.seleziona(modelRow);
        }
    }

    public class TextPrezziEditor
    extends TextInsertEditor {
        @Override
        public void chiama_aiuto(String col_row) {
            String[] a = col_row.split("_");
            int col = Integer.parseInt(a[0]);
            int row = Integer.parseInt(a[1]);
            System.out.println("chiamaaiuto " + col + " " + row);
            MyListiniAcquisto.this.aiuto_articolo(MyListiniAcquisto.this.jTablePl.getSelectedRow(), col);
            this.getCellEditorValue();
        }
    }

    public class TextEditor
    extends RicercaCellEditor {
        RowFilter<ListiniTableModel, Object> rf_local = null;

        @Override
        public void newFilter(int col) {
            if (!MyListiniAcquisto.this.non_tutte_le_righe) {
                try {
                    this.rf_local = RowFilter.regexFilter("(?i)" + this.tf.getText(), col);
                    MyListiniAcquisto.this.andFilters.set(col, this.rf_local);
                }
                catch (PatternSyntaxException e) {
                    Funzioni.inviaBugPerEmail(e);
                    Funzioni.LogStackTrace(e);
                    return;
                }
                MyListiniAcquisto.this.rf = RowFilter.andFilter(MyListiniAcquisto.this.andFilters);
                MyListiniAcquisto.this.sorter.setRowFilter(MyListiniAcquisto.this.rf);
                MyListiniAcquisto.this.formatta();
            } else {
                String where = "";
                where = where + "WHERE 1 ";
                if (col == 0) {
                    where = where + " AND mmag_listini.nome LIKE '%" + this.tf.getText() + "%' ";
                }
                String order_by = " ORDER BY ragione_sociale_cf ASC LIMIT 0," + Configurazioni.righe_ricerca;
                MyListiniAcquisto.this.insieme_l.caricamento(where, order_by);
                MyListiniAcquisto.this.ltm.setDataListini(MyListiniAcquisto.this.insieme_l.vettoreListini);
                MyListiniAcquisto.this.formatta();
            }
        }
    }
}

