/*
 * Decompiled with CFR 0.152.
 */
package magazzino.listini;

import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.table.AbstractTableModel;
import magazzino.listini.Fattore;
import utils.Funzioni;
import utils.FunzioniDate;
import utils.Money;

public class FattoriTableModel
extends AbstractTableModel {
    ArrayList<Fattore> cache;
    Funzioni f = new Funzioni();
    FunzioniDate fda = new FunzioniDate();

    public FattoriTableModel() {
        this.cache = new ArrayList();
    }

    @Override
    public String getColumnName(int i) {
        String retVal = "";
        switch (i) {
            case 0: {
                retVal = "Da";
                break;
            }
            case 1: {
                retVal = "A";
                break;
            }
            case 2: {
                retVal = "Fattore";
                break;
            }
            default: {
                retVal = "";
            }
        }
        return retVal;
    }

    @Override
    public int getRowCount() {
        return this.cache.size();
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (!this.cache.isEmpty()) {
            Fattore p = this.cache.get(row);
            return p.getColValue(col);
        }
        return "";
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        Fattore p = this.cache.get(row);
        if (col == 0) {
            p.setDa(new Money(value.toString()));
        }
        if (col == 1) {
            p.setA(new Money(value.toString()));
        }
        if (col == 2) {
            p.setFattore(Double.parseDouble(value.toString()));
        }
        this.fireTableRowsUpdated(row, row);
    }

    public Class getColumnClass(int c) {
        return this.getValueAt(0, c).getClass();
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return true;
    }

    public void setData(ArrayList<Fattore> vettorePNR) {
        this.cache = new ArrayList();
        Iterator<Fattore> i = vettorePNR.iterator();
        while (i.hasNext()) {
            this.cache.add(i.next());
        }
        this.fireTableChanged(null);
    }
}

