/*
 * Decompiled with CFR 0.152.
 */
package magazzino.distinte_base;

import java.math.BigDecimal;
import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;
import magazzino.articoli.Articolo;
import magazzino.distinte_base.Componente;
import utils.Quantita;

public class ComponentiTableModel
extends AbstractTableModel {
    ArrayList<Componente> cache = new ArrayList();
    int colCount;
    String[] headers;
    boolean modo_ric = false;

    public void setModo_ric(boolean modo_ric) {
        this.modo_ric = modo_ric;
    }

    @Override
    public String getColumnName(int i) {
        String retVal = "";
        switch (i) {
            case 0: {
                retVal = "Codice";
                break;
            }
            case 1: {
                retVal = "Descrizione";
                break;
            }
            case 2: {
                retVal = "Quantita";
                break;
            }
            case 3: {
                retVal = "Note";
                break;
            }
            default: {
                retVal = this.headers[i];
            }
        }
        return retVal;
    }

    @Override
    public int getRowCount() {
        return this.cache.size();
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (!this.cache.isEmpty()) {
            Componente g = this.cache.get(row);
            return g.getColValue(col);
        }
        return "";
    }

    public Class getColumnClass(int c) {
        return this.getValueAt(0, c).getClass();
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        Componente c = this.cache.get(row);
        if (col == 0) {
            Articolo a = new Articolo();
            a.seleziona(" WHERE v_mmag_articoli_estesa.codice_articolo= '" + value.toString() + "' ");
            c.setId_articolo(a.getId());
            c.setDescrizione_articolo(a.getDescrizione());
            c.setCodice_articolo(a.getCodice_articolo());
            if (c.getQuantita().isZero()) {
                c.setQuantita(new Quantita(BigDecimal.ONE));
            }
        }
        if (col == 2) {
            c.setQuantita(new Quantita(value.toString()));
        }
        if (col == 3) {
            c.setNote(value.toString());
        }
        this.fireTableRowsUpdated(row, row);
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col != 1;
    }

    public void setDataComponenti(ArrayList<Componente> vettoreComponenti) {
        this.cache = new ArrayList();
        for (Componente c : vettoreComponenti) {
            this.cache.add(c);
        }
        this.fireTableChanged(null);
    }
}

