/*
 * Decompiled with CFR 0.152.
 */
package gestionale.trattamento_economico;

import anagrafiche.clienti_fornitori.MyAnagrafica;
import cisterna.das.MyDAS;
import gestionale.MyDesktopWindow;
import gestionale.configurazioni.ConfigurazioneFinestre;
import gestionale.configurazioni.Configurazioni;
import gestionale.configurazioni.MyProprietaFrame;
import gestionale.documenti.MyDocumentiAttivi;
import gestionale.primanota.MyRegistrazioni;
import gestionale.trattamento_economico.ConfRata;
import gestionale.trattamento_economico.ConfRateTableModel;
import gestionale.trattamento_economico.InsiemeConfRate;
import gestionale.trattamento_economico.InsiemeTE;
import gestionale.trattamento_economico.TEFixedModel;
import gestionale.trattamento_economico.TETableModel;
import gestionale.trattamento_economico.TrattamentoEconomico;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.regex.PatternSyntaxException;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.RowFilter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableRowSorter;
import magazzino.fOUT.MyFOut;
import magazzino.fpIN.MyfpIN;
import magazzino.ncIN.MyncIN;
import magazzino.ordini_for.MyMagazzinoOrdini;
import magazzino.richieste_offerte.MyMagazzinoRO;
import trasporti.fatturazione.MyTraFatturazione;
import trasporti.fatture_passive_autostrade.MyTraFattureAutostrade;
import trasporti.fatture_vettori.MyTraFattureVettori;
import trasporti.manutenzione_ddi.MyDDIManutenzione;
import utils.Funzioni;
import utils.GenericTableRenderer;
import utils.MyTrace;
import utils.RicercaCellEditor;
import utils.RicercaCellRenderer;
import utils.TextInsertEditor;
import utils.ToolTipHeader;

public class MyTrattamentoEconomico
extends JInternalFrame
implements InternalFrameListener,
ListSelectionListener,
MouseListener {
    String civetta_permessi;
    public static int size_diritti = 1;
    public static String[] array_diritti = new String[]{"CONFIGURAZIONE_TABELLE_MODIFICA"};
    JToolBar jToolBarMod;
    TETableModel tetm;
    InsiemeTE insieme_te;
    JScrollPane scroll;
    JTable jTableTE;
    TEFixedModel tefm;
    JScrollPane fixedScroll;
    JTable fixedTable;
    ConfRateTableModel rtm;
    private TableRowSorter<TETableModel> sorter;
    RowFilter<TETableModel, Object> rf = null;
    ArrayList<RowFilter<TETableModel, Object>> andFilters = new ArrayList();
    boolean in_filter = false;
    boolean in_modifica = false;
    boolean in_new = false;
    boolean non_tutte_le_righe = false;
    TrattamentoEconomico te_selezione;
    public int checkchiamante = 0;
    public JInternalFrame chiamante = null;
    Funzioni f = new Funzioni();
    private JButton jButtonAddRata;
    private JButton jButtonClean;
    private JButton jButtonElimina;
    private JToggleButton jButtonFiltra;
    private JButton jButtonFirst;
    private JButton jButtonForm;
    private JButton jButtonLast;
    private JButton jButtonModifica;
    private JButton jButtonNext;
    private JButton jButtonNuovo;
    private JButton jButtonPrevious;
    private JButton jButtonRefresh;
    private JButton jButtonStampa;
    private JComboBox jComboMP;
    private JComboBox jComboPartenza;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanelDettaglio;
    private JPanel jPanelElenco;
    private JPanel jPanelRate;
    private JScrollPane jScrollPane1;
    private JToolBar.Separator jSeparator1;
    private JToolBar.Separator jSeparator2;
    private JToolBar.Separator jSeparator3;
    private JTabbedPane jTabbedPane1;
    private JTable jTableRate;
    private JTextField jTextCod;
    private JTextField jTextDescrizione;
    private JTextField jTextNRate;
    private JToolBar jToolBar1;
    private JPanel p;

    public MyTrattamentoEconomico() {
        this.tetm = new TETableModel();
        this.insieme_te = new InsiemeTE();
        this.jTableTE = new JTable(this.tetm);
        this.jTableTE.setSelectionMode(0);
        this.sorter = new TableRowSorter<TETableModel>(this.tetm);
        for (int i = 0; i < this.tetm.getColumnCount(); ++i) {
            RowFilter rf_local = RowFilter.regexFilter("(?i)", i);
            this.andFilters.add(i, rf_local);
        }
        this.tefm = new TEFixedModel();
        this.tefm.setFIXED_NUM(0);
        this.fixedTable = new JTable(this.tefm);
        this.fixedTable.setAutoResizeMode(4);
        this.rtm = new ConfRateTableModel();
        this.addInternalFrameListener(this);
        this.initComponents();
        this.crea_toolbar();
        this.aggiungi_tabelle();
        this.filtra();
        ListSelectionModel listSelectionModel = this.jTableTE.getSelectionModel();
        listSelectionModel.addListSelectionListener(this);
        this.formatta();
        this.visualizzazione();
        this.controlla_diritti();
        this.setLocation(ConfigurazioneFinestre.GetPoint(this.getClass().getName(), new Point(200, 0)));
        this.setSize(ConfigurazioneFinestre.GetDimension(this.getClass().getName(), new Dimension(600, 600)));
    }

    private void controlla_diritti() {
        if (!MyDesktopWindow.profilo.controllaPermesso("CONFIGURAZIONE_TABELLE_MODIFICA")) {
            this.jButtonModifica.setEnabled(false);
            this.jButtonNuovo.setEnabled(false);
            this.jButtonElimina.setEnabled(false);
        }
    }

    private void crea_toolbar() {
        this.jToolBarMod = new JToolBar();
        JButton jButtonSalva = new JButton();
        JButton jButtonAnnulla = new JButton();
        jButtonSalva.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/document-save-as.png")));
        jButtonSalva.setText("Salva");
        jButtonSalva.setFocusable(true);
        jButtonSalva.setVerticalTextPosition(3);
        jButtonSalva.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyTrattamentoEconomico.this.jButtonSalvaActionPerformed(evt);
            }
        });
        this.jToolBarMod.add(jButtonSalva);
        jButtonAnnulla.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/edit-undo.png")));
        jButtonAnnulla.setText("Annulla");
        jButtonAnnulla.setFocusable(true);
        jButtonAnnulla.setVerticalTextPosition(3);
        jButtonAnnulla.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyTrattamentoEconomico.this.jButtonAnnullaActionPerformed(evt);
            }
        });
        this.jToolBarMod.add(jButtonAnnulla);
    }

    private void aggiungi_tabelle() {
        this.scroll = new JScrollPane(this.jTableTE){

            @Override
            public void setColumnHeaderView(Component view) {
            }
        };
        this.scroll.setHorizontalScrollBarPolicy(31);
        this.fixedScroll = new JScrollPane(this.fixedTable);
        this.fixedScroll.setVerticalScrollBarPolicy(22);
        this.fixedScroll.setPreferredSize(new Dimension(400, 25));
        JScrollBar bar = this.fixedScroll.getVerticalScrollBar();
        JScrollBar dummyBar = new JScrollBar(){

            @Override
            public void paint(Graphics g) {
            }
        };
        dummyBar.setPreferredSize(bar.getPreferredSize());
        this.fixedScroll.setVerticalScrollBar(dummyBar);
        final JScrollBar bar1 = this.scroll.getHorizontalScrollBar();
        JScrollBar bar2 = this.fixedScroll.getHorizontalScrollBar();
        bar2.addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                bar1.setValue(e.getValue());
            }
        });
        this.jTableTE.setModel(this.tetm);
        this.jTableTE.setAutoCreateRowSorter(true);
        this.jTableTE.setRowSorter(this.sorter);
        this.jTableTE.setFillsViewportHeight(true);
        this.p.add((Component)this.scroll, "Center");
        this.p.add((Component)this.fixedScroll, "North");
    }

    public void visualizzazione() {
        int numero = Integer.parseInt(this.jTextNRate.getText());
        int dimensione = this.te_selezione.getI_rate().vettoreTE.size();
        if (dimensione != numero) {
            this.jButtonAddRata.setVisible(true);
            this.jLabel7.setVisible(true);
        } else {
            this.jButtonAddRata.setVisible(false);
            this.jLabel7.setVisible(false);
        }
        this.jTextCod.setEnabled(this.in_modifica);
        this.jTextDescrizione.setEnabled(this.in_modifica);
        this.jComboPartenza.setEnabled(this.in_modifica);
        this.jTextNRate.setEnabled(this.in_modifica);
        this.jComboMP.setEnabled(this.in_modifica);
        this.jTableRate.setEnabled(this.in_modifica);
        if (this.in_modifica) {
            this.getContentPane().remove(this.jToolBar1);
            this.getContentPane().add((Component)this.jToolBarMod, "North");
            this.jTabbedPane1.setEnabledAt(0, false);
        } else {
            this.getContentPane().remove(this.jToolBarMod);
            this.getContentPane().add((Component)this.jToolBar1, "North");
            this.jTabbedPane1.setEnabledAt(0, true);
        }
        this.getContentPane().validate();
        this.getContentPane().repaint();
    }

    public void formatta() {
        this.jTableTE.getSelectionModel().setSelectionInterval(0, 0);
        this.jTableTE.setDefaultRenderer(Object.class, new GenericTableRenderer());
        this.jTableTE.addMouseListener(this);
        this.fixedTable.setRowHeight(30);
        this.fixedTable.setDefaultEditor(String.class, new TextEditor());
        this.fixedTable.setDefaultRenderer(String.class, new RicercaCellRenderer());
        this.jTableRate.setRowHeight(25);
        this.jTableRate.setDefaultEditor(Object.class, new TextInsertEditor());
        this.jTableRate.setDefaultRenderer(Object.class, new RicercaCellRenderer());
        this.header_tebella();
    }

    public void header_tebella() {
        try {
            String[] toolTipStr = new String[]{"Codice Trattamento", "Descrizione Trattamento"};
            ToolTipHeader header1 = new ToolTipHeader(this.jTableTE.getColumnModel());
            ToolTipHeader header2 = new ToolTipHeader(this.fixedTable.getColumnModel());
            header1.setToolTipStrings(toolTipStr);
            header2.setToolTipStrings(toolTipStr);
            this.fixedTable.setTableHeader(header2);
            this.jTableTE.setTableHeader(header1);
            header1.setResizingAllowed(false);
            header2.setResizingAllowed(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void filtra() {
        String o = "";
        if (Configurazioni.righe_ricerca != 0) {
            o = o + " LIMIT 0," + Configurazioni.righe_ricerca;
        }
        this.insieme_te.caricamento("", o);
        this.tetm.setDataTE(this.insieme_te.vettoreTE);
        if (Configurazioni.righe_ricerca != 0 && this.insieme_te.vettoreTE.size() >= Configurazioni.righe_ricerca) {
            this.non_tutte_le_righe = true;
        }
    }

    public void seleziona(int row) {
        this.te_selezione = new TrattamentoEconomico();
        this.te_selezione = (TrattamentoEconomico)this.insieme_te.vettoreTE.elementAt(row);
        this.te_selezione.seleziona_dettagli();
        this.riempi_campi();
    }

    public void riempi_campi() {
        this.jTextCod.setText(this.te_selezione.getCodice());
        this.jTextDescrizione.setText(this.te_selezione.getDescrizione());
        this.jComboPartenza.setSelectedItem(this.te_selezione.getPartenza());
        this.jTextNRate.setText("" + this.te_selezione.getRate());
        this.jComboMP.setSelectedItem(this.te_selezione.getModo_pagamento());
        this.f.ordina_vettore_rate(this.te_selezione.getI_rate().vettoreTE);
        this.rtm.setDataConfRate(this.te_selezione.getI_rate().vettoreTE);
        this.jTableRate.setModel(this.rtm);
    }

    private void costruisci() {
        this.te_selezione.setCodice(this.jTextCod.getText());
        this.te_selezione.setDescrizione(this.jTextDescrizione.getText());
        this.te_selezione.setPartenza(this.jComboPartenza.getSelectedItem().toString());
        this.te_selezione.setModo_pagamento(this.jComboMP.getSelectedItem().toString());
        int nr = 0;
        try {
            nr = Integer.parseInt(this.jTextNRate.getText());
        }
        catch (NumberFormatException e) {
            MyTrace.log.severe("ERRORE:non hai inserito un numero in nrate");
            e.printStackTrace();
            Funzioni.LogStackTrace(e);
        }
        this.te_selezione.setRate(nr);
    }

    private boolean check() {
        if (this.in_new && this.f.id_trattamento_economico(this.jTextCod.getText()) != 0) {
            JOptionPane.showMessageDialog(this, "Esiste gi\u00e0 un trattamento economico con questo codice");
            return false;
        }
        if (this.jTextCod.getText().equals("")) {
            JOptionPane.showMessageDialog(this, "Non \u00e8 possibile inserire un trattamento economico senza codice");
            return false;
        }
        if (this.jTextNRate.getText() == null || this.jTextNRate.getText().equals("0")) {
            JOptionPane.showMessageDialog(this, "Non \u00e8 possibile inserire un trattamento economico senza nessuna rata");
            return false;
        }
        if (this.jTextDescrizione.getText().equals("")) {
            JOptionPane.showMessageDialog(this, "Inserire la descrizione");
            return false;
        }
        return true;
    }

    private void initComponents() {
        this.jToolBar1 = new JToolBar();
        this.jButtonNuovo = new JButton();
        this.jButtonModifica = new JButton();
        this.jButtonElimina = new JButton();
        this.jButtonForm = new JButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.jButtonFirst = new JButton();
        this.jButtonPrevious = new JButton();
        this.jButtonNext = new JButton();
        this.jButtonLast = new JButton();
        this.jSeparator2 = new JToolBar.Separator();
        this.jButtonRefresh = new JButton();
        this.jButtonFiltra = new JToggleButton();
        this.jButtonClean = new JButton();
        this.jSeparator3 = new JToolBar.Separator();
        this.jButtonStampa = new JButton();
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanelElenco = new JPanel();
        this.p = new JPanel();
        this.jPanelDettaglio = new JPanel();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jTextCod = new JTextField();
        this.jTextDescrizione = new JTextField();
        this.jLabel3 = new JLabel();
        this.jComboPartenza = new JComboBox();
        this.jLabel4 = new JLabel();
        this.jTextNRate = new JTextField();
        this.jLabel5 = new JLabel();
        this.jComboMP = new JComboBox();
        this.jPanelRate = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jTableRate = new JTable(this.rtm);
        this.jLabel6 = new JLabel();
        this.jPanel2 = new JPanel();
        this.jButtonAddRata = new JButton();
        this.jLabel7 = new JLabel();
        this.setClosable(true);
        this.setDefaultCloseOperation(2);
        this.setIconifiable(true);
        this.setMaximizable(true);
        this.setResizable(true);
        this.setTitle("Configurazioni \\ Trattamento Economico");
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent evt) {
                MyTrattamentoEconomico.this.posizione_finestra(evt);
            }

            @Override
            public void componentResized(ComponentEvent evt) {
                MyTrattamentoEconomico.this.finestra_ridimensionata(evt);
            }
        });
        this.jToolBar1.setRollover(true);
        this.jButtonNuovo.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/document-new.png")));
        this.jButtonNuovo.setText("Nuovo");
        this.jButtonNuovo.setFocusable(false);
        this.jButtonNuovo.setVerticalTextPosition(3);
        this.jButtonNuovo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyTrattamentoEconomico.this.jButtonNuovoActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonNuovo);
        this.jButtonModifica.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/accessories-text-editor.png")));
        this.jButtonModifica.setText("Modifica");
        this.jButtonModifica.setFocusable(false);
        this.jButtonModifica.setHorizontalAlignment(11);
        this.jButtonModifica.setVerticalTextPosition(3);
        this.jButtonModifica.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyTrattamentoEconomico.this.jButtonModificaActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonModifica);
        this.jButtonElimina.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/user-trash.png")));
        this.jButtonElimina.setText("Elimina");
        this.jButtonElimina.setFocusable(false);
        this.jButtonElimina.setHorizontalAlignment(11);
        this.jButtonElimina.setVerticalTextPosition(3);
        this.jButtonElimina.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyTrattamentoEconomico.this.jButtonEliminaActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonElimina);
        this.jButtonForm.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/preferences-system.png")));
        this.jButtonForm.setText("Propriet\u00e0");
        this.jButtonForm.setFocusable(false);
        this.jButtonForm.setHorizontalAlignment(11);
        this.jButtonForm.setVerticalTextPosition(3);
        this.jButtonForm.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyTrattamentoEconomico.this.jButtonFormActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonForm);
        this.jToolBar1.add(this.jSeparator1);
        this.jButtonFirst.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/go-first.png")));
        this.jButtonFirst.setFocusable(false);
        this.jButtonFirst.setHorizontalTextPosition(0);
        this.jButtonFirst.setVerticalTextPosition(3);
        this.jButtonFirst.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyTrattamentoEconomico.this.jButtonFirstActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonFirst);
        this.jButtonPrevious.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/go-previous.png")));
        this.jButtonPrevious.setFocusable(false);
        this.jButtonPrevious.setHorizontalTextPosition(0);
        this.jButtonPrevious.setVerticalTextPosition(3);
        this.jButtonPrevious.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyTrattamentoEconomico.this.jButtonPreviousActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonPrevious);
        this.jButtonNext.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/go-next.png")));
        this.jButtonNext.setFocusable(false);
        this.jButtonNext.setHorizontalTextPosition(0);
        this.jButtonNext.setVerticalTextPosition(3);
        this.jButtonNext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyTrattamentoEconomico.this.jButtonNextActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonNext);
        this.jButtonLast.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/go-last.png")));
        this.jButtonLast.setFocusable(false);
        this.jButtonLast.setHorizontalTextPosition(0);
        this.jButtonLast.setVerticalTextPosition(3);
        this.jButtonLast.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyTrattamentoEconomico.this.jButtonLastActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonLast);
        this.jToolBar1.add(this.jSeparator2);
        this.jButtonRefresh.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/view-refresh.png")));
        this.jButtonRefresh.setFocusable(false);
        this.jButtonRefresh.setHorizontalTextPosition(0);
        this.jButtonRefresh.setVerticalTextPosition(3);
        this.jButtonRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyTrattamentoEconomico.this.jButtonRefreshActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonRefresh);
        this.jButtonFiltra.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/edit-find.png")));
        this.jButtonFiltra.setFocusable(false);
        this.jButtonFiltra.setHorizontalTextPosition(0);
        this.jButtonFiltra.setVerticalTextPosition(3);
        this.jButtonFiltra.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyTrattamentoEconomico.this.jButtonFiltraActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonFiltra);
        this.jButtonClean.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/edit-clear.png")));
        this.jButtonClean.setFocusable(false);
        this.jButtonClean.setHorizontalTextPosition(0);
        this.jButtonClean.setVerticalTextPosition(3);
        this.jButtonClean.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyTrattamentoEconomico.this.jButtonCleanActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonClean);
        this.jToolBar1.add(this.jSeparator3);
        this.jButtonStampa.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/document-print.png")));
        this.jButtonStampa.setFocusable(false);
        this.jButtonStampa.setHorizontalTextPosition(0);
        this.jButtonStampa.setVerticalTextPosition(3);
        this.jToolBar1.add(this.jButtonStampa);
        this.getContentPane().add((Component)this.jToolBar1, "North");
        this.jPanelElenco.setLayout(new BorderLayout());
        this.p.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.p.setLayout(new BorderLayout());
        this.jPanelElenco.add((Component)this.p, "Center");
        this.jTabbedPane1.addTab("Elenco", this.jPanelElenco);
        this.jPanelDettaglio.setLayout(new BorderLayout());
        this.jPanel1.setLayout(new GridBagLayout());
        this.jLabel1.setText("Codice");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel1.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel2.setText("Descrizione");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel1.add((Component)this.jLabel2, gridBagConstraints);
        this.jTextCod.setMinimumSize(new Dimension(200, 30));
        this.jTextCod.setPreferredSize(new Dimension(200, 27));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel1.add((Component)this.jTextCod, gridBagConstraints);
        this.jTextDescrizione.setMinimumSize(new Dimension(200, 30));
        this.jTextDescrizione.setPreferredSize(new Dimension(200, 27));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel1.add((Component)this.jTextDescrizione, gridBagConstraints);
        this.jLabel3.setText("Data di Partenza");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel1.add((Component)this.jLabel3, gridBagConstraints);
        this.jComboPartenza.setModel(new DefaultComboBoxModel<String>(new String[]{"Data Fattura", "Fine Mese"}));
        this.jComboPartenza.setPreferredSize(new Dimension(87, 27));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel1.add((Component)this.jComboPartenza, gridBagConstraints);
        this.jLabel4.setText("Numero Rate");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel1.add((Component)this.jLabel4, gridBagConstraints);
        this.jTextNRate.setMinimumSize(new Dimension(200, 30));
        this.jTextNRate.setPreferredSize(new Dimension(200, 27));
        this.jTextNRate.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                MyTrattamentoEconomico.this.jTextNRateFocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel1.add((Component)this.jTextNRate, gridBagConstraints);
        this.jLabel5.setText("Modalit\u00e0 di Pagamento");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel1.add((Component)this.jLabel5, gridBagConstraints);
        this.jComboMP.setModel(new DefaultComboBoxModel<String>(new String[]{"BB", "BPOST", "CONTR", "RDIR", "RIBA", "RID"}));
        this.jComboMP.setPreferredSize(new Dimension(60, 27));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel1.add((Component)this.jComboMP, gridBagConstraints);
        this.jPanelRate.setPreferredSize(new Dimension(252, 202));
        this.jPanelRate.setLayout(new BorderLayout());
        this.jTableRate.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.jTableRate.setPreferredSize(new Dimension(300, 200));
        this.jScrollPane1.setViewportView(this.jTableRate);
        this.jPanelRate.add((Component)this.jScrollPane1, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.jPanel1.add((Component)this.jPanelRate, gridBagConstraints);
        this.jLabel6.setBackground(new Color(204, 255, 204));
        this.jLabel6.setFont(new Font("Tahoma", 1, 11));
        this.jLabel6.setText("Rate");
        this.jLabel6.setOpaque(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.jPanel1.add((Component)this.jLabel6, gridBagConstraints);
        this.jPanel2.setMinimumSize(new Dimension(500, 20));
        this.jPanel2.setLayout(new GridBagLayout());
        this.jButtonAddRata.setText("+");
        this.jButtonAddRata.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyTrattamentoEconomico.this.jButtonAddRataActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        this.jPanel2.add((Component)this.jButtonAddRata, gridBagConstraints);
        this.jLabel7.setText("(Il numero delle rate scritto non combacia con il numero effettivo di righe)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.jPanel2.add((Component)this.jLabel7, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 2;
        this.jPanel1.add((Component)this.jPanel2, gridBagConstraints);
        this.jPanelDettaglio.add((Component)this.jPanel1, "Center");
        this.jTabbedPane1.addTab("Dettaglio", this.jPanelDettaglio);
        this.getContentPane().add((Component)this.jTabbedPane1, "Center");
        this.pack();
    }

    private void jButtonSalvaActionPerformed(ActionEvent evt) {
        if (this.in_new) {
            if (this.check()) {
                this.costruisci();
                boolean check2 = this.te_selezione.iinserisci(true);
                if (check2) {
                    this.in_new = false;
                    this.in_modifica = false;
                    this.filtra();
                    this.visualizzazione();
                    this.jTabbedPane1.setSelectedIndex(0);
                } else {
                    JOptionPane.showMessageDialog(this, "Si \u00e8 verificato un errore al momento dell'inserimento dei dati nel database,\nRicontrollare i campi riempiti e non.\nSe il problema persiste contattare Kronos");
                }
            }
        } else if (this.check()) {
            this.costruisci();
            this.te_selezione.mmodifica(true);
            this.in_modifica = false;
            this.filtra();
            this.visualizzazione();
            this.jTabbedPane1.setSelectedIndex(0);
        } else {
            JOptionPane.showMessageDialog(this, "Si \u00e8 verificato un errore al momento dell'inserimento dei dati nel database,\nRicontrollare i campi riempiti e non.\nSe il problema persiste contattare Kronos");
        }
    }

    private void jButtonAnnullaActionPerformed(ActionEvent evt) {
        this.in_modifica = false;
        this.visualizzazione();
        this.jTabbedPane1.setSelectedIndex(0);
    }

    private void jButtonNuovoActionPerformed(ActionEvent evt) {
        this.in_new = true;
        this.jTableTE.getSelectionModel().clearSelection();
        this.te_selezione = new TrattamentoEconomico();
        this.te_selezione.setI_rate(new InsiemeConfRate());
        this.riempi_campi();
        this.in_modifica = true;
        this.jTabbedPane1.setSelectedIndex(1);
        this.visualizzazione();
    }

    private void jButtonModificaActionPerformed(ActionEvent evt) {
        this.in_modifica = true;
        this.visualizzazione();
        this.jTabbedPane1.setSelectedIndex(1);
    }

    private void jButtonEliminaActionPerformed(ActionEvent evt) {
        this.jTabbedPane1.setSelectedIndex(1);
        int res = JOptionPane.showConfirmDialog(this, "Sei sicuro di voler eleiminare questo trattamento economico?");
        if (res == 0) {
            this.te_selezione.eelimina(true);
            this.in_modifica = false;
            this.filtra();
        }
        this.visualizzazione();
        this.jTabbedPane1.setSelectedIndex(0);
    }

    private void jButtonFormActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        MyProprietaFrame oggetto = new MyProprietaFrame();
        this.getDesktopPane().add(oggetto);
        oggetto.setLocation(200, 0);
        oggetto.setVisible(true);
        oggetto.moveToFront();
        this.setCursor(new Cursor(0));
    }

    private void jButtonFirstActionPerformed(ActionEvent evt) {
        if (this.tetm.getRowCount() != 0) {
            this.jTableTE.getSelectionModel().setSelectionInterval(0, 0);
        }
    }

    private void jButtonPreviousActionPerformed(ActionEvent evt) {
        if (this.jTableTE.getSelectedRow() > 0 && this.tetm.getRowCount() != 0) {
            this.jTableTE.getSelectionModel().setSelectionInterval(this.jTableTE.getSelectedRow() - 1, this.jTableTE.getSelectedRow() - 1);
        }
    }

    private void jButtonNextActionPerformed(ActionEvent evt) {
        if (this.tetm.getRowCount() != 0) {
            this.jTableTE.getSelectionModel().setSelectionInterval(this.jTableTE.getSelectedRow() + 1, this.jTableTE.getSelectedRow() + 1);
        }
    }

    private void jButtonLastActionPerformed(ActionEvent evt) {
        if (this.tetm.getRowCount() != 0) {
            this.jTableTE.getSelectionModel().setSelectionInterval(this.tetm.getRowCount() - 1, this.tetm.getRowCount() - 1);
        }
    }

    private void jButtonRefreshActionPerformed(ActionEvent evt) {
        this.filtra();
        this.formatta();
        this.visualizzazione();
    }

    private void jButtonFiltraActionPerformed(ActionEvent evt) {
        if (!this.in_filter) {
            this.in_filter = true;
            String[] a_ric = new String[]{"", ""};
            this.tefm.addRow(a_ric);
            this.fixedScroll.setViewportView(this.fixedTable);
            this.fixedScroll.setPreferredSize(new Dimension(400, 65));
            this.p.add((Component)this.fixedScroll, "North");
            this.p.repaint();
            this.repaint();
            this.fixedTable.setCellSelectionEnabled(true);
            this.fixedTable.changeSelection(0, 0, false, false);
            this.fixedTable.requestFocus();
        } else {
            this.in_filter = false;
            this.tefm.deleteRow();
            this.tefm = new TEFixedModel();
            this.fixedTable.setModel(this.tefm);
            this.fixedScroll.setViewportView(this.fixedTable);
            this.fixedScroll.setPreferredSize(new Dimension(400, 25));
            this.sorter.setRowFilter(null);
            this.p.add((Component)this.fixedScroll, "North");
            this.p.repaint();
            this.repaint();
        }
        this.formatta();
    }

    private void jButtonCleanActionPerformed(ActionEvent evt) {
        if (this.in_filter) {
            this.in_filter = true;
            this.sorter.setRowFilter(null);
            String[] a_ric = new String[]{"", ""};
            this.tefm = new TEFixedModel();
            this.fixedTable.setModel(this.tefm);
            this.tefm.addRow(a_ric);
            this.andFilters = new ArrayList();
            for (int i = 0; i < this.tetm.getColumnCount(); ++i) {
                RowFilter rf_local = RowFilter.regexFilter("(?i)", i);
                this.andFilters.add(i, rf_local);
            }
            this.fixedScroll.setViewportView(this.fixedTable);
            this.fixedScroll.setPreferredSize(new Dimension(400, 65));
            this.p.add((Component)this.fixedScroll, "North");
            this.p.repaint();
            this.repaint();
        }
        this.formatta();
    }

    private void jTextNRateFocusLost(FocusEvent evt) {
        int numero;
        if (this.in_new) {
            this.costruisci();
            this.te_selezione.setI_rate(new InsiemeConfRate());
            this.rtm = new ConfRateTableModel();
            numero = Integer.parseInt(this.jTextNRate.getText());
            if (numero == 0) {
                JOptionPane.showMessageDialog(this, "Non ci possono essere 0 rate");
            } else {
                for (int i = 0; i < numero; ++i) {
                    ConfRata r = new ConfRata();
                    r.setTe(this.te_selezione);
                    r.setGiorni(0);
                    r.setPercentuale(100.0);
                    this.te_selezione.getI_rate().vettoreTE.add(r);
                }
            }
            this.rtm.setDataConfRate(this.te_selezione.getI_rate().vettoreTE);
            this.jTableRate.setModel(this.rtm);
        }
        numero = Integer.parseInt(this.jTextNRate.getText());
        int dimensione = this.te_selezione.getI_rate().vettoreTE.size();
        if (dimensione != numero) {
            this.jButtonAddRata.setVisible(true);
            this.jLabel7.setVisible(true);
        } else {
            this.jButtonAddRata.setVisible(false);
            this.jLabel7.setVisible(false);
        }
    }

    private void posizione_finestra(ComponentEvent evt) {
        ConfigurazioneFinestre.SetPoint(this.getClass().getName(), this.getLocation());
    }

    private void finestra_ridimensionata(ComponentEvent evt) {
        ConfigurazioneFinestre.SetDimension(this.getClass().getName(), this.getSize());
    }

    private void jButtonAddRataActionPerformed(ActionEvent evt) {
        int numero = Integer.parseInt(this.jTextNRate.getText());
        int dimensione = this.te_selezione.getI_rate().vettoreTE.size();
        if (dimensione != numero) {
            this.jButtonAddRata.setVisible(true);
            this.jLabel7.setVisible(true);
            ConfRata r = new ConfRata();
            r.setTe(this.te_selezione);
            r.setGiorni(0);
            r.setPercentuale(100.0);
            this.te_selezione.getI_rate().vettoreTE.add(r);
            this.rtm.setDataConfRate(this.te_selezione.getI_rate().vettoreTE);
            this.jTableRate.setModel(this.rtm);
        } else {
            this.jButtonAddRata.setVisible(false);
            this.jLabel7.setVisible(false);
        }
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new MyTrattamentoEconomico().setVisible(true);
            }
        });
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        int viewRow = this.jTableTE.getSelectedRow();
        int modelRow = 1000000000;
        if (this.in_filter) {
            if (viewRow >= 0) {
                modelRow = this.jTableTE.convertRowIndexToModel(viewRow);
            }
        } else {
            modelRow = viewRow;
        }
        if (modelRow <= this.tetm.getRowCount() - 1 && modelRow >= 0) {
            this.seleziona(modelRow);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2) {
            JTable jtb = (JTable)e.getSource();
            int viewRow = jtb.getSelectedRow();
            int modelRow = 1000000000;
            if (this.in_filter) {
                if (viewRow >= 0) {
                    modelRow = this.jTableTE.convertRowIndexToModel(viewRow);
                }
            } else {
                modelRow = viewRow;
            }
            if (modelRow <= this.tetm.getRowCount() - 1 && modelRow >= 0) {
                TrattamentoEconomico te = (TrattamentoEconomico)this.insieme_te.vettoreTE.elementAt(modelRow);
                if (this.chiamante != null) {
                    if (this.chiamante.getClass() == MyAnagrafica.class && ((MyAnagrafica)this.chiamante).f_te_open) {
                        ((MyAnagrafica)this.chiamante).jTextMPagamento.setText("" + te.getCodice());
                        ((MyAnagrafica)this.chiamante).jLabelDescrizioneTE.setText("" + te.getDescrizione());
                        ((MyAnagrafica)this.chiamante).f_te_open = false;
                    }
                    if (this.chiamante.getClass() == MyRegistrazioni.class && ((MyRegistrazioni)this.chiamante).f_te_open) {
                        ((MyRegistrazioni)this.chiamante).jTextTE.setText(te.getCodice());
                        ((MyRegistrazioni)this.chiamante).f_te_open = false;
                    }
                    if (this.chiamante.getClass() == MyfpIN.class && ((MyfpIN)this.chiamante).f_te_open) {
                        ((MyfpIN)this.chiamante).jTextTE.setText(te.getCodice());
                        ((MyfpIN)this.chiamante).f_te_open = false;
                    }
                    if (this.chiamante.getClass() == MyncIN.class && ((MyncIN)this.chiamante).f_te_open) {
                        ((MyncIN)this.chiamante).jTextTE.setText(te.getCodice());
                        ((MyncIN)this.chiamante).f_te_open = false;
                    }
                    if (this.chiamante.getClass() == MyDAS.class && ((MyDAS)this.chiamante).f_te_open) {
                        ((MyDAS)this.chiamante).jTextTE.setText(te.getCodice());
                        ((MyDAS)this.chiamante).f_te_open = false;
                    }
                    if (this.chiamante.getClass() == MyDDIManutenzione.class && ((MyDDIManutenzione)this.chiamante).f_te_open) {
                        ((MyDDIManutenzione)this.chiamante).jTextTE.setText(te.getCodice());
                        ((MyDDIManutenzione)this.chiamante).f_te_open = false;
                    }
                    if (this.chiamante.getClass() == MyFOut.class && ((MyFOut)this.chiamante).f_te_open) {
                        ((MyFOut)this.chiamante).jTextTE.setText(te.getCodice());
                        ((MyFOut)this.chiamante).f_te_open = false;
                    }
                    if (this.chiamante.getClass() == MyDocumentiAttivi.class && ((MyDocumentiAttivi)this.chiamante).f_te_open) {
                        ((MyDocumentiAttivi)this.chiamante).jTextTE.setText(te.getCodice());
                        ((MyDocumentiAttivi)this.chiamante).f_te_open = false;
                    }
                    if (this.chiamante.getClass() == MyDAS.class && ((MyDAS)this.chiamante).f_te_open) {
                        ((MyDAS)this.chiamante).jTextTE.setText(te.getCodice());
                        ((MyDAS)this.chiamante).f_te_open = false;
                    }
                    if (this.chiamante.getClass() == MyTraFattureVettori.class && ((MyTraFattureVettori)this.chiamante).f_te_open) {
                        ((MyTraFattureVettori)this.chiamante).jTextTE.setText(te.getCodice());
                        ((MyTraFattureVettori)this.chiamante).f_te_open = false;
                    }
                    if (this.chiamante.getClass() == MyTraFatturazione.class && ((MyTraFatturazione)this.chiamante).f_te_open) {
                        ((MyTraFatturazione)this.chiamante).jTextTE.setText(te.getCodice());
                        ((MyTraFatturazione)this.chiamante).f_te_open = false;
                    }
                    if (this.chiamante.getClass() == MyTraFattureAutostrade.class && ((MyTraFattureAutostrade)this.chiamante).f_te_open) {
                        ((MyTraFattureAutostrade)this.chiamante).jTextTE.setText(te.getCodice());
                        ((MyTraFattureAutostrade)this.chiamante).f_te_open = false;
                    }
                    if (this.chiamante.getClass() == MyMagazzinoOrdini.class && ((MyMagazzinoOrdini)this.chiamante).f_te_open) {
                        ((MyMagazzinoOrdini)this.chiamante).jTextTE.setText(te.getCodice());
                        ((MyMagazzinoOrdini)this.chiamante).f_te_open = false;
                    }
                    if (this.chiamante.getClass() == MyMagazzinoRO.class && ((MyMagazzinoRO)this.chiamante).f_te_open) {
                        ((MyMagazzinoRO)this.chiamante).jTextTE.setText(te.getCodice());
                        ((MyMagazzinoRO)this.chiamante).f_te_open = false;
                    }
                    this.dispose();
                }
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void internalFrameOpened(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameClosing(InternalFrameEvent e) {
        if (this.chiamante != null) {
            if (this.chiamante.getClass() == MyAnagrafica.class && ((MyAnagrafica)this.chiamante).f_te_open) {
                ((MyAnagrafica)this.chiamante).f_te_open = false;
            }
            if (this.chiamante.getClass() == MyRegistrazioni.class && ((MyRegistrazioni)this.chiamante).f_te_open) {
                ((MyRegistrazioni)this.chiamante).f_te_open = false;
            }
            if (this.chiamante.getClass() == MyfpIN.class && ((MyfpIN)this.chiamante).f_te_open) {
                ((MyfpIN)this.chiamante).f_te_open = false;
            }
            if (this.chiamante.getClass() == MyncIN.class && ((MyncIN)this.chiamante).f_te_open) {
                ((MyncIN)this.chiamante).f_te_open = false;
            }
            if (this.chiamante.getClass() == MyDAS.class && ((MyDAS)this.chiamante).f_te_open) {
                ((MyDAS)this.chiamante).f_te_open = false;
            }
            if (this.chiamante.getClass() == MyDDIManutenzione.class && ((MyDDIManutenzione)this.chiamante).f_te_open) {
                ((MyDDIManutenzione)this.chiamante).f_te_open = false;
            }
            if (this.chiamante.getClass() == MyFOut.class && ((MyFOut)this.chiamante).f_te_open) {
                ((MyFOut)this.chiamante).f_te_open = false;
            }
            if (this.chiamante.getClass() == MyDocumentiAttivi.class && ((MyDocumentiAttivi)this.chiamante).f_te_open) {
                ((MyDocumentiAttivi)this.chiamante).f_te_open = false;
            }
            if (this.chiamante.getClass() == MyTraFattureVettori.class && ((MyTraFattureVettori)this.chiamante).f_te_open) {
                ((MyTraFattureVettori)this.chiamante).f_te_open = false;
            }
            if (this.chiamante.getClass() == MyTraFatturazione.class && ((MyTraFatturazione)this.chiamante).f_te_open) {
                ((MyTraFatturazione)this.chiamante).f_te_open = false;
            }
            if (this.chiamante.getClass() == MyTraFattureAutostrade.class && ((MyTraFattureAutostrade)this.chiamante).f_te_open) {
                ((MyTraFattureAutostrade)this.chiamante).f_te_open = false;
            }
            if (this.chiamante.getClass() == MyMagazzinoOrdini.class && ((MyMagazzinoOrdini)this.chiamante).f_te_open) {
                ((MyMagazzinoOrdini)this.chiamante).f_te_open = false;
            }
            if (this.chiamante.getClass() == MyMagazzinoRO.class && ((MyMagazzinoRO)this.chiamante).f_te_open) {
                ((MyMagazzinoRO)this.chiamante).f_te_open = false;
            }
            this.dispose();
        }
    }

    @Override
    public void internalFrameClosed(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameIconified(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameDeiconified(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameActivated(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameDeactivated(InternalFrameEvent e) {
    }

    public class TextEditor
    extends RicercaCellEditor {
        RowFilter<TETableModel, Object> rf_local = null;

        @Override
        public void newFilter(int col) {
            if (!MyTrattamentoEconomico.this.non_tutte_le_righe) {
                try {
                    this.rf_local = RowFilter.regexFilter("(?i)" + this.tf.getText(), col);
                    MyTrattamentoEconomico.this.andFilters.set(col, this.rf_local);
                }
                catch (PatternSyntaxException e) {
                    Funzioni.inviaBugPerEmail(e);
                    Funzioni.LogStackTrace(e);
                    return;
                }
                MyTrattamentoEconomico.this.rf = RowFilter.andFilter(MyTrattamentoEconomico.this.andFilters);
                MyTrattamentoEconomico.this.sorter.setRowFilter(MyTrattamentoEconomico.this.rf);
                MyTrattamentoEconomico.this.formatta();
            } else {
                String w = " WHERE 1 ";
                if (col == 0) {
                    w = w + " AND codice LIKE '%" + this.tf.getText() + "%'";
                }
                if (col == 1) {
                    w = w + " AND descrizione LIKE '%" + this.tf.getText() + "%'";
                }
                String o = " LIMIT 0," + Configurazioni.righe_ricerca;
                MyTrattamentoEconomico.this.insieme_te.caricamento(w, o);
                MyTrattamentoEconomico.this.tetm.setDataTE(MyTrattamentoEconomico.this.insieme_te.vettoreTE);
                MyTrattamentoEconomico.this.formatta();
            }
        }
    }
}

