/*
 * Decompiled with CFR 0.152.
 */
package gestionale.scadenziario;

import anagrafiche.banche.Banca;
import anagrafiche.clienti_fornitori.Anagrafica;
import anagrafiche.indirizzi.DA_CANCELLARE_Indirizzo;
import gestionale.configurazioni.Configurazioni;
import gestionale.personalizzazione.stampe.IntestazioneSollecito;
import gestionale.personalizzazione.stampe.PiedePaginaGenericoIntestato;
import gestionale.personalizzazione.stampe.TestoSollecito;
import gestionale.primanota.Registrazione;
import gestionale.scadenziario.InsiemeScadenze;
import gestionale.scadenziario.Scadenza;
import java.math.BigDecimal;
import java.util.Iterator;
import java.util.Vector;
import utils.Funzioni;
import utils.FunzioniDate;
import utils.Money;
import utils.MyTrace;
import utils.stampe.GestoreStampe;
import utils.stampe.OggettoToPrint;

public class StampaSollecito {
    Funzioni f;
    double totale;
    FunzioniDate fda;
    int id_scadenza;
    int id_cf;
    String tipo_cf;
    boolean esito = false;

    public StampaSollecito(int id_scadenza, int id_cf, String tipo_cf) {
        MyTrace.log.info("RICHIESTA ISTANZA CLASSE StampaSollecito()");
        this.id_cf = id_cf;
        this.id_scadenza = id_scadenza;
        this.tipo_cf = tipo_cf;
        MyTrace.log.info("CLASSE StampaSollecito() ISTANZIATA");
    }

    public StampaSollecito(int id_cf) {
        MyTrace.log.info("RICHIESTA ISTANZA CLASSE StampaSollecito()");
        this.id_cf = id_cf;
        MyTrace.log.info("CLASSE StampaSollecito() ISTANZIATA");
    }

    public boolean Elabora() {
        Configurazioni.getIstanza();
        int y_inizio = Configurazioni.inizio_stampe;
        try {
            MyTrace.log.info(" XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX STAMPA SOLLECITO INIZIO XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
            long tempo_di_visualizzazione = System.currentTimeMillis();
            GestoreStampe stampa_sollecito = new GestoreStampe();
            stampa_sollecito.aggiungi_pj();
            Vector vettoreS = new Vector();
            String ragione_sociale = "ragione sociale";
            String email = "email";
            String piva = "piva";
            boolean id_trattamento = false;
            String trattamento = "trattamento";
            String banca = "banca";
            String sede_via = "via";
            String sede_cap = "cap";
            String sede_citta = "citt\u00e0";
            String sede_provincia = "provincia";
            this.f = new Funzioni();
            String sede_indirizzo = "";
            this.fda = new FunzioniDate();
            stampa_sollecito.setIntPP((OggettoToPrint)new IntestazioneSollecito());
            stampa_sollecito.setPiedePaginaGenericoIntestato((OggettoToPrint)new PiedePaginaGenericoIntestato("Sollecito"));
            Anagrafica c = new Anagrafica();
            c.seleziona_da_id(this.id_cf);
            c.seleziona_dettagli();
            ragione_sociale = c.getRagione_sociale();
            try {
                sede_indirizzo = c.getSede_legale().getIndirizzoCompleto().replaceAll("CAP@", " ").replaceAll("cap@", " ");
            }
            catch (Exception ex) {
                MyTrace.log.severe("ECCEZIONE in StampaSollecito() nel tentativo di ricavare l'indirizzo completo dalla sede legale");
                ex.printStackTrace();
                Funzioni.inviaBugPerEmail(ex);
                Funzioni.LogStackTrace(ex);
            }
            System.out.println("la sede \u00e8 in via " + sede_via);
            piva = c.getPiva();
            int y = y_inizio;
            stampa_sollecito.setFont(stampa_sollecito.Font_Calibri_10_B);
            stampa_sollecito.appendRoundRect(370, y + 10, 150, 60, 10, 10);
            stampa_sollecito.appendTextOvunque("Spett.le", 377, y + 22);
            stampa_sollecito.setFont(stampa_sollecito.Font_Calibri_10);
            stampa_sollecito.appendTextOvunque("" + ragione_sociale, 377, y + 35);
            stampa_sollecito.setFont(stampa_sollecito.Font_Calibri_8);
            stampa_sollecito.appendTestoDimensionePosizione("" + sede_indirizzo, 377, y + 45, 140);
            stampa_sollecito.appendTestoDimensionePosizione("OGGETTO::: SOLLECITO PER FATTURE INSOLUTE " + this.fda.giornoDellaSettimana(this.fda.dataCorrente()) + "   " + this.fda.dataCorrenteIt(), 20, y + 40, 500);
            stampa_sollecito.appendTestoDimensionePosizione("In allegato Vi trasmettiamo l'Estratto Conto relativo alla Vostra posizione contabile che risulta dalla ns. contabilit\u00e0:", 20, y + 120, 500);
            stampa_sollecito.appendTextOvunque("  Data Doc.", 22, y + 150);
            stampa_sollecito.appendTextOvunque("  Num. Doc.", 60, y + 150);
            stampa_sollecito.appendTextOvunque("  Tipo di Documento", 120, y + 150);
            stampa_sollecito.appendTextOvunque("  Dare", 300, y + 150);
            stampa_sollecito.appendTextOvunque("  Avere", 360, y + 150);
            stampa_sollecito.appendTextOvunque("  Importo Scadenza", 420, y + 150);
            stampa_sollecito.appendTextOvunque("  Data Scadenza", 500, y + 150);
            stampa_sollecito.appendRoundRect(15, y + 140, 550, 20, 10, 10);
            int y_corrente = y + 180;
            String w = "where tipo_cf='C' and pagato=0 and id_anagrafica=" + this.id_cf;
            InsiemeScadenze insieme_perstampa = new InsiemeScadenze();
            insieme_perstampa.caricamento_filtrato(w, "");
            Iterator i = insieme_perstampa.vettoreS.iterator();
            Money totDare = new Money(BigDecimal.ZERO);
            Money totAvere = new Money(BigDecimal.ZERO);
            while (i.hasNext()) {
                Scadenza s = (Scadenza)i.next();
                s.setR(new Registrazione());
                s.getR().seleziona(s.getId_registro());
                stampa_sollecito.appendTextOvunque(s.getNum_doc() + "/" + s.getR().getAnno_doc(), 22, y_corrente);
                stampa_sollecito.appendTextOvunque("" + this.fda.gira_data(s.getData_doc()), 60, y_corrente);
                stampa_sollecito.appendTextOvunque("" + s.getDescrizione_cc(), 120, y_corrente);
                if (s.getSegno() == 2) {
                    stampa_sollecito.appendTextOvunque("" + this.f.formattaNumero("" + s.getImporto_doc()), 300, y_corrente);
                    totDare = totDare.plus(s.getImporto());
                }
                if (s.getSegno() == 1) {
                    stampa_sollecito.appendTextOvunque("" + this.f.formattaNumero("" + s.getImporto_doc()), 360, y_corrente);
                    totDare = totDare.plus(s.getImporto());
                }
                stampa_sollecito.appendTextOvunque("" + this.f.formattaNumero("" + s.getImporto()), 420, y_corrente);
                stampa_sollecito.appendTextOvunque("" + s.getData_scadenza_it(), 500, y_corrente);
                y_corrente += 15;
            }
            stampa_sollecito.appendTextOvunque("Il Totale da saldare \u00e8         " + this.f.formattaNumero("" + totDare), 280, y_corrente += 15);
            stampa_sollecito.appendTextOvunque(this.f.formattaNumero("" + totAvere), 410, y_corrente);
            stampa_sollecito.appendRoundRect(15, y_inizio + 165, 550, (y_corrente += 10) - (y + 165), 10, 10);
            stampa_sollecito.appendPersonalizzazione((OggettoToPrint)new TestoSollecito(y_corrente += 20));
            int passo = 15;
            boolean n = false;
            int rigainizio = y_inizio + 215;
            String date_now = this.fda.dataCorrente().replaceAll("-", "");
            String ora_now = this.fda.OraCorrente().replaceAll(":", "");
            String nome_file = this.f.pulisci_nome_file(date_now + ora_now + "_Sollecito_cliente_" + ragione_sociale.replaceAll(" ", "_"));
            stampa_sollecito.getSeg().getMy_pj_corrente().getPj().setJobName(nome_file);
            MyTrace.log.info(" PERFORMANCE: Tempo di Elaborazione =" + (System.currentTimeMillis() - tempo_di_visualizzazione) + " millisecondi");
            stampa_sollecito.print();
            System.out.println("Fine Stampa");
            MyTrace.log.info(" XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX STAMPA SOLLECITO FINE XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
            MyTrace.log.info(" PERFORMANCE: Tempo Totale compresa la stampa =" + (System.currentTimeMillis() - tempo_di_visualizzazione) + " millisecondi");
            this.esito = true;
        }
        catch (Exception ex) {
            MyTrace.log.severe("ECCEZIONE in StampaSollecito()");
            ex.printStackTrace();
            Funzioni.inviaBugPerEmail(ex);
            Funzioni.LogStackTrace(ex);
            this.esito = false;
        }
        return this.esito;
    }

    public boolean Elabora_2(Vector v_scadenze) {
        Configurazioni.getIstanza();
        int y_inizio = Configurazioni.inizio_stampe;
        try {
            MyTrace.log.info(" XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX STAMPA SOLLECITO INIZIO XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
            long tempo_di_visualizzazione = System.currentTimeMillis();
            GestoreStampe stampa_sollecito = new GestoreStampe();
            stampa_sollecito.aggiungi_pj();
            String ragione_sociale = "ragione sociale";
            String sede_via = "via";
            String sede_cap = "cap";
            String sede_citta = "citt\u00e0";
            String sede_provincia = "provincia";
            String email = "email";
            String piva = "piva";
            boolean id_trattamento = false;
            String trattamento = "trattamento";
            String banca = "banca";
            String sede_indirizzo = "";
            this.f = new Funzioni();
            this.fda = new FunzioniDate();
            stampa_sollecito.setIntPP((OggettoToPrint)new IntestazioneSollecito());
            stampa_sollecito.setPiedePaginaGenericoIntestato((OggettoToPrint)new PiedePaginaGenericoIntestato("Sollecito"));
            Anagrafica c = new Anagrafica();
            c.seleziona_da_id(this.id_cf);
            c.seleziona_dettagli();
            ragione_sociale = c.getRagione_sociale();
            piva = c.getPiva();
            DA_CANCELLARE_Indirizzo i = new DA_CANCELLARE_Indirizzo();
            i = c.getSede_legale();
            if (i.getId() != 0) {
                sede_via = i.getIndirizzo();
                sede_cap = i.getCap().getCap();
                sede_citta = i.getLocalita_selezionata();
                sede_provincia = i.getCap().getCd_provincia();
            }
            int y = y_inizio;
            stampa_sollecito.setFont(stampa_sollecito.Font_Calibri_10_B);
            stampa_sollecito.appendRoundRect(370, y + 10, 200, 60, 10, 10);
            stampa_sollecito.appendTextOvunque("Spett.le", 377, y + 22);
            stampa_sollecito.setFont(stampa_sollecito.Font_Calibri_10);
            stampa_sollecito.appendTestoDimensionePosizione(ragione_sociale + " - " + sede_via + " - " + sede_cap + " " + sede_citta + "  " + sede_provincia, 377, y + 35, 185);
            stampa_sollecito.appendTestoDimensionePosizione(this.fda.giornoDellaSettimana(this.fda.dataCorrente()) + "   " + this.fda.dataCorrenteIt(), 25, y + 35, 500);
            stampa_sollecito.appendTestoDimensionePosizione("OGGETTO::: SOLLECITO PER FATTURE INSOLUTE", 25, y + 50, 500);
            stampa_sollecito.appendTestoDimensionePosizione("Vi trasmettiamo l'Estratto Conto relativo alla Vostra posizione contabile che risulta dalla ns. contabilit\u00e0:", 25, y + 100, 500);
            stampa_sollecito.appendTextOvunque("Data Doc.", 25, y + 130);
            stampa_sollecito.appendTextOvunque("Num. Doc.", 80, y + 130);
            stampa_sollecito.appendTextOvunque("Tipo di Documento", 150, y + 130);
            stampa_sollecito.appendTextOvunque("Importo Scadenza", 350, y + 130);
            stampa_sollecito.appendTextOvunque("Data Scadenza", 450, y + 130);
            stampa_sollecito.appendRoundRect(20, y + 120, 550, 20, 10, 10);
            int y_corrente = y + 160;
            Money totDare = new Money(BigDecimal.ZERO);
            Money totAvere = new Money(BigDecimal.ZERO);
            for (Scadenza s : v_scadenze) {
                if (!s.isSel_per_stampa()) continue;
                Registrazione r = new Registrazione();
                r.seleziona(s.getId_registro());
                stampa_sollecito.appendTextOvunque(s.getNum_doc() + "/" + r.getAnno_doc(), 25, y_corrente);
                stampa_sollecito.appendTextOvunque("" + this.fda.gira_data(s.getData_doc()), 80, y_corrente);
                stampa_sollecito.appendTextOvunque("" + s.getDescrizione_cc(), 150, y_corrente);
                totDare = totDare.plus(s.getImporto());
                stampa_sollecito.appendStringaOvunqueFormattazioneDestra("" + this.f.formattaNumero("" + s.getImporto()), 350, y_corrente, 50);
                stampa_sollecito.appendTextOvunque("" + s.getData_scadenza_it(), 450, y_corrente);
                y_corrente += 15;
            }
            stampa_sollecito.appendTextOvunque("Il Totale da saldare \u00e8         " + this.f.formattaNumero("" + totDare), 230, y_corrente += 15);
            stampa_sollecito.appendRoundRect(20, y_inizio + 145, 550, (y_corrente += 10) - (y + 145), 10, 10);
            stampa_sollecito.appendPersonalizzazione((OggettoToPrint)new TestoSollecito(y_corrente += 20));
            Banca banca_cliente = new Banca();
            int id_banca = c.getId_anag_banche();
            banca_cliente.seleziona(id_banca);
            String descr_banca = banca_cliente.getDescrizione();
            String localita_banca = banca_cliente.getLocalita();
            String provincia_banca = banca_cliente.getProvincia();
            String cc_banca = banca_cliente.getConto();
            String iban_banca = banca_cliente.getIBAN();
            String iban_banca_1 = iban_banca.substring(0, 4);
            String iban_banca_2 = iban_banca.substring(4, 8);
            String iban_banca_3 = iban_banca.substring(8, 12);
            String iban_banca_4 = iban_banca.substring(12, 16);
            String iban_banca_5 = iban_banca.substring(16, 19);
            String iban_banca_6 = iban_banca.substring(19, 23);
            String iban_banca_7 = iban_banca.substring(23, iban_banca.length());
            stampa_sollecito.appendTextOvunque(descr_banca + " " + localita_banca + " " + provincia_banca + " ", 230, y_corrente += 40);
            stampa_sollecito.appendTextOvunque("Conto Corrente n\u00b0 " + cc_banca, 230, y_corrente += 12);
            stampa_sollecito.appendTextOvunque("IBAN: " + iban_banca_1 + "-" + iban_banca_2 + "-" + iban_banca_3 + "-" + iban_banca_4 + "-" + iban_banca_5 + "-" + iban_banca_6 + "-" + iban_banca_7, 230, y_corrente += 12);
            int passo = 15;
            boolean n = false;
            int rigainizio = y + 215;
            String date_now = this.fda.dataCorrente().replaceAll("-", "");
            String ora_now = this.fda.OraCorrente().replaceAll(":", "");
            String nome_file = this.f.pulisci_nome_file(date_now + ora_now + "_Sollecito_cliente_" + ragione_sociale.replaceAll(" ", "_"));
            stampa_sollecito.getSeg().getMy_pj_corrente().getPj().setJobName(nome_file);
            MyTrace.log.info(" PERFORMANCE: Tempo di Elaborazione =" + (System.currentTimeMillis() - tempo_di_visualizzazione) + " millisecondi");
            stampa_sollecito.print();
            System.out.println("Fine Stampa");
            MyTrace.log.info(" XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX STAMPA SOLLECITO FINE XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
            MyTrace.log.info(" PERFORMANCE: Tempo Totale compresa la stampa =" + (System.currentTimeMillis() - tempo_di_visualizzazione) + " millisecondi");
            this.esito = true;
        }
        catch (Exception ex) {
            MyTrace.log.severe("ECCEZIONE in StampaSollecito()");
            ex.printStackTrace();
            Funzioni.inviaBugPerEmail(ex);
            Funzioni.LogStackTrace(ex);
            this.esito = false;
        }
        return this.esito;
    }
}

