/*
 * Decompiled with CFR 0.152.
 */
package gestionale.scadenziario;

import gestionale.configurazioni.Configurazioni;
import gestionale.personalizzazione.stampe.IntestazioneScadenziario;
import gestionale.personalizzazione.stampe.PiedePaginaGenericoIntestato;
import gestionale.scadenziario.Scadenza;
import java.awt.Color;
import java.math.BigDecimal;
import java.util.Iterator;
import java.util.Vector;
import utils.BannerWorking;
import utils.Funzioni;
import utils.FunzioniDate;
import utils.Money;
import utils.MyTrace;
import utils.stampe.GestoreStampe;
import utils.stampe.OggettoToPrint;

public class StampaScadenzePerCliente
implements Runnable {
    Funzioni f;
    FunzioniDate fda;
    int y;
    int y_inizio;
    Thread thread;
    Color colore = new Color(220, 220, 220);
    String dataDA;
    String dataDA_girata;
    String dataA;
    String dataA_girata;
    String cliente_fornitore;
    Vector v_scadenze;
    int i = 0;
    float[] dash = new float[]{1.0f, 1.0f};

    public StampaScadenzePerCliente(String cliente_fornitore, String dataDA, String dataA, Vector v_scadenze) {
        MyTrace.log.info("STAMPA SCADENZE PER CLIENTE   (START)");
        this.f = new Funzioni();
        this.fda = new FunzioniDate();
        this.dataDA = dataDA;
        this.dataA = dataA;
        this.v_scadenze = v_scadenze;
        this.cliente_fornitore = cliente_fornitore;
        this.dataDA_girata = this.fda.gira_data(dataDA);
        this.dataA_girata = this.fda.gira_data(dataA);
        Configurazioni.getIstanza();
        this.y = this.y_inizio = Configurazioni.inizio_stampe;
        MyTrace.log.info("STAMPA SCADENZE PER CLIENTE    (STOP)");
    }

    public void avvia() {
        this.thread = new Thread(this);
        MyTrace.log.info("avvio Procedura su Thread");
        this.thread.start();
    }

    @Override
    public void run() {
        BannerWorking attesa = new BannerWorking("ELABORAZIONE SU THREAD STAMPA SCADENZE PER CLIENTE");
        attesa.start();
        this.elabora_formattazione_stampa(this.v_scadenze);
        attesa.stop();
    }

    private void elabora_formattazione_stampa(Vector lista_clienti) {
        try {
            MyTrace.log.info("STAMPA SCADENZE  PER CLIENTE: XXXXXXXXXXXXXXXXXXXXXXXXXXXXXX  INIZIO STAMPA XXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
            GestoreStampe stampa = new GestoreStampe();
            stampa.aggiungi_pj();
            this.intestazione_tabella_conti(this.cliente_fornitore, stampa, 20, this.y, this.dataDA, this.dataA);
            this.y = this.y_inizio + 75;
            Vector<String> vettore_lista_ragioni_sociali = new Vector<String>();
            for (Scadenza s : lista_clienti) {
                if (!s.isSel_per_stampa() || vettore_lista_ragioni_sociali.contains(s.getA_ragione_sociale())) continue;
                vettore_lista_ragioni_sociali.add(s.getA_ragione_sociale());
            }
            String rag_soc_primo = "";
            if (!vettore_lista_ragioni_sociali.isEmpty()) {
                rag_soc_primo = (String)vettore_lista_ragioni_sociali.elementAt(0);
                stampa.setFont(stampa.Font_Calibri_14_B);
                stampa.appendTextOvunque(rag_soc_primo, 20, this.y);
                stampa.appendLine(20, this.y + 5, 573, this.y + 5);
                ++this.i;
            }
            this.y += 20;
            Money totale_scadenze_dare = new Money(BigDecimal.ZERO);
            Money totale_scadenze_avere = new Money(BigDecimal.ZERO);
            Money totale_importi = new Money(BigDecimal.ZERO);
            Money totale_saldato = new Money(BigDecimal.ZERO);
            Money totale_non_saldato = new Money(BigDecimal.ZERO);
            for (String ragione_sociale : vettore_lista_ragioni_sociali) {
                Money tot_dare = new Money(BigDecimal.ZERO);
                Money tot_avere = new Money(BigDecimal.ZERO);
                Money tot_importi = new Money(BigDecimal.ZERO);
                Money tot_importi_saldati = new Money(BigDecimal.ZERO);
                Iterator iteratore_valori = lista_clienti.iterator();
                while (iteratore_valori.hasNext()) {
                    stampa.setFont(stampa.Font_Calibri_10);
                    Scadenza s = (Scadenza)iteratore_valori.next();
                    String ragione_sociale_1 = s.getA_ragione_sociale();
                    if (s.isSel_per_stampa() && ragione_sociale_1.equals(ragione_sociale)) {
                        if (s.getPagato() == 0) {
                            if (s.getSegno() == 1) {
                                tot_dare.plusplus(s.getImporto());
                                totale_scadenze_dare.plusplus(s.getImporto());
                                totale_importi.plusplus(s.getImporto());
                                tot_importi.plusplus(s.getImporto());
                            } else {
                                tot_avere.plusplus(s.getImporto());
                                totale_scadenze_avere.plusplus(s.getImporto());
                                totale_importi = totale_importi.minus(s.getImporto());
                                tot_importi = tot_importi.minus(s.getImporto());
                            }
                            totale_saldato.plusplus(s.getImporto_saldato());
                        }
                        tot_importi_saldati.plusplus(s.getImporto_saldato());
                        if (this.y > 720) {
                            stampa.paginanuova();
                            this.y = this.y_inizio;
                            this.intestazione_tabella_conti(this.cliente_fornitore, stampa, 20, this.y, this.dataDA, this.dataA);
                            this.y = this.y_inizio + 75;
                        }
                        stampa.appendRect(20, this.y, 555, 20, this.colore);
                        stampa.setFont(stampa.Font_Calibri_7);
                        stampa.appendTextOvunque(s.getNum_reg() + "/" + this.fda.anno(s.getData_registrazione()), 25, this.y + 8);
                        stampa.appendStringaOvunqueFormattazioneDestra(s.getNum_doc() + "/" + this.fda.anno(s.getData_doc()), 60, this.y + 8, 40);
                        stampa.appendTextOvunque(this.fda.gira_data(s.getData_doc()), 115, this.y + 8);
                        int l_descrizione_cc = s.getDescrizione_cc().length();
                        if (l_descrizione_cc > 47) {
                            String str_descrizione_cc = s.getDescrizione_cc().substring(0, 47);
                            stampa.appendTextOvunque(str_descrizione_cc, 175, this.y + 8);
                        } else {
                            stampa.appendTextOvunque(s.getDescrizione_cc(), 175, this.y + 8);
                        }
                        stampa.appendStringaOvunqueFormattazioneDestra(this.f.formattaNumero("" + s.getImporto_doc()), 280, this.y + 8, 30);
                        if (s.getSegno() == 1) {
                            stampa.appendStringaOvunqueFormattazioneDestra(this.f.formattaNumero("" + s.getImporto()), 330, this.y + 8, 30);
                        }
                        if (s.getSegno() == 2) {
                            stampa.appendStringaOvunqueFormattazioneDestra(this.f.formattaNumero("" + s.getImporto()), 370, this.y + 8, 30);
                        }
                        stampa.appendStringaOvunqueFormattazioneDestra(this.f.formattaNumero("" + s.getImporto_saldato()), 405, this.y + 8, 40);
                        stampa.appendTextOvunque(s.getData_scadenza_it(), 475, this.y + 8);
                        int l_descrizione_rag_soc = s.getA_ragione_sociale().length();
                        if (l_descrizione_rag_soc > 31) {
                            String str_descrizione_r_s = s.getA_ragione_sociale().substring(0, 31);
                            stampa.appendTextOvunque(s.getTipo_a_cf() + s.getA_codice_cf() + " - " + str_descrizione_r_s, 25, this.y + 16);
                        } else {
                            stampa.appendTextOvunque(s.getTipo_a_cf() + s.getA_codice_cf() + " - " + s.getA_ragione_sociale(), 25, this.y + 16);
                        }
                        stampa.appendTextOvunque(s.getModo_pagamento(), 175, this.y + 16);
                        if (s.getPagato() == 1) {
                            stampa.appendTextOvunque(this.fda.gira_data(s.getData_doc_saldo()), 525, this.y + 16);
                        }
                        if (s.getPagato() == 0) {
                            if (s.getImporto_saldato().isZero()) {
                                stampa.appendTextOvunque("Non Pagato", 525, this.y + 13, Color.RED);
                            } else {
                                stampa.appendTextOvunque("Saldato in parte", 525, this.y + 13, Color.ORANGE);
                            }
                        }
                        this.y += 20;
                    }
                    if (this.y <= 720) continue;
                    stampa.paginanuova();
                    this.y = this.y_inizio;
                    this.intestazione_tabella_conti(this.cliente_fornitore, stampa, 20, this.y, this.dataDA, this.dataA);
                    this.y = this.y_inizio + 75;
                }
                stampa.setFont(stampa.Font_Calibri_10_B);
                if (this.y > 720) {
                    stampa.paginanuova();
                    this.y = this.y_inizio;
                    this.intestazione_tabella_conti(this.cliente_fornitore, stampa, 20, this.y, this.dataDA, this.dataA);
                    this.y = this.y_inizio + 75;
                }
                this.y += 2;
                stampa.appendLine(305, this.y, 573, this.y, Color.GRAY);
                stampa.setFont(stampa.Font_Calibri_7_B);
                stampa.appendTextOvunque("Tot. Importi", 275, this.y + 10);
                stampa.appendTextOvunque("TOTALE DARE", 320, this.y + 10);
                stampa.appendTextOvunque("Scadenze Avere", 365, this.y + 10);
                stampa.appendTextOvunque("Totale Saldato", 415, this.y + 10);
                stampa.appendTextOvunque("Totale Non Saldato", 490, this.y + 10);
                stampa.appendStringaOvunqueFormattazioneDestra("" + tot_importi, 280, this.y + 20, 30);
                stampa.appendStringaOvunqueFormattazioneDestra("" + tot_dare, 330, this.y + 20, 30);
                stampa.appendStringaOvunqueFormattazioneDestra("" + tot_avere, 370, this.y + 20, 30);
                stampa.appendStringaOvunqueFormattazioneDestra("" + tot_importi_saldati, 400, this.y + 20, 45);
                stampa.appendStringaOvunqueFormattazioneDestra("" + tot_dare.minus(tot_avere.minus(tot_importi_saldati)), 485, this.y + 20, 45);
                stampa.setFont(stampa.Font_Calibri_10);
                this.y += 45;
                if (this.y > 720) {
                    stampa.paginanuova();
                    this.y = this.y_inizio;
                    this.intestazione_tabella_conti(this.cliente_fornitore, stampa, 20, this.y, this.dataDA, this.dataA);
                    this.y = this.y_inizio + 75;
                }
                if (this.i < vettore_lista_ragioni_sociali.size()) {
                    stampa.setFont(stampa.Font_Calibri_10);
                    String scadenza_1 = (String)vettore_lista_ragioni_sociali.elementAt(this.i);
                    stampa.setFont(stampa.Font_Calibri_14_B);
                    stampa.appendTextOvunque(scadenza_1, 20, this.y);
                    stampa.appendLine(20, this.y + 5, 573, this.y + 5);
                    ++this.i;
                }
                this.y += 20;
                if (this.y <= 720) continue;
                stampa.paginanuova();
                this.y = this.y_inizio;
                this.intestazione_tabella_conti(this.cliente_fornitore, stampa, 20, this.y, this.dataDA, this.dataA);
                this.y = this.y_inizio + 75;
            }
            totale_non_saldato = totale_scadenze_dare.minus(totale_scadenze_avere.minus(totale_saldato));
            if (this.y > 720) {
                stampa.paginanuova();
                this.y = this.y_inizio;
                this.intestazione_tabella_conti(this.cliente_fornitore, stampa, 20, this.y, this.dataDA, this.dataA);
                this.y = this.y_inizio + 75;
            } else {
                this.y -= 20;
            }
            stampa.appendLine(30, this.y, 573, this.y);
            stampa.appendLine(30, this.y + 5, 573, this.y + 5);
            this.y += 20;
            stampa.appendRoundRect(170, this.y, 250, 100, 10, 10);
            stampa.setFont(stampa.Font_Calibri_12_B);
            stampa.appendTextOvunque("TOTALE IMPORTI", 190, this.y + 20);
            stampa.appendTextOvunque("TOTALE SCADENZE DARE", 190, this.y + 35);
            stampa.appendTextOvunque("TOTALE SCADENZE AVERE", 190, this.y + 50);
            stampa.appendTextOvunque("TOTALE SALDATO", 190, this.y + 65);
            stampa.appendTextOvunque("TOTALE NON SALDATO", 190, this.y + 80);
            stampa.appendStringaOvunqueFormattazioneDestra("" + totale_importi, 350, this.y + 20, 45);
            stampa.appendStringaOvunqueFormattazioneDestra("" + totale_scadenze_avere, 350, this.y + 35, 45);
            stampa.appendStringaOvunqueFormattazioneDestra("" + totale_scadenze_dare, 350, this.y + 50, 45);
            stampa.appendStringaOvunqueFormattazioneDestra("" + totale_saldato, 350, this.y + 65, 45);
            stampa.appendStringaOvunqueFormattazioneDestra("" + totale_non_saldato, 350, this.y + 80, 45);
            stampa.setFont(stampa.Font_Calibri_8);
            String date_now = this.fda.dataCorrente().replaceAll("-", "");
            String ora_now = this.fda.OraCorrente().replaceAll(":", "");
            String nome_file = this.f.pulisci_nome_file(date_now + ora_now + "_Scadenze_" + this.dataDA_girata + "_Al_" + this.dataA_girata);
            stampa.getSeg().getMy_pj_corrente().getPj().setJobName(nome_file);
            stampa.setPiedePaginaGenericoIntestato((OggettoToPrint)new PiedePaginaGenericoIntestato("Scadenziario"));
            stampa.setIntPP((OggettoToPrint)new IntestazioneScadenziario());
            stampa.setInt((OggettoToPrint)new IntestazioneScadenziario());
            stampa.print();
            MyTrace.log.info(" XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX STAMPA SCADENZE PER CLIENTE FINE XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
        }
        catch (Exception ex) {
            MyTrace.log.severe("ERRORE: eccezione elabora_formattazione_stampa() nella stampa scadenze per cliente");
            ex.printStackTrace();
            Funzioni.inviaBugPerEmail(ex);
            Funzioni.LogStackTrace(ex);
        }
        catch (Error err) {
            MyTrace.log.severe("ERRORE: elabora_formattazione_stampa() errore di avvio o di linkaggio");
            err.printStackTrace();
        }
    }

    public void intestazione_tabella_conti(String c_f, GestoreStampe stampa, int x, int y, String dataDA, String dataA) {
        stampa.setFont(stampa.Font_Calibri_8);
        stampa.appendRoundRect(x, y, 555, 47, 10, 10);
        stampa.appendTextOvunque("NUM.", 22, y + 10);
        stampa.appendTextOvunque("REG.", 22, y + 20);
        stampa.appendTextOvunque("NUMERO", 55, y + 10);
        stampa.appendTextOvunque("DOCUMENTO", 55, y + 20);
        stampa.appendTextOvunque("DATA", 115, y + 10);
        stampa.appendTextOvunque("DOCUMENTO", 115, y + 20);
        stampa.appendTextOvunque("DESCRIZIONE", 175, y + 10);
        stampa.appendTextOvunque("CAUSALE", 175, y + 20);
        stampa.appendTextOvunque("IMPORTO", 275, y + 10);
        stampa.appendTextOvunque("DOCUMENTO", 275, y + 20);
        stampa.appendTextOvunque("DARE", 330, y + 10);
        stampa.appendTextOvunque("SCADENZA", 330, y + 20);
        stampa.appendTextOvunque("AVERE", 370, y + 10);
        stampa.appendTextOvunque("SCADENZA", 370, y + 20);
        stampa.appendTextOvunque("IMPORTO", 420, y + 10);
        stampa.appendTextOvunque("SALDATO", 420, y + 20);
        stampa.appendTextOvunque("DATA", 475, y + 10);
        stampa.appendTextOvunque("SCADENZA", 475, y + 20);
        stampa.appendTextOvunque("STATO", 525, y + 10);
        stampa.appendTextOvunque("PAGAMENTO", 525, y + 20);
        if (c_f.equals("C") || c_f.equals("Clienti")) {
            stampa.appendTextOvunque("CODICE E RAGIONE SOCIALE CLIENTE", 25, y + 40);
            stampa.setFont(stampa.Font_Arial_12_B);
            stampa.appendTextOvunque("Scadenze verso Clienti dal " + dataDA + " al " + dataA, 30, y - 5);
            stampa.setFont(stampa.Font_Calibri_8);
        }
        if (c_f.equals("F") || c_f.equals("Fornitori")) {
            stampa.appendTextOvunque("CODICE E RAGIONE SOCIALE FORNITORE", 25, y + 40);
            stampa.setFont(stampa.Font_Arial_12_B);
            stampa.appendTextOvunque("Scadenze verso Fornitori dal " + dataDA + " al " + dataA, 30, y - 5);
            stampa.setFont(stampa.Font_Calibri_8);
        }
        stampa.appendTextOvunque("TRATTAMENTO ECONOMICO", 175, y + 40);
    }
}

