/*
 * Decompiled with CFR 0.152.
 */
package gestionale.scadenziario;

import gestionale.configurazioni.Configurazioni;
import gestionale.primanota.InsiemePartite;
import gestionale.scadenziario.Scadenza;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.Vector;
import utils.Funzioni;
import utils.Money;
import utils.MyTrace;
import utils.Performance;

public class InsiemeScadenze {
    public Vector vettoreS;
    int colCount;
    public String[] headers;
    public Money totale_importo_dare = new Money(BigDecimal.ZERO);
    public Money totale_importo_avere = new Money(BigDecimal.ZERO);
    public Money totale_scadenze_dare = new Money(BigDecimal.ZERO);
    public Money totale_scadenze_avere = new Money(BigDecimal.ZERO);
    public Money totale_saldato_dare = new Money(BigDecimal.ZERO);
    public Money totale_saldato_avere = new Money(BigDecimal.ZERO);

    public InsiemeScadenze() {
        this.vettoreS = new Vector();
    }

    public int caricamento(String where, String order_by) {
        Performance perf = new Performance("CARICA SCADENZIARIO");
        this.vettoreS = new Vector();
        String query = "SELECT * FROM scadenziario";
        query = query + " " + where;
        query = query + " " + order_by;
        try {
            ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query);
            while (res.next()) {
                Scadenza s = new Scadenza();
                s.setId(res.getInt("idscadenziario"));
                s.setId_registro(res.getInt("id_registro"));
                s.setData_scadenza(res.getString("data_scadenza"));
                s.setImporto(new Money(res.getDouble("importo")));
                s.setPercentuale_imponibile(new Money(res.getDouble("percentuale_imponibile")));
                s.setPercentuale_imposta(new Money(res.getDouble("percentuale_imposta")));
                s.setId_partita_c(res.getInt("id_partita_c"));
                s.setNote(res.getString("note"));
                s.setPagato(res.getInt("pagato"));
                this.vettoreS.addElement(s);
            }
            Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        }
        catch (Exception e) {
            this.vettoreS = new Vector();
            MyTrace.log.severe("Seleziona scadenze non riuscito");
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            Configurazioni.eccezione.gestisci("4.2", null);
        }
        System.out.println("La dimenzione \u00e8 " + this.vettoreS.size());
        perf.fine();
        return this.vettoreS.size();
    }

    public int caricamento_filtrato(String where, String order_by) {
        this.vettoreS = new Vector();
        this.totale_importo_dare = new Money(BigDecimal.ZERO);
        this.totale_importo_avere = new Money(BigDecimal.ZERO);
        this.totale_scadenze_dare = new Money(BigDecimal.ZERO);
        this.totale_saldato_dare = new Money(BigDecimal.ZERO);
        this.totale_scadenze_avere = new Money(BigDecimal.ZERO);
        this.totale_saldato_avere = new Money(BigDecimal.ZERO);
        HashMap<String, Money> hashMap = new HashMap<String, Money>();
        String query = "select scadenziario.*,  partite.segno,  registro.*,  conf_causale_contabile.*, anag_anagrafica.idanagrafica,  anag_anagrafica.codice as codice_cf,  anag_anagrafica.ragione_sociale,  conf_trattamento_economico.*  from scadenziario  left join registro on scadenziario.id_registro=registro.idregistro  left join anag_anagrafica on registro.id_anagrafica=anag_anagrafica.idanagrafica  left join conf_causale_contabile on registro.id_causale_contabile= conf_causale_contabile.idcausale_contabile  left join conf_trattamento_economico ON conf_trattamento_economico.idtrattamento_economico = registro.id_conf_trattamento_economico  left join partite ON scadenziario.id_partita_c=partite.idpartite ";
        query = query + " " + where;
        query = query + " " + order_by;
        try {
            ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query);
            while (res.next()) {
                Scadenza s = new Scadenza();
                s.setId(res.getInt("idscadenziario"));
                s.setId_registro(res.getInt("id_registro"));
                s.setData_scadenza(res.getString("data_scadenza"));
                s.setImporto(new Money(res.getDouble("importo")));
                s.setImporto_saldato(new Money(res.getDouble("importo_saldato")));
                s.setPercentuale_imponibile(new Money(res.getDouble("percentuale_imponibile")));
                s.setPercentuale_imposta(new Money(res.getDouble("percentuale_imposta")));
                s.setId_partita_c(res.getInt("id_partita_c"));
                s.setNote(res.getString("note"));
                s.setPagato(res.getInt("pagato"));
                s.setTipo_a_cf(res.getString("tipo_cf"));
                s.setDescrizione_cc(res.getString("descrizione"));
                s.setNum_doc(res.getString("num_doc"));
                s.setNum_reg(res.getString("num_reg"));
                s.setData_doc(res.getString("data_doc"));
                s.setImporto_doc(new Money(res.getDouble("importo_doc")));
                s.setData_registrazione(res.getString("data_reg"));
                s.setSel_per_stampa(false);
                s.setModo_pagamento(res.getString("modo_pagamento"));
                s.setSegno(res.getInt("segno"));
                String key = res.getString("data_doc") + res.getString("num_doc");
                if (!hashMap.containsKey(key)) {
                    hashMap.put(key, s.getImporto_doc());
                }
                if (s.getSegno() == 1) {
                    this.totale_scadenze_dare = this.totale_scadenze_dare.plus(new Money(s.getImporto()));
                    this.totale_saldato_dare = this.totale_saldato_dare.plus(new Money(s.getImporto_saldato()));
                    this.totale_importo_dare = this.totale_importo_dare.plus(new Money(s.getImporto_doc()));
                }
                if (s.getSegno() == 2) {
                    this.totale_scadenze_avere = this.totale_scadenze_avere.plus(new Money(s.getImporto()));
                    this.totale_saldato_avere = this.totale_saldato_avere.plus(new Money(s.getImporto_saldato()));
                    this.totale_importo_avere = this.totale_importo_avere.plus(new Money(s.getImporto_doc()));
                }
                if (s.getPagato() == 1) {
                    String w = " WHERE id_scadenza=" + s.getId() + " ";
                    s.seleziona_scadenza_saldata(w);
                }
                s.setId_anag_cf(res.getInt("idanagrafica"));
                s.setA_codice_cf(res.getString("codice_cf"));
                s.setA_ragione_sociale(res.getString("ragione_sociale"));
                s.verificaMoney();
                this.vettoreS.addElement(s);
            }
            Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        }
        catch (Exception e) {
            this.vettoreS = new Vector();
            MyTrace.log.severe("Seleziona scadenze non riuscito");
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            Configurazioni.eccezione.gestisci("4.2", null);
        }
        return this.vettoreS.size();
    }

    public int caricamento_scadenze_aperte(String where, String order_by) {
        this.vettoreS = new Vector();
        String query = "SELECT scadenziario.*, registro.num_doc ,  partite.*, anag_anagrafica.codice, anag_anagrafica.ragione_sociale  fROM scadenziario LEFT JOIN partite ON scadenziario.id_partita_c=partite.idpartite LEFT JOIN anag_anagrafica ON partite.id_anagrafica=anag_anagrafica.idanagrafica  LEFT JOIN scadenze_partite_rif ON scadenziario.idscadenziario=scadenze_partite_rif.id_scadenza  left join registro on scadenziario.id_registro=registro.idregistro ";
        query = query + " " + where;
        query = query + " " + order_by;
        try {
            ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query);
            while (res.next()) {
                Scadenza s = new Scadenza();
                s.setId(res.getInt("idscadenziario"));
                s.setId_registro(res.getInt("id_registro"));
                s.setData_scadenza(res.getString("data_scadenza"));
                s.setImporto(new Money(res.getDouble("importo")));
                s.setPercentuale_imponibile(new Money(res.getDouble("percentuale_imponibile")));
                s.setPercentuale_imposta(new Money(res.getDouble("percentuale_imposta")));
                s.setImporto_saldato(new Money(res.getDouble("importo_saldato")));
                s.setId_partita_c(res.getInt("id_partita_c"));
                s.setNote(res.getString("note"));
                s.setPagato(res.getInt("pagato"));
                s.setA_ragione_sociale(res.getString("ragione_sociale"));
                s.setNum_doc(res.getString("num_doc"));
                s.setA_codice_cf(res.getString("codice"));
                s.setTipo_a_cf(res.getString("tipo_cf"));
                s.setId_anag_cf(res.getInt("id_anagrafica"));
                s.setSegno(res.getInt("segno"));
                s.setTipo_partita(res.getString("tipo_partita"));
                if (!s.getImporto_saldato().isZero()) {
                    s.setI_partite_saldo(new InsiemePartite());
                    String w = " WHERE scadenze_partite_rif.id_scadenza='" + s.getId() + "'";
                    s.getI_partite_saldo().caricamento(w, "");
                }
                this.vettoreS.addElement(s);
            }
            Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        }
        catch (Exception e) {
            this.vettoreS = new Vector();
            MyTrace.log.severe("Seleziona scadenze non riuscito");
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            Configurazioni.eccezione.gestisci("4.2", null);
        }
        return this.vettoreS.size();
    }
}

